/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.beans;

import jp.terasoluna.utlib.LogUTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.beans.JXPathIndexedBeanWrapperImpl} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * JavaBean̔zERNV^ɃANZXłNXB<br>
 * OF<br>
 * NXprotected\bḧnode not null łB
 * <p>
 * 
 * @see jp.terasoluna.fw.beans.JXPathIndexedBeanWrapperImpl
 */
public class JXPathIndexedBeanWrapperImplTest03 extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(JXPathIndexedBeanWrapperImplTest03.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public JXPathIndexedBeanWrapperImplTest03(String name) {
        super(name);
    }

    /**
     * testToPropertyName01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() xpath:".[@name='bbb']"<br>
     *         () X^uisMapObject()̖߂l:true<br>
     *         () X^uextractMapKey()̖߂l:"bbb"<br>
     *         () X^uextractDecrementIndex()̖߂l:""<br>
     *         
     * <br>
     * ҒlF(߂l) String:"bbb"<br>
     *         (ԕω) isMapObject()̈:".[@name='bbb']"<br>
     *         (ԕω) extractMapKey()̈:".[@name='bbb']"<br>
     *         (ԕω) extractDecrementIndex()̈:".[@name='bbb']"<br>
     *         
     * <br>
     * yMap^EKwȂ̎z<br>
     * z肵͂̏ꍇ̎B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToPropertyName01() throws Exception {
        // O
        String result = null;
        JXPathIndexedBeanWrapperImplStub04 target =
            new JXPathIndexedBeanWrapperImplStub04("");
        target.isMapObjectReturnValue = true;
        target.extractDecrementIndexReturnValue = "";

        // eXg{
        result = target.toPropertyName(".[@name='bbb']");

        // 
        assertEquals("bbb",result);
        assertEquals(".[@name='bbb']", target.isMapObjectArg1.get(0));
        assertEquals(".[@name='bbb']", target.extractMapKeyArg1.get(0));
        assertEquals(".[@name='bbb']", target.extractDecrementIndexArg1.get(0));
    }

    /**
     * testToPropertyName02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() xpath:"aaa[@name='bbb']"<br>
     *         () X^uisMapObject()̖߂l:false<br>
     *         () X^uextractMapKey()̖߂l:"bbb"<br>
     *         () X^uisMapAttribute()̖߂l:true<br>
     *         () X^uextractMapAttributeName()̖߂l:"aaa"<br>
     *         () X^uextractDecrementIndex()̖߂l:""<br>
     *         
     * <br>
     * ҒlF(߂l) String:"aaa(bbb)"<br>
     *         (ԕω) isMapObject()̈:"aaa[@name='bbb']"<br>
     *         (ԕω) extractMapKey()̈:"aaa[@name='bbb']"<br>
     *         (ԕω) isMapAttribute()̈:"aaa[@name='bbb']"<br>
     *         (ԕω) extractMapAttributeName()̈:"aaa[@name='bbb']"<br>
     *         (ԕω) extractDecrementIndex()̈:"aaa[@name='bbb']"<br>
     *         
     * <br>
     * yMapEKwȂ̎z<br>
     * z肵͂̏ꍇ̎B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToPropertyName02() throws Exception {
        // O
        String result = null;
        JXPathIndexedBeanWrapperImplStub04 target =
            new JXPathIndexedBeanWrapperImplStub04("");
        target.isMapObjectReturnValue = false;
        target.isMapAttributeReturnValue = true;
        target.extractDecrementIndexReturnValue = "";

        // eXg{
        result = target.toPropertyName("aaa[@name='bbb']");

        // 
        assertEquals("aaa(bbb)", result);
        assertEquals("aaa[@name='bbb']", target.isMapObjectArg1.get(0));
        assertEquals("aaa[@name='bbb']", target.extractMapKeyArg1.get(0));
        assertEquals("aaa[@name='bbb']", target.isMapAttributeArg1.get(0));
        assertEquals("aaa[@name='bbb']", target.extractMapAttributeNameArg1.get(0));
        assertEquals("aaa[@name='bbb']", target.extractDecrementIndexArg1.get(0));
    }

    /**
     * testToPropertyName03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() xpath:"aaa[@name='bbb'][10]"<br>
     *         () X^uisMapObject()̖߂l:false<br>
     *         () X^uextractMapKey()̖߂l:"bbb"<br>
     *         () X^uisMapAttribute()̖߂l:true<br>
     *         () X^uextractMapAttributeName()̖߂l:"aaa"<br>
     *         () X^uextractDecrementIndex()̖߂l:"[9]"<br>
     *         
     * <br>
     * ҒlF(߂l) String:"aaa(bbb)[9]"<br>
     *         (ԕω) isMapObject()̈:"aaa[@name='bbb'][10]"<br>
     *         (ԕω) extractMapKey()̈:"aaa[@name='bbb'][10]"<br>
     *         (ԕω) isMapAttribute()̈:"aaa[@name='bbb'][10]"<br>
     *         (ԕω) extractMapAttributeName()̈:"aaa[@name='bbb'][10]"<br>
     *         (ԕω) extractDecrementIndex()̈:"aaa[@name='bbb'][10]"<br>
     *         
     * <br>
     * yMapzEKwȂ̎z<br>
     * z肵͂̏ꍇ̎B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToPropertyName03() throws Exception {
        // O
        String result = null;
        JXPathIndexedBeanWrapperImplStub04 target =
            new JXPathIndexedBeanWrapperImplStub04("");
        target.isMapObjectReturnValue = false;
        target.isMapAttributeReturnValue = true;
        target.extractDecrementIndexReturnValue = "[9]";

        // eXg{
        result = target.toPropertyName("aaa[@name='bbb'][10]");

        // 
        assertEquals("aaa(bbb)[9]", result);
        assertEquals("aaa[@name='bbb'][10]", target.isMapObjectArg1.get(0));
        assertEquals("aaa[@name='bbb'][10]", target.extractMapKeyArg1.get(0));
        assertEquals("aaa[@name='bbb'][10]", target.isMapAttributeArg1.get(0));
        assertEquals("aaa[@name='bbb'][10]", target.extractMapAttributeNameArg1.get(0));
        assertEquals("aaa[@name='bbb'][10]", target.extractDecrementIndexArg1.get(0));
    }

    /**
     * testToPropertyName04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() xpath:"aaa"<br>
     *         () X^uisMapObject()̖߂l:false<br>
     *         () X^uisMapAttribute()̖߂l:false<br>
     *         () X^uextractAttributeName()̖߂l:"aaa"<br>
     *         () X^uextractDecrementIndex()̖߂l:""<br>
     *         
     * <br>
     * ҒlF(߂l) String:"aaa"<br>
     *         (ԕω) isMapObject()̈:"aaa"<br>
     *         (ԕω) isMapAttribute()̈:"aaa"<br>
     *         (ԕω) extractAttributeName()̈:"aaa"<br>
     *         (ԕω) extractDecrementIndex()̈:"aaa"<br>
     *         
     * <br>
     * ybean/v~eBuEKwȂ̎z<br>
     * z肵͂̏ꍇ̎B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToPropertyName04() throws Exception {
        // O
        String result = null;
        JXPathIndexedBeanWrapperImplStub04 target =
            new JXPathIndexedBeanWrapperImplStub04("");
        target.isMapObjectReturnValue = false;
        target.isMapAttributeReturnValue = false;
        target.extractDecrementIndexReturnValue = "";

        // eXg{
        result = target.toPropertyName("aaa");

        // 
        assertEquals("aaa", result);
        assertEquals("aaa", target.isMapObjectArg1.get(0));
        assertEquals("aaa", target.isMapAttributeArg1.get(0));
        assertEquals("aaa", target.extractAttributeNameArg1.get(0));
        assertEquals("aaa", target.extractDecrementIndexArg1.get(0));
    }

    /**
     * testToPropertyName05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() xpath:"aaa[100]"<br>
     *         () X^uisMapObject()̖߂l:false<br>
     *         () X^uisMapAttribute()̖߂l:false<br>
     *         () X^uextractAttributeName()̖߂l:"aaa"<br>
     *         () X^uextractDecrementIndex()̖߂l:"[99]"<br>
     *         
     * <br>
     * ҒlF(߂l) String:"aaa[99]"<br>
     *         (ԕω) isMapObject()̈:"aaa[100]"<br>
     *         (ԕω) isMapAttribute()̈:"aaa[100]"<br>
     *         (ԕω) extractAttributeName()̈:"aaa[100]"<br>
     *         (ԕω) extractDecrementIndex()̈:"aaa[100]"<br>
     *         
     * <br>
     * ybean/v~eBuzEKwȂ̎z<br>
     * z肵͂̏ꍇ̎B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToPropertyName05() throws Exception {
        // O
        String result = null;
        JXPathIndexedBeanWrapperImplStub04 target =
            new JXPathIndexedBeanWrapperImplStub04("");
        target.isMapObjectReturnValue = false;
        target.isMapAttributeReturnValue = false;
        target.extractDecrementIndexReturnValue = "[99]";

        // eXg{
        result = target.toPropertyName("aaa[100]");

        // 
        assertEquals("aaa[99]", result);
        assertEquals("aaa[100]", target.isMapObjectArg1.get(0));
        assertEquals("aaa[100]", target.isMapAttributeArg1.get(0));
        assertEquals("aaa[100]", target.extractAttributeNameArg1.get(0));
        assertEquals("aaa[100]", target.extractDecrementIndexArg1.get(0));
    }

    /**
     * testToPropertyName06()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() xpath:"aaa[@name='bbb']/ddd[@name='eee']"<br>
     *         () X^uisMapObject()̖߂l:false<br>
     *         () X^uextractMapKey()̖߂l:1: "bbb"<br>
     *                2: "eee"<br>
     *         () X^uisMapAttribute()̖߂l:true<br>
     *         () X^uextractMapAttributeName()̖߂l:1: "aaa"<br>
     *                2: "ddd"<br>
     *         () X^uextractDecrementIndex()̖߂l:""<br>
     *         
     * <br>
     * ҒlF(߂l) String:"aaa(bbb).ddd(eee)"<br>
     *         (ԕω) isMapObject()̈:1: "aaa[@name='bbb']"<br>
     *                    2: "ddd[@name='eee']"<br>
     *         (ԕω) extractMapKey()̈:1: "aaa[@name='bbb']"<br>
     *                    2: "ddd[@name='eee']"<br>
     *         (ԕω) isMapAttribute()̈:1: "aaa[@name='bbb']"<br>
     *                    2: "ddd[@name='eee']"<br>
     *         (ԕω) extractMapAttributeName()̈:1: "aaa[@name='bbb']"<br>
     *                    2: "ddd[@name='eee']"<br>
     *         (ԕω) extractDecrementIndex()̈:1: "aaa[@name='bbb']"<br>
     *                    2: "ddd[@name='eee']"<br>
     *         
     * <br>
     * yMapEKw̎z<br>
     * z肵͂̏ꍇ̎BKwԂ̋؂蕶p^[B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToPropertyName06() throws Exception {
        // O
        String result = null;
        JXPathIndexedBeanWrapperImplStub04 target =
            new JXPathIndexedBeanWrapperImplStub04("");
        target.isMapObjectReturnValue = false;
        target.isMapAttributeReturnValue = true;
        target.extractDecrementIndexReturnValue = "";

        // eXg{
        result = target.toPropertyName("aaa[@name='bbb']/ddd[@name='eee']");

        // 
        assertEquals("aaa(bbb).ddd(eee)", result);
        assertEquals("aaa[@name='bbb']", target.isMapObjectArg1.get(0));
        assertEquals("aaa[@name='bbb']", target.extractMapKeyArg1.get(0));
        assertEquals("ddd[@name='eee']", target.extractMapKeyArg1.get(1));
        assertEquals("aaa[@name='bbb']", target.isMapAttributeArg1.get(0));
        assertEquals("ddd[@name='eee']", target.isMapAttributeArg1.get(1));
        assertEquals("aaa[@name='bbb']", target.extractMapAttributeNameArg1.get(0));
        assertEquals("ddd[@name='eee']", target.extractMapAttributeNameArg1.get(1));
        assertEquals("aaa[@name='bbb']", target.extractDecrementIndexArg1.get(0));
        assertEquals("ddd[@name='eee']", target.extractDecrementIndexArg1.get(1));
    }

    /**
     * testToPropertyName07()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() xpath:""<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException("XPath is null or blank.")<br>
     *         (ԕω) O:OxFG[<br>
     *                    XPath is null or blank.<br>
     *         
     * <br>
     * xpath󕶎̏ꍇ̎B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToPropertyName07() throws Exception {
        // O
        JXPathIndexedBeanWrapperImpl target =
            new JXPathIndexedBeanWrapperImpl("");

        // eXg{
        try {
            target.toPropertyName("");
            fail();

        } catch (IllegalArgumentException e) {
            // 
            assertEquals("XPath is null or blank.", e.getMessage());
            assertTrue(LogUTUtil.checkError("XPath is null or blank."));
        }
    }

    /**
     * testExtractAttributeName01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() node:"aaa[bbb]"<br>
     *         
     * <br>
     * ҒlF(߂l) String:"aaa"<br>
     *         
     * <br>
     * node̓e lXgȂ̑z肵`̏ꍇ̎B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractAttributeName01() throws Exception {
        // O
        String result = null;
        JXPathIndexedBeanWrapperImpl target =
            new JXPathIndexedBeanWrapperImpl("");

        // eXg{
        result = target.extractAttributeName("aaa[bbb]");

        // 
        assertEquals("aaa", result);
    }

    /**
     * testExtractAttributeName02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() node:"aaa[bbb][ddd]"<br>
     *         
     * <br>
     * ҒlF(߂l) String:"aaa[bbb]"<br>
     *         
     * <br>
     * node̓elXĝ z肵`̏ꍇ̎B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractAttributeName02() throws Exception {
        // O
        String result = null;
        JXPathIndexedBeanWrapperImpl target =
            new JXPathIndexedBeanWrapperImpl("");

        // eXg{
        result = target.extractAttributeName("aaa[bbb][ddd]");

        // 
        assertEquals("aaa[bbb]", result);
    }

    /**
     * testExtractAttributeName03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() node:"aaa.ccc.eee"<br>
     *         
     * <br>
     * ҒlF(߂l) String:"aaa.ccc.eee"<br>
     *         
     * <br>
     * node"["Ȃꍇ̎B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractAttributeName03() throws Exception {
        // O
        String result = null;
        JXPathIndexedBeanWrapperImpl target =
            new JXPathIndexedBeanWrapperImpl("");

        // eXg{
        result = target.extractAttributeName("aaa.ccc.eee");

        // 
        assertEquals("aaa.ccc.eee", result);
    }

    /**
     * testExtractAttributeName04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() node:""<br>
     *         
     * <br>
     * ҒlF(߂l) String:""<br>
     *         
     * <br>
     * node󕶎̏ꍇ̎B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractAttributeName04() throws Exception {
        // O
        String result = null;
        JXPathIndexedBeanWrapperImpl target =
            new JXPathIndexedBeanWrapperImpl("");

        // eXg{
        result = target.extractAttributeName("");

        // 
        assertEquals("", result);
    }

    /**
     * testExtractMapAttributeName01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() node:"aaa[bbb]"<br>
     *         
     * <br>
     * ҒlF(߂l) String:"aaa"<br>
     *         
     * <br>
     * node̓e z肵`̏ꍇ̎B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractMapAttributeName01() throws Exception {
        // O
        String result = null;
        JXPathIndexedBeanWrapperImpl target =
            new JXPathIndexedBeanWrapperImpl("");

        // eXg{
        result = target.extractMapAttributeName("aaa[bbb]");

        // 
        assertEquals("aaa", result);
    }

    /**
     * testExtractMapAttributeName02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() node:"[bbb]"<br>
     *         
     * <br>
     * ҒlF(߂l) String:""<br>
     *         
     * <br>
     * nodȇȂꍇ̎B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractMapAttributeName02() throws Exception {
        // O
        String result = null;
        JXPathIndexedBeanWrapperImpl target =
            new JXPathIndexedBeanWrapperImpl("");

        // eXg{
        result = target.extractMapAttributeName("[bbb]");

        // 
        assertEquals("", result);
    }

    /**
     * testExtractMapAttributeName03()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() node:"aaa"<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException("Cannot get Map attribute. Invalid property name. 'aaa'")<br>
     *         (ԕω) O:OxFG[<br>
     *                    Cannot get Map attribute. Invalid property name. 'aaa'<br>
     *         
     * <br>
     * node"["Ȃꍇ̎B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractMapAttributeName03() throws Exception {
        // O
        JXPathIndexedBeanWrapperImpl target =
            new JXPathIndexedBeanWrapperImpl("");

        // eXg{
        try {
            target.extractMapAttributeName("aaa");
            fail();

        } catch (IllegalArgumentException e) {
            // 
            assertEquals("Cannot get Map attribute. Invalid property name. 'aaa'", e.getMessage());
            assertTrue(LogUTUtil.checkError("Cannot get Map attribute. Invalid property name. 'aaa'"));
        }
    }

    /**
     * testExtractMapAttributeName04()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() node:""<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalArgmentException("Cannot get Map attribute. Invalid property name. ''")<br>
     *         (ԕω) O:OxFG[<br>
     *                    Cannot get Map attribute. Invalid property name. ''<br>
     *         
     * <br>
     * node󕶎̏ꍇ̎B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractMapAttributeName04() throws Exception {
        // O
        JXPathIndexedBeanWrapperImpl target =
            new JXPathIndexedBeanWrapperImpl("");

        // eXg{
        try {
            target.extractMapAttributeName("");
            fail();

        } catch (IllegalArgumentException e) {
            // 
            assertEquals("Cannot get Map attribute. Invalid property name. ''", e.getMessage());
            assertTrue(LogUTUtil.checkError("Cannot get Map attribute. Invalid property name. ''"));
        }
    }

    /**
     * testExtractMapKey01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() node:"aaa[@name='bbb']"<br>
     *         
     * <br>
     * ҒlF(߂l) String:"bbb"<br>
     *         
     * <br>
     * node̓e z肵`̏ꍇ̎B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractMapKey01() throws Exception {
        // O
        String result = null;
        JXPathIndexedBeanWrapperImpl target =
            new JXPathIndexedBeanWrapperImpl("");

        // eXg{
        result = target.extractMapKey("aaa[@name='bbb']");

        // 
        assertEquals("bbb", result);
    }

    /**
     * testExtractMapKey02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() node:"aaa[@name='']"<br>
     *         
     * <br>
     * ҒlF(߂l) String:""<br>
     *         
     * <br>
     * nodeMapL[󕶎̏ꍇ̎B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractMapKey02() throws Exception {
        // O
        String result = null;
        JXPathIndexedBeanWrapperImpl target =
            new JXPathIndexedBeanWrapperImpl("");

        // eXg{
        result = target.extractMapKey("aaa[@name='']");

        // 
        assertEquals("", result);
    }

    /**
     * testExtractMapKey03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() node:"aaa[@name='bbb'"<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException("Cannot get Map key. Invalid property name. 'aaa[@name='bbb''")<br>
     *         (ԕω) O:OxFG[<br>
     *                    Cannot get Map key. Invalid property name. 'aaa[@name='bbb''<br>
     *         
     * <br>
     * node"]"Ȃꍇ̎B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractMapKey03() throws Exception {
        // O
        JXPathIndexedBeanWrapperImpl target =
            new JXPathIndexedBeanWrapperImpl("");

        // eXg{
        try {
            target.extractMapKey("aaa[@name='bbb'");
            fail();

        } catch (IllegalArgumentException e) {
            // 
            assertEquals("Cannot get Map key. Invalid property name. 'aaa[@name='bbb''", e.getMessage());
            assertTrue(LogUTUtil.checkError("Cannot get Map key. Invalid property name. 'aaa[@name='bbb''"));
        }
    }

    /**
     * testExtractMapKey04()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() node:"aaa@name='bbb']"<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException("Cannot get Map key. Invalid property name. 'aaa@name='bbb']'")<br>
     *         (ԕω) O:OxFG[<br>
     *                    Cannot get Map key. Invalid property name. 'aaa@name='bbb']'<br>
     *         
     * <br>
     * node"["Ȃꍇ̎B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractMapKey04() throws Exception {
        // O
        JXPathIndexedBeanWrapperImpl target =
            new JXPathIndexedBeanWrapperImpl("");

        // eXg{
        try {
            target.extractMapKey("aaa@name='bbb']");
            fail();

        } catch (IllegalArgumentException e) {
            // 
            assertEquals("Cannot get Map key. Invalid property name. 'aaa@name='bbb']'", e.getMessage());
            assertTrue(LogUTUtil.checkError("Cannot get Map key. Invalid property name. 'aaa@name='bbb']'"));
        }
    }

    /**
     * testExtractMapKey05()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() node:"aaa"<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException("Cannot get Map key. Invalid property name. 'aaa'")<br>
     *         (ԕω) O:OxFG[<br>
     *                    Cannot get Map key. Invalid property name. 'aaa'<br>
     *         
     * <br>
     * node[]Ȃꍇ̎B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractMapKey05() throws Exception {
        // O
        JXPathIndexedBeanWrapperImpl target =
            new JXPathIndexedBeanWrapperImpl("");

        // eXg{
        try {
            target.extractMapKey("aaa");
            fail();

        } catch (IllegalArgumentException e) {
            // 
            assertEquals("Cannot get Map key. Invalid property name. 'aaa'", e.getMessage());
            assertTrue(LogUTUtil.checkError("Cannot get Map key. Invalid property name. 'aaa'"));
        }
    }

    /**
     * testExtractMapKey06()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() node:"aaa]@name='bbb'["<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException("Cannot get Map key. Invalid property name. 'aaa]@name='bbb'['")<br>
     *         (ԕω) O:OxFG[<br>
     *                    Cannot get Map key. Invalid property name. 'aaa]@name='bbb'['<br>
     *         
     * <br>
     * node[]t̏ꍇ̎B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractMapKey06() throws Exception {
        // O
        JXPathIndexedBeanWrapperImpl target =
            new JXPathIndexedBeanWrapperImpl("");

        // eXg{
        try {
            target.extractMapKey("aaa]@name='bbb'[");
            fail();

        } catch (IllegalArgumentException e) {
            // 
            assertEquals("Cannot get Map key. Invalid property name. 'aaa]@name='bbb'['", e.getMessage());
            assertTrue(LogUTUtil.checkError("Cannot get Map key. Invalid property name. 'aaa]@name='bbb'['"));
        }
    }

    /**
     * testExtractMapKey07()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() node:""<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException("Cannot get Map key. Invalid property name. ''")<br>
     *         (ԕω) O:OxFG[<br>
     *                    Cannot get Map key. Invalid property name. ''<br>
     *         
     * <br>
     * node󕶎̏ꍇ̎B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractMapKey07() throws Exception {
        // O
        JXPathIndexedBeanWrapperImpl target =
            new JXPathIndexedBeanWrapperImpl("");

        // eXg{
        try {
            target.extractMapKey("");
            fail();

        } catch (IllegalArgumentException e) {
            // 
            assertEquals("Cannot get Map key. Invalid property name. ''", e.getMessage());
            assertTrue(LogUTUtil.checkError("Cannot get Map key. Invalid property name. ''"));
        }
    }

    /**
     * testExtractDecrementIndex01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() node:"[3]"<br>
     *         () X^uextractIncrementIndex()̖߂l:"test[3]&-1"<br>
     *         
     * <br>
     * ҒlF(߂l) String:"[3]:-1"<br>
     *         (ԕω) extractIncrementIndex()<br>
     *                    ̈:property="[3]"<br>
     *                    increment=-1<br>
     *                    (property+":"+increment𓖃\bh̖߂lƂ)<br>
     *         
     * <br>
     * extractIncrementIndex()𐳂ĂяoĂ邱Ƃ̎B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractDecrementIndex01() throws Exception {
        // O
        String result = null;
        JXPathIndexedBeanWrapperImplStub02 target =
            new JXPathIndexedBeanWrapperImplStub02("");

        // eXg{
        result = target.extractDecrementIndex("[3]");

        // 
        assertEquals("[3]:-1", result);
    }

    /**
     * testIsMapAttribute01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() node:"z[@name]"<br>
     *         
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         
     * <br>
     * MapIuWFNg̏ꍇ̎Bnode̓r"[@name"
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testIsMapAttribute01() throws Exception {
        // O
        boolean result = false;
        JXPathIndexedBeanWrapperImpl target =
            new JXPathIndexedBeanWrapperImpl("");

        // eXg{
        result = target.isMapAttribute("z[@name]");

        // 
        assertTrue(result);
    }

    /**
     * testIsMapAttribute02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() node:"@name"<br>
     *         
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         
     * <br>
     * MapIuWFNgȊȌꍇ̎B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testIsMapAttribute02() throws Exception {
        // O
        boolean result = true;
        JXPathIndexedBeanWrapperImpl target =
            new JXPathIndexedBeanWrapperImpl("");

        // eXg{
        result = target.isMapAttribute("@name");

        // 
        assertFalse(result);
    }

    /**
     * testIsMapAttribute03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() node:""<br>
     *         
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         
     * <br>
     * node󕶎̏ꍇ̎B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testIsMapAttribute03() throws Exception {
        // O
        boolean result = true;
        JXPathIndexedBeanWrapperImpl target =
            new JXPathIndexedBeanWrapperImpl("");

        // eXg{
        result = target.isMapAttribute("");

        // 
        assertFalse(result);
    }

    /**
     * testIsMapObject01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() node:".[@name"<br>
     *         
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         
     * <br>
     * MapIuWFNg̏ꍇ̎B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testIsMapObject01() throws Exception {
        // O
        boolean result = false;
        JXPathIndexedBeanWrapperImpl target =
            new JXPathIndexedBeanWrapperImpl("");

        // eXg{
        result = target.isMapObject(".[@name");

        // 
        assertTrue(result);
    }

    /**
     * testIsMapObject02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() node:"a.[@name=]"<br>
     *         
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         
     * <br>
     * MapIuWFNgȊȌꍇ̎B".[@name"擪n܂ȂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testIsMapObject02() throws Exception {
        // O
        boolean result = true;
        JXPathIndexedBeanWrapperImpl target =
            new JXPathIndexedBeanWrapperImpl("");

        // eXg{
        result = target.isMapObject("a.[@name=]");

        // 
        assertFalse(result);
    }

    /**
     * testIsMapObject03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() node:""<br>
     *         
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         
     * <br>
     * node󕶎̏ꍇ̎B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testIsMapObject03() throws Exception {
        // O
        boolean result = true;
        JXPathIndexedBeanWrapperImpl target =
            new JXPathIndexedBeanWrapperImpl("");

        // eXg{
        result = target.isMapObject("");

        // 
        assertFalse(result);
    }

}
