/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.validation;

import org.apache.commons.validator.Field;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.Var;

import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.fw.validation.FieldChecks;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.validation.FieldChecks}
 * NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * TERASOLUNA̓̓`FbN@\ŋʂɎgp錟؃[NXB
 * <p>
 *
 * @see jp.terasoluna.fw.validation.FieldChecks
 */
public class FieldChecksTest09 extends TestCase {

    /**
     * eXgpCX^XB
     */
    private ValidatorAction va = null;

    /**
     * eXgpCX^XB
     */
    private Field field = null;

    /**
     * eXgpCX^XB
     */
    private FieldChecks_ValidationErrorsImpl01 errors = null;

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(FieldChecksTest09.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        va = new ValidatorAction();
        field = new Field();
        errors = new FieldChecks_ValidationErrorsImpl01();
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public FieldChecksTest09(String name) {
        super(name);
    }

    /**
     * testValidateUrl01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:null<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * beannull̏ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateUrl01() throws Exception {
        // eXg{
        // 
        assertTrue(new FieldChecks().validateUrl(null, va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateUrl02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * bean󕶎̏ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateUrl02() throws Exception {
        // eXg{
        // 
        assertTrue(new FieldChecks().validateUrl("", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateUrl03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:abc://terasoluna.com/index.html#fragment<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                allowallschemes=true<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * varallowallschemestruêƂAbeañXL[}sȏꍇłtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateUrl03() throws Exception {
        // O
        Var var = new Var();
        var.setName("allowallschemes");
        var.setValue("true");
        field.addVar(var);

        // eXg{
        // 
        assertTrue(new FieldChecks().validateUrl(
            "abc://terasoluna.com/index.html#fragment", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateUrl04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:abc://terasoluna.com/index.html<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                allowallschemes=null<br>
     *                schemes=http,ftp<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂaddErrorsĂяoB<br>
     *
     * <br>
     * varallowallschemesnullŁAbeañXL[}varschemesɎw肳ꂽXL[}ƈvȂꍇAG[ǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateUrl04() throws Exception {
        // O
        Var var = new Var();
        var.setName("schemes");
        var.setValue("http,ftp");
        field.addVar(var);

        // eXg{
        // 
        assertFalse(new FieldChecks().validateUrl(
            "abc://terasoluna.com/index.html", va, field, errors));

        // addErrorsmF
        assertEquals(1, errors.addErrorCount);
        assertEquals("abc://terasoluna.com/index.html", errors.beanList.get(0));
        assertSame(va, errors.vaList.get(0));
        assertSame(field, errors.fieldList.get(0));
    }

    /**
     * testValidateUrl05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:abc://terasoluna.com/index.html<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                allowallschemes=""<br>
     *                schemes=http,ftp<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂ
     *                           addErrorsĂяoB<br>
     *
     * <br>
     * varallowallschemes󕶎ŁA
     * beañXL[}varschemesɎw肳ꂽXL[}ƈvȂꍇA
     * G[ǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateUrl05() throws Exception {
        // O
        Var var1 = new Var();
        var1.setName("allowallschemes");
        var1.setValue("");
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("schemes");
        var2.setValue("http,ftp");
        field.addVar(var2);

        // eXg{
        // 
        assertFalse(new FieldChecks().validateUrl(
            "abc://terasoluna.com/index.html", va, field, errors));

        // addErrorsmF
        assertEquals(1, errors.addErrorCount);
        assertEquals("abc://terasoluna.com/index.html", errors.beanList.get(0));
        assertSame(va, errors.vaList.get(0));
        assertSame(field, errors.fieldList.get(0));
    }

    /**
     * testValidateUrl06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:abc://terasoluna.com/index.html<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                allowallschemes="test"<br>
     *                schemes=http,ftp<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂ
     *                           addErrorsĂяoB<br>
     *
     * <br>
     * varallowallschemestrueȊO̕ŁA
     * beañXL[}varschemesɎw肳ꂽXL[}ƈvȂꍇA
     * G[ǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateUrl06() throws Exception {
        // O
        Var var1 = new Var();
        var1.setName("allowallschemes");
        var1.setValue("test");
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("schemes");
        var2.setValue("http,ftp");
        field.addVar(var2);

        // eXg{
        // 
        assertFalse(new FieldChecks().validateUrl(
            "abc://terasoluna.com/index.html", va, field, errors));

        // addErrorsmF
        assertEquals(1, errors.addErrorCount);
        assertEquals("abc://terasoluna.com/index.html", errors.beanList.get(0));
        assertSame(va, errors.vaList.get(0));
        assertSame(field, errors.fieldList.get(0));
    }

    /**
     * testValidateUrl07()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:abc://terasoluna.com/index.html<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                allowallschemes="test"<br>
     *                schemes=http,ftp,abc<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * varallowallschemestrueȊO̕ŁA
     * beañXL[}varschemesɎw肳ꂽXL[}ƈvꍇA
     * trueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateUrl07() throws Exception {
        // O
        Var var1 = new Var();
        var1.setName("allowallschemes");
        var1.setValue("test");
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("schemes");
        var2.setValue("http,ftp,abc");
        field.addVar(var2);

        // eXg{
        // 
        assertTrue(new FieldChecks().validateUrl(
            "abc://terasoluna.com/index.html", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateUrl08()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:abc://terasoluna.com//index.html<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                allowallschemes="true"<br>
     *                allow2slashes="true"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * varallow2slashestruêƂAbeanurl̋؂蕶Ɂu//v܂܂ĂĂtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateUrl08() throws Exception {
        // O
        Var var1 = new Var();
        var1.setName("allowallschemes");
        var1.setValue("true");
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("allow2slashes");
        var2.setValue("true");
        field.addVar(var2);

        // eXg{
        // 
        assertTrue(new FieldChecks().validateUrl(
            "abc://terasoluna.com//index.html", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateUrl09()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:abc://terasoluna.com//index.html<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                allowallschemes="true"<br>
     *                allow2slashes=null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂ
     *                           addErrorsĂяoB<br>
     *
     * <br>
     * varallow2slashesnullŁA
     * beanurl̋؂蕶Ɂu//v܂܂ĂꍇA
     * G[ǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateUrl09() throws Exception {
        // O
        Var var = new Var();
        var.setName("allowallschemes");
        var.setValue("true");
        field.addVar(var);

        // eXg{
        // 
        assertFalse(new FieldChecks().validateUrl(
            "abc://terasoluna.com//index.html", va, field, errors));

        // addErrorsmF
        assertEquals(1, errors.addErrorCount);
        assertEquals("abc://terasoluna.com//index.html", errors.beanList.get(0));
        assertSame(va, errors.vaList.get(0));
        assertSame(field, errors.fieldList.get(0));
    }

    /**
     * testValidateUrl10()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:abc://terasoluna.com//index.html<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                allowallschemes="true"<br>
     *                allow2slashes=""<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂ
     *                           addErrorsĂяoB<br>
     *
     * <br>
     * varallow2slashes󕶎ŁA
     * beanurl̋؂蕶Ɂu//v܂܂ĂꍇA
     * G[ǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateUrl10() throws Exception {
        // O
        Var var1 = new Var();
        var1.setName("allowallschemes");
        var1.setValue("true");
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("allow2slashes");
        var2.setValue("");
        field.addVar(var2);

        // eXg{
        // 
        assertFalse(new FieldChecks().validateUrl(
            "abc://terasoluna.com//index.html", va, field, errors));

        // addErrorsmF
        assertEquals(1, errors.addErrorCount);
        assertEquals("abc://terasoluna.com//index.html", errors.beanList.get(0));
        assertSame(va, errors.vaList.get(0));
        assertSame(field, errors.fieldList.get(0));
    }

    /**
     * testValidateUrl11()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:abc://terasoluna.com//index.html<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                allowallschemes="true"<br>
     *                allow2slashes="test"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂ
     *                           addErrorsĂяoB<br>
     *
     * <br>
     * varallow2slashestrueȊO̕ŁA
     * beanurl̋؂蕶Ɂu//v܂܂ĂꍇA
     * G[ǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateUrl11() throws Exception {
        // O
        Var var1 = new Var();
        var1.setName("allowallschemes");
        var1.setValue("true");
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("allow2slashes");
        var2.setValue("test");
        field.addVar(var2);

        // eXg{
        // 
        assertFalse(new FieldChecks().validateUrl(
            "abc://terasoluna.com//index.html", va, field, errors));

        // addErrorsmF
        assertEquals(1, errors.addErrorCount);
        assertEquals("abc://terasoluna.com//index.html", errors.beanList.get(0));
        assertSame(va, errors.vaList.get(0));
        assertSame(field, errors.fieldList.get(0));
    }

    /**
     * testValidateUrl12()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:abc://terasoluna.com/index.html#fragment<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                allowallschemes="true"<br>
     *                nofragments="true"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂ
     *                           addErrorsĂяoB<br>
     *
     * <br>
     * varnofragmentstrueŁAbeanurlɃtOg݂ꍇA
     * G[ǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateUrl12() throws Exception {
        // O
        Var var1 = new Var();
        var1.setName("allowallschemes");
        var1.setValue("true");
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("nofragments");
        var2.setValue("true");
        field.addVar(var2);

        // eXg{
        // 
        assertFalse(new FieldChecks().validateUrl(
            "abc://terasoluna.com/index.html#fragment", va, field, errors));

        // addErrorsmF
        assertEquals(1, errors.addErrorCount);
        assertEquals("abc://terasoluna.com/index.html#fragment",
                errors.beanList.get(0));
        assertSame(va, errors.vaList.get(0));
        assertSame(field, errors.fieldList.get(0));
    }

    /**
     * testValidateUrl13()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:abc://terasoluna.com/index.html#fragment<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                allowallschemes="true"<br>
     *                nofragments=null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * varnofragmentsnullŁAbeanurlɃtOg݂ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateUrl13() throws Exception {
        // O
        Var var = new Var();
        var.setName("allowallschemes");
        var.setValue("true");
        field.addVar(var);

        // eXg{
        // 
        assertTrue(new FieldChecks().validateUrl(
            "abc://terasoluna.com/index.html#fragment", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateUrl14()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:abc://terasoluna.com/index.html#fragment<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                allowallschemes="true"<br>
     *                nofragments=""<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * varnofragments󕶎ŁAbeanurlɃtOg݂ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateUrl14() throws Exception {
        // O
        Var var1 = new Var();
        var1.setName("allowallschemes");
        var1.setValue("true");
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("nofragments");
        var2.setValue("");
        field.addVar(var2);

        // eXg{
        // 
        assertTrue(new FieldChecks().validateUrl(
            "abc://terasoluna.com/index.html#fragment", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateUrl15()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:abc://terasoluna.com/index.html#fragment<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                allowallschemes="true"<br>
     *                nofragments="test"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * varnofragmentstrueȊO̕ŁA
     * beanurlɃtOg݂ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateUrl15() throws Exception {
        // O
        Var var1 = new Var();
        var1.setName("allowallschemes");
        var1.setValue("true");
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("nofragments");
        var2.setValue("test");
        field.addVar(var2);

        // eXg{
        // 
        assertTrue(new FieldChecks().validateUrl(
            "abc://terasoluna.com/index.html#fragment", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateByteRange01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:null<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * beannull̏ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateByteRange01() throws Exception {
        // eXg{
        // 
        assertTrue(new FieldChecks().validateByteRange(null, va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateByteRange02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * bean󕶎̏ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateByteRange02() throws Exception {
        // eXg{
        // 
        assertTrue(new FieldChecks().validateByteRange("", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateByteRange03()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF,G
     * <br><br>
     * ͒lF() bean:"test"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                minByteLength="test"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ValidatorException<br>
     *                    bZ[WF"Mistake on validation definition file.
     *                    - minByteLength is not number.
     *                    You'll have to check it over. "<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF"Mistake on validation definition file.
     *                    - minByteLength is not number.
     *                    You'll have to check it over. ", new NumberFormatException()<br>
     *
     * <br>
     * varmaxByteLength̒llɕϊłȂꍇA
     * ValidatorException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateByteRange03() throws Exception {
        // O
        Var var = new Var();
        var.setName("minByteLength");
        var.setValue("test");
        field.addVar(var);

        // eXg{
        // 
        try {
            new FieldChecks().validateByteRange("test", va, field, errors);
            fail();
        } catch (ValidatorException e) {
            String message = "Mistake on validation definition file. " +
                    "- minByteLength is not number. " +
                    "You'll have to check it over. ";
            assertEquals(message, e.getMessage());
            assertTrue(LogUTUtil.checkError(message, new NumberFormatException()));
        }
    }

    /**
     * testValidateByteRange04()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF,G
     * <br><br>
     * ͒lF() bean:"test"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                maxByteLength="test"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ValidatorException<br>
     *                    bZ[WF"Mistake on validation definition file.
     *                    - maxByteLength is not number.
     *                    You'll have to check it over. "<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF"Mistake on validation definition file.
     *                    - maxByteLength is not number.
     *                    You'll have to check it over. ", new NumberFormatException()<br>
     *
     * <br>
     * varmaxByteLength̒llɕϊłȂꍇA
     * ValidatorException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateByteRange04() throws Exception {
        // O
        Var var = new Var();
        var.setName("maxByteLength");
        var.setValue("test");
        field.addVar(var);

        // eXg{
        // 
        try {
            new FieldChecks().validateByteRange("test", va, field, errors);
            fail();
        } catch (ValidatorException e) {
            String message = "Mistake on validation definition file. " +
                    "- maxByteLength is not number. " +
                    "You'll have to check it over. ";
            assertEquals(message, e.getMessage());
            assertTrue(LogUTUtil.checkError(message, new NumberFormatException()));
        }
    }

    /**
     * testValidateByteRange05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"test"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                minByteLength=null<br>
     *                maxByteLength=null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * varminByteLengthAmaxByteLengthnull̏ꍇA
     * ͈͂0`Integer.MAX_LENGTHƂă`FbNs邱ƂmFB<br>
     * EleXg͕Iɕs\ȂߏȗB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateByteRange05() throws Exception {
        // eXg{
        // 
        assertTrue(new FieldChecks().validateByteRange("test", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateByteRange06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"test"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                minByteLength=""<br>
     *                maxByteLength=""<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * varminByteLengthAmaxByteLength󕶎̏ꍇA
     * ͈͂0`Integer.MAX_LENGTHƂă`FbNs邱ƂmFB<br>
     * EleXg͕Iɕs\ȂߏȗB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateByteRange06() throws Exception {
        // O
        Var var1 = new Var();
        var1.setName("minByteLength");
        var1.setValue("");
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("minByteLength");
        var2.setValue("");
        field.addVar(var2);

        // eXg{
        // 
        assertTrue(new FieldChecks().validateByteRange("test", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateByteRange07()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF,G
     * <br><br>
     * ͒lF() bean:"test"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                encoding="test"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ValidatorException<br>
     *                    bZ[WF"encoding[test] is not supported."<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF"encoding[test] is not supported."<br>
     *
     * <br>
     * varencodingT|[gȂGR[fBȌꍇA
     * ValidatorException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateByteRange07() throws Exception {
        // O
        Var var = new Var();
        var.setName("encoding");
        var.setValue("test");
        field.addVar(var);

        // eXg{
        // 
        try {
            new FieldChecks().validateByteRange("test", va, field, errors);
            fail();
        } catch (ValidatorException e) {
            String message = "encoding[test] is not supported.";
            assertEquals(message, e.getMessage());
            assertTrue(LogUTUtil.checkError(message));
        }
    }

    /**
     * testValidateByteRange08()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:""<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                minByteLength="6"<br>
     *                maxByteLength="6"<br>
     *                encoding=null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * varencodingnull̏ꍇA
     * ftHg̃GR[fBOŃGR[hs邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateByteRange08() throws Exception {
        // O
        Var var1 = new Var();
        var1.setName("minByteLength");
        var1.setValue("6");
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("maxByteLength");
        var2.setValue("6");
        field.addVar(var2);

        // eXg{
        // 
        assertTrue(new FieldChecks().validateByteRange("", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateByteRange09()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:""<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                minByteLength="6"<br>
     *                maxByteLength="6"<br>
     *                encoding=""<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * varencoding󕶎̏ꍇA
     * ftHg̃GR[fBOŃGR[hs邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateByteRange09() throws Exception {
        // O
        Var var1 = new Var();
        var1.setName("minByteLength");
        var1.setValue("6");
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("maxByteLength");
        var2.setValue("6");
        field.addVar(var2);
        
        Var var3 = new Var();
        var3.setName("encoding");
        var3.setValue("");
        field.addVar(var3);

        // eXg{
        // 
        assertTrue(new FieldChecks().validateByteRange("", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateByteRange10()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:""<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                minByteLength="7"<br>
     *                maxByteLength="10"<br>
     *                encoding="UTF-8"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * bean̒lw肵GR[fBOŔ͈͓łꍇA
     * true擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateByteRange10() throws Exception {
        // O
        Var var1 = new Var();
        var1.setName("minByteLength");
        var1.setValue("7");
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("maxByteLength");
        var2.setValue("10");
        field.addVar(var2);
        
        Var var3 = new Var();
        var3.setName("encoding");
        var3.setValue("UTF-8");
        field.addVar(var3);

        // eXg{
        // 
        assertTrue(new FieldChecks().validateByteRange("", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateByteRange11()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:""<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                minByteLength="7"<br>
     *                maxByteLength="10"<br>
     *                encoding="Windows-31J"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂ
     *                           addErrorsĂяoB<br>
     *
     * <br>
     * bean̒lvarencodingŃGR[hoCg
     * minByteLength̒l菬ꍇA
     * G[ǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateByteRange11() throws Exception {
        // O
        Var var1 = new Var();
        var1.setName("minByteLength");
        var1.setValue("7");
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("maxByteLength");
        var2.setValue("10");
        field.addVar(var2);
        
        Var var3 = new Var();
        var3.setName("encoding");
        var3.setValue("Windows-31J");
        field.addVar(var3);

        // eXg{
        // 
        assertFalse(new FieldChecks().validateByteRange("", va, field, errors));

        // addErrorsmF
        assertEquals(1, errors.addErrorCount);
        assertEquals("", errors.beanList.get(0));
        assertSame(va, errors.vaList.get(0));
        assertSame(field, errors.fieldList.get(0));
    }

    /**
     * testValidateByteRange12()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:""<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                minByteLength="5"<br>
     *                maxByteLength="8"<br>
     *                encoding="UTF-8"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂ
     *                           addErrorsĂяoB<br>
     *
     * <br>
     * bean̒lvarencodingŃGR[hoCg
     * maxByteLength̒l傫ꍇA
     * G[ǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateByteRange12() throws Exception {
        // O
        Var var1 = new Var();
        var1.setName("minByteLength");
        var1.setValue("5");
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("maxByteLength");
        var2.setValue("8");
        field.addVar(var2);
        
        Var var3 = new Var();
        var3.setName("encoding");
        var3.setValue("UTF-8");
        field.addVar(var3);

        // eXg{
        // 
        assertFalse(new FieldChecks().validateByteRange("", va, field, errors));

        // addErrorsmF
        assertEquals(1, errors.addErrorCount);
        assertEquals("", errors.beanList.get(0));
        assertSame(va, errors.vaList.get(0));
        assertSame(field, errors.fieldList.get(0));
    }

}
