/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.taglib;

import java.io.IOException;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.Tag;

import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.TagUTUtil;
import jp.terasoluna.utlib.UTUtil;
import jp.terasoluna.utlib.exception.Exception_BodyContentImpl;
import jp.terasoluna.utlib.exception.Exception_JspWriterImpl;
import junit.framework.TestCase;

/**
 * IfAuthorizedBlockTag ubN{bNXeXgB<br>
 * O<br>
 * -<br>
 */
public class IfAuthorizedBlockTagTest extends TestCase {

    // eXgΏۃNX
    IfAuthorizedBlockTag tag = null;
    
    /**
     * Constructor for IterateRowSetTeiTest.
     * @param arg0
     */
    public IfAuthorizedBlockTagTest(String arg0) {
        super(arg0);
    }

    /**
     * @see TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        tag = (IfAuthorizedBlockTag) TagUTUtil.create(
                IfAuthorizedBlockTag.class);
        LogUTUtil.flush();

    }

    /**
     * @see TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * testSetBlockId01()B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lF"blockId"
     * 
     * ҒlFɂĐݒ肵l
     *
     * Őݒ肵lݒ肳Ă邱ƂmFB
     *
     * @throws Exception eXgR[h̖{Ƃ̖O
     */
    public void testSetBlockId01() throws Exception {
        // eXgf[^ݒ
        String value = "blockId";

        // eXgs
        tag.setBlockId(value);

        // ʊmF
        String result = (String) UTUtil.getPrivateField(tag, "blockId");
        assertEquals(value, result);
    }

    /**
     * testSetParentBlockId01()B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒lF"parentBlockId"
     * 
     * ҒlFɂĐݒ肵l
     *
     * Őݒ肵lݒ肳Ă邱ƂmFB
     *
     * @throws Exception eXgR[h̖{Ƃ̖O
     */
    public void testSetParentBlockId01() throws Exception {
        // eXgf[^ݒ
        String value = "parentBlockId";

        // eXgs
        tag.setParentBlockId(value);

        // ʊmF
        String result = (String) UTUtil.getPrivateField(tag, "parentBlockId");
        assertEquals(value, result);
    }

    /**
     * testRelease01B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒l
     * this.blockId=*<br>
     * this.parentBlockId=*<br>
     *
     * ߂l:void<br>
     * this.blockId=null<br>
     * this.parentBlockId=null<br>
     *
     * OƂĐݒ肵elAsɊel
     * 邱ƂmF<br>
     */
    public void testRelease01() throws Exception {
        // eXgf[^ݒ
        String blockId = "";
        String parentBlockId = "";

        UTUtil.setPrivateField(tag, "blockId", blockId);
        UTUtil.setPrivateField(tag, "parentBlockId", parentBlockId);

        // eXgs
        tag.release();

        // eXgʊmF

        String blockId2 = (String) UTUtil.getPrivateField(tag, "blockId");
        String parentBlockId2 =
            (String) UTUtil.getPrivateField(tag, "parentBlockId");

        assertNull(blockId2);
        assertNull(parentBlockId2);

    }

    /**
     * testDoStartTag01B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒l
     * this.blockId=not null<br>
     *
     * ߂l:int=EVAL_BODY_BUFFERED<br>
     *
     * "this.blockId"not null̏ꍇAEVAL_BODY_BUFFERED
     * Ԃ邱ƂmF<br>
     */
    public void testDoStartTag01() throws Exception {
        // eXgf[^ݒ
        // ubNID̐ݒ
        UTUtil.setPrivateField(tag, "blockId", "blockId");

        //eXgs
        int result = tag.doStartTag();

        //eXgʊmF
        assertEquals(BodyTag.EVAL_BODY_BUFFERED, result);

    }

    /**
     * testDoStartTag02B<br>
     *
     * (ُn)<br>
     * ϓ_FG<br>
     *
     * ͒l
     * this.blockId=null<br>
     *
     * ߂l:int=JspException<br>
     *
     * "this.blockId"null̏ꍇAJspException邱ƂmF<br>
     */
    public void testDoStartTag02() throws Exception {
        // eXgf[^ݒ
        // ubNID̐ݒ
        UTUtil.setPrivateField(tag, "blockId", null);

        // eXgs
        try {
            tag.doStartTag();
            fail();
        } catch (JspException e) {
            // eXgʊmF
            assertEquals("blockId is required.", e.getMessage());
            return;
        }

    }

    /**
     * testDoAfterBody01B<br>
     *
     * (n)<br>
     * ϓ_FC<br>
     *
     * ͒l
     * blockId=null<br>
     * parentBlockId=null<br>
     *
     * ߂l:int=SKIP_BODY<br>
     *        parentBlockId=null<br>
     *
     *EblockIdnull̏ꍇASKIP_BODYԂ邱ƂmFB<br>
     *EANZX`FbNʂۑĂȂƂmF<br>
     */
    public void testDoAfterBody01() throws Exception {
        // eXgf[^ݒ
        // ubNID̐ݒ
        UTUtil.setPrivateField(tag, "blockId", null);
        // parentBlockID̐ݒ
        UTUtil.setPrivateField(tag, "parentBlockId", null);
        // eXgs
        int result = tag.doAfterBody();

        // eXgʊmF
        assertEquals(Tag.SKIP_BODY, result);

        // PageContext
        PageContext pc = TagUTUtil.getPageContext(tag);
        Boolean parentBlockId = (Boolean) pc.getAttribute("parentBlockId");
        assertNull(parentBlockId);
    }

    /**
     * testDoAfterBody02B<br>
     *
     * (n)<br>
     * ϓ_FA,F<br>
     *
     * ͒l
     * blockId= not null<br>
     * blockInfo= false<br>
     * parentBlockId=null<br>
     *
     * ߂l:int=SKIP_BODY<br>
     *        parentBlockId=null<br>
     *
     * blockIdnot null̏ꍇASKIP_BODYԂ邱ƂmFB<br>
     * EANZX`FbNʂۑĂȂƂmF<br>
     */
    public void testDoAfterBody02() throws Exception {
        // eXgf[^ݒ
        // ubNID̐ݒ
        UTUtil.setPrivateField(tag, "blockId", "blockId");
        // eubNID̐ݒ
        UTUtil.setPrivateField(tag, "parentBlockId", null);
        // blockInfo̐ݒ
        PageContext pc = TagUTUtil.getPageContext(tag);
        pc.setAttribute(
            "blockId",
            new Boolean("false"),
            PageContext.PAGE_SCOPE);

        // eXgs
        int result = tag.doAfterBody();

        // eXgʊmF
        assertEquals(Tag.SKIP_BODY, result);

        // PageContext
        pc = TagUTUtil.getPageContext(tag);
        Boolean parentBlockId = (Boolean) pc.getAttribute("parentBlockId");
        assertNull(parentBlockId);

    }

    /**
     * testDoAfterBody03B<br>
     *
     * (n)<br>
     * ϓ_FA,F<br>
     *
     * ͒l
     * blockId= not null<br>
     * blockInfo= false<br>
     * parentBlockId=not null<br>
     *
     * ߂l:int=SKIP_BODY<br>
     *        parentBlockId=false<br>
     *
     * blockIdnot null̏ꍇASKIP_BODYԂ邱ƂmFB<br>
     * EANZX`FbNʂۑĂ邱ƂmF<br>
     */
    public void testDoAfterBody03() throws Exception {
        // eXgf[^ݒ
        // ubNID̐ݒ
        UTUtil.setPrivateField(tag, "blockId", "blockId");
        // eubNID̐ݒ
        UTUtil.setPrivateField(tag, "parentBlockId", "parentBlockId");
        //blockInfo̐ݒ
        PageContext pc = TagUTUtil.getPageContext(tag);
        pc.setAttribute(
            "blockId",
            new Boolean("false"),
            PageContext.PAGE_SCOPE);

        // eXgs
        int result = tag.doAfterBody();

        // eXgʊmF
        assertEquals(Tag.SKIP_BODY, result);

        // PageContext
        pc = TagUTUtil.getPageContext(tag);
        Boolean parentBlockId = (Boolean) pc.getAttribute("parentBlockId");
        assertFalse(parentBlockId.booleanValue());

    }

    /**
     * testDoAfterBody04B<br>
     *
     * (n)<br>
     * ϓ_FA,F<br>
     *
     * ͒l
     * blockId= not null<br>
     * blockInfo= true<br>
     * parentBlockId=not null<br>
     *
     * ߂l:int=SKIP_BODY<br>
     *        parentBlockId=true<br>
     *
     * blockIdnot null̏ꍇASKIP_BODYԂ邱ƂmFB<br>
     * EANZX`FbNʂۑĂ邱ƂmF<br>
     */
    public void testDoAfterBody04() throws Exception {
        // eXgf[^ݒ
        // ubNID̐ݒ
        UTUtil.setPrivateField(tag, "blockId", "blockId");
        // eubNID̐ݒ
        UTUtil.setPrivateField(tag, "parentBlockId", "parentBlockId");
        // blockInfo̐ݒ
        PageContext pc = TagUTUtil.getPageContext(tag);
        pc.setAttribute("blockId", new Boolean("True"), PageContext.PAGE_SCOPE);

        // bodyContent
        UTUtil.setPrivateField(tag, "bodyContent", pc.pushBody());

        // eXgs
        int result = tag.doAfterBody();

        // eXgʊmF
        assertEquals(Tag.SKIP_BODY, result);

        // PageContext
        pc = TagUTUtil.getPageContext(tag);
        Boolean parentBlockId = (Boolean) pc.getAttribute("parentBlockId");
        assertTrue(parentBlockId.booleanValue());

    }

    /**
     * testDoAfterBody05B<br>
     *
     * (n)<br>
     * ϓ_FA<br>
     *
     * ͒l
     * blockId= not null<br>
     * blockInfo= Boolean^ȊO<br>
     * parentBlockId=not null<br>
     *
     * ߂l:ClassCastExceptionĂ郍O\<br>
     *       int=SKIP_BODYԋpB<br>
     *
     * pageContext ubNCastۂɁA<br>
     * ClassCastException邱ƂmFB<br>
     * ClassCastExceptionĂA͎sASKIP_BODYԂB<br>
     */
    public void testDoAfterBody05() throws Exception {
        // eXgf[^ݒ
        // ubNID̐ݒ
        UTUtil.setPrivateField(tag, "blockId", "blockId");
        // eubNID̐ݒ
        UTUtil.setPrivateField(tag, "parentBlockId", "parentBlockId");
        // blockInfo̐ݒ
        PageContext pc = TagUTUtil.getPageContext(tag);
        Object obj = "a";
        pc.setAttribute("blockId", obj, PageContext.PAGE_SCOPE);

        // bodyContent
        UTUtil.setPrivateField(
            tag,
            "bodyContent",
            pc.pushBody());

        // eXgs
        int result = tag.doAfterBody();

        // ʂ̊mF
        // ClassCastExceptionNǂlogmFB
        boolean logCheck = LogUTUtil.checkWarn("Class cast error.",
                new ClassCastException());
        assertTrue(logCheck);
        assertEquals(Tag.SKIP_BODY, result);
    }

    /**
     * testDoAfterBody06B<br>
     *
     * (ُn)<br>
     * ϓ_FG<br>
     *
     * ͒l
     * blockId= not null<br>
     * blockInfo= true<br>
     * parentBlockId=not null<br>
     *
     * ߂l:IOException<br>
     *
     * bodyContent.writeOut()sۂɁA<br>
     * IOExceptionԂ邱ƂmFB<br>
     */
    public void testDoAfterBody06() throws Exception {
        // eXgf[^ݒ
        // ubNID̐ݒ
        UTUtil.setPrivateField(tag, "blockId", "blockId");
        // eubNID̐ݒ
        UTUtil.setPrivateField(tag, "parentBlockId", "parentBlockId");
        // blockInfo̐ݒ
        PageContext pc = TagUTUtil.getPageContext(tag);
        pc.setAttribute("blockId", new Boolean("True"), PageContext.PAGE_SCOPE);

        // bodyContent
        UTUtil.setPrivateField(tag, "bodyContent", pc
                .pushBody());
        // IOExceptionݒ
        Exception_JspWriterImpl jsp = new Exception_JspWriterImpl();
        Exception_BodyContentImpl exception = new Exception_BodyContentImpl(jsp);
        exception.setTrue();
        exception.setTiming(1);
        UTUtil.setPrivateField(tag, "bodyContent", exception);
        // eXgs
        try {
            tag.doAfterBody();
            fail();
        } catch (JspException ex) {
            // eXgʊmF
            assertEquals(IOException.class.getName(), ex.getRootCause()
                    .getClass().getName());
            return;
        }
    }

    /**
     * testDoEndTag01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     *   
     * ͒l:Ȃ<br>
     * 
     * Ғl
     * ߂l:int=EVAL_PAGE<br>
     * 
     * EVAL_PAGEԋpB<br>
     */
    public void testDoEndTag01() throws Exception {

        int result = 0;
        // eXgs
        result = tag.doEndTag();

        // eXgʊmF
        assertEquals(Tag.EVAL_PAGE, result);
    }
}
