/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.springmvc.servlet.view.velocity;

import org.springframework.web.servlet.view.AbstractUrlBasedView;
import org.springframework.web.servlet.view.velocity.VelocityView;
import org.springframework.web.servlet.view.velocity.VelocityViewResolver;

/**
 * GR[fBOw肪\VelocityViewResolvergNXB
 * 
 * SpringVelocityViewResolvergA
 * View̃GR[fBOw\ɂĂB
 * 
 * <p>
 * VelocityViewResolverŐݒ\ȃvpeBɉA
 * ȉ̃vpeBݒ肷邱ƁB
 * </p>
 * 
 * <p>
 *   <table border="1" CELLPADDING="8">
 *     <th></th>
 *     <th></th>
 *  
 *     <tr>
 *       <td align=center><b>encoding</b></td>
 *       <td>View̃GR[fBOݒ</td>
 *     </tr>
 *  </table>
 * 
 * </p>
 *  yBean`t@C̐ݒz<br>
 * <code><pre>
 *   &lt;bean id="viewResolver" 
 *           class="jp.terasoluna.fw.web.rich.springmvc.servlet.view.velocity.VelocityViewResolverEx"&gt;
 *       &lt;property name="cache"&gt;&lt;value&gt;true&lt;/value&gt;&lt;/property&gt;
 *       &lt;property name="requestContextAttribute" value="rc"/&gt;
 *       &lt;property name="prefix"&gt;&lt;value&gt;&lt;/value&gt;&lt;/property&gt;
 *       &lt;property name="suffix"&gt;&lt;value&gt;.vm&lt;/value&gt;&lt;/property&gt;
 *       &lt;property name="exposeSpringMacroHelpers"&gt;&lt;value&gt;true&lt;/value&gt;&lt;/property&gt;
 *       &lt;property name="contentType"&gt;&lt;value&gt;text/xml;charset=UTF-8&lt;/value&gt;&lt;/property&gt;
 *       &lt;property name="encoding"&gt;&lt;value&gt;UTF-8&lt;/value&gt;&lt;/property&gt;
 *   &lt;/bean&gt;
 * </pre></code>
 * 
 */
public class VelocityViewResolverEx extends VelocityViewResolver {
    
    /**
     * View̃GR[fBOB
     */ 
    private String encoding = null;
    
    /**
     * View̃GR[fBO擾B
     * @return View̃GR[fBOB
     */
    public String getEncoding() {
        return encoding;
    }

    /**
     * View̃GR[fBOݒ肷B
     * @param encoding View̃GR[fBOB
     */
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    /**
     * ViewCX^X쐬B
     * ViewCX^XɃGR[fBO̐ݒsB
     * 
     * @param viewName view
     * @return ViewCX^X
     * @throws Exception O
     */
    @Override
    protected AbstractUrlBasedView buildView(String viewName)
            throws Exception {
        VelocityView view = (VelocityView) super.buildView(viewName);
        if (encoding != null) {
            view.setEncoding(encoding);
        }
        return view;
    }
}
