/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.util;

import java.io.File;

import jp.terasoluna.utlib.PropertyTestCase;
import jp.terasoluna.utlib.UTUtil;

/**
 * 
 * FileUtil ubN{bNXeXgB<br>
 *
 * (O)<br>
 * @EvpeBt@C(system.properties)ɂāAZbV
 * @@fBNg̃x[Xȉ̂悤Ɏw肳Ă邱<br>
 * @@iftHgԂȂOKj<br>
 * @@@session.dir.base=/tmp/sessions<br>
 * @EvpeBt@C(test.properties)ɁA폜eXgp
 * @@fBNg̃x[Xȉ̂悤ɒǉw肷邱<br>
 * @@@fileutiltest.dir.base=/tmp/test<br>
 *
 */
@SuppressWarnings("unused")
public class FileUtilTest extends PropertyTestCase {

    /**
     * ZbVfBNgvpeB擾L[lB
     */
    public static final String SESSIONS_DIR = "session.dir.base";

    /*
     * ZbVfBNg̐΃pXB
     */
    String TMP_SESSIONS_DIR = "/tmp/sessions/";

    /*
     * FileUtileXgpfBNg̐΃pXB
     */
    String TMP_TEST_DIR = "/tmp/test/";

    /**
     * Constructor for FileUtilTest.
     * @param arg0
     */
    public FileUtilTest(String arg0) {
        super(arg0);
    }

    @Override
    protected void setUpData() throws Exception {
        addProperty("session.dir.base", "/tmp/sessions");
    }

    @Override
    protected void cleanUpData() throws Exception {
        deleteProperty("session.dir.base");
    }

    /**
     * getSessionDirectoryName(1)
     * 
     * (n)<br>
     * ϓ_F<br>
     * 
     * ͒lF16̉p<br>
     * ҒlF͂̃nbVl16iϊ<br>
     * @throws Exception O  */
    public void testGetSessionDirectoryName01() throws Exception {
        // ͒l̐ݒ
        String input = "01234567abcdefgh";

        // eXgΏۂ̎s
        String result = FileUtil.getSessionDirectoryName(input);

        // ʂ̊mF
        String hope = StringUtil.toHexString(HashUtil.hashSHA1(input), "");
        assertEquals(hope, result);
    }

    /**
     * getSessionDirectoryName(2)
     * 
     * (ُn)<br>
     * ϓ_F<br>
     * 
     * ͒lFnull<br>
     * ҒlFNullPointerException<br>
     * @throws Exception O
     */
    public void testGetSessionDirectoryName02() throws Exception {
        // ͒l̐ݒ
        String input = null;

        // eXgΏۂ̎s
        try {
            String result = FileUtil.getSessionDirectoryName(input);
            fail();
        } catch (NullPointerException e) {
            return;
        }
    }

    /**
     * getSessionDirectoryName(3)
     * 
     * (n)<br>
     * ϓ_F<br>
     * 
     * ͒lF""(󕶎)<br>
     * ҒlF͂̃nbVl16iϊ<br>
     * @throws Exception O */
    public void testGetSessionDirectoryName03() throws Exception {
        // ͒l̐ݒ
        String input = "";

        // eXgΏۂ̎s
        String result = FileUtil.getSessionDirectoryName(input);

        // ʂ̊mF
        String hope = StringUtil.toHexString(HashUtil.hashSHA1(input), "");
        assertEquals(hope, result);
    }

    /**
     * getSessionDirectory(1)
     * 
     * (n)<br>
     * ϓ_F<br>
     * 
     * ͒lF16̉p<br>
     * ҒlF͂ɑΉfBNg̃fBNg<br>
     * @throws Exception O */
    public void testGetSessionDirectory01() throws Exception {
        // ͒l̐ݒ
        String input = "01234567abcdefgh";

        // eXgΏۂ̎s
        File result = FileUtil.getSessionDirectory(input);

        // ʂ̊mF
        String dirName = StringUtil.toHexString(HashUtil.hashSHA1(input), "");
        File hope = new File(TMP_SESSIONS_DIR + dirName);
        assertEquals(hope, result);
    }

    /**
     * getSessionDirectory(2)
     * 
     * (ُn)<br>
     * ϓ_F<br>
     * 
     * ͒lFnull<br>
     * ҒlFNullPointerException<br>
     * @throws Exception O */
    public void testGetSessionDirectory02() throws Exception {
        // ͒l̐ݒ
        String input = null;

        // eXgΏۂ̎s
        try {
            File result = FileUtil.getSessionDirectory(input);
            fail();
        } catch (NullPointerException e) {
            return;
        }
    }

    /**
     * getSessionDirectory(3)
     * 
     * (n)<br>
     * ϓ_F<br>
     * 
     * ͒lF""(󕶎)<br>
     * ҒlF͂ɑΉfBNg̃fBNg<br>
     * @throws Exception O */
    public void testGetSessionDirectory03() throws Exception {
        // ͒l̐ݒ
        String input = "";

        // eXgΏۂ̎s
        File result = FileUtil.getSessionDirectory(input);

        // ʂ̊mF
        String dirName = StringUtil.toHexString(HashUtil.hashSHA1(input), "");
        File hope = new File(TMP_SESSIONS_DIR + dirName);
        assertEquals(hope, result);
    }

    /**
     * getSessionDirectory(4)
     * 
     * (n)<br>
     * ϓ_F<br>
     * 
     * vpeBsession.dir.baseݒ肳ĂȂA
     * ftHg̃fBNgԂė鎖mFB
     * @throws Exception O */
    public void testGetSessionDirectory04() throws Exception {
        // ͒l̐ݒ
        String input = "01234567abcdefgh";

        // vpeB폜
        deleteProperty("session.dir.base");

        // eXgΏۂ̎s
        File result = FileUtil.getSessionDirectory(input);

        // ʂ̊mF
        String dirName = StringUtil.toHexString(HashUtil.hashSHA1(input), "");
        File hope = new File(File.separator + "temp" + File.separator + dirName);
        assertEquals(hope, result);
    }

    /**
     * getSessionDirectory(5)
     * 
     * (n)<br>
     * ϓ_F<br>
     * 
     * vpeBsession.dir.base̒l󕶎̎A
     * ftHg̃fBNgԂė鎖mFB
     * @throws Exception O */
    @SuppressWarnings("unchecked")
    public void testGetSessionDirectory05() throws Exception {
        // ͒l̐ݒ
        String input = "01234567abcdefgh";

        // vpeB̒l󕶎ɐݒ
        deleteProperty("session.dir.base");
        addProperty("session.dir.base", "");

        // eXgΏۂ̎s
        File result = FileUtil.getSessionDirectory(input);

        // ʂ̊mF
        String dirName = StringUtil.toHexString(HashUtil.hashSHA1(input), "");
        File hope = new File(File.separator + "temp" + File.separator + dirName);
        assertEquals(hope, result);
    }
    
    /**
     * makeSessionDirectory(1)
     * 
     * (n)<br>
     * ϓ_F<br>
     * 
     * ͒lF16̉p<br>
     * ҒlFeXgΏۂ̎sA͂ɑΉfBNg
     * @@@@fBNg쐬Ă邱<br>
     * @throws Exception O */
    public void testMakeSessionDirectory01() throws Exception {
        // ͒l̐ݒ
        String input = "01234567abcdefgh";

        // O
        String dirName = StringUtil.toHexString(HashUtil.hashSHA1(input), "");
        File dir = new File(TMP_SESSIONS_DIR + dirName);
        // 쐬fBNg݂ꍇA폜
        if (dir.exists()) {
            dir.delete();
        }

        // eXgΏۂ̎s
        boolean result = FileUtil.makeSessionDirectory(input);

        // ʂ̊mF
        assertTrue(result);
        // fBNg쐬Ă邱Ƃ̊mF
        if (!dir.exists()) {
            fail();
        }
    }

    /**
     * makeSessionDirectory(2)
     * 
     * (n)<br>
     * ϓ_F<br>
     * 
     * ͒lF16̉piɑΉfBNg݂j<br>
     * ҒlFeXgΏۂ̎ssA͂ɑΉfBNg
     * @@@@fBNg쐬Ă邱<br>
     * @throws Exception O */
    public void testMakeSessionDirectory02() throws Exception {
        // ͒l̐ݒ
        String input = "01234567abcdefgh";

        // O
        String dirName = StringUtil.toHexString(HashUtil.hashSHA1(input), "");
        File dir = new File(TMP_SESSIONS_DIR + dirName);
        // 쐬fBNg݂ꍇA폜
        if (dir.exists()) {
            dir.delete();
        }

        // eXgΏۂ̎si2JԂj
        FileUtil.makeSessionDirectory(input);
        boolean result = FileUtil.makeSessionDirectory(input);

        // ʂ̊mF
        assertFalse(result);
        // fBNg쐬Ă邱Ƃ̊mF
        if (!dir.exists()) {
            fail();
        }
    }

    /**
     * makeSessionDirectory(3)
     * 
     * (n)<br>
     * ϓ_F<br>
     * 
     * ͒lFnull<br>
     * ҒlFfalse<br>
     * @throws Exception O */
    public void testMakeSessionDirectory03() throws Exception {
        // ͒l̐ݒ
        String input = null;

        // eXgΏۂ̎s
        boolean result = FileUtil.makeSessionDirectory(input);

        // ʂ̊mF
        assertFalse(result);
    }

    /**
     * makeSessionDirectory(4)
     * 
     * (n)<br>
     * ϓ_F<br>
     * 
     * ͒lF""(󕶎)<br>
     * ҒlFfalse<br>
     * @throws Exception O */
    public void testMakeSessionDirectory04() throws Exception {
        // ͒l̐ݒ
        String input = "";

        // O

        // eXgΏۂ̎s
        boolean result = FileUtil.makeSessionDirectory(input);

        // ʂ̊mF
        assertFalse(result);
    }

    /**
     * rmdirs(1)
     * 
     * (n)<br>
     * ϓ_F<br>
     * 
     * ͒lFCӂ̃fBNgiTufBNgAt@CȂj<br>
     * ҒlFeXgΏۂ̎sAfBNg폜邱<br>
     * @throws Exception O */
    public void testRmdirs01() throws Exception {
        // ͒l̐ݒ
        File dir = new File(TMP_TEST_DIR + "rmdirs1");

        // O
        // 폜fBNg݂ȂꍇA쐬
        if (!dir.exists()) {
            dir.mkdirs();
        }

        // eXgΏۂ̎s
        boolean result = FileUtil.rmdirs(dir);

        // ʂ̊mF
        assertTrue(result);
        // fBNg폜Ă邱Ƃ̊mF
        if (dir.exists()) {
            fail();
        }
    }

    /**
     * rmdirs(2)
     * 
     * (n)<br>
     * ϓ_F<br>
     * 
     * ͒lF݂ȂfBNg<br>
     * ҒlFeXgΏۂ̎ssAfBNg݂Ȃ<br>
     * @throws Exception O */
    public void testRmdirs02() throws Exception {
        // ͒l̐ݒ
        File dir = new File(TMP_TEST_DIR + "rmdirs2");

        // O
        // fBNg݂ꍇA폜
        if (dir.exists()) {
            dir.delete();
        }

        // eXgΏۂ̎s
        boolean result = FileUtil.rmdirs(dir);

        // ʂ̊mF
        assertFalse(result);
        // fBNg݂ȂƂ̊mF
        if (dir.exists()) {
            fail();
        }
    }

    /**
     * rmdirs(3)
     * 
     * (n)<br>
     * ϓ_F<br>
     * 
     * ͒lFCӂ̃fBNgiTufBNgAt@Cj<br>
     * ҒlFeXgΏۂ̎sAfBNg폜邱<br>
     * @throws Exception O */
    public void testRmdirs03() throws Exception {
        // ͒l̐ݒ
        File dir = new File(TMP_TEST_DIR + "rmdirs3");

        // O
        // TufBNgAt@C̐ݒ
        File subdir = new File(TMP_TEST_DIR + "rmdirs3/tmp");
        File file = new File(TMP_TEST_DIR + "rmdirs3/tmp.txt");
        // 폜fBNgAt@C݂ȂꍇA쐬
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!subdir.exists()) {
            subdir.mkdirs();
        }
        if (!file.exists()) {
            file.createNewFile();
        }

        // eXgΏۂ̎s
        boolean result = FileUtil.rmdirs(dir);

        // ʂ̊mF
        assertTrue(result);
        // efBNg݂ȂƂ̊mF
        if (dir.exists()) {
            fail();
        }
    }

    /**
     * rmdirs(4)
     * 
     * (n)<br>
     * ϓ_F<br>
     * 
     * ͒lFnull<br>
     * ҒlFfalse<br>
     * @throws Exception O */
    public void testRmdirs04() throws Exception {
        // ͒l̐ݒ
        File dir = null;

        // eXgΏۂ̎s
        boolean result = FileUtil.rmdirs(dir);

        // ʂ̊mF
        assertFalse(result);
    }

    /**
     * rmdirs(5)
     * 
     * (n)<br>
     * ϓ_F<br>
     * 
     * ͒lF""(󕶎)̃pXFileIuWFNg<br>
     * ҒlFfalse<br>
     * @throws Exception O */
    public void testRmdirs05() throws Exception {
        // ͒l̐ݒ
        File dir = new File("");

        // eXgΏۂ̎s
        boolean result = FileUtil.rmdirs(dir);

        // ʂ̊mF
        assertFalse(result);
    }

    /**
     * rmdirs(6)
     * 
     * (n)<br>
     * ϓ_F<br>
     * 
     * ͒lFǂݎp̃fBNgiTufBNgAt@CȂj<br>
     * ҒlFeXgΏۂ̎sAfBNg폜邱<br>
     * @throws Exception O */
    public void testRmdirs06() throws Exception {
        // ͒l̐ݒ
        File dir = new File(TMP_TEST_DIR + "rmdirs6");

        // O
        // fBNg͍쐬Ă
        // ǂݎpŐݒ肷
        if(!dir.exists()){
            dir.mkdir();
            dir.setReadOnly();
        }

        // eXgΏۂ̎s
        boolean result = FileUtil.rmdirs(dir);

        // ʂ̊mF
        assertTrue(result);
        // fBNg폜Ă邱Ƃ̊mF
        if (dir.exists()) {
            fail();
        }
    }

    /**
     * removeSessionDirectory01()
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒lFsessionID="01234567abcdefgh"<br>
     * ҒlFtrue<br>
     * 
     * ZbVIDɑΉfBNg݂AfBNg̍폜ɐA
     * trueԋp邱ƂmFB
     * 
     * @throws Exception O */
    public void testRemoveSessionDirectory01() throws Exception {
        // ݒ
        String input = "01234567abcdefgh";
        UTUtil.invokePrivate(
            FileUtil.class,
            "makeSessionDirectory",
            String.class,
            input);
        // eXgs
        // ʊmF
        assertTrue(FileUtil.removeSessionDirectory(input));
    }

    /**
     * removeSessionDirectory02()
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒lFsessionID="01234567abcdefgh"<br>
     * ҒlFfalse<br>
     * 
     * ZbVIDɑΉfBNg݂ȂƂA
     * fBNg̍폜Ɏsfalseԋp邱ƂmFB
     * 
     * @throws Exception O */
    public void testRemoveSessionDirectory02() throws Exception {
        // ݒ
        String input = "01234567abcdefgh";
        File dir = (File) UTUtil.invokePrivate(FileUtil.class,
                "getSessionDirectory", String.class, input);
        dir.delete();

        // eXgs
        // ʊmF
        assertFalse(FileUtil.removeSessionDirectory(input));
    }

    /**
     * removeSessionDirectory03()
     * 
     * (ُn)<br>
     * ϓ_FC,G<br>
     * 
     * ͒lFsessionID=null<br>
     * ҒlFNullPOinterException<br>
     * 
     * ZbVIDnull̎ANullPointerException邱ƂmFB
     * 
     * @throws Exception O */
    public void testRemoveSessionDirectory03() throws Exception {
        try {
            // eXgΏۂ̎s
            FileUtil.removeSessionDirectory(null);
            fail();
        } catch (NullPointerException e) {
            return;
        }
        // ʊmF
        fail();
    }
}
