/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms;

import com.mockrunner.mock.jms.MockDestination;
import com.mockrunner.mock.jms.MockMessageConsumer;
import com.mockrunner.mock.jms.MockSession;
import com.mockrunner.mock.jms.MockTopicSubscriber;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;

public class MockTopic
extends MockDestination
implements Topic {
    private String name;

    public MockTopic(String string) {
        this.name = string;
    }

    public String getTopicName() throws JMSException {
        return this.name;
    }

    public void addMessage(Message message) throws JMSException {
        this.addReceivedMessage(message);
        boolean bl = false;
        Iterator iterator = this.sessionSet().iterator();
        while (iterator.hasNext()) {
            Object object;
            MockSession mockSession = (MockSession)iterator.next();
            MessageListener messageListener = mockSession.getMessageListener();
            if (null != messageListener) {
                messageListener.onMessage(message);
                bl = true;
                this.acknowledgeMessage(message, mockSession);
                continue;
            }
            List list = mockSession.getTopicTransmissionManager().getTopicSubscriberList(this.name);
            for (int i = 0; i < list.size(); ++i) {
                object = (MockTopicSubscriber)list.get(i);
                if (!((MockMessageConsumer)object).canConsume(message)) continue;
                ((MockMessageConsumer)object).receiveMessage(message);
                bl = true;
                this.acknowledgeMessage(message, mockSession);
            }
            Map map = mockSession.getTopicTransmissionManager().getDurableTopicSubscriberMap(this.name);
            object = map.keySet().iterator();
            while (object.hasNext()) {
                MockTopicSubscriber mockTopicSubscriber = (MockTopicSubscriber)map.get(object.next());
                if (!mockTopicSubscriber.canConsume(message)) continue;
                mockTopicSubscriber.receiveMessage(message);
                bl = true;
                this.acknowledgeMessage(message, mockSession);
            }
        }
        if (!bl) {
            this.addCurrentMessage(message);
        }
    }
}

