/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.file.dao.standard;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import jp.terasoluna.fw.file.annotation.FileFormat;
import jp.terasoluna.fw.file.annotation.InputFileColumn;
import jp.terasoluna.fw.file.annotation.StringConverter;
import jp.terasoluna.fw.file.dao.FileException;
import jp.terasoluna.fw.file.dao.FileLineException;
import jp.terasoluna.fw.file.dao.FileLineIterator;
import jp.terasoluna.fw.file.dao.standard.ColumnParser;
import jp.terasoluna.fw.file.dao.standard.EncloseCharLineFeed1LineReader;
import jp.terasoluna.fw.file.dao.standard.EncloseCharLineFeed2LineReader;
import jp.terasoluna.fw.file.dao.standard.FileDAOUtility;
import jp.terasoluna.fw.file.dao.standard.LineFeed1LineReader;
import jp.terasoluna.fw.file.dao.standard.LineFeed2LineReader;
import jp.terasoluna.fw.file.dao.standard.LineReader;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileLineIterator<T>
implements FileLineIterator<T> {
    private String fileName = null;
    private Class<T> clazz = null;
    private String lineFeedChar = System.getProperty("line.separator");
    private String fileEncoding = System.getProperty("file.encoding");
    private int headerLineCount = 0;
    private int trailerLineCount = 0;
    private String currentLineString = null;
    private int currentLineCount = 0;
    private Reader reader = null;
    private Field[] fields = null;
    private Method[] methods = null;
    private Map<String, ColumnParser> columnParserMap = null;
    private List<String> header = new ArrayList<String>();
    private List<String> trailer = new ArrayList<String>();
    private boolean readHeader = false;
    private boolean readData = false;
    private boolean readTrailer = false;
    private Queue<String> trailerQueue = null;
    private LineReader lineReader = null;
    private int columnCount = 0;

    public AbstractFileLineIterator(String fileName, Class<T> clazz, Map<String, ColumnParser> columnParserMap) {
        if (fileName == null || "".equals(fileName)) {
            throw new FileException("File is not found.", new IllegalStateException(), fileName);
        }
        FileFormat fileFormat = clazz.getAnnotation(FileFormat.class);
        if (fileFormat == null) {
            throw new FileException("FileFormat annotation is not found.", new IllegalStateException(), fileName);
        }
        this.fileName = fileName;
        this.clazz = clazz;
        if (fileFormat.lineFeedChar() != null && !"".equals(fileFormat.lineFeedChar())) {
            this.lineFeedChar = fileFormat.lineFeedChar();
        }
        if (fileFormat.fileEncoding() != null && !"".equals(fileFormat.fileEncoding())) {
            this.fileEncoding = fileFormat.fileEncoding();
        }
        this.headerLineCount = fileFormat.headerLineCount();
        this.trailerLineCount = fileFormat.trailerLineCount();
        this.columnParserMap = columnParserMap;
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.reader.ready()) {
                return true;
            }
        }
        catch (IOException e) {
            throw new FileException(e, this.fileName);
        }
        return false;
    }

    @Override
    public T next() {
        if (this.readTrailer) {
            throw new FileLineException("Data part should be called before trailer part.", new IllegalStateException(), this.fileName, this.currentLineCount, null, -1);
        }
        if (!this.hasNext()) {
            throw new FileLineException(new NoSuchElementException(), this.fileName, this.currentLineCount, null, -1);
        }
        T fileLineObject = null;
        String currentString = this.readLine();
        try {
            fileLineObject = this.clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new FileLineException(e, this.fileName, this.currentLineCount + 1);
        }
        catch (IllegalAccessException e) {
            throw new FileLineException(e, this.fileName, this.currentLineCount + 1);
        }
        String[] columns = this.separateColumns(currentString);
        if (this.columnCount != columns.length) {
            throw new FileLineException("Column Count is not different from FileLineObject's column counts", new IllegalStateException(), this.fileName, this.currentLineCount, null, -1);
        }
        for (int i = 0; i < this.fields.length; ++i) {
            InputFileColumn inputFileColumn = null;
            if (this.fields[i] != null) {
                inputFileColumn = this.fields[i].getAnnotation(InputFileColumn.class);
            }
            if (inputFileColumn == null) continue;
            String columnString = columns[inputFileColumn.columnIndex()];
            if (0 < inputFileColumn.bytes()) {
                try {
                    if (columnString.getBytes(this.fileEncoding).length != inputFileColumn.bytes()) {
                        throw new FileLineException("Data size is different from a set point of a column.", new IllegalStateException(), this.fileName, this.currentLineCount + 1, this.fields[i].getName(), inputFileColumn.columnIndex());
                    }
                }
                catch (UnsupportedEncodingException e) {
                    throw new FileException(e, this.fileName);
                }
            }
            columnString = FileDAOUtility.trim(columnString, this.fileEncoding, inputFileColumn.trimChar(), inputFileColumn.trimType());
            columnString = FileDAOUtility.padding(columnString, this.fileEncoding, inputFileColumn.bytes(), inputFileColumn.paddingChar(), inputFileColumn.paddingType());
            try {
                StringConverter stringConverter = inputFileColumn.stringConverter().newInstance();
                columnString = stringConverter.convert(columnString);
            }
            catch (InstantiationException e) {
                throw new FileLineException(e, this.fileName, this.currentLineCount + 1, this.fields[i].getName(), inputFileColumn.columnIndex());
            }
            catch (IllegalAccessException e) {
                throw new FileLineException(e, this.fileName, this.currentLineCount + 1, this.fields[i].getName(), inputFileColumn.columnIndex());
            }
            ColumnParser textSetter = this.columnParserMap.get(this.fields[i].getType().getName());
            try {
                textSetter.parse(columnString, fileLineObject, this.methods[i], inputFileColumn.columnFormat());
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new FileLineException(e, this.fileName, this.currentLineCount + 1, this.fields[i].getName(), inputFileColumn.columnIndex());
            }
            catch (IllegalAccessException e) {
                throw new FileLineException(e, this.fileName, this.currentLineCount + 1, this.fields[i].getName(), inputFileColumn.columnIndex());
            }
            catch (InvocationTargetException e) {
                throw new FileLineException(e, this.fileName, this.currentLineCount + 1, this.fields[i].getName(), inputFileColumn.columnIndex());
            }
            catch (ParseException e) {
                throw new FileLineException(e, this.fileName, this.currentLineCount + 1, this.fields[i].getName(), inputFileColumn.columnIndex());
            }
        }
        this.readData = true;
        ++this.currentLineCount;
        return fileLineObject;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void init() {
        try {
            this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.fileName), this.fileEncoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new FileException(e, this.fileName);
        }
        catch (FileNotFoundException e) {
            throw new FileException(e, this.fileName);
        }
        if (1 <= this.trailerLineCount) {
            this.trailerQueue = new ArrayBlockingQueue<String>(this.trailerLineCount);
        }
        this.buildFields();
        this.buildMethods();
        if (this.getEncloseChar() == '\u0000') {
            if (this.lineFeedChar.length() == 2) {
                this.lineReader = new LineFeed2LineReader(this.reader, this.lineFeedChar);
                return;
            } else {
                if (this.lineFeedChar.length() != 1) throw new FileException("lineFeedChar length must be 1 or 2. but: " + this.lineFeedChar.length(), new IllegalStateException(), this.fileName);
                this.lineReader = new LineFeed1LineReader(this.reader, this.lineFeedChar);
            }
            return;
        } else if (this.lineFeedChar.length() == 1) {
            this.lineReader = new EncloseCharLineFeed1LineReader(this.getDelimiter(), this.getEncloseChar(), this.reader, this.lineFeedChar);
            return;
        } else {
            if (this.lineFeedChar.length() != 2) throw new FileException("lineFeedChar length must be 1 or 2. but: " + this.lineFeedChar.length(), new IllegalStateException(), this.fileName);
            this.lineReader = new EncloseCharLineFeed2LineReader(this.getDelimiter(), this.getEncloseChar(), this.reader, this.lineFeedChar);
        }
    }

    private void buildFields() {
        this.fields = this.clazz.getDeclaredFields();
        Field[] fieldArray = new Field[this.fields.length];
        for (Field field : this.getFields()) {
            InputFileColumn inputFileColumn = field.getAnnotation(InputFileColumn.class);
            if (inputFileColumn == null) continue;
            if (fieldArray[inputFileColumn.columnIndex()] != null) {
                throw new FileException("Column Index: " + inputFileColumn.columnIndex() + " is duplicated.", this.fileName);
            }
            fieldArray[inputFileColumn.columnIndex()] = field;
            ++this.columnCount;
        }
    }

    private void buildMethods() {
        ArrayList<Method> methodList = new ArrayList<Method>();
        StringBuilder setterName = new StringBuilder();
        for (Field field : this.fields) {
            if (field.getAnnotation(InputFileColumn.class) != null) {
                String fieldName = field.getName();
                setterName.setLength(0);
                setterName.append("set");
                setterName.append(StringUtils.upperCase((String)fieldName.substring(0, 1)));
                setterName.append(fieldName.substring(1, fieldName.length()));
                try {
                    methodList.add(this.clazz.getMethod(setterName.toString(), field.getType()));
                    continue;
                }
                catch (NoSuchMethodException e) {
                    throw new FileException(e, this.fileName);
                }
            }
            methodList.add(null);
        }
        this.methods = methodList.toArray(new Method[methodList.size()]);
    }

    @Override
    public void closeFile() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new FileException(e, this.fileName);
        }
    }

    @Override
    public List<String> getHeader() {
        if (this.readTrailer || this.readData) {
            throw new FileException(new IllegalStateException(), this.fileName);
        }
        if (!this.readHeader) {
            this.readHeader = true;
            if (0 < this.headerLineCount) {
                for (int i = 0; i < this.headerLineCount; ++i) {
                    if (!this.hasNext()) {
                        throw new FileException(new NoSuchElementException(), this.fileName);
                    }
                    try {
                        this.header.add(this.lineReader.readLine());
                        continue;
                    }
                    catch (FileException e) {
                        throw new FileException(e, this.fileName);
                    }
                }
            }
        }
        return this.header;
    }

    @Override
    public List<String> getTrailer() {
        if (0 < this.trailerLineCount) {
            while (this.hasNext()) {
                if (!this.readHeader) {
                    this.getHeader();
                }
                if (this.trailerLineCount <= this.trailerQueue.size()) {
                    this.currentLineString = this.trailerQueue.poll();
                }
                try {
                    this.trailerQueue.add(this.lineReader.readLine());
                }
                catch (FileException e) {
                    throw new FileException(e, this.fileName);
                }
            }
            for (String fileLineBuilder : this.trailerQueue) {
                this.trailer.add(fileLineBuilder);
            }
        }
        this.readTrailer = true;
        return this.trailer;
    }

    protected String readLine() {
        if (!this.hasNext()) {
            throw new FileException(new NoSuchElementException(), this.fileName);
        }
        if (!this.readHeader) {
            this.getHeader();
        }
        if (1 <= this.trailerLineCount) {
            if (this.trailerQueue.size() < this.trailerLineCount) {
                int loopCount = this.trailerLineCount - this.trailerQueue.size();
                for (int i = 0; i < loopCount; ++i) {
                    if (!this.hasNext()) {
                        throw new FileException(new NoSuchElementException(), this.fileName);
                    }
                    try {
                        this.trailerQueue.add(this.lineReader.readLine());
                        continue;
                    }
                    catch (FileException e) {
                        throw new FileException(e, this.fileName);
                    }
                }
                if (!this.hasNext()) {
                    return null;
                }
            }
            this.currentLineString = this.trailerQueue.poll();
            try {
                this.trailerQueue.add(this.lineReader.readLine());
            }
            catch (FileException e) {
                throw new FileException(e, this.fileName);
            }
        }
        try {
            this.currentLineString = this.lineReader.readLine();
        }
        catch (FileException e) {
            throw new FileException(e, this.fileName);
        }
        return this.currentLineString;
    }

    @Override
    public void skip(int skipLines) {
        for (int i = 0; i < skipLines; ++i) {
            this.readLine();
        }
    }

    protected abstract char getDelimiter();

    protected abstract char getEncloseChar();

    protected abstract String[] separateColumns(String var1);

    protected String getLineFeedChar() {
        return this.lineFeedChar;
    }

    protected String getFileEncoding() {
        return this.fileEncoding;
    }

    protected int getHeaderLineCount() {
        return this.headerLineCount;
    }

    protected int getTrailerLineCount() {
        return this.trailerLineCount;
    }

    public int getCurrentLineCount() {
        return this.currentLineCount;
    }

    protected Field[] getFields() {
        return this.fields;
    }

    protected String getFileName() {
        return this.fileName;
    }
}

