/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.controlbreak;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.terasoluna.fw.batch.controlbreak.ControlBreakChunk;
import jp.terasoluna.fw.batch.controlbreak.ControlBreakDef;
import jp.terasoluna.fw.batch.controlbreak.ControlBreakDefItem;
import jp.terasoluna.fw.batch.controlbreak.ControlBreakRowObject;
import jp.terasoluna.fw.batch.core.BLogicException;
import jp.terasoluna.fw.batch.core.BLogicResultHandler;
import jp.terasoluna.fw.batch.core.ExceptionHandlerUtil;
import jp.terasoluna.fw.batch.core.JobException;
import jp.terasoluna.fw.batch.core.JobExceptionHandler;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.openapi.BLogicResult;
import jp.terasoluna.fw.batch.openapi.ControlBreakHandler;
import jp.terasoluna.fw.batch.openapi.JobContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlBreakProcessor {
    private ControlBreakDef controlBreakDef = null;
    private BLogicResultHandler blogicResultHandler = null;
    private Map<JobException, JobExceptionHandler> exceptionHandlerMap = null;
    private JobExceptionHandler defaultJobExceptionHandler = null;

    public void doChunkControlBreak(ControlBreakChunk controlBreakChunk, JobStatus jobStatus, List<LinkedHashMap<String, Object>> batchUpdateMapList) {
        ControlBreakDefItem chunkControlBreakDefItem = this.controlBreakDef.getChunkControlBreakDefItem();
        if (chunkControlBreakDefItem.getBreakKey().size() == 0) {
            return;
        }
        Map<String, Object> chunkControlBreakKeyMap = controlBreakChunk.getChunkControlBreakMap();
        ControlBreakHandler<JobContext> controlBreakHandler = chunkControlBreakDefItem.getControlBreakHandler();
        this.processControlBreak(controlBreakChunk.getJobContext(), jobStatus, batchUpdateMapList, chunkControlBreakKeyMap, controlBreakHandler);
    }

    public void doTransChunkControlBreak(ControlBreakChunk controlBreakChunk, JobStatus jobStatus, List<LinkedHashMap<String, Object>> batchUpdateMapList) {
        List<List<String>> transChunkControlBreakKeyList = controlBreakChunk.getTransChunkControlBreakKeyList();
        Map<String, Object> chunkControlBreakKeyMap = controlBreakChunk.getChunkControlBreakMap();
        HashMap<String, Object> transChunkControlBreakKeyMap = new HashMap<String, Object>();
        for (List<String> transChunkControlBreakKey : transChunkControlBreakKeyList) {
            transChunkControlBreakKeyMap.clear();
            if (transChunkControlBreakKey.size() == 0) continue;
            if (!jobStatus.isContinue()) {
                return;
            }
            ControlBreakHandler<JobContext> controlBreakHandler = this.controlBreakDef.getTransChunkControlBreakHandler(transChunkControlBreakKey);
            for (String propertyName : transChunkControlBreakKey) {
                Object value = chunkControlBreakKeyMap.get(propertyName);
                transChunkControlBreakKeyMap.put(propertyName, value);
            }
            this.processControlBreak(controlBreakChunk.getJobContext(), jobStatus, batchUpdateMapList, transChunkControlBreakKeyMap, controlBreakHandler);
        }
    }

    public void doAllTransChunkControlBreak(ControlBreakChunk controlBreakChunk, JobStatus jobStatus, List<LinkedHashMap<String, Object>> batchUpdateMapList) {
        Map<String, Object> allChunkControlBreakKeyMap = controlBreakChunk.getChunkControlBreakMap();
        List<ControlBreakDefItem> transChunkControlBreakDefItemList = this.controlBreakDef.getTransChunkControlBreakDefItemList();
        HashMap<String, Object> breakKeyValueMap = new HashMap<String, Object>();
        for (ControlBreakDefItem transChunkControlBreakDefItem : transChunkControlBreakDefItemList) {
            breakKeyValueMap.clear();
            if (transChunkControlBreakDefItem.getBreakKey().size() == 0) continue;
            if (!jobStatus.isContinue()) {
                return;
            }
            for (String propertyName : transChunkControlBreakDefItem.getBreakKey()) {
                Object value = allChunkControlBreakKeyMap.get(propertyName);
                breakKeyValueMap.put(propertyName, value);
            }
            ControlBreakHandler<JobContext> controlBreakHandler = transChunkControlBreakDefItem.getControlBreakHandler();
            this.processControlBreak(controlBreakChunk.getJobContext(), jobStatus, batchUpdateMapList, breakKeyValueMap, controlBreakHandler);
        }
    }

    public void doControlBreak(ControlBreakRowObject controlBreakRowObject, JobContext jobContext, JobStatus jobStatus, List<LinkedHashMap<String, Object>> batchUpdateMapList) {
        List<List<String>> controlBreakKeyList = controlBreakRowObject.getControlBreakKeyList();
        Map<String, Object> allControlBreakKeyMap = controlBreakRowObject.getControlBreakMap();
        HashMap<String, Object> controlBreakKeyMap = new HashMap<String, Object>();
        if (controlBreakKeyList.size() > 0) {
            for (List<String> controlBreakKey : controlBreakKeyList) {
                controlBreakKeyMap.clear();
                if (controlBreakKey.size() == 0) continue;
                if (!jobStatus.isContinue()) {
                    return;
                }
                ControlBreakHandler<JobContext> controlBreakHandler = this.controlBreakDef.getControlBreakHandler(controlBreakKey);
                for (String propertyName : controlBreakKey) {
                    Object value = allControlBreakKeyMap.get(propertyName);
                    controlBreakKeyMap.put(propertyName, value);
                }
                this.processControlBreak(jobContext, jobStatus, batchUpdateMapList, controlBreakKeyMap, controlBreakHandler);
            }
        }
    }

    public void doAllChunkInternalControlBreak(ControlBreakRowObject controlBreakRowObject, JobContext jobContext, JobStatus jobStatus, List<LinkedHashMap<String, Object>> batchUpdateMapList) {
        Map<String, Object> allControlBreakKeyMap = controlBreakRowObject.getControlBreakMap();
        List<ControlBreakDefItem> controlBreakDefItemListReverseOrder = this.controlBreakDef.getControlBreakDefItemList();
        HashMap<String, Object> breakKeyValueMap = new HashMap<String, Object>();
        for (ControlBreakDefItem controlBreakDefItem : controlBreakDefItemListReverseOrder) {
            breakKeyValueMap.clear();
            if (controlBreakDefItem.getBreakKey().size() == 0) continue;
            if (!jobStatus.isContinue()) {
                return;
            }
            for (String propertyName : controlBreakDefItem.getBreakKey()) {
                Object value = allControlBreakKeyMap.get(propertyName);
                breakKeyValueMap.put(propertyName, value);
            }
            ControlBreakHandler<JobContext> controlBreakHandler = controlBreakDefItem.getControlBreakHandler();
            this.processControlBreak(jobContext, jobStatus, batchUpdateMapList, breakKeyValueMap, controlBreakHandler);
        }
    }

    private void processControlBreak(JobContext jobContext, JobStatus jobStatus, List<LinkedHashMap<String, Object>> batchUpdateMapList, Map<String, Object> chunkControlBreakKeyMap, ControlBreakHandler<JobContext> controlBreakHandler) {
        BLogicResult handlerResult = null;
        try {
            handlerResult = controlBreakHandler.handleControlBreak(chunkControlBreakKeyMap, jobContext);
            this.blogicResultHandler.handle(handlerResult, chunkControlBreakKeyMap, jobStatus, batchUpdateMapList);
        }
        catch (RuntimeException e) {
            BLogicException wrappingException = new BLogicException(e, chunkControlBreakKeyMap, handlerResult);
            JobExceptionHandler handler = ExceptionHandlerUtil.getJobExceptionHandler(wrappingException, this.exceptionHandlerMap, this.defaultJobExceptionHandler);
            handler.handlException(jobContext, wrappingException, jobStatus);
        }
    }

    public void setBlogicResultHandler(BLogicResultHandler blogicResultHandler) {
        this.blogicResultHandler = blogicResultHandler;
    }

    public void setControlBreakDef(ControlBreakDef controlBreakDef) {
        this.controlBreakDef = controlBreakDef;
    }

    public void setDefaultJobExceptionHandler(JobExceptionHandler defaultJobExceptionHandler) {
        this.defaultJobExceptionHandler = defaultJobExceptionHandler;
    }

    public void setExceptionHandlerMap(Map<JobException, JobExceptionHandler> exceptionHandlerMap) {
        this.exceptionHandlerMap = exceptionHandlerMap;
    }
}

