/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.standard;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import jp.terasoluna.fw.batch.core.BLogicResultHandler;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.messages.BLogicMessage;
import jp.terasoluna.fw.batch.messages.BLogicMessages;
import jp.terasoluna.fw.batch.messages.MessageAccessor;
import jp.terasoluna.fw.batch.openapi.BLogicResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardBLogicResultHandler
implements BLogicResultHandler {
    private static Log log = LogFactory.getLog(StandardBLogicResultHandler.class);
    private MessageAccessor messageAccessor = null;

    @Override
    public void handle(BLogicResult blogicResult, Object blogicInputData, JobStatus jobStatus, List<LinkedHashMap<String, Object>> batchUpdateMapList) {
        jobStatus.countBLogic(blogicResult.getReturnCode());
        this.processBLogicMessages(blogicResult);
        switch (blogicResult.getReturnCode()) {
            case NORMAL_CONTINUE: {
                this.processNormalContinue(jobStatus, blogicResult, batchUpdateMapList);
                break;
            }
            case NORMAL_END: {
                this.processNormalEnd(jobStatus, blogicResult, batchUpdateMapList);
                break;
            }
            case ERROR_CONTINUE: {
                this.processErrorContinue(blogicInputData, jobStatus, blogicResult);
                break;
            }
            case ERROR_END: {
                this.processErrorEnd(blogicInputData, jobStatus, blogicResult);
                break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)blogicResult.getReturnCode()) + " illegal ReturnCode");
            }
        }
    }

    protected void processBLogicMessages(BLogicResult blogicResult) {
        this.writeBLogicMessagesLog(blogicResult.getMessages(), LOG_TYPE.INFO);
        this.writeBLogicMessagesLog(blogicResult.getErrors(), LOG_TYPE.ERROR);
    }

    protected void processNormalContinue(JobStatus jobStatus, BLogicResult bLogicResult, List<LinkedHashMap<String, Object>> batchUpdateMapList) {
        if (bLogicResult.getBatchUpdateMap() != null && bLogicResult.getBatchUpdateMap().size() > 0) {
            batchUpdateMapList.add(bLogicResult.getBatchUpdateMap());
        }
    }

    protected void processNormalEnd(JobStatus jobStatus, BLogicResult bLogicResult, List<LinkedHashMap<String, Object>> batchUpdateMapList) {
        if (bLogicResult.getBatchUpdateMap() != null && bLogicResult.getBatchUpdateMap().size() > 0) {
            batchUpdateMapList.add(bLogicResult.getBatchUpdateMap());
        }
        jobStatus.setJobState(JobStatus.STATE.ENDING_NORMALLY);
        jobStatus.setJobExitCode(bLogicResult.getJobExitCode());
    }

    protected void processErrorContinue(Object blogicInputData, JobStatus jobStatus, BLogicResult blogicResult) {
        this.writeErrorLog(jobStatus, blogicResult, blogicInputData);
    }

    protected void processErrorEnd(Object blogicInputData, JobStatus jobStatus, BLogicResult bLogicResult) {
        this.writeErrorLog(jobStatus, bLogicResult, blogicInputData);
        jobStatus.setJobState(JobStatus.STATE.ENDING_ABNORMALLY);
        jobStatus.setJobExitCode(bLogicResult.getJobExitCode());
    }

    protected void writeErrorLog(JobStatus jobStatus, BLogicResult bLogicResult, Object blogicInputData) {
        log.error((Object)("Error JobID: " + jobStatus.getJobId() + " InputData: " + blogicInputData));
    }

    protected void writeBLogicMessagesLog(BLogicMessages blogicMessages, LOG_TYPE logType) {
        if (blogicMessages == null || blogicMessages.isEmpty()) {
            return;
        }
        Iterator<BLogicMessage> itr = blogicMessages.get();
        while (itr.hasNext()) {
            BLogicMessage blogicMessage = itr.next();
            if (blogicMessage.isResource()) {
                this.writeLog(this.messageAccessor.getMessage(blogicMessage.getKey(), blogicMessage.getValues()), logType);
                continue;
            }
            this.writeLog(blogicMessage.getKey(), logType);
        }
    }

    protected void writeLog(String message, LOG_TYPE logType) {
        switch (logType) {
            case TRACE: {
                log.trace((Object)message);
                break;
            }
            case DEBUG: {
                log.debug((Object)message);
                break;
            }
            case INFO: {
                log.info((Object)message);
                break;
            }
            case WARN: {
                log.warn((Object)message);
                break;
            }
            case ERROR: {
                log.error((Object)message);
                break;
            }
            case FATAL: {
                log.fatal((Object)message);
                break;
            }
            default: {
                throw new IllegalArgumentException("No log Type which agrees.");
            }
        }
    }

    public void setMessageAccessor(MessageAccessor messageAccessor) {
        this.messageAccessor = messageAccessor;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum LOG_TYPE {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR,
        FATAL;

    }
}

