/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.validation;

import java.util.ArrayList;
import java.util.List;

import jp.terasoluna.utlib.PropertyTestCase;
import jp.terasoluna.utlib.UTUtil;
import jp.terasoluna.fw.validation.ValidationUtil;

/**
 * {@link jp.terasoluna.fw.validation.ValidationUtil} NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * ؃WbÑ[eBeBNXB
 * <p>
 *
 * @see jp.terasoluna.fw.validation.ValidationUtil
 */
public class ValidationUtilTest04 extends PropertyTestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(ValidationUtilTest04.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#setUpData()
     */
    @Override
    protected void setUpData() throws Exception {
        UTUtil.setPrivateField(ValidationUtil.class, "hankakuKanaList",
            "¯֬ܦް");
        UTUtil.setPrivateField(ValidationUtil.class, "zenkakuKanaList",
            "ACEGI@BDFHJLNPRKMOQSTVXZ\" +
            "UWY[]^`ceg_adfhijklmnqtwz" +
            "orux{psvy|}~" +
            "b[");
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#cleanUpData()
     */
    @Override
    protected void cleanUpData() throws Exception {
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public ValidationUtilTest04(String name) {
        super(name);
    }

    /**
     * testHasNotProhibitedChar01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * valuenull̏ꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testHasNotProhibitedChar01() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.hasNotProhibitedChar(null, "abc"));
    }

    /**
     * testHasNotProhibitedChar02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:""<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * value󕶎̏ꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testHasNotProhibitedChar02() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.hasNotProhibitedChar("", "abc"));
    }

    /**
     * testHasNotProhibitedChar03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:"abc"<br>
     *         () prohibitedChars:null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * prohibitedCharsnull̏ꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testHasNotProhibitedChar03() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.hasNotProhibitedChar("abc", null));
    }

    /**
     * testHasNotProhibitedChar04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:"abc"<br>
     *         () prohibitedChars:""i󕶎j<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * prohibitedChars󕶎̏ꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testHasNotProhibitedChar04() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.hasNotProhibitedChar("abc", ""));
    }

    /**
     * testHasNotProhibitedChar05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:"a"<br>
     *         () prohibitedChars:"abc"<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * value1łꂪ֎~̏ꍇAfalse擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testHasNotProhibitedChar05() throws Exception {
        // eXg{E
        assertFalse(ValidationUtil.hasNotProhibitedChar("a", "abc"));
    }

    /**
     * testHasNotProhibitedChar06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:"d"<br>
     *         () prohibitedChars:"abc"<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * value1łꂪ֎~łȂꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testHasNotProhibitedChar06() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.hasNotProhibitedChar("d", "abc"));
    }

    /**
     * testHasNotProhibitedChar07()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:"abc"<br>
     *         () prohibitedChars:"cde"<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * valuełꂪ֎~܂ޏꍇAfalse擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testHasNotProhibitedChar07() throws Exception {
        // eXg{E
        assertFalse(ValidationUtil.hasNotProhibitedChar("abc", "cde"));
    }

    /**
     * testHasNotProhibitedChar08()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:"abc"<br>
     *         () prohibitedChars:"def"<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * valuełꂪ֎~܂܂ȂꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testHasNotProhibitedChar08() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.hasNotProhibitedChar("abc", "def"));
    }

    /**
     * testHasNotProhibitedChar09()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:"ab\""<br>
     *         () prohibitedChars:"cd\""<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * valueɃGXP[vKvȕ܂݂ꂪ֎~̏ꍇAfalse擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testHasNotProhibitedChar09() throws Exception {
        // eXg{E
        assertFalse(ValidationUtil.hasNotProhibitedChar("ab\"", "cd\""));
    }

    /**
     * testHasNotProhibitedChar10()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:"ab\""<br>
     *         () prohibitedChars:"de\\"<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * valueɃGXP[vKvȕ܂݂ꂪ֎~łȂꍇA
     * true擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testHasNotProhibitedChar10() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.hasNotProhibitedChar("ab\"", "cd\\"));
    }

    /**
     * testIsArrayInRange01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() obj:null<br>
     *         () min:1<br>
     *         () max:5<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * objnull̏ꍇminPȏ̏ꍇAfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsArrayInRange01() throws Exception {
        // O
        Object obj = null;
        int min = 1;
        int max = 5;

        // eXg{
        boolean result = ValidationUtil.isArrayInRange(obj, min, max);

        // 
        assertFalse(result);
    }

    /**
     * testIsArrayInRange02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() obj:""(String)<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     * ԕωF(O) IllegalArgumentException<br>
     *                  bZ[WFjava.lang.String is neither Array nor Collection.
     *
     * <br>
     * objzECollection^ł͂ȂꍇA
     * IllegalArgumentException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsArrayInRange02() throws Exception {
        // O
        Object obj = "";
        int min = 0;
        int max = 0;

        // eXg{
        try {
            ValidationUtil.isArrayInRange(obj, min, max);
            fail();
        } catch (IllegalArgumentException e) {
            assertEquals("java.lang.String is neither Array nor Collection.",
                    e.getMessage());
        }
    }

    /**
     * testIsArrayInRange03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() obj:{"a","b","c"}<br>
     *                izj<br>
     *         () min:0<br>
     *         () max:10<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * objzŁȀ͈͓ꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsArrayInRange03() throws Exception {
        // O
        Object obj = new String[]{"a","b","c"};
        int min = 0;
        int max = 10;

        // eXg{
        boolean result = ValidationUtil.isArrayInRange(obj, min, max);

        // 
        assertTrue(result);
    }

    /**
     * testIsArrayInRange04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() obj:ArrayList<br>
     *                [1="a"]<br>
     *                [2="b"]<br>
     *                [3="c"]<br>
     *         () min:5<br>
     *         () max:10<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * objRNVŁA͈͊Ȍꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsArrayInRange04() throws Exception {
        // O
        List<String> obj = new ArrayList<String>();
        obj.add("a");
        obj.add("b");
        obj.add("c");
        int min = 5;
        int max = 10;

        // eXg{
        boolean result = ValidationUtil.isArrayInRange(obj, min, max);

        // 
        assertFalse(result);
    }

    /**
     * testIsArrayInRange05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() obj:int[] {<br>
     *                  1,2,3<br>
     *                };<br>
     *         () min:0<br>
     *         () max:2<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * v~eBuz^ŁA͈͊Ȍꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsArrayInRange05() throws Exception {
        // O
        int[] array = new int[]{
            1, 2, 3
        };

        // eXg{
        boolean result = ValidationUtil.isArrayInRange(array, 0, 2);

        // 
        assertFalse(result);
    }

    /**
     * testIsUrl01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * valuenull̏ꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsUrl01() throws Exception {
        // O
        String value = null;
        boolean allowallschemes = false;
        boolean allow2slashes = false;
        boolean nofragments = false;
        String schemesVar = null;

        // eXg{
        boolean result = ValidationUtil.isUrl(value, allowallschemes,
                allow2slashes, nofragments, schemesVar);

        // 
        assertTrue(result);
    }

    /**
     * testIsUrl02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:""<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * value󔒂̏ꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsUrl02() throws Exception {
        // O
        String value = "";
        boolean allowallschemes = false;
        boolean allow2slashes = false;
        boolean nofragments = false;
        String schemesVar = null;

        // eXg{
        boolean result = ValidationUtil.isUrl(value, allowallschemes,
                allow2slashes, nofragments, schemesVar);

        // 
        assertTrue(result);
    }

    /**
     * testIsUrl03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:http://www.nttdata.co.jp/index.html<br>
     *         () allowallschemes:false<br>
     *         () allow2slashes:false<br>
     *         () nofragments:false<br>
     *         () schemesVar:null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * valueURLŁAIvVfalseAschemesVarnull̏ꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsUrl03() throws Exception {
        // O
        String value = "http://www.nttdata.co.jp/index.html";
        boolean allowallschemes = false;
        boolean allow2slashes = false;
        boolean nofragments = false;
        String schemesVar = null;

        // eXg{
        boolean result = ValidationUtil.isUrl(value, allowallschemes,
                allow2slashes, nofragments, schemesVar);

        // 
        assertTrue(result);
    }

    /**
     * testIsUrl04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:http://www.nttdata.co.jp<br>
     *         () allowallschemes:false<br>
     *         () allow2slashes:false<br>
     *         () nofragments:false<br>
     *         () schemesVar:null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * valueURLŁAIvVfalseAschemesVarnull̏ꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsUrl04() throws Exception {
        // O
        String value = "http://www.nttdata.co.jp";
        boolean allowallschemes = false;
        boolean allow2slashes = false;
        boolean nofragments = false;
        String schemesVar = null;

        // eXg{
        boolean result = ValidationUtil.isUrl(value, allowallschemes,
                allow2slashes, nofragments, schemesVar);

        // 
        assertTrue(result);
    }

    /**
     * testIsUrl05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:http://www.nttdata.co.jp/index.html<br>
     *         () allowallschemes:false<br>
     *         () allow2slashes:false<br>
     *         () nofragments:false<br>
     *         () schemesVar:""<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * valueURLł͂ȂŁAIvVfalseAschemesVar󔒂̏ꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsUrl05() throws Exception {
        // O
        String value = "http://www.nttdata.co.jp/index.html";
        boolean allowallschemes = false;
        boolean allow2slashes = false;
        boolean nofragments = false;
        String schemesVar = "";

        // eXg{
        boolean result = ValidationUtil.isUrl(value, allowallschemes,
                allow2slashes, nofragments, schemesVar);

        // 
        assertFalse(result);
    }

    /**
     * testIsUrl06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:http://www.nttdata.co.jp/<br>
     *         () allowallschemes:true<br>
     *         () allow2slashes:true<br>
     *         () nofragments:true<br>
     *         () schemesVar:"http"<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * valueURLŁAIvVtrueAschemesVarNotNull̏ꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsUrl06() throws Exception {
        // O
        String value = "http://www.nttdata.co.jp/";
        boolean allowallschemes = true;
        boolean allow2slashes = true;
        boolean nofragments = true;
        String schemesVar = "http";

        // eXg{
        boolean result = ValidationUtil.isUrl(value, allowallschemes,
                allow2slashes, nofragments, schemesVar);

        // 
        assertTrue(result);
    }

    /**
     * testIsUrl07()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:https://www.nttdata.co.jp/index.html<br>
     *         () allowallschemes:true<br>
     *         () allow2slashes:true<br>
     *         () nofragments:true<br>
     *         () schemesVar:"http,ftp,https"<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * valueURLŁAIvVtrueAschemesVarNotNull(J}؂̕)̏ꍇ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsUrl07() throws Exception {
        // O
        String value = "https://www.nttdata.co.jp/index.html";
        boolean allowallschemes = true;
        boolean allow2slashes = true;
        boolean nofragments = true;
        String schemesVar = "http,ftp,https";

        // eXg{
        boolean result = ValidationUtil.isUrl(value, allowallschemes,
                allow2slashes, nofragments, schemesVar);

        // 
        assertTrue(result);
    }

}
