/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.validation;

import java.util.ArrayList;
import java.util.Collection;
import jp.terasoluna.fw.util.PropertyAccessException;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.fw.validation.FieldChecks;
import junit.framework.TestCase;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.Var;

/**
 * {@link jp.terasoluna.fw.validation.FieldChecks}
 * NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * TERASOLUNA̓̓`FbN@\ŋʂɎgp錟؃[NXB
 * <p>
 *
 * @see jp.terasoluna.fw.validation.FieldChecks
 */
public class FieldChecksTest08 extends TestCase {

    /**
     * eXgpCX^XB
     */
    private ValidatorAction va = null;

    /**
     * eXgpCX^XB
     */
    private Field field = null;

    /**
     * eXgpCX^XB
     */
    private FieldChecks_ValidationErrorsImpl01 errors = null;

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(FieldChecksTest08.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        va = new ValidatorAction();
        field = new Field();
        errors = new FieldChecks_ValidationErrorsImpl01();
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public FieldChecksTest08(String name) {
        super(name);
    }

    /**
     * testValidateNumericString01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:null<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * beannull̏ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumericString01() throws Exception {
        // eXg{
        // 
        assertTrue(new FieldChecks().validateNumericString(null, va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateNumericString02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * bean󕶎̏ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumericString02() throws Exception {
        // eXg{
        // 
        assertTrue(new FieldChecks().validateNumericString("", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateNumericString03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:100.05<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂaddErrorsĂяoB<br>
     *
     * <br>
     * beanɐȊO̕܂܂ꍇAG[ǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumericString03() throws Exception {
        // eXg{
        // 
        assertFalse(new FieldChecks().validateNumericString(
                "100.05", va, field, errors));

        // addErrorsmF
        assertEquals(1, errors.addErrorCount);
        assertEquals("100.05", errors.beanList.get(0));
        assertSame(va, errors.vaList.get(0));
        assertSame(field, errors.fieldList.get(0));
    }

    /**
     * testValidateNumericString04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:1234567890<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * bean݂̂ō\ĂꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumericString04() throws Exception {
        // eXg{
        // 
        assertTrue(new FieldChecks().validateNumericString(
                "1234567890", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateStringLength01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:null<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * beannull̏ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateStringLength01() throws Exception {
        // eXg{
        // 
        assertTrue(new FieldChecks().validateStringLength(
                null, va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateStringLength02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * bean󕶎̏ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateStringLength02() throws Exception {
        // eXg{
        // 
        assertTrue(new FieldChecks().validateStringLength(
                "", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateStringLength03()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF,G
     * <br><br>
     * ͒lF() bean:"test"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                stringLength=null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ValidatorException<br>
     *                    bZ[WF"Mistake on validation definition file. " +
                    "- stringLength is not number. " +
                    "You'll have to check it over. ";<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF"Mistake on validation definition file. " +
                    "- stringLength is not number. " +
                    "You'll have to check it over. ", new NumberFormatException()<br>
     *
     * <br>
     * varstringLengthnull̏ꍇAValidatorExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateStringLength03() throws Exception {
        // eXg{
        // 
        try {
            new FieldChecks().validateStringLength("test", va, field, errors);
            fail();
        } catch (ValidatorException e) {
            String message = "Mistake on validation definition file. " +
            "- stringLength is not number. " +
            "You'll have to check it over. ";
            assertEquals(message, e.getMessage());
            assertTrue(LogUTUtil.checkError(message, new NumberFormatException()));
        }
    }

    /**
     * testValidateStringLength04()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF,G
     * <br><br>
     * ͒lF() bean:"test"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                stringLength=""<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ValidatorException<br>
     *                    bZ[WF"Mistake on validation definition file. " +
     *        "- stringLength is not number. " +
     *        "You'll have to check it over. "<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF"Mistake on validation definition file. " +
     *        "- stringLength is not number. " +
     *        "You'll have to check it over. ", new NumberFormatException()<br>
     *
     * <br>
     * varstringLength󕶎̏ꍇA
     * ValidatorExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateStringLength04() throws Exception {
        // O
        Var var = new Var();
        var.setName("stringLength");
        var.setValue("");
        field.addVar(var);

        // eXg{
        // 
        try {
            new FieldChecks().validateStringLength("test", va, field, errors);
            fail();
        } catch (ValidatorException e) {
            String message = "Mistake on validation definition file. " +
            "- stringLength is not number. " +
            "You'll have to check it over. ";
            assertEquals(message, e.getMessage());
            assertTrue(LogUTUtil.checkError(message, new NumberFormatException()));
        }
    }

    /**
     * testValidateStringLength05()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF,G
     * <br><br>
     * ͒lF() bean:"test"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                stringLength="test"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ValidatorException<br>
     *                    bZ[WF"Mistake on validation definition file.
     *                    - stringLength is not number.
     *                    You'll have to check it over. "<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF"Mistake on validation definition file.
     *                    - stringLength is not number.
     *                    You'll have to check it over. ", new NumberFormatException()<br>
     *
     * <br>
     * varstringLengthlɕϊłȂꍇA
     * ValidatorException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateStringLength05() throws Exception {
        // O
        Var var = new Var();
        var.setName("stringLength");
        var.setValue("test");
        field.addVar(var);

        // eXg{
        // 
        try {
            new FieldChecks().validateStringLength("test", va, field, errors);
            fail();
        } catch (ValidatorException e) {
            String message = "Mistake on validation definition file. " +
                    "- stringLength is not number. " +
                    "You'll have to check it over. ";
            assertEquals(message, e.getMessage());
            assertTrue(LogUTUtil.checkError(message, new NumberFormatException()));
        }
    }

    /**
     * testValidateStringLength06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"test"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                stringLength="3"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂ
     *                           addErrorsĂяoB<br>
     *
     * <br>
     * beaňAvarstringLength̒l傫ꍇA
     * G[ǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateStringLength06() throws Exception {
        // O
        Var var = new Var();
        var.setName("stringLength");
        var.setValue("3");
        field.addVar(var);

        // eXg{
        // 
        assertFalse(
                new FieldChecks().validateStringLength("test", va, field, errors));

        // addErrorsmF
        assertEquals(1, errors.addErrorCount);
        assertEquals("test", errors.beanList.get(0));
        assertSame(va, errors.vaList.get(0));
        assertSame(field, errors.fieldList.get(0));
    }

    /**
     * testValidateStringLength07()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"test"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                stringLength="5"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂ
     *                           addErrorsĂяoB<br>
     *
     * <br>
     * beaňAvarstringLength̒l菬ꍇA
     * G[ǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateStringLength07() throws Exception {
        // O
        Var var = new Var();
        var.setName("stringLength");
        var.setValue("5");
        field.addVar(var);

        // eXg{
        // 
        assertFalse(
                new FieldChecks().validateStringLength("test", va, field, errors));

        // addErrorsmF
        assertEquals(1, errors.addErrorCount);
        assertEquals("test", errors.beanList.get(0));
        assertSame(va, errors.vaList.get(0));
        assertSame(field, errors.fieldList.get(0));
    }

    /**
     * testValidateStringLength08()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"test"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                stringLength="4"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * beaňAvarstringLength̒lƈvꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateStringLength08() throws Exception {
        // O
        Var var = new Var();
        var.setName("stringLength");
        var.setValue("4");
        field.addVar(var);

        // eXg{
        // 
        assertTrue(
                new FieldChecks().validateStringLength("test", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateArrayRange01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F,G
     * <br><br>
     * ͒lF() bean:null<br>
     *         () va:not null<br>
     *         () field:property="field"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ValidatorException<br>
     *                    bZ[WF
     *                    "target of validateArrayRange must be not null."<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF
     *                    "target of validateArrayRange must be not null."<br>
     *
     * <br>
     * beannull̏ꍇAValidatorExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateArrayRange01() throws Exception {
        // O
        field.setProperty("field");

        // eXg{
        // 
        try {
            new FieldChecks().validateArrayRange(null, va, field, errors);
            fail();
        } catch (ValidatorException e) {
            String message = "target of validateArrayRange must be not null.";
            assertEquals(message, e.getMessage());
            assertTrue(LogUTUtil.checkError(message));
        }

    }

    /**
     * testValidateArrayRange02()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF,G
     * <br><br>
     * ͒lF() bean:JavaBean<br>
     *                 testField݂Ȃ<br>
     *         () va:not null<br>
     *         () field:property="testField"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ValidatorException<br>
     *                    bZ[WF"Cannot get property type[" +
     *                    JavaBean.class.getName+".testField]"<br>
     *         (ԕω) O:ValidatorException<br>
     *                    bZ[WF"Cannot get property type[" +
     *                    JavaBean.class.getName+".testField]"<br>
     *
     * <br>
     * fieldpropertyŎw肳ꂽbeanɑ݂ȂꍇA
     * ValidatorExceptionX[邱ƂmFB<br>
     * BeanUtil.getPropertyTypenullԋpB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateArrayRange02() throws Exception {
        // O
        FieldChecks_JavaBeanStub01 bean = new FieldChecks_JavaBeanStub01();
        field.setProperty("testField");

        // eXg{
        // 
        try {
            new FieldChecks().validateArrayRange(bean, va, field, errors);
            fail();
        } catch (ValidatorException e) {
            String message = "Cannot get property type[" +
                bean.getClass().getName() + ".testField]";
            assertEquals(message, e.getMessage());
            assertTrue(LogUTUtil.checkError(message));
        }
    }

    /**
     * testValidateArrayRange03()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:JavaBean<br>
     *         () va:not null<br>
     *         () field:property=null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ValidatorException<br>
     *                    bZ[WF"Cannot get property type[" +
     *                    JavaBean.class.getName+".null]"<br>
     *         (ԕω) O:ValidatorException<br>
     *                    bZ[WF"Cannot get property type[" +
     *                    JavaBean.class.getName+".null]", new PropertyAccessException(new IllegalArgumentException())<br>
     *
     * <br>
     * fieldpropertynull̏ꍇA
     * ValidatorExceptionX[邱ƂmFB<br>
     * BeanUtil.getPropertyTypePropertyAccessExceptionX[B
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateArrayRange03() throws Exception {
        // O
        FieldChecks_JavaBeanStub01 bean = new FieldChecks_JavaBeanStub01();

        // eXg{
        // 
        try {
            new FieldChecks().validateArrayRange(bean, va, field, errors);
            fail();
        } catch (ValidatorException e) {
            String message = "Cannot get property type[" +
                bean.getClass().getName() + ".null]";
            assertEquals(message, e.getMessage());
            assertTrue(LogUTUtil.checkError(message,
                new PropertyAccessException(new IllegalArgumentException())));
        }
    }

    /**
     * testValidateArrayRange04()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF,G
     * <br><br>
     * ͒lF() bean:JavaBean<br>
     *         () va:not null<br>
     *         () field:property=""<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ValidatorException<br>
     *                    bZ[WF"Cannot get property type[" +
     *                    JavaBean.class.getName+".testField]"<br>
     *         (ԕω) O:ValidatorException<br>
     *                    bZ[WF"Cannot get property type[" +
     *                    JavaBean.class.getName+".testField]"<br>
     *
     * <br>
     * fieldproperty󕶎̏ꍇA
     * ValidatorExceptionX[邱ƂmFB<br>
     * BeanUtil.getPropertyTypenullԋpB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateArrayRange04() throws Exception {
        // O
        FieldChecks_JavaBeanStub01 bean = new FieldChecks_JavaBeanStub01();
        field.setProperty("");

        // eXg{
        // 
        try {
            new FieldChecks().validateArrayRange(bean, va, field, errors);
            fail();
        } catch (ValidatorException e) {
            String message = "Cannot get property type[" +
                bean.getClass().getName() + ".]";
            assertEquals(message, e.getMessage());
            assertTrue(LogUTUtil.checkError(message));
        }
    }

    /**
     * testValidateArrayRange05()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF,G
     * <br><br>
     * ͒lF() bean:JavaBean<br>
     *                field1(String[]^)=null<br>
     *         () va:not null<br>
     *         () field:property="field1"<br>
     *                var:<br>
     *                minArrayLength="test"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ValidatorException<br>
     *                    bZ[WF"Mistake on validation definition file.
     *                    - minArrayLength is not number.
     *                    You'll have to check it over. "<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF"Mistake on validation definition file.
     *                    - minArrayLength is not number.
     *                    You'll have to check it over. ", new NumberFormatException()<br>
     *
     * <br>
     * varminArrayLengthlɕϊłȂꍇAValidatorException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateArrayRange05() throws Exception {
        // O
        FieldChecks_JavaBeanStub01 bean = new FieldChecks_JavaBeanStub01();
        bean.setField1(null);
        field.setProperty("field1");
        Var var = new Var();
        var.setName("minArrayLength");
        var.setValue("test");
        field.addVar(var);

        // eXg{
        // 
        try {
            new FieldChecks().validateArrayRange(bean, va, field, errors);
            fail();
        } catch (ValidatorException e) {
            String message = "Mistake on validation definition file. " +
                    "- minArrayLength is not number. " +
                    "You'll have to check it over. ";
            assertEquals(message, e.getMessage());
            assertTrue(LogUTUtil.checkError(message, new NumberFormatException()));
        }
    }

    /**
     * testValidateArrayRange06()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF,G
     * <br><br>
     * ͒lF() bean:JavaBean<br>
     *                field1(String[]^)=null<br>
     *         () va:not null<br>
     *         () field:property="field1"<br>
     *                var:<br>
     *                maxArrayLength="test"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ValidatorException<br>
     *                    bZ[WF"Mistake on validation definition file.
     *                    - maxArrayLength is not number.
     *                    You'll have to check it over. "<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF"Mistake on validation definition file.
     *                    - maxArrayLength is not number.
     *                    You'll have to check it over. ", new NumberFormatException()<br>
     *
     * <br>
     * varmaxArrayLengthlɕϊłȂꍇA
     * ValidatorException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateArrayRange06() throws Exception {
        // O
        FieldChecks_JavaBeanStub01 bean = new FieldChecks_JavaBeanStub01();
        bean.setField1(null);
        field.setProperty("field1");
        Var var = new Var();
        var.setName("maxArrayLength");
        var.setValue("test");
        field.addVar(var);

        // eXg{
        // 
        try {
            new FieldChecks().validateArrayRange(bean, va, field, errors);
            fail();
        } catch (ValidatorException e) {
            String message = "Mistake on validation definition file. " +
                    "- maxArrayLength is not number. " +
                    "You'll have to check it over. ";
            assertEquals(message, e.getMessage());
            assertTrue(LogUTUtil.checkError(message, new NumberFormatException()));
        }
    }

    /**
     * testValidateArrayRange07()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:JavaBean<br>
     *                field1(String[]^)=null<br>
     *         () va:not null<br>
     *         () field:property="field1"<br>
     *                var:<br>
     *                minArrayLength="0"<br>
     *                maxArrayLength="0"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * beañ`FbNΏۂ̃tB[hlnull̏ꍇA
     * zTCYu0vƂă`FbNs邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateArrayRange07() throws Exception {
        // O
        FieldChecks_JavaBeanStub01 bean = new FieldChecks_JavaBeanStub01();
        bean.setField1(null);
        field.setProperty("field1");
        Var var1 = new Var();
        var1.setName("minArrayLength");
        var1.setValue("0");
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("maxArrayLength");
        var2.setValue("0");
        field.addVar(var2);

        // eXg{
        // 
        assertTrue(new FieldChecks().validateArrayRange(bean, va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateArrayRange08()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF,G
     * <br><br>
     * ͒lF() bean:JavaBean<br>
     *                field2(String^)="test"<br>
     *         () va:not null<br>
     *         () field:property="field2"<br>
     *                var:<br>
     *                minArrayLength=Integer.MAX_VALUE<br>
     *                maxArrayLength=Integer.MAX_VALUE<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ValidatorException<br>
     *                    bZ[WF"property [" +
     *                    JavaBean.class.getName +
     *                    ".field2] must be instance of Array or Collection."
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF"property [" +
     *                    JavaBean.class.getName +
     *                    ".field2] must be instance of Array or Collection."
     *
     * <br>
     * beañ`FbNΏۂ̃tB[hzECollection^ł͂ȂꍇA
     * ValidatorException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateArrayRange08() throws Exception {
        // O
        FieldChecks_JavaBeanStub01 bean = new FieldChecks_JavaBeanStub01();
        bean.setField1(null);
        field.setProperty("field2");
        Var var1 = new Var();
        var1.setName("minArrayLength");
        var1.setValue(String.valueOf(Integer.MAX_VALUE));
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("maxArrayLength");
        var2.setValue(String.valueOf(Integer.MAX_VALUE));
        field.addVar(var2);

        // eXg{
        // 
        try {
            new FieldChecks().validateArrayRange(bean, va, field, errors);
            fail();
        } catch (ValidatorException e) {
            String message = "property [" +bean.getClass().getName() +
                ".field2] must be instance of Array or Collection.";
            assertEquals(message, e.getMessage());
            assertTrue(LogUTUtil.checkError(message));
        }
    }

    /**
     * testValidateArrayRange09()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:JavaBean<br>
     *                field1(String[]^)={}<br>
     *                vfȂ<br>
     *         () va:not null<br>
     *         () field:property="field1"<br>
     *                var:<br>
     *                maxArrayLength=Integer.MAX_VALUE<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * varminArrayLength擾łȂꍇA
     * ͈͂̍ŏl0Ń`FbNs邱ƂmFB<br>
     * maxArrayLengthȗꂽꍇInteger.MAX_LENGTHőlɂȂ邪
     * Iɕs\Ȃ߃eXg͍sȂB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateArrayRange09() throws Exception {
        // O
        FieldChecks_JavaBeanStub01 bean = new FieldChecks_JavaBeanStub01();
        bean.setField1(null);
        field.setProperty("field1");
        Var var = new Var();
        var.setName("maxArrayLength");
        var.setValue(String.valueOf(Integer.MAX_VALUE));
        field.addVar(var);

        // eXg{
        // 
        assertTrue(new FieldChecks().validateArrayRange(bean, va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateArrayRange10()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:JavaBean<br>
     *                field1(String[]^)={}<br>
     *                vfȂ<br>
     *         () va:not null<br>
     *         () field:property="field1"<br>
     *                var:<br>
     *                minArrayLength=""<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * varminArrayLength󕶎̏ꍇA͈͂̍ŏl0Ń`FbN
     * s邱ƂmFB<br>
     * maxArrayLength󕶎̏ꍇInteger.MAX_LENGTHőlɂȂ邪
     * Iɕs\Ȃ߃eXg͍sȂB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateArrayRange10() throws Exception {
        // O
        FieldChecks_JavaBeanStub01 bean = new FieldChecks_JavaBeanStub01();
        bean.setField1(null);
        field.setProperty("field1");
        Var var = new Var();
        var.setName("minArrayLength");
        var.setValue("");
        field.addVar(var);

        // eXg{
        // 
        assertTrue(new FieldChecks().validateArrayRange(bean, va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateArrayRange11()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:JavaBean<br>
     *                field1(String[]^)={<br>
     *                    "test1","test2","test3"<br>
     *                }<br>
     *                vfR<br>
     *         () va:not null<br>
     *         () field:property="field1"<br>
     *                var:<br>
     *                minArrayLength="1"<br>
     *                maxArrayLength="5"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * beañ`FbNΏۂ̔ztB[h̗vfA
     * varminArrayLengthmaxArrayLength͈͓̔̂ƂA
     * true擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateArrayRange11() throws Exception {
        // O
        FieldChecks_JavaBeanStub01 bean = new FieldChecks_JavaBeanStub01();
        String[] array = {
            "test1", "test2", "test3"
        };
        bean.setField1(array);
        field.setProperty("field1");
        Var var1 = new Var();
        var1.setName("minArrayLength");
        var1.setValue("1");
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("maxArrayLength");
        var2.setValue("5");
        field.addVar(var2);

        // eXg{
        // 
        assertTrue(new FieldChecks().validateArrayRange(bean, va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateArrayRange12()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:JavaBean<br>
     *                field3(Collection^)={<br>
     *                    "test1","test2","test3"<br>
     *                }<br>
     *                vfR<br>
     *         () va:not null<br>
     *         () field:property="field3"<br>
     *                var:<br>
     *                minArrayLength="4"<br>
     *                maxArrayLength="10"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂ
     *                           addErrorsĂяoB<br>
     *
     * <br>
     * beañ`FbNΏۂCollection^tB[h̗vfA
     * varminArrayLengthmaxArrayLength͈̔͂菭ȂꍇA
     * G[ǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testValidateArrayRange12() throws Exception {
        // O
        FieldChecks_JavaBeanStub01 bean = new FieldChecks_JavaBeanStub01();
        Collection list = new ArrayList();
        list.add("test1");
        list.add("test2");
        list.add("test3");
        bean.setField3(list);
        field.setProperty("field3");
        Var var1 = new Var();
        var1.setName("minArrayLength");
        var1.setValue("4");
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("maxArrayLength");
        var2.setValue("10");
        field.addVar(var2);

        // eXg{
        // 
        assertFalse(new FieldChecks().validateArrayRange(bean, va, field, errors));

        // addErrorsmF
        assertEquals(1, errors.addErrorCount);
        assertSame(bean, errors.beanList.get(0));
        assertSame(va, errors.vaList.get(0));
        assertSame(field, errors.fieldList.get(0));
    }

    /**
     * testValidateArrayRange13()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:JavaBean<br>
     *                field4(int[]^)={<br>
     *                    1,2,3,4,5,6,7,8,9,0<br>
     *                }<br>
     *                vf10<br>
     *         () va:not null<br>
     *         () field:property="field4"<br>
     *                var:<br>
     *                minArrayLength="1"<br>
     *                maxArrayLength="5"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂ
     *                           addErrorsĂяoB<br>
     *
     * <br>
     * beañ`FbNΏۂ̃v~eBuz^tB[h̗vfA
     * varminArrayLengthmaxArrayLength͈̔͂傫ꍇA
     * G[ǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateArrayRange13() throws Exception {
        // O
        FieldChecks_JavaBeanStub01 bean = new FieldChecks_JavaBeanStub01();
        int[] array = {
            1, 2, 3, 4, 5, 6, 7, 8, 9, 0
        };
        bean.setField4(array);
        field.setProperty("field4");
        Var var1 = new Var();
        var1.setName("minArrayLength");
        var1.setValue("1");
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("maxArrayLength");
        var2.setValue("5");
        field.addVar(var2);

        // eXg{
        // 
        assertFalse(new FieldChecks().validateArrayRange(bean, va, field, errors));

        // addErrorsmF
        assertEquals(1, errors.addErrorCount);
        assertSame(bean, errors.beanList.get(0));
        assertSame(va, errors.vaList.get(0));
        assertSame(field, errors.fieldList.get(0));
    }

    /**
     * testValidateArrayRange14()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:JavaBean<br>
     *                field1(String[]^)={<br>
     *                    "test1","test2","test3"<br>
     *                }<br>
     *                vfR<br>
     *         () va:not null<br>
     *         () field:property="field1"<br>
     *                var:<br>
     *                minArrayLength="3"<br>
     *                maxArrayLength="3"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * beañ`FbNΏۂ̔ztB[h̗vfƁA
     * varminArrayLengthmaxArrayLength̒lƂA
     * true擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateArrayRange14() throws Exception {
        // O
        FieldChecks_JavaBeanStub01 bean = new FieldChecks_JavaBeanStub01();
        String[] array = {
            "test1", "test2", "test3"
        };
        bean.setField1(array);
        field.setProperty("field1");
        Var var1 = new Var();
        var1.setName("minArrayLength");
        var1.setValue("3");
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("maxArrayLength");
        var2.setValue("3");
        field.addVar(var2);

        // eXg{
        // 
        assertTrue(new FieldChecks().validateArrayRange(bean, va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateArrayRange15()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF,G
     * <br><br>
     * ͒lF() bean:JavaBean<br>
     *                field5(Stiring[]^)<br>
     *                getField5ŗOB<br>
     *         () va:not null<br>
     *         () field:property="field5"<br>
     *                var:<br>
     *                minArrayLength="3"<br>
     *                maxArrayLength="3"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ValidatorException<br>
     *                    bZ[WF"Cannot get property [" +
     *                    JavaBean.class.getName+".field5]"<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF"Cannot get property [" +
     *                    JavaBean.class.getName+".field5]", 
                new PropertyAccessException(new IllegalArgumentException())));<br>
     *
     * <br>
     * `FbNΏۂ̃vpeB̎擾ɗOꍇA
     * ValidatorException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateArrayRange15() throws Exception {
        // O
        FieldChecks_JavaBeanStub01 bean = new FieldChecks_JavaBeanStub01();
        field.setProperty("field5");
        Var var1 = new Var();
        var1.setName("minArrayLength");
        var1.setValue("3");
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("maxArrayLength");
        var2.setValue("3");
        field.addVar(var2);

        // eXg{
        // 
        try {
            new FieldChecks().validateArrayRange(bean, va, field, errors);
            fail();
        } catch (ValidatorException e) {
            String message = "Cannot get property [" +
                bean.getClass().getName() + ".field5]";
            assertEquals(message, e.getMessage());
            assertTrue(LogUTUtil.checkError(message,
                new PropertyAccessException(new IllegalArgumentException())));
        }
    }

}
