/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web;

import java.io.File;
import java.io.FileInputStream;

import jp.terasoluna.fw.util.FileUtil;
import jp.terasoluna.fw.util.PropertyUtil;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockHttpSession;
import jp.terasoluna.utlib.PropertyTestCase;

/**
 * {@link jp.terasoluna.fw.web.HttpSessionListenerImpl} 
 * NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * HTTPZbṼCtTCNCxgNXB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.HttpSessionListenerImpl
 */
public class HttpSessionListenerImplTest extends PropertyTestCase {

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#setUpData()
     */
    @Override
    protected void setUpData() throws Exception {
        LogUTUtil.flush();
        
        addProperty("session.dir.base", "c:/sessions");
        
        // t@C폜
        FileUtil.removeSessionDirectory("dummyID");
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#cleanUpData()
     */
    @Override
    protected void cleanUpData() throws Exception {
        // t@C폜
        FileUtil.removeSessionDirectory("dummyID");
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public HttpSessionListenerImplTest(String name) {
        super(name);
    }

    /**
     * testSessionDestroyed01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() event:not null<br>
     *         () session.getId():"dummyID"<br>
     *         () dir.exists():false<br>
     *         () dir.isDirectory():false<br>
     *         () fBNg
     *         ("c:/sessions/" + FileUtil.getSessionDirectoryName("dummyID"))<br>
     *         :݂Ȃꍇ<br>
     *         () vpeB:session.dir.base=<br>
     *                c:/sessions<br>
     *         
     * <br>
     * ҒlF(ԕω) fBNg
     *         ("c:/sessions/" + FileUtil.getSessionDirectoryName("dummyID"))<br>
     *         :݂Ȃ<br>
     *         
     * <br>
     * ZbVfBNg݂Ȃꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSessionDestroyed01() throws Exception {
        // O
        HttpSessionListenerImpl listener = new HttpSessionListenerImpl();
        
        MockHttpSession session = new MockHttpSession();
        // HttpSessionEvent
        HttpSessionListenerImpl_HttpSessionEventStub01 event =
            new HttpSessionListenerImpl_HttpSessionEventStub01(session);
        
        // eXg{
        listener.sessionDestroyed(event);
        
        // 
        File file = new File(PropertyUtil.getProperty("session.dir.base") + "/"
                + FileUtil.getSessionDirectoryName("dummyID"));
        
        assertFalse(file.exists());
    }

    /**
     * testSessionDestroyed02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() event:not null<br>
     *         () session.getId():"dummyID"<br>
     *         () dir.exists():true<br>
     *         () dir.isDirectory():false<br>
     *         () fBNg
     *         ("c:/sessions/" + FileUtil.getSessionDirectoryName("dummyID"))<br>
     *         :݂邪AfBNgłȂꍇ<br>
     *         () vpeB:session.dir.base=<br>
     *                c:/sessions<br>
     *         
     * <br>
     * ҒlF(ԕω) fBNg
     *         ("c:/sessions/" + FileUtil.getSessionDirectoryName("dummyID"))<br>
     *         :폜Ȃ<br>
     *         
     * <br>
     * ZbVfBNg݂邪AfBNgłȂꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSessionDestroyed02() throws Exception {
        // O
        // ZbVfBNg쐬
        File file = new File(PropertyUtil.getProperty("session.dir.base")
                + "/" + FileUtil.getSessionDirectoryName("dummyID"));
        
        file.createNewFile();
        
        
        // O
        HttpSessionListenerImpl listener = new HttpSessionListenerImpl();
        
        MockHttpSession session = new MockHttpSession();
        // HttpSessionEvent
        HttpSessionListenerImpl_HttpSessionEventStub01 event =
            new HttpSessionListenerImpl_HttpSessionEventStub01(session);
        
        // eXg{
        listener.sessionDestroyed(event);
        
        // 
        File result = new File(PropertyUtil.getProperty("session.dir.base")
                + "/" + FileUtil.getSessionDirectoryName("dummyID"));
        
        assertTrue(result.exists());
        
        // ㏈Ft@C̍폜fBNgłȂcleanUpData()ł͍폜Ȃ
        file.delete();
        
    }

    /**
     * testSessionDestroyed03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() event:not null<br>
     *         () session.getId():"dummyID"<br>
     *         () dir.exists():true<br>
     *         () dir.isDirectory():true<br>
     *         () fBNg
     *         ("c:/sessions/" + FileUtil.getSessionDirectoryName("dummyID"))<br>
     *         :fBNg
     *         () vpeB:session.dir.base=<br>
     *                c:/sessions<br>
     *         
     * <br>
     * ҒlF(ԕω) fBNg
     *         ("c:/sessions/" + FileUtil.getSessionDirectoryName("dummyID"))<br>
     *         :폜<br>
     *         
     * <br>
     * ZbVfBNg݂AfBNg̏ꍇA폜ꂽmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSessionDestroyed03() throws Exception {
        // O
        // ZbVfBNg쐬
        FileUtil.makeSessionDirectory("dummyID");
                
        // O
        HttpSessionListenerImpl listener = new HttpSessionListenerImpl();
        
        MockHttpSession session = new MockHttpSession();
        // HttpSessionEvent
        HttpSessionListenerImpl_HttpSessionEventStub01 event =
            new HttpSessionListenerImpl_HttpSessionEventStub01(session);
        
        // eXg{
        listener.sessionDestroyed(event);
        
        // 
        File result = new File(PropertyUtil.getProperty("session.dir.base")
                + "/" + FileUtil.getSessionDirectoryName("dummyID"));
        
        assertFalse(result.exists());
    }
    

    /**
     * testSessionDestroyed04()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() event:not null<br>
     *         () session.getId():"dummyID"<br>
     *         () dir.exists():true<br>
     *         () dir.isDirectory():true<br>
     *         () FileUtil.removeSessionDirectory():true<br>
     *         () fBNg<br>
     *                ("c:/sessions/" +@FileUtil.getSessionDirectoryName("dummyID")):fBNgi폜łȂj<br>
     *         () vpeB:session.dir.base=<br>
     *                c:/sessions<br>
     *         
     * <br>
     * ҒlF(ԕω) fBNg<br>
     *                    ("c:/sessions/" + FileUtil.getSessionDirectoryName("dummyID")):폜Ȃ<br>
     *         (ԕω) O:<errorx><br>
     *                    bZ[WF"can't remove \"" + dir.getPath() + "\"."<br>
     *         
     * <br>
     * ZbVfBNg݂AfBNgł邪폜łȂꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unused")
    public void testSessionDestroyed04() throws Exception {
        // O
        // ZbVfBNg쐬
        FileUtil.makeSessionDirectory("dummyID");
        // fBNgɃt@C쐬
        File file = new File(PropertyUtil.getProperty("session.dir.base")
                + "/" + FileUtil.getSessionDirectoryName("dummyID")
                + "/test.txt");
        file.createNewFile();
        FileInputStream fileInputStream = new FileInputStream(file);

        // O
        HttpSessionListenerImpl listener = new HttpSessionListenerImpl();
        
        MockHttpSession session = new MockHttpSession();
        // HttpSessionEvent
        HttpSessionListenerImpl_HttpSessionEventStub01 event =
            new HttpSessionListenerImpl_HttpSessionEventStub01(session);

        // eXg{
        listener.sessionDestroyed(event);

        // 
        File result = new File(PropertyUtil.getProperty("session.dir.base")
                + "/" + FileUtil.getSessionDirectoryName("dummyID"));

        assertTrue(result.exists());
        assertTrue(LogUTUtil.checkError("can't remove \"" + result.getPath()
                + "\"."));

        // FileInputStreamN[Y
        fileInputStream.close();
    }
}