/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.file.dao.standard;

import java.io.IOException;
import java.io.Reader;

import jp.terasoluna.fw.file.dao.FileException;

/**
 * t@Cf[^̃f[^1sǂݎAƂČďoɕԋpB
 * 
 * 
 */
public class EncloseCharLineFeed1LineReader implements LineReader {

    /**
     * ؂蕶B
     */
    private char delimiterCharacter;

    /**
     * ͂ݕB
     */
    private char encloseCharacter;

    /**
     * t@CANZXp̕Xg[B
     */
    private Reader reader;

    /**
     * s؂蕶B
     */
    private String lineFeedChar;

    /**
     * RXgN^B
     * 
     * @param delimiterCharacter ؂蕶
     * @param encloseCharacter ͂ݕ
     * @param reader t@CANZXp̕Xg[
     * @param lineFeedChar s؂蕶
     */
    public EncloseCharLineFeed1LineReader(char delimiterCharacter,
            char encloseCharacter, Reader reader, String lineFeedChar) {
        this.delimiterCharacter = delimiterCharacter;
        this.encloseCharacter = encloseCharacter;
        this.reader = reader;
        this.lineFeedChar = lineFeedChar;
    }

    /**
     * t@Cf[^̃f[^1sǂݎAƂČďoɕԋpB
     * 
     * @return f[^̂Ps̕
     */
    public String readLine() {
        // 1J̕i[obt@
        StringBuilder currentLineString = new StringBuilder();

        // J̐擪̕i[obt@
        StringBuilder columnIni = new StringBuilder(1);

        // ͂ݕIĂ邩mFtOBtrueȂJ͈͂ݕň͂܂ĂB
        boolean isEnclosed = true;

        // GXP[vV[PXǂݍ񂾂trueɁBȊȌꍇfalseB
        boolean isEscape = false;

        // s؂蕶1ځB
        char lineFeedChar1 = lineFeedChar.charAt(0);

        try {
            while (reader.ready()) {
                char currentChar = (char) reader.read();
                if (columnIni == null || columnIni.length() == 0) {
                    columnIni.append(currentChar);
                }
                if (columnIni.charAt(0) == encloseCharacter) {
                    if (isEnclosed) {
                        if (currentChar == encloseCharacter) {
                            isEnclosed = false;
                        }
                        currentLineString.append(currentChar);
                    } else {
                        if (currentChar == encloseCharacter && !isEscape) {
                            isEscape = true;
                        } else if (currentChar == encloseCharacter
                                && isEscape) {
                            isEscape = false;
                            currentLineString.append(encloseCharacter);
                            currentLineString.append(currentChar);
                        } else if (currentChar == delimiterCharacter) {
                            if (isEscape) {
                                currentLineString.append(encloseCharacter);
                                columnIni.delete(0, 1);
                                isEnclosed = true;
                                isEscape = false;
                            }
                            currentLineString.append(currentChar);
                        } else if (currentChar == lineFeedChar1) {
                            if (isEscape) {
                                currentLineString.append(encloseCharacter);
                                columnIni.delete(0, 1);
                                isEnclosed = true;
                                isEscape = false;
                                break;
                            } else {
                                currentLineString.append(currentChar);
                            }
                        } else {
                            if (isEscape) {
                                currentLineString.append(encloseCharacter);

                                columnIni.delete(0, 1);
                                isEnclosed = true;
                                isEscape = false;
                            }
                            currentLineString.append(currentChar);
                        }
                    }
                } else if (columnIni.charAt(0) == lineFeedChar1) {
                    columnIni.delete(0, 1);
                    isEnclosed = true;
                    isEscape = false;
                    break;
                } else {
                    if (currentChar == delimiterCharacter) {
                        currentLineString.append(currentChar);
                        columnIni.delete(0, 1);
                        isEnclosed = true;
                        isEscape = false;
                    } else if (currentChar == lineFeedChar1) {
                        columnIni.delete(0, 1);
                        isEnclosed = true;
                        isEscape = false;
                        break;
                    } else {
                        currentLineString.append(currentChar);
                    }
                }
            }
        } catch (IOException e) {
            throw new FileException(e);
        }

        return currentLineString.toString();
    }

}
