/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.struts.actions;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.util.FileUtil;
import jp.terasoluna.fw.web.struts.actions.ActionEx;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class MakeSessionDirectoryAction
extends ActionEx {
    private static Log log = LogFactory.getLog(MakeSessionDirectoryAction.class);
    private static final String SESSION_NOT_FOUND_ERROR = "error.session.not.found";
    private static final String FORWARD_ERRORPAGE_ERROR = "error.forward.errorpage";

    public ActionForward doExecute(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) {
        HttpSession session;
        if (log.isDebugEnabled()) {
            log.debug((Object)"doExecute() called.");
        }
        if ((session = req.getSession(false)) == null) {
            log.error((Object)"HttpSession is not available.");
            throw new SystemException(null, SESSION_NOT_FOUND_ERROR);
        }
        FileUtil.makeSessionDirectory(session.getId());
        String path = mapping.getParameter();
        if (path == null) {
            try {
                res.sendError(404);
            }
            catch (IOException e) {
                log.error((Object)"Error page(404) forwarding failed.");
                throw new SystemException(e, FORWARD_ERRORPAGE_ERROR);
            }
            return null;
        }
        ActionForward retVal = new ActionForward(path);
        return retVal;
    }
}

