/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.taglib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.terasoluna.fw.web.codelist.CodeBean;
import jp.terasoluna.fw.web.codelist.CodeListLoader;

/**
 * R[hXg̏ <code>Map</code> ōsA
 * {@link jp.terasoluna.fw.web.codelist.CodeListLoader} NXB<br>
 * <br>
 * ̃NXpăR[hXg`ꍇ́A {@link #setCodeListMap(Map)} \bhŃR[hXg
 * <code>Map</code> `ŗ^A{@link #load()} sKvB<br>
 * <h5>Springt[[Nł̎gpB</h5>
 * <code><pre>
 *  &lt;bean id=&quot;reader1&quot;
 *        class=&quot;jp.terasoluna.fw.web.codelist.MappedCodeListLoader&quot;
 *        init-method=&quot;load&quot;&gt;
 *      &lt;property name=&quot;codeListMap&quot;&gt;
 *          &lt;map&gt;
 *              &lt;entry key=&quot;001&quot;&gt;
 *                  &lt;value&gt;value001&lt;/value&gt;
 *              &lt;/entry&gt;
 *              &lt;entry key=&quot;002&quot;&gt;
 *                  &lt;value&gt;value002&lt;/value&gt;
 *              &lt;/entry&gt;
 *              &lt;entry key=&quot;003&quot;&gt;
 *                  &lt;value&gt;value003&lt;/value&gt;
 *              &lt;/entry&gt;
 *          &lt;/map&gt;
 *      &lt;/property&gt;
 *  &lt;/bean&gt;
 * </pre></code>
 * 
 */
public class CodeListLoader_WriteCodeListTagStub01 implements CodeListLoader {


		/**
		 * R[hXgɗ^邽߂ <code>Map</code> B
		 */
		private Map<String, String> codeListMap = null;

		/**
		 * R[hXgB
		 * 
		 * @see CodeBean
		 */
		private List<CodeBean> codeLists = null;

		/**
		 * R[hXg <code>Map</code> 擾B
		 * 
		 * @return R[hXg <code>Map</code>
		 */
		public Map getCodeListMap() {
			return codeListMap;
		}

		/**
		 * R[hXg <code>Map</code> ݒ肷B
		 * 
		 * @param codeListMap
		 *            R[hXg <code>Map</code>
		 */
		public void setCodeListMap(Map<String, String> codeListMap) {
			this.codeListMap = codeListMap;
		}

		/**
		 * R[hXg̏sB<br>
		 * <br>
		 * ɐݒ肳Ă <code>codeListMap</code> ̏񂩂 {@link CodeBean} 𐶐B
		 */
		public void load() {
			if (codeLists != null) {
				return;
			}
			if (codeListMap == null) {
				codeLists = Collections.unmodifiableList(new ArrayList<CodeBean>());
				return;
			}
			List<CodeBean> list = new ArrayList<CodeBean>();
			Iterator it = codeListMap.keySet().iterator();
			while (it.hasNext()) {
				String key = (String) it.next();
				String value = codeListMap.get(key);
				CodeBean cb = new CodeBean();
				cb.setId(key);
				cb.setName(value);
				list.add(cb);
			}
			codeLists = Collections.unmodifiableList(list);
		}

		/**
		 * R[hXg擾B<br>
		 * <br>
		 * R[hXg {@link CodeBean} ̔zƂĎ擾łB<br>
		 * R[hXg͌ƂăAvP[VňӂƂȂłB ̃\bhI[o[Chꍇ́AƖWbNȂǂ
		 * R[hXg̓eҏWĂeȂ悤ɎKvB
		 * 
		 * @return R[hXg
		 */
		public CodeBean[] getCodeBeans() {
				return null;
		}
}
