/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.utlib;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import javax.servlet.ServletOutputStream;

/**
 * HttpServletOutputStream ̃bNAbvNXB
 * <BR><BR>
 * 
 * <pre>
 * [gp1(t@C𗘗pȂꍇ)]
 * // MockIuWFNg̏ 
 * MockHttpServletRequest req = new MockHttpServletRequest();
 * MockHttpServletResponse res = new MockHttpServletResponse();
 * MockServletOutputStream sos = new MockServletOutputStream();
 * res.setOutputStream(sos);
 * 
 * // eXgΏ(Action#perform)s 
 * 
 * // ʂ̊mF 
 * byte[] expect = {'a', 'b', 'c'};
 * assertTrue(Arrays.equals(expect, sos.toByteArray()));
 * 
 * 
 * [gp2(t@C𗘗pꍇ)]
 * // MockIuWFNg̏ 
 * MockHttpServletRequest req = new MockHttpServletRequest();
 * MockHttpServletResponse res = new MockHttpServletResponse();
 * File outFile = new File("outFile.txt");
 * MockServletOutputStream sos = new MockServletOutputStream(outFile);
 * res.setOutputStream(sos);
 * 
 * // eXgΏ(Action#execute)s 
 * 
 * // ʂ̊mF
 * File expectFile = UTUtil.getFile("expectFile.txt");
 * UTUtil.assertEqualsFile(expectFile, outFile);
 * 
 * </pre>
 * 
 *
 */
public class MockServletOutputStream extends ServletOutputStream {

    /** ServletOutputStream̑OutputStream */
    OutputStream os = null;

    /**
     * ftHgRXgN^iXg[o͐̓oCgzjB
     * <BR><BR>
     * Ȃ̃RgN^̏ꍇAIByteArrayOutputStream
     * ServletOutputStreamւB
     */
    public MockServletOutputStream() throws FileNotFoundException {

        super();
        os = new ByteArrayOutputStream();
    }

    /**
     * Xg[̏o͐Ƀt@C𗘗pꍇ̃RXgN^B
     * <BR><BR>
     * java.io.FileƂRgN^̏ꍇAI
     * FileOutputStreamServletOutputStreamւB
     * 
     * @param file Xg[̏ݐƂȂt@C
     */
    public MockServletOutputStream(File file) throws FileNotFoundException {

        super();
        os = new FileOutputStream(file);
    }

    /**
     * @see java.io.OutputStream#write(int)
     */
    public void write(int b) throws IOException {
        os.write(b);
    }

    /**
     * @see java.io.OutputStream#close()
     */
    public void close() throws IOException {
        os.close();
    }

    /**
     * @see java.io.OutputStream#flush()
     */
    public void flush() throws IOException {
        os.flush();
    }

    /**
     * ܂ꂽoCĩoCg擾B
     * <BR><BR>
     * ̃\bhĂяốAȂRXgN^ŌĂяoꍇ
     * Ȃ̂ŗvӁB
     */
    public byte[] toByteArray() {
        if (!(os instanceof ByteArrayOutputStream)) {
            String msg = "Xg[o͐悪t@ĈƂ͗pł܂I";
            throw new IllegalStateException(msg);
        }
        ByteArrayOutputStream baos = (ByteArrayOutputStream) os;
        return baos.toByteArray();
    }

}
