/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.service.thin;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.util.PropertyAccessException;
import jp.terasoluna.fw.web.struts.form.DynaValidatorActionFormEx;
import jp.terasoluna.fw.web.struts.form.FormEx;
import jp.terasoluna.utlib.DynaActionFormCreator;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockHttpServletResponse;
import jp.terasoluna.utlib.MockHttpSession;
import junit.framework.TestCase;

import org.apache.struts.Globals;
import org.apache.struts.action.ActionMapping;

import com.mockrunner.mock.web.MockHttpServletRequest;

/**
 * {@link jp.terasoluna.fw.service.thin.BLogicMapper} NX
 * ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * rWlXWbNo͏񔽉fNXB<br>
 * BLogicIOPlugInɂĐꂽBLogicResourcesƂɁA
 * Webw̃IuWFNgƁArWlXWbNԂ̃f[^̃}bsOsB
 * <p>
 *
 * @see jp.terasoluna.fw.service.thin.BLogicMapper
 */
@SuppressWarnings("unused")
public class BLogicMapperTest extends TestCase {

    /**
     * t@CpXvpeB擾
     */
    private static final String CONFIG_FILE_NAME = BLogicMapperTest.class
            .getResource("BLogicMapperTest.xml").getPath();

    private static final String RULES_FILE_NAME = BLogicMapperTest.class
            .getResource("BLogicMapperTest-rules.xml").getPath();

    private final DynaActionFormCreator creator;

    private DynaValidatorActionFormEx formEx = null;
    
    private String resource = "resource.path";

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.formEx =
            (DynaValidatorActionFormEx) this.creator.create(CONFIG_FILE_NAME);
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public BLogicMapperTest(String name) {
        super(name);

        this.creator = new DynaActionFormCreator(RULES_FILE_NAME);
    }

    /**
     * testBLogicMapper01()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() resources:null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentExceptionF<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "resources file location is not specified"<br>
     *         
     * <br>
     * RXgN^nulll̏ꍇAO邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testBLogicMapper01() throws Exception {
        
        // eXg{
        try {
            new BLogicMapper(null);
            fail();
        } catch (IllegalArgumentException e) {
            // 
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
            assertTrue(LogUTUtil.checkError("resources file location is " +
                    "not specified"));
        }
        
    }

    /**
     * testBLogicMapper02()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() resources:""<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentExceptionF<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "resources file location is not specified"<br>
     *         
     * <br>
     * RXgN^l̏ꍇAO邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testBLogicMapper02() throws Exception {
        // eXg{
        try {
            new BLogicMapper("");
            fail();
        } catch (IllegalArgumentException e) {
            // 
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
            assertTrue(LogUTUtil.checkError("resources file location is " +
                    "not specified"));
        }
        
    }

    /**
     * testBLogicMapper03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() resources:"resource.path"<br>
     *         
     * <br>
     * ҒlF(߂l) blogicMapper:not Null
     * <br>
     * RXgN^݂̈ꍇACX^X邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testBLogicMapper03() throws Exception {
        // eXg{
        BLogicMapper blogicMapper = new BLogicMapper(resource);
        
        // 
        assertNotNull(blogicMapper);
    }

    /**
     * testGetValueFromRequest01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() propName:"requestValue"<br>
     *         () request:[requestValue="requestValue"]<br>
     *         () response:not null<br>
     *
     * <br>
     * ҒlF(߂l) Object:"requestValue"<br>
     *         (ԕω) O:|<br>
     *         (ԕω) O:|<br>
     *
     * <br>
     * propNameL[requestɒli[ĂA擾lԋp邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetValueFromRequest01() throws Exception {
        // [NGXg
        HttpServletRequest request = new BLogicMapper_MockHttpServletRequest01();

        request.setAttribute("requestValue", "requestValue");

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BLogicMapper
        BLogicMapper mapper = new BLogicMapper(resource);

        // eXg{E
        assertEquals("requestValue", mapper.getValueFromRequest("requestValue",
                request, response));
    }

    /**
     * testGetValueFromRequest02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() propName:"value"<br>
     *         () request:[requestValue="requestValue"]<br>
     *         () response:not null<br>
     *
     * <br>
     * ҒlF(߂l) Object:null<br>
     *         (ԕω) O:|<br>
     *         (ԕω) O:|<br>
     *
     * <br>
     * propNameL[requestɒli[ĂȂAnullԋp邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetValueFromRequest02() throws Exception {
        // [NGXg
        HttpServletRequest request = new BLogicMapper_MockHttpServletRequest01();
        request.setAttribute("requestValue", "requestValue");

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BLogicMapper
        BLogicMapper mapper = new BLogicMapper(resource);

        // eXg{E
        assertNull(mapper.getValueFromRequest("value", request, response));
    }

    /**
     * testGetValueFromRequest03()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() propName:""<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *
     * <br>
     * ҒlF(߂l) Object:|<br>
     *         (ԕω) O:IllegalArgumentException<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "illegal argument:propName = []"<br>
     *
     * <br>
     * propName󕶎̎AO邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetValueFromRequest03() throws Exception {
        // [NGXg
        HttpServletRequest request = new BLogicMapper_MockHttpServletRequest01();

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BLogicMapper
        BLogicMapper mapper = new BLogicMapper(resource);

        // eXgs
        try {
            Object result = mapper.getValueFromRequest("", request, response);
            fail();
        } catch (IllegalArgumentException e) {
            // eXgʊmF
            assertTrue(LogUTUtil.checkError("illegal argument:propName = []"));
        }
    }

    /**
     * testGetValueFromRequest04()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() propName:null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *
     * <br>
     * ҒlF(߂l) Object:|<br>
     *         (ԕω) O:IllegalArgumentException<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "illegal argument:propName = [null]"<br>
     *
     * <br>
     * propNamenull̎AO邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetValueFromRequest04() throws Exception {
        // [NGXg
        HttpServletRequest request = new BLogicMapper_MockHttpServletRequest01();

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BLogicMapper
        BLogicMapper mapper = new BLogicMapper(resource);

        // eXgs
        try {
            Object result = mapper.getValueFromRequest(null, request, response);
            fail();
        } catch (IllegalArgumentException e) {
            // eXgʊmF
            assertTrue(LogUTUtil
                    .checkError("illegal argument:propName = [null]"));
        }
    }

    /**
     * testSetValueToRequest01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() value:"value"<br>
     *         () propName:"requestValue"<br>
     *         () request:[requestValue="requestValue"]<br>
     *         () response:not null<br>
     *
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) O:|<br>
     *         (ԕω) request:[requestValue="value"]<br>
     *
     * <br>
     * value̒lrequestɔf邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetValueToRequest01() throws Exception {
        // [NGXg
        HttpServletRequest request = new BLogicMapper_MockHttpServletRequest01();
        request.setAttribute("requestValue", "requestValue");

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BLogicMapper
        BLogicMapper mapper = new BLogicMapper(resource);

        // eXg{
        mapper.setValueToRequest("value", "requestValue", request, response);

        // 
        assertEquals("value", request.getAttribute("requestValue"));
    }

    /**
     * testSetValueToRequest02()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() value:"value"<br>
     *         () propName:""<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) O:IllegalArgumentException<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "illegal argument:propName = []"<br>
     *         (ԕω) request:|<br>
     *
     * <br>
     * propName̒l󕶎̎AO邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetValueToRequest02() throws Exception {
        // [NGXg
        HttpServletRequest request = new BLogicMapper_MockHttpServletRequest01();

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BLogicMapper
        BLogicMapper mapper = new BLogicMapper(resource);

        // eXg{E
        try {
            mapper.setValueToRequest("value", "", request, response);
            fail();
        } catch (IllegalArgumentException e) {
            // eXgʊmF
            assertTrue(LogUTUtil.checkError("illegal argument:propName = []"));
        }
    }

    /**
     * testSetValueToRequest03()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() value:"value"<br>
     *         () propName:null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) O:IllegalArgumentException<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "illegal argument:propName = [null]"<br>
     *         (ԕω) request:|<br>
     *
     * <br>
     * propName̒lnull̎AO邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetValueToRequest03() throws Exception {
        // [NGXg
        HttpServletRequest request = new BLogicMapper_MockHttpServletRequest01();

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BLogicMapper
        BLogicMapper mapper = new BLogicMapper(resource);

        // eXg{E
        try {
            mapper.setValueToRequest("value", null, request, response);
            fail();
        } catch (IllegalArgumentException e) {
            // eXgʊmF
            assertTrue(LogUTUtil
                    .checkError("illegal argument:propName = [null]"));
        }
    }

    /**
     * testSetValueToRequest04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:null<br>
     *         () propName:"requestValue"<br>
     *         () request:[requestValue="requestValue"]<br>
     *         () response:not null<br>
     *
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) O:|<br>
     *         (ԕω) request:requestValue폜<br>
     *
     * <br>
     * valuenull̎Arequestɓo^ĂAttribute폜邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetValueToRequest04() throws Exception {
        // [NGXg
        HttpServletRequest request = new BLogicMapper_MockHttpServletRequest01();
        request.setAttribute("requestValue", "requestValue");

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BLogicMapper
        BLogicMapper mapper = new BLogicMapper(resource);

        // eXg{
        mapper.setValueToRequest(null, "requestValue", request, response);

        // 
        assertFalse(request.getAttributeNames().hasMoreElements());
    }

    /**
     * testSetValueToRequest05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() value:"value"<br>
     *         () propName:"requestValue"<br>
     *         () request:requestValueݒȂ<br>
     *         () response:not null<br>
     *
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) O:|<br>
     *         (ԕω) request:[requestValue="value"]<br>
     *
     * <br>
     * value̒lrequestɔf邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetValueToRequest05() throws Exception {
        // [NGXg
        HttpServletRequest request = new BLogicMapper_MockHttpServletRequest01();

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BLogicMapper
        BLogicMapper mapper = new BLogicMapper(resource);

        // eXg{
        mapper.setValueToRequest("value", "requestValue", request, response);

        // 
        assertEquals("value", request.getAttribute("requestValue"));
    }

    /**
     * testGetValueFromSession01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() propName:"sessionValue"<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () sessionirequest.getSession()j:[sessionValue="sessionValue"]<br>
     *
     * <br>
     * ҒlF(߂l) Object:"sessionValue"<br>
     *         (ԕω) O:|<br>
     *         (ԕω) O:|<br>
     *
     * <br>
     * propNameL[sessionɒli[ĂA擾lԋp邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetValueFromSession01() throws Exception {
        // [ZbV
        HttpSession session = new MockHttpSession();
        session.setAttribute("sessionValue", "sessionValue");

        // [NGXg
        MockHttpServletRequest request = new BLogicMapper_MockHttpServletRequest01();
        request.setSession(session);

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BLogicMapper
        BLogicMapper mapper = new BLogicMapper(resource);

        // eXg{E
        assertEquals("sessionValue", mapper.getValueFromSession("sessionValue",
                request, response));
    }

    /**
     * testGetValueFromSession02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() propName:"value"<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () sessionirequest.getSession()j:[sessionValue="sessionValue"]<br>
     *
     * <br>
     * ҒlF(߂l) Object:null<br>
     *         (ԕω) O:|<br>
     *         (ԕω) O:|<br>
     *
     * <br>
     * propNameL[sessionɒli[ĂȂAnullԋp邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetValueFromSession02() throws Exception {
        // [ZbV
        HttpSession session = new MockHttpSession();
        session.setAttribute("sessionValue", "sessionValue");

        // [NGXg
        MockHttpServletRequest request = new BLogicMapper_MockHttpServletRequest01();
        request.setSession(session);

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BLogicMapper
        BLogicMapper mapper = new BLogicMapper(resource);

        // eXg{E
        assertNull(mapper.getValueFromSession("value", request, response));
    }

    /**
     * testGetValueFromSession03()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() propName:""<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () sessionirequest.getSession()j:not null<br>
     *
     * <br>
     * ҒlF(߂l) Object:|<br>
     *         (ԕω) O:IllegalArgumentException<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "illegal argument:propName = []"<br>
     *
     * <br>
     * propName̒l󕶎̎AO邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetValueFromSession03() throws Exception {
        // [ZbV
        HttpSession session = new MockHttpSession();

        // [NGXg
        MockHttpServletRequest request = new BLogicMapper_MockHttpServletRequest01();
        request.setSession(session);

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BLogicMapper
        BLogicMapper mapper = new BLogicMapper(resource);

        // eXg{E
        try {
            Object result = mapper.getValueFromSession("", request, response);
            fail();
        } catch (IllegalArgumentException e) {
            // eXgʊmF
            assertTrue(LogUTUtil.checkError("illegal argument:propName = []"));
        }
    }

    /**
     * testGetValueFromSession04()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() propName:null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () sessionirequest.getSession()j:not null<br>
     *
     * <br>
     * ҒlF(߂l) Object:|<br>
     *         (ԕω) O:IllegalArgumentException<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "illegal argument:propName = [null]"<br>
     *
     * <br>
     * propName̒lnull̎AO邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetValueFromSession04() throws Exception {
        // [ZbV
        HttpSession session = new MockHttpSession();

        // [NGXg
        MockHttpServletRequest request = new BLogicMapper_MockHttpServletRequest01();
        request.setSession(session);

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BLogicMapper
        BLogicMapper mapper = new BLogicMapper(resource);

        // eXg{E
        try {
            Object result = mapper.getValueFromSession(null, request, response);
            fail();
        } catch (IllegalArgumentException e) {
            // eXgʊmF
            assertTrue(LogUTUtil
                    .checkError("illegal argument:propName = [null]"));
        }
    }

    /**
     * testSetValueToSession01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() value:"value"<br>
     *         () propName:"sessionValue"<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () sessionirequest.getSession()j:[sessionValue="sessionValue"]<br>
     *
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) O:|<br>
     *         (ԕω) O:|<br>
     *         (ԕω) session:[sessionValue="value"]<br>
     *
     * <br>
     * value̒lsessionɔf邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetValueToSession01() throws Exception {
        // [ZbV
        HttpSession session = new MockHttpSession();
        session.setAttribute("sessionValue", "sessionValue");

        // [NGXg
        MockHttpServletRequest request = new BLogicMapper_MockHttpServletRequest01();
        request.setSession(session);

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BLogicMapper
        BLogicMapper mapper = new BLogicMapper(resource);

        // eXg{
        mapper.setValueToSession("value", "sessionValue", request, response);

        // 
        assertEquals("value", session.getAttribute("sessionValue"));
    }

    /**
     * testSetValueToSession02()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() value:"value"<br>
     *         () propName:""<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () sessionirequest.getSession()j:not null<br>
     *
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) O:IllegalArgumentException<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "illegal argument:propName = []"<br>
     *         (ԕω) session:|<br>
     *
     * <br>
     * propName̒l󕶎̎AO邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetValueToSession02() throws Exception {
        // [ZbV
        HttpSession session = new MockHttpSession();

        // [NGXg
        MockHttpServletRequest request = new BLogicMapper_MockHttpServletRequest01();
        request.setSession(session);

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BLogicMapper
        BLogicMapper mapper = new BLogicMapper(resource);

        // eXg{E
        try {
            mapper.setValueToSession("value", "", request, response);
            fail();
        } catch (IllegalArgumentException e) {
            // eXgʊmF
            assertTrue(LogUTUtil.checkError("illegal argument:propName = []"));
        }
    }

    /**
     * testSetValueToSession03()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() value:"value"<br>
     *         () propName:null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () sessionirequest.getSession()j:not null<br>
     *
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) O:IllegalArgumentException<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "illegal argument:propName = [null]"<br>
     *         (ԕω) session:|<br>
     *
     * <br>
     * propName̒lnull̎AO邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetValueToSession03() throws Exception {
        // [ZbV
        HttpSession session = new MockHttpSession();

        // [NGXg
        MockHttpServletRequest request = new BLogicMapper_MockHttpServletRequest01();
        request.setSession(session);

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BLogicMapper
        BLogicMapper mapper = new BLogicMapper(resource);

        // eXg{E
        try {
            mapper.setValueToSession("value", null, request, response);
            fail();
        } catch (IllegalArgumentException e) {
            // eXgʊmF
            assertTrue(LogUTUtil
                    .checkError("illegal argument:propName = [null]"));
        }
    }

    /**
     * testSetValueToSession04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:null<br>
     *         () propName:"sessionValue"<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () sessionirequest.getSession()j:[sessionValue="sessionValue"]<br>
     *
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) O:|<br>
     *         (ԕω) O:|<br>
     *         (ԕω) session:sessionValue폜<br>
     *
     * <br>
     * valuenull̎Asessionɓo^ĂAttribute폜邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetValueToSession04() throws Exception {
        // [ZbV
        HttpSession session = new MockHttpSession();
        session.setAttribute("sessionValue", "sessionValue");

        // [NGXg
        MockHttpServletRequest request = new BLogicMapper_MockHttpServletRequest01();
        request.setSession(session);

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BLogicMapper
        BLogicMapper mapper = new BLogicMapper(resource);

        // eXg{
        mapper.setValueToSession(null, "sessionValue", request, response);

        // 
        assertFalse(session.getAttributeNames().hasMoreElements());
    }

    /**
     * testSetValueToSession05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() value:"value"<br>
     *         () propName:"sessionValue"<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () sessionirequest.getSession()j:sessionValueݒȂ<br>
     *
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) O:|<br>
     *         (ԕω) O:|<br>
     *         (ԕω) session:[sessionValue="value"]<br>
     *
     * <br>
     * value̒lsessionɔf邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetValueToSession05() throws Exception {
        // [ZbV
        HttpSession session = new MockHttpSession();

        // [NGXg
        MockHttpServletRequest request = new BLogicMapper_MockHttpServletRequest01();
        request.setSession(session);

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BLogicMapper
        BLogicMapper mapper = new BLogicMapper(resource);

        // eXg{
        mapper.setValueToSession("value", "sessionValue", request, response);

        // 
        assertEquals("value", session.getAttribute("sessionValue"));
    }

    /**
     * testGetValueFromForm01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() propName:"param1"<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () mapping:not null<br>
     *         () mapping.getScope():"request"<br>
     *         () form:[param1="param1"]<br>
     *
     * <br>
     * ҒlF(߂l) Object:"param1"<br>
     *         (ԕω) O:|<br>
     *         (ԕω) O:|<br>
     *
     * <br>
     * propNameL[formɒli[ĂA擾lԋp邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetValueFromForm01() throws Exception {
        // ANV}bsO
        ActionMapping mapping = new ActionMapping();
        mapping.setScope("request");

        // ANVtH[
        DynaValidatorActionFormEx form = this.formEx;
        form.set("param1", "param1");

        // [NGXg
        HttpServletRequest request = new BLogicMapper_MockHttpServletRequest01();
        request.setAttribute(Globals.MAPPING_KEY, mapping);
        request.setAttribute(mapping.getAttribute(), form);

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BLogicMapper
        BLogicMapper mapper = new BLogicMapper(resource);

        // eXg{E
        assertEquals("param1", mapper.getValueFromForm("param1", request,
                response));
    }

    /**
     * testGetValueFromForm02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() propName:"param2"<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () mapping:not null<br>
     *         () mapping.getScope():"session"<br>
     *         () form:[param2="param2"]<br>
     *
     * <br>
     * ҒlF(߂l) Object:"param2"<br>
     *         (ԕω) O:|<br>
     *         (ԕω) O:|<br>
     *
     * <br>
     * propNameL[formɒli[ĂA擾lԋp邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetValueFromForm02() throws Exception {
        // ANV}bsO
        ActionMapping mapping = new ActionMapping();
        mapping.setScope("session");

        // ANVtH[
        DynaValidatorActionFormEx form = this.formEx;
        form.set("param2", "param2");

        // [ZbV
        HttpSession session = new MockHttpSession();
        session.setAttribute(mapping.getAttribute(), form);

        // [NGXg
        MockHttpServletRequest request = new BLogicMapper_MockHttpServletRequest01();
        request.setAttribute(Globals.MAPPING_KEY, mapping);
        request.setSession(session);

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BLogicMapper
        BLogicMapper mapper = new BLogicMapper(resource);

        // eXg{E
        assertEquals("param2", mapper.getValueFromForm("param2", request,
                response));
    }

    /**
     * testGetValueFromForm03()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() propName:"param0"<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () mapping:not null<br>
     *         () mapping.getScope():"session"<br>
     *         () form:param0̃tB[hȂ<br>
     *
     * <br>
     * ҒlF(߂l) Object:|<br>
     *         (ԕω) O:PropertyAccessException<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "illegal argument:propName = [param0]"<br>
     *
     * <br>
     * propNameŎw肳tB[hformɑ݂ȂAO邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetValueFromForm03() throws Exception {
        // ANV}bsO
        ActionMapping mapping = new ActionMapping();
        mapping.setScope("session");

        // ANVtH[
        FormEx form = this.formEx;

        // [ZbV
        HttpSession session = new MockHttpSession();
        session.setAttribute(mapping.getAttribute(), form);

        // [NGXg
        MockHttpServletRequest request = new BLogicMapper_MockHttpServletRequest01();
        request.setAttribute(Globals.MAPPING_KEY, mapping);
        request.setSession(session);

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BLogicMapper
        BLogicMapper mapper = new BLogicMapper(resource);

        // eXg{E
        try {
            Object result = mapper
                    .getValueFromForm("param0", request, response);
            fail();
        } catch (PropertyAccessException e) {
            // eXgʊmF
            assertTrue(LogUTUtil
                    .checkError("illegal argument:propName = [param0]"));
        }
    }

    /**
     * testGetValueFromForm04()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() propName:""<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () mapping:not null<br>
     *         () mapping.getScope():"request"<br>
     *         () form:not null<br>
     *
     * <br>
     * ҒlF(߂l) Object:|<br>
     *         (ԕω) O:PropertyAccessException<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "illegal argument:propName = []"<br>
     *
     * <br>
     * propName󕶎̎AO邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetValueFromForm04() throws Exception {
        // ANV}bsO
        ActionMapping mapping = new ActionMapping();
        mapping.setScope("request");

        // ANVtH[
        FormEx form = this.formEx;

        // [NGXg
        HttpServletRequest request = new BLogicMapper_MockHttpServletRequest01();
        request.setAttribute(Globals.MAPPING_KEY, mapping);
        request.setAttribute(mapping.getAttribute(), form);

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BLogicMapper
        BLogicMapper mapper = new BLogicMapper(resource);

        // eXg{E
        try {
            Object result = mapper.getValueFromForm("", request, response);
            fail();
        } catch (PropertyAccessException e) {
            // eXgʊmF
            assertTrue(LogUTUtil.checkError("illegal argument:propName = []"));
        }
    }

    /**
     * testGetValueFromForm05()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() propName:null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () mapping:not null<br>
     *         () mapping.getScope():"request"<br>
     *         () form:not null<br>
     *
     * <br>
     * ҒlF(߂l) Object:|<br>
     *         (ԕω) O:PropertyAccessException<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "illegal argument:propName = [null]"<br>
     *
     * <br>
     * propNamenull̎AO邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetValueFromForm05() throws Exception {
        // ANV}bsO
        ActionMapping mapping = new ActionMapping();
        mapping.setScope("request");

        // ANVtH[
        FormEx form = this.formEx;

        // [NGXg
        HttpServletRequest request = new BLogicMapper_MockHttpServletRequest01();
        request.setAttribute(Globals.MAPPING_KEY, mapping);
        request.setAttribute(mapping.getAttribute(), form);

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BLogicMapper
        BLogicMapper mapper = new BLogicMapper(resource);

        // eXg{E
        try {
            Object result = mapper.getValueFromForm(null, request, response);
            fail();
        } catch (PropertyAccessException e) {
            // eXgʊmF
            assertTrue(LogUTUtil
                    .checkError("illegal argument:propName = [null]"));
        }
    }

    /**
     * testGetValueFromForm06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() propName:"param1"<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () mapping:not null<br>
     *         () mapping.getScope():"request"<br>
     *         () form:[param1="param1"]<br>
     *
     * <br>
     * ҒlF(߂l) Object:"java.lang.String"<br>
     *         (ԕω) O:|<br>
     *         (ԕω) O:|<br>
     *
     * <br>
     * propNamelXƂvpeBQƂĂꍇA
     * vpeBl𐳏Ɏ擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetValueFromForm06() throws Exception {
        // ANV}bsO
        ActionMapping mapping = new ActionMapping();
        mapping.setScope("request");
        mapping.setName("testGetValueFromForm06");

        // ANVtH[
        BlogicMapper_ActionFormStub01 form =
        	new BlogicMapper_ActionFormStub01();
        form.setParam1("param1");

        // [NGXg
        HttpServletRequest request =
        	new BLogicMapper_MockHttpServletRequest01();
        request.setAttribute(Globals.MAPPING_KEY, mapping);
        request.setAttribute(mapping.getAttribute(), form);

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BLogicMapper
        BLogicMapper mapper = new BLogicMapper(resource);

        // eXg{E
        assertEquals("java.lang.String",
        		mapper.getValueFromForm("param1.class.name", request,
        		response));
    }

    /**
     * testSetValueToForm01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() value:"value"<br>
     *         () propName:"param1"<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () mapping:not null<br>
     *         () mapping.getScope():"request"<br>
     *         () form:[param1="param1"]<br>
     *                modified=false<br>
     *
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) O:|<br>
     *         (ԕω) form:[param1="value"]<br>
     *                    modified=true<br>
     *
     * <br>
     * value̒lformɔf邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetValueToForm01() throws Exception {
        // ANV}bsO
        ActionMapping mapping = new ActionMapping();
        mapping.setScope("request");

        // ANVtH[
        DynaValidatorActionFormEx form = this.formEx;
        form.set("param1", "param1");
        form.setModified(false);

        // [NGXg
        HttpServletRequest request = new BLogicMapper_MockHttpServletRequest01();
        request.setAttribute(Globals.MAPPING_KEY, mapping);
        request.setAttribute(mapping.getAttribute(), form);

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BLogicMapper
        BLogicMapper mapper = new BLogicMapper(resource);

        // eXg{
        mapper.setValueToForm("value", "param1", request, response);

        // 
        assertEquals("value", form.get("param1"));
        assertTrue(form.isModified());
    }

    /**
     * testSetValueToForm02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() value:"value"<br>
     *         () propName:"param2"<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () mapping:not null<br>
     *         () mapping.getScope():"session"<br>
     *         () form:[param2="param2"]<br>
     *                modified=false<br>
     *
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) O:|<br>
     *         (ԕω) form:[param2="value"]<br>
     *                    modified=true<br>
     *
     * <br>
     * value̒lformɔf邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetValueToForm02() throws Exception {
        // ANV}bsO
        ActionMapping mapping = new ActionMapping();
        mapping.setScope("session");

        // ANVtH[
        DynaValidatorActionFormEx form = this.formEx;
        form.set("param2", "param2");
        form.setModified(false);

        // [ZbV
        HttpSession session = new MockHttpSession();
        session.setAttribute(mapping.getAttribute(), form);

        // [NGXg
        MockHttpServletRequest request = new BLogicMapper_MockHttpServletRequest01();
        request.setAttribute(Globals.MAPPING_KEY, mapping);
        request.setSession(session);

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BLogicMapper
        BLogicMapper mapper = new BLogicMapper(resource);

        // eXg{
        mapper.setValueToForm("value", "param2", request, response);

        // 
        assertEquals("value", form.get("param2"));
        assertTrue(form.isModified());
    }

    /**
     * testSetValueToForm03()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() value:"value"<br>
     *         () propName:"param0"<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () mapping:not null<br>
     *         () mapping.getScope():"request"<br>
     *         () form:param0̃tB[hȂ<br>
     *                modified=false<br>
     *
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) O:PropertyAccessException<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "illegal argument:propName = [param0]"<br>
     *         (ԕω) form:modified=false<br>
     *
     * <br>
     * propNameŎw肳tB[hformɑ݂ȂAO邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetValueToForm03() throws Exception {
        // ANV}bsO
        ActionMapping mapping = new ActionMapping();
        mapping.setScope("request");

        // ANVtH[
        FormEx form = this.formEx;
        form.setModified(false);

        // [NGXg
        HttpServletRequest request = new BLogicMapper_MockHttpServletRequest01();
        request.setAttribute(Globals.MAPPING_KEY, mapping);
        request.setAttribute(mapping.getAttribute(), form);

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BLogicMapper
        BLogicMapper mapper = new BLogicMapper(resource);

        // eXg{E
        try {
            mapper.setValueToForm("value", "param0", request, response);
            fail();
        } catch (PropertyAccessException e) {
            // eXgʊmF
            assertTrue(LogUTUtil
                    .checkError("illegal argument:propName = [param0]"));
            assertFalse(form.isModified());
        }
    }

    /**
     * testSetValueToForm04()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() value:"value"<br>
     *         () propName:""<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () mapping:not null<br>
     *         () mapping.getScope():"request"<br>
     *         () form:not null<br>
     *                modified=false<br>
     *
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) O:PropertyAccessException<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "illegal argument:propName = []"<br>
     *         (ԕω) form:modified=false<br>
     *
     * <br>
     * propName̒l󕶎̎AO邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetValueToForm04() throws Exception {
        // ANV}bsO
        ActionMapping mapping = new ActionMapping();
        mapping.setScope("request");

        // ANVtH[
        FormEx form = this.formEx;
        form.setModified(false);

        // [NGXg
        HttpServletRequest request = new BLogicMapper_MockHttpServletRequest01();
        request.setAttribute(Globals.MAPPING_KEY, mapping);
        request.setAttribute(mapping.getAttribute(), form);

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BLogicMapper
        BLogicMapper mapper = new BLogicMapper(resource);

        // eXg{E
        try {
            mapper.setValueToForm("value", "", request, response);
            fail();
        } catch (PropertyAccessException e) {
            // eXgʊmF
            assertTrue(LogUTUtil
                    .checkError("illegal argument:propName = []"));
            assertFalse(form.isModified());
        }
    }

    /**
     * testSetValueToForm05()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() value:"value"<br>
     *         () propName:null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () mapping:not null<br>
     *         () mapping.getScope():"request"<br>
     *         () form:not null<br>
     *                modified=false<br>
     *
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) O:PropertyAccessException<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "illegal argument:propName = [null]"<br>
     *         (ԕω) form:modified=false<br>
     *
     * <br>
     * propName̒lnull̎AO邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetValueToForm05() throws Exception {
        // ANV}bsO
        ActionMapping mapping = new ActionMapping();
        mapping.setScope("request");

        // ANVtH[
        FormEx form = this.formEx;
        form.setModified(false);

        // [NGXg
        HttpServletRequest request = new BLogicMapper_MockHttpServletRequest01();
        request.setAttribute(Globals.MAPPING_KEY, mapping);
        request.setAttribute(mapping.getAttribute(), form);

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BLogicMapper
        BLogicMapper mapper = new BLogicMapper(resource);

        // eXg{E
        try {
            mapper.setValueToForm("value", null, request, response);
            fail();
        } catch (PropertyAccessException e) {
            // eXgʊmF
            assertTrue(LogUTUtil
                    .checkError("illegal argument:propName = [null]"));
            assertFalse(form.isModified());
        }
    }

    /**
     * testSetValueToForm06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() value:"value"<br>
     *         () propName:"param3.value"<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () mapping:not null<br>
     *         () mapping.getScope():"request"<br>
     *         () form:[param3=HashMap]<br>
     *                ActionFormNX<br>
     *
     * <br>
     * ҒlF(߂l) void:|<br>
     *         (ԕω) O:|<br>
     *         (ԕω) form:[param3=HashMap{ value="value"}]<br>
     *
     * <br>
     * propNameɃlXgvpeBw肳ꂽꍇA
     * ɒlݒ肳邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetValueToForm06() throws Exception {
        // ANV}bsO
        ActionMapping mapping = new ActionMapping();
        mapping.setScope("request");
        Map map = new HashMap();

        // ANVtH[
        BlogicMapper_ActionFormStub01 form =
        	new BlogicMapper_ActionFormStub01();
        form.setParam3(map);

        // [NGXg
        HttpServletRequest request = new BLogicMapper_MockHttpServletRequest01();
        request.setAttribute(Globals.MAPPING_KEY, mapping);
        request.setAttribute(mapping.getAttribute(), form);

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BLogicMapper
        BLogicMapper mapper = new BLogicMapper(resource);

        // eXg{
        mapper.setValueToForm("value", "param3.value", request, response);

        // 
        Map result = form.getParam3();
        assertEquals("value", result.get("value"));
    }

    /**
     * testGetValueFromApplication01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() propName:"sessionValue"<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () servletContext:[applicationValue="applicationValue"]<br>
     *
     * <br>
     * ҒlF(߂l) Object:"applicationValue"<br>
     *         (ԕω) O:|<br>
     *         (ԕω) O:|<br>
     *
     * <br>
     * propNameL[ɃT[ubgReLXgɒli[ĂA
     * 擾lԋp邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetValueFromApplication01() throws Exception {
        // [ZbV
        HttpSession session = new MockHttpSession();
        ServletContext context = session.getServletContext();
        context.setAttribute("applicationValue", "applicationValue");

        // [NGXg
        MockHttpServletRequest request = new BLogicMapper_MockHttpServletRequest01();
        request.setSession(session);

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BLogicMapper
        BLogicMapper mapper = new BLogicMapper(resource);

        // eXg{E
        assertEquals("applicationValue",
            mapper.getValueFromApplication("applicationValue", request, response));
    }

    /**
     * testGetValueFromApplication02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() propName:"value"<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () servletContext:[applicationValue="applicationValue"]<br>
     *
     * <br>
     * ҒlF(߂l) Object:null<br>
     *         (ԕω) O:|<br>
     *         (ԕω) O:|<br>
     *
     * <br>
     * propNameL[ɃT[ubgReLXgɒli[ĂȂA
     * nullԋp邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetValueFromApplication02() throws Exception {
        // [ZbV
        HttpSession session = new MockHttpSession();
        ServletContext context = session.getServletContext();
        context.setAttribute("applicationValue", "applicationValue");

        // [NGXg
        MockHttpServletRequest request = new BLogicMapper_MockHttpServletRequest01();
        request.setSession(session);

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BLogicMapper
        BLogicMapper mapper = new BLogicMapper(resource);

        // eXg{E
        assertNull(mapper.getValueFromApplication("value", request, response));
    }

    /**
     * testGetValueFromApplication03()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() propName:""<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () servletContext:not null<br>
     *
     * <br>
     * ҒlF(߂l) Object:|<br>
     *         (ԕω) O:IllegalArgumentException<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "illegal argument:propName = []"<br>
     *
     * <br>
     * propName̒l󕶎̎AO邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetValueFromApplication03() throws Exception {
        // [ZbV
        HttpSession session = new MockHttpSession();

        // [NGXg
        MockHttpServletRequest request = new BLogicMapper_MockHttpServletRequest01();
        request.setSession(session);

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BLogicMapper
        BLogicMapper mapper = new BLogicMapper(resource);

        // eXg{E
        try {
            Object result = mapper.getValueFromApplication("", request, response);
            fail();
        } catch (IllegalArgumentException e) {
            // eXgʊmF
            assertTrue(LogUTUtil.checkError("illegal argument:propName = []"));
        }
    }

    /**
     * testGetValueFromApplication04()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FCG
     * <br><br>
     * ͒lF() propName:null<br>
     *         () request:not null<br>
     *         () response:not null<br>
     *         () servletContext:not null<br>
     *
     * <br>
     * ҒlF(߂l) Object:|<br>
     *         (ԕω) O:IllegalArgumentException<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "illegal argument:propName = [null]"<br>
     *
     * <br>
     * propName̒lnull̎AO邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetValueFromApplication04() throws Exception {
        // [ZbV
        HttpSession session = new MockHttpSession();

        // [NGXg
        MockHttpServletRequest request = new BLogicMapper_MockHttpServletRequest01();
        request.setSession(session);

        // [X|X
        HttpServletResponse response = new MockHttpServletResponse();

        // BLogicMapper
        BLogicMapper mapper = new BLogicMapper(resource);

        // eXg{E
        try {
            Object result = mapper.getValueFromApplication(null, request, response);
            fail();
        } catch (IllegalArgumentException e) {
            // eXgʊmF
            assertTrue(LogUTUtil
                    .checkError("illegal argument:propName = [null]"));
        }
    }

}
