/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.springmvc.controller;

import jp.terasoluna.fw.service.rich.BLogic;
import jp.terasoluna.fw.web.rich.context.support.DefaultRequestContextSupportImpl;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.UTUtil;
import jp.terasoluna.fw.web.rich.springmvc.bind.creator.XMLServletRequestDataBinderCreator;
import jp.terasoluna.fw.web.rich.springmvc.controller.BLogicController;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.rich.springmvc.controller.BLogicController} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * BLogicC^tF[XNXspNGXgRg[B<br>
 * OFblogicnullɂȂȂ
 * <p>
 * 
 * @see jp.terasoluna.fw.web.rich.springmvc.controller.BLogicController
 */
public class BLogicControllerTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(BLogicControllerTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public BLogicControllerTest(String name) {
        super(name);
    }

    /**
     * testSetBlogic01()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() blogic:BlogicNX<br>
     *         () this.blogic:null<br>
     *         
     * <br>
     * ҒlF(ԕω) this.blogic:Ŏw肵blogic<br>
     *         
     * <br>
     * blogicSetter\bh̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetBlogic01() throws Exception {
        // O 
        BLogicController controller = new BLogicController();
        BLogic<Object, Object> blogic = new BLogicController_BLogicImplStub01();
        UTUtil.setPrivateField(controller, "blogic", null);
        
        // eXg{ 
        controller.setBlogic(blogic);

        //  
        assertSame(blogic, UTUtil.getPrivateField(controller, "blogic"));
    }

    /**
     * testAfterPropertiesSet01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() this.dataBinderCreator:null<br>
     *         () this.ctxSupport:null<br>
     *         () this.blogic:null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalStateException("DataBinderCreator is Null.")<br>
     *         (ԕω) O:OxFG[DataBinderCreator is Null.<br>
     *         
     * <br>
     * eNX̃\bhĂ΂Ă邩mFeXgB
     * f[^oC_NXݒ肳ĂȂߗO𔭐B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAfterPropertiesSet01() throws Exception {
        // O 
        BLogicController controller = new BLogicController();
        UTUtil.setPrivateField(controller, "dataBinderCreator", null);
        UTUtil.setPrivateField(controller, "ctxSupport", null);
        UTUtil.setPrivateField(controller, "blogic", null);
        
        // eXg{
        try {
            controller.afterPropertiesSet();
            fail();
        } catch (IllegalStateException e) {
            // OK
            String expect = "DataBinderCreator is Null.";
            assertEquals(expect, e.getMessage());
            LogUTUtil.checkError(expect);
        }
    }

    /**
     * testAfterPropertiesSet02()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() this.dataBinderCreator:not null<br>
     *         () this.ctxSupport:not null<br>
     *         () this.blogic:null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalStateException<br>
     *                    ihCannot create BLogicController without blogic(BLogic) being set. 
     *                    Check Bean definition file."j<br>
     *         (ԕω) O:OxFG[<br>
     *                    Cannot create BLogicController without blogic(BLogic) being set. 
     *                    Check Bean definition file.<br>
     *         
     * <br>
     * CX^XDIReiĂ΂郁\bhB
     * blogicNullł邽߁AOp^[B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAfterPropertiesSet02() throws Exception {
        // O 
        BLogicController controller = new BLogicController();
        UTUtil.setPrivateField(controller, "dataBinderCreator", 
                new XMLServletRequestDataBinderCreator());
        UTUtil.setPrivateField(controller, "ctxSupport", 
                new DefaultRequestContextSupportImpl());
        UTUtil.setPrivateField(controller, "blogic", null);
        
        // eXg{
        try {
            controller.afterPropertiesSet();
            fail();
        } catch (IllegalStateException e) {
            // OK
            String expect = "Cannot create BLogicController without blogic(BLogic) being set. "
                + "Check Bean definition file.";
            assertEquals(expect, e.getMessage());
            LogUTUtil.checkError(expect);
        }
    }

    /**
     * testAfterPropertiesSet03()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() this.dataBinderCreator:not null<br>
     *         () this.ctxSupport:not null<br>
     *         () this.blogic:not null<br>
     *         
     * <br>
     * ҒlF
     * <br>
     * CX^XDIReiĂ΂郁\bhB
     * ɑݒ肳Ă邽߁AȂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAfterPropertiesSet03() throws Exception {
        // O 
        BLogicController controller = new BLogicController();
        UTUtil.setPrivateField(controller, "dataBinderCreator", 
                new XMLServletRequestDataBinderCreator());
        UTUtil.setPrivateField(controller, "ctxSupport", 
                new DefaultRequestContextSupportImpl());
        UTUtil.setPrivateField(controller, "blogic", 
                new BLogicController_BLogicImplStub01());
        
        // eXg{
        controller.afterPropertiesSet();
        
        // OK
    }

    /**
     * testGetCommandType01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() this.blogic:BlogicImp implements Blogic<Integer, Long><br>
     *         
     * <br>
     * ҒlF(߂l) Type:Integer<br>
     *         
     * <br>
     * Blogic^p[^`Ă鐳P[XB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
//    BLogicControllergߍ폜
//    public void testGetCommandType01() throws Exception {
//        // O 
//        BLogicController controller = new BLogicController();
//        BLogic<Integer, Long> blogic = new BLogicController_BLogicImplStub02();
//        UTUtil.setPrivateField(controller, "blogic", blogic);
//        
//        // eXg{ 
//        Type result = controller.getCommandType();
//
//        //  
//        assertSame(Integer.class, result);
//    }

    /**
     * testGetCommandType02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() this.blogic:ProxyCX^X<br>
     *                EbvĂBlogic<br>
     *                BlogicImp implements Blogic<Integer, Long><br>
     *         
     * <br>
     * ҒlF(߂l) Type:Integer<br>
     *         
     * <br>
     * vLVBlogicbvĂp^[̃eXgB
     * bvĂBlogic̃p[^擾B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
//  BLogicControllergߍ폜
//    public void testGetCommandType02() throws Exception {
//        // O 
//        BLogicController controller = new BLogicController();
//        ProxyFactory pf = new ProxyFactory(new BLogicController_BLogicImplStub02());
//        BLogic blogic = (BLogic) pf.getProxy();
//        UTUtil.setPrivateField(controller, "blogic", blogic);
        
        // eXg{ 
//        Type result = controller.getCommandType();

        //  
//        assertSame(Integer.class, result);
//    }

    /**
     * testGetCommandType03()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() this.blogic:BlogicImp implements Blogic<Integer, Long> , <br>
     *                Iterator<Float>,<br>
     *                List<br>
     *         
     * <br>
     * ҒlF(߂l) Type:Integer<br>
     *         
     * <br>
     * BlogicR̃C^tF[XĂp^[B
     * ^p[^`ĂC^tF[XB
     * Blogič^p[^ԂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
//    public void testGetCommandType03() throws Exception {
    
    // FWPɂ폜
    //  R}h^̎擾@A^p[^ł͂ȂA
    //  execute\bh̃p[^Ŏ擾悤ύX߁A폜
    
    
//        // O 
//        BLogicController controller = new BLogicController();
//        BLogic<Integer, Long> blogic = new BLogicController_BLogicImplStub03();
//        UTUtil.setPrivateField(controller, "blogic", blogic);
//        
//        // eXg{ 
//        Type result = controller.getCommandType();
//
//        //  
//        assertSame(Integer.class, result);
//    }

    /**
     * testGetCommandType04()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() this.blogic:BlogicImp implements Blogic<br>
     *                (^p[^wȂj<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalStateException<br>
     *                    ("Cannot get BLogic<P, R> parameter P.")<br>
     *         (ԕω) O:Ox:G[<br>
     *                    Cannot get BLogic<P, R> parameter P.<br>
     *         
     * <br>
     * Blogic^p[^`ĂȂp^[BOX[B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
//  BLogicControllergߍ폜
//    public void testGetCommandType04() throws Exception {
//        // O 
//        BLogicController controller = new BLogicController();
//        BLogic blogic = new BLogicController_BLogicImplStub04();
//        UTUtil.setPrivateField(controller, "blogic", blogic);
//        
//        // eXg{ 
//        try {
//            controller.getCommandType();
//            fail();
//        } catch (IllegalStateException e) {
//            // OK
//            String expect = "Cannot get Command type. "
//                + "execute(P) method argument P must not use Object class.";
//            assertEquals(expect, e.getMessage());
//            assertTrue(LogUTUtil.checkError(expect));
//        }
//    }
    
    /**
     * testGetCommandType05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() this.blogic:EۃNXpBlogic<br>
     *                public class BLogicController_BLogicImplStub06<br>
     *                    extends BLogicController_BLogicImplStub05<Integer, Long><br>
     *                public abstract class BLogicController_BLogicImplStub05<P, R><br>
     *                    extends AbstractBLogic<P, R><br>
     *         
     * <br>
     * ҒlF(߂l) Type:Integer<br>
     *         
     * <br>
     * BlogicۃNXpĂp^[B^p[^擾B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
//  BLogicControllergߍ폜
//    public void testGetCommandType05() throws Exception {
//        // O 
//        BLogicController controller = new BLogicController();
//        BLogic<Integer, Long> blogic = new BLogicController_BLogicImplStub06();
//        UTUtil.setPrivateField(controller, "blogic", blogic);
//        
//        // eXg{ 
//        Type result = controller.getCommandType();
//
//        //  
//        assertSame(Integer.class, result);
//    }

    /**
     * testGetCommandType06()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() this.blogic:execute\bhI[o[[hĂBlogic<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalStateException<br>
     *                    ("Cannot get Command type. BLogic class cannot be overload execute(P) method.")<br>
     *         (ԕω) O:Ox:G[<br>
     *                    Cannot get Command type. BLogic class cannot be overload execute(P) method.<br>
     *         
     * <br>
     * Blogicexecute\bhI[o[[hĂp^[BOX[B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
//  BLogicControllergߍ폜
//    public void testGetCommandType06() throws Exception {
//        // O 
//        BLogicController controller = new BLogicController();
//        BLogic blogic = new BLogicController_BLogicImplStub07();
//        UTUtil.setPrivateField(controller, "blogic", blogic);
//        
//        // eXg{ 
//        try {
//            controller.getCommandType();
//            fail();
//        } catch (IllegalStateException e) {
//            // OK
//            String expect = "Cannot get Command type. "
//                + "BLogic class cannot be overload execute(P) method.";
//            assertEquals(expect, e.getMessage());
//            assertTrue(LogUTUtil.checkError(expect));
//        }
//    }

    /**
     * testExecuteService01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() command:not null<br>
     *         () this.blogic:not null<br>
     *         
     * <br>
     * ҒlF(߂l) Object:blogic.execute()̖߂lƓƂmFB<br>
     *         (ԕω) blogic.execute():\bhĂяoꂽƂmFB<br>
     *                    󂯎ƂmFB<br>
     *         
     * <br>
     * T[rXWbN̐neXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExecuteService01() throws Exception {
        // O 
        BLogicController controller = new BLogicController();
        BLogic<Object, Object> blogic = new BLogicController_BLogicImplStub01();
        UTUtil.setPrivateField(controller, "blogic", blogic);
        Object command = new Object();
        
        // eXg{ 
        Object result = controller.executeService(command);

        //  
        assertSame(command, result);
        assertSame(command, UTUtil.getPrivateField(blogic, "command"));
    }
    
    /**
     * testSetBusinessLogic01()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() blogic:BlogicNX<br>
     *         () this.blogic:null<br>
     *         
     * <br>
     * ҒlF(ԕω) this.blogic:Ŏw肵blogic<br>
     *         
     * <br>
     * blogicSetter\bh̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetBusinessLogic01() throws Exception {

        // O 
        BLogicController controller = new BLogicController();
        BLogic<Object, Object> blogic = new BLogicController_BLogicImplStub01();
        UTUtil.setPrivateField(controller, "blogic", null);

        // eXg{ 
        controller.setBusinessLogic(blogic);

        //  
        assertSame(blogic, UTUtil.getPrivateField(controller, "blogic"));
    }


}
