/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.service.rich.exception;

import jp.terasoluna.utlib.UTUtil;
import jp.terasoluna.fw.service.rich.exception.ServiceException;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.service.rich.exception.ServiceException}
 * NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * T[rXw̃NXŐVKO킷NXB
 * <p>
 * 
 * @see jp.terasoluna.fw.service.rich.exception.ServiceException
 */
public class ServiceExceptionTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(ServiceExceptionTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public ServiceExceptionTest(String name) {
        super(name);
    }

    /**
     * testServiceException01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC, D
     * <br><br>
     * ͒lF() errorCode:"AAA"<br>
     *         () options:{"AAA", "BBB","CCC"}<br>
     *         
     * <br>
     * ҒlF(ԕω) errorCode:"AAA"<br>
     *         (ԕω) options:{"AAA", "BBB","CCC"}<br>
     *         
     * <br>
     * ̒l𐳏ɑɐݒ肷邱ƁB(G[R[hnot null)
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testServiceException01() throws Exception {
        // O
        // errorCode : "AAA"
        String errorCode = "AAA";
        // options : {"AAA", "BBB", "CCC"}
        String[] options = {"AAA", "BBB", "CCC"};

        // eXg{
        ServiceException e = new ServiceException(errorCode, options);

        // 
        // errorCode
        assertEquals(errorCode, UTUtil.getPrivateField(e, "errorCode"));
        
        // options
        String[] getOptions = (String[]) UTUtil.getPrivateField(e, "options");
        for(int i=0; i<options.length; i++) {
            assertEquals(options[i], getOptions[i]);
        }
        assertEquals(3, getOptions.length);
        
        // optionsCX^X`FbN
        // ȉ͂̔͏ȗ
        assertSame(options, getOptions);
    }

    /**
     * testServiceException02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC, D
     * <br><br>
     * ͒lF() errorCode:""<br>
     *         () options:{"AAA", "BBB","CCC"}<br>
     *         
     * <br>
     * ҒlF(ԕω) errorCode:""<br>
     *         (ԕω) options:{"AAA", "BBB","CCC"}<br>
     *         
     * <br>
     * ̒l𐳏ɑɐݒ肷邱ƁB(G[R[h󕶎)
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testServiceException02() throws Exception {
        // O
        // errorCode : ""
        String errorCode = "";
        // options : {"AAA", "BBB", "CCC"}
        String[] options = {"AAA", "BBB", "CCC"};

        // eXg{
        ServiceException e = new ServiceException(errorCode, options);

        // 
        // errorCode
        assertEquals(errorCode, UTUtil.getPrivateField(e, "errorCode"));
        
        // options
        String[] getOptions = (String[]) UTUtil.getPrivateField(e, "options");
        for(int i=0; i<options.length; i++) {
            assertEquals(options[i], getOptions[i]);
        }
        assertEquals(3, getOptions.length);
    }

    /**
     * testServiceException03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC, D
     * <br><br>
     * ͒lF() errorCode:null<br>
     *         () options:{"AAA", "BBB","CCC"}<br>
     *         
     * <br>
     * ҒlF(ԕω) errorCode:null<br>
     *         (ԕω) options:{"AAA", "BBB","CCC"}<br>
     *         
     * <br>
     * ̒l𐳏ɑɐݒ肷邱ƁB(G[R[h null)
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testServiceException03() throws Exception {
        // O
        // errorCode : null
        String errorCode = null;
        // options : {"AAA", "BBB", "CCC"}
        String[] options = {"AAA", "BBB", "CCC"};

        // eXg{
        ServiceException e = new ServiceException(errorCode, options);

        // 
        // errorCode
        assertNull(UTUtil.getPrivateField(e, "errorCode"));
        
        // options
        String[] getOptions = (String[]) UTUtil.getPrivateField(e, "options");
        for(int i=0; i<options.length; i++) {
            assertEquals(options[i], getOptions[i]);
        }
        assertEquals(3, getOptions.length);
    }

    /**
     * testServiceException04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC, D
     * <br><br>
     * ͒lF() errorCode:"AAA"<br>
     *         () options:{"AAA"}<br>
     *         
     * <br>
     * ҒlF(ԕω) errorCode:"AAA"<br>
     *         (ԕω) options:{"AAA"}<br>
     *         
     * <br>
     * ̒l𐳏ɑɐݒ肷邱ƁB(options not null)
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testServiceException04() throws Exception {
        // O
        // errorCode : "AAA"
        String errorCode = "AAA";
        // options : {"AAA"}
        String[] options = {"AAA"};

        // eXg{
        ServiceException e = new ServiceException(errorCode, options);

        // 
        // errorCode
        assertEquals(errorCode, UTUtil.getPrivateField(e, "errorCode"));
        
        // options
        String[] getOptions = (String[]) UTUtil.getPrivateField(e, "options");
        for(int i=0; i<options.length; i++) {
            assertEquals(options[i], getOptions[i]);
        }
        assertEquals(1, getOptions.length);
    }

    /**
     * testServiceException05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC, D
     * <br><br>
     * ͒lF() errorCode:"AAA"<br>
     *         () options:{}<br>
     *         
     * <br>
     * ҒlF(ԕω) errorCode:"AAA"<br>
     *         (ԕω) options:{}<br>
     *         
     * <br>
     * ̒l𐳏ɑɐݒ肷邱ƁB(options 󕶎)
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testServiceException05() throws Exception {
        // O
        // errorCode : "AAA"
        String errorCode = "AAA";
        // options : {}
        String[] options = {};

        // eXg{
        ServiceException e = new ServiceException(errorCode, options);

        // 
        // errorCode
        assertEquals(errorCode, UTUtil.getPrivateField(e, "errorCode"));
        
        // options
        String[] getOptions = (String[]) UTUtil.getPrivateField(e, "options");
        assertEquals(0, getOptions.length);
    }

    /**
     * testServiceException06()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC, D
     * <br><br>
     * ͒lF() errorCode:"AAA"<br>
     *         () options:null<br>
     *         
     * <br>
     * ҒlF(ԕω) errorCode:"AAA"<br>
     *         (ԕω) options:null<br>
     *         
     * <br>
     * ̒l𐳏ɑɐݒ肷邱ƁB(options  null)
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testServiceException06() throws Exception {
        // O
        // errorCode : "AAA"
        String errorCode = "AAA";
        // options : null
        String[] options = null;

        // eXg{
        ServiceException e = new ServiceException(errorCode, options);

        // 
        // errorCode
        assertEquals(errorCode, UTUtil.getPrivateField(e, "errorCode"));
        
        // options
        String[] getOptions = (String[]) UTUtil.getPrivateField(e, "options");
        assertNull(getOptions);
    }

    /**
     * testServiceException07()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC, D
     * <br><br>
     * ͒lF() errorCode:"AAA"<br>
     *         () options:w肵Ȃ<br>
     *         
     * <br>
     * ҒlF(ԕω) errorCode:"AAA"<br>
     *         (ԕω) options:{}<br>
     *         
     * <br>
     * ̒l𐳏ɑɐݒ肷邱ƁB(optionsw肵Ȃ)
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testServiceException07() throws Exception {
        // O
        // errorCode : "AAA"
        String errorCode = "AAA";

        // eXg{
        ServiceException e = new ServiceException(errorCode);

        // 
        // errorCode
        assertEquals(errorCode, UTUtil.getPrivateField(e, "errorCode"));
        
        // options
        String[] getOptions = (String[]) UTUtil.getPrivateField(e, "options");
        assertEquals(0, getOptions.length);
    }

    /**
     * testGetErrorCode01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() Ȃ:|<br>
     *         () errorCode:"AAA"<br>
     *         
     * <br>
     * ҒlF(߂l) errorCode:"AAA"<br>
     *         
     * <br>
     * ɐݒ肳Ăl𐳏Ɏ擾邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetErrorCode01() throws Exception {
        // O
        // errorCode : "AAA"
        String errorCode = "AAA";
        
        ServiceException e = new ServiceException(errorCode);

        // eXg{
        String getErrorCode = e.getErrorCode();

        // 
        assertEquals(errorCode, getErrorCode);
    }

    /**
     * testGetOptions01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() Ȃ:|<br>
     *         () options:["aaa", "bbb"]<br>
     *         
     * <br>
     * ҒlF(߂l) options:Ɠ̃CX^X<br>
     *         
     * <br>
     * ɐݒ肳Ăl𐳏Ɏ擾邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetOptions01() throws Exception {
        // O
        // errorCode : "AAA"
        String errorCode = "AAA";
        // options : {"aaa", "bbb"}
        String[] options = {"aaa", "bbb"};
        
        ServiceException e = new ServiceException(errorCode, options);

        // eXg{
        String[] getOptions = e.getOptions();

        // 
        assertSame(options, getOptions);
    }

}
