/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.utlib;

import java.io.BufferedReader;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;

import com.mockrunner.mock.web.MockHttpServletRequest;
import com.mockrunner.mock.web.WebMockObjectFactory;
import com.mockrunner.tag.TagTestModule;

/**
 *  JUnitł̃JX^^ONX̃eXgT|[g郆[eBeBNXB
 * 
 * @version 2004.01.16
 *
 */
public class TagUTUtil {

    /**
     * TagSupportTagTestModule̊֌Wێ}bvB
     * {UtilNXstaticȃCX^X̂̓XbhZ[tłȂ
     * ߂悭ȂAJUnit̃eXg͒ʏ}`XbhŎsȂ
     * ߁Â悤ɂĂB
     */
    private static Map<Object, Object> testModuleMap
        = new HashMap<Object, Object>();

    /**
     * eXgΏۂ̃JX^^ÕCX^X𐶐B
     * <BR><BR>
     * JX^^ONX́AnewłȂƂ肪B
     * 邽߂̂̃\bhpӂĂB̃\bhŐꂽNX
     * ́AbNAbvPageContextێĂB
     * <BR><BR>
     * 
     * <PRE>
     * [gp]
     * SampleTag tag = (SampleTag) TagUTUtil.create(SampleTag.class);
     * tag.doStartTag();
     * </PRE>
     * 
     * @param c JX^^ONXClassIuWFNgB
     * @return ꂽJX^^ONX̃CX^XB
     */
    public static TagSupport create(Class c) {
        // Mockrunner̃^OeXgpT|[gNXTagTestModule𐶐
        WebMockObjectFactory factory = new WebMockObjectFactory();
        TagTestModule testModule = new TagTestModule(factory);
        
        // eXgΏۂTagSupportNXTagTestModuleCX^X
        // BƁAPageContext܂߂ăCX^XĂB
        TagSupport tag = testModule.createTag(c);
        
        // TagSupportTagTestModuleƊ֌WLbVĂB
        testModuleMap.put(tag, testModule);
        
        // TagSupportԂB
        return tag;        
    }
    
    /**
     * JX^^ÕCX^XɊ֘AtĂPageContext擾B
     * <BR><BR>
     * RequestSessionɑlݒ肵ĂKvꍇɗpB
     * <PRE>
     * [gp]
     * //JX^^O̐ 
     * SampleTag tag = (SampleTag) TagUTUtil.create(SampleTag.class);
     * 
     * // JavaBean̐ 
     * DataBean bean = new DataBean();
     * bean.setValue("Hello");
     * 
     * // JX^^OQƂ邽߂ɃZbVBeanǉ 
     * PageContext pc = TagUTUtil.getPageContext(tag);
     * pc.setAttribute("data", bean, PageContext.SESSION_SCOPE);
     * 
     * // eXgs
     * int result = tag.doStartTag();
     * assertEquals(Tag.SKIP_BODY, result); 
     * </PRE>
     * 
     * @param tag JX^^ÕCX^XB
     * @return tagɊ֘AtĂPageContextB
     */
    public static PageContext getPageContext(TagSupport tag) {
        // tagɊ֘AtĂTagTestModule擾B
        TagTestModule testModule = getRelatedTestModule(tag);

        // tagɊ֘AtĂPageContextԂB
        return testModule.getMockPageContext();
    }
    
    /**
     * JX^^Ǒ݂JspWriteȑo͂BufferedReaderƂĕԂB
     * <BR><BR>
     * ^OۂJSPo͂̒gmFۂɗpB
     * <PRE>
     * [gp]
     * //JX^^O̐ 
     * SampleTag tag = (SampleTag) TagUTUtil.create(SampleTag.class);
     * 
     * // eXgs
     * int result = tag.doStartTag();
     * assertEquals(Tag.SKIP_BODY, result); 
     * 
     * // o͂̊mF
     * BufferedReader reader = TagUTUtil.getOutputReader(tag);
     * String output = reader.readLine();
     * assertEquals("Hello", output);
     * </PRE>
     * 
     * @param tag JX^^ÕCX^XB
     * @return tagJspWriteȑo͂ǂނ߂BufferedReaderB
     */
    public static BufferedReader getOutputReader(TagSupport tag) {
        // tagɊ֘AtĂTagTestModule擾B
        TagTestModule testModule = getRelatedTestModule(tag);

        // taǧ݂JspWriteȑo͂BufferedReaderƂĕԂB
        return testModule.getOutputAsBufferedReader();
    }

    /**
     * JX^^Ǒ݂JspWriteȑo͂StringƂĕԂB
     * <BR><BR>
     * ^OۂJSPo͂̒gmFۂɗpB
     * <PRE>
     * [gp]
     * //JX^^O̐ 
     * SampleTag tag = (SampleTag) TagUTUtil.create(SampleTag.class);
     * 
     * // eXgs
     * int result = tag.doStartTag();
     * assertEquals(Tag.SKIP_BODY, result); 
     * 
     * // o͂̊mF
     * String output = TagUTUtil.getOutputString(tag);
     * assertEquals("Hello", output.trim());
     * </PRE>
     * 
     * @param tag JX^^ÕCX^XB
     * @return tagJspWriteȑo͂StrinǵB
     */
    public static String getOutputString(TagSupport tag) {
        // tagɊ֘AtĂTagTestModule擾B
        TagTestModule testModule = getRelatedTestModule(tag);

        // taǧ݂JspWriteȑo͂StringƂĕԂB
        return testModule.getOutput();
    }
    
    
	/**
	 * JX^^OHttpServletRequestContextPathݒ肷B
	 * <BR><BR>
	 * 
	 * <PRE>
	 * [gp]
     * //JX^^O̐ 
     * SampleTag tag = (SampleTag) TagUTUtil.create(SampleTag.class);
	 * 
     * //ContextPath̐ݒ
     * TagUTUtil.setContextPath(tag,contextPath);
     * 
     * // eXgs
	 * int result = tag.doStartTag();
	 * 
	 * //ʂ̊mF
	 * assertEquals(Tag.SKIP_BODY, result); 
	 * </PRE>
	 * 
	 * @param tag JX^^ÕCX^XB
	 * @param contextPath ContextPathɐݒ肷
	 */
	public static void setContextPath(TagSupport tag, String contextPath) {
		// tagɊ֘AtĂContextPath擾B
		PageContext pageContext = getPageContext(tag);

        //PageContextRequest擾B
		MockHttpServletRequest req =
		  (MockHttpServletRequest)pageContext.getRequest();
        
        //RequestContextPathݒ肷
        req.setContextPath(contextPath);
	}

	/**
	 * JX^^OHttpServletRequestParameterݒ肷B
	 * <BR><BR>
	 * 
	 * <PRE>
	 * [gp]
	 * //JX^^O̐ 
	 * SampleTag tag = (SampleTag) TagUTUtil.create(SampleTag.class);
	 * 
	 * //Parameter̐ݒ
	 * TagUTUtil.setParameter(tag,key,values);
	 * 
	 * // eXgs
	 * int result = tag.doStartTag();
	 * 
	 * //ʂ̊mF
	 * assertEquals(Tag.SKIP_BODY, result); 
	 * </PRE>
	 * 
	 * @param tag JX^^ÕCX^XB
	 * @param key Parameter̃L[
	 * @param values Parameter̃L[ɑ΂lizł͂Ȃj
	 */
	public static void setParameter(TagSupport tag, String key, String values) {
		// tagɊ֘AtĂContextPath擾B
		PageContext pageContext = getPageContext(tag);

		//PageContextRequest擾B
		MockHttpServletRequest req =
		  (MockHttpServletRequest)pageContext.getRequest();
        
		//RequestParameterݒ肷
		req.setupAddParameter(key,values);
	}

	/**
	 * JX^^OHttpServletRequestParameterݒ肷B
	 * <BR><BR>
	 * 
	 * <PRE>
	 * [gp]
	 * //JX^^O̐ 
	 * SampleTag tag = (SampleTag) TagUTUtil.create(SampleTag.class);
	 * 
	 * //Parameter̐ݒ
	 * TagUTUtil.setParameter(tag,key,values);
	 * 
	 * // eXgs
	 * int result = tag.doStartTag();
	 * 
	 * //ʂ̊mF
	 * assertEquals(Tag.SKIP_BODY, result); 
	 * </PRE>
	 * 
	 * @param tag JX^^ÕCX^XB
	 * @param key Parameter̃L[
	 * @param values Parameter̃L[ɑ΂lizj
	 */
	public static void setParameter(TagSupport tag, String key, String[] values) {

		// tagɊ֘AtĂContextPath擾B
		PageContext pageContext = getPageContext(tag);

		//PageContextRequest擾B
		MockHttpServletRequest req =
		  (MockHttpServletRequest)pageContext.getRequest();
        
		//RequestParameterݒ肷
		req.setupAddParameter(key,values);
	}

	/**
	 * JX^^OHttpServletRequestMethodݒ肷B
	 * <BR><BR>
	 * 
	 * <PRE>
	 * [gp]
	 * //JX^^O̐ 
	 * SampleTag tag = (SampleTag) TagUTUtil.create(SampleTag.class);
	 * 
	 * //ContextPath̐ݒ
	 * TagUTUtil.setMethod(tag,method);
	 * 
	 * // eXgs
	 * int result = tag.doStartTag();
	 * 
	 * //ʂ̊mF
	 * assertEquals(Tag.SKIP_BODY, result); 
	 * </PRE>
	 * 
	 * @param tag JX^^ÕCX^XB
	 * @param method Methodɐݒ肷
	 */
	public static void setMethod(TagSupport tag, String method) {
		// tagɊ֘AtĂContextPath擾B
		PageContext pageContext = getPageContext(tag);

		//PageContextRequest擾B
		MockHttpServletRequest req =
		  (MockHttpServletRequest)pageContext.getRequest();
        
		//Requestmethodݒ肷
		req.setMethod(method);
	}
        
    /**
     * JX^^OɊ֘AtꂽTagTestModuleԋpB
     * 
     * @param tag JX^^ÕCX^XB
     * @return tagɊ֘AtĂTagTestModuleB
     */
    private static TagTestModule getRelatedTestModule(TagSupport tag) {
        // ֘AtĂTestModuleȂΗO𓊂B
        if (!testModuleMap.containsKey(tag)) {
            throw new IllegalArgumentException("sȃp[^łB");
        }
        
        // ֘AtĂTagTestModuleԂB
        return (TagTestModule) testModuleMap.get(tag);
    }

    /**
     * privateȃRXgN^B
     */
    private TagUTUtil() {
    }

}
