/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.standard;

import jp.terasoluna.fw.batch.core.AbstractCollector;
import jp.terasoluna.fw.batch.core.CollectedDataHandler;
import jp.terasoluna.fw.batch.core.CollectorResult;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.openapi.JobContext;
import jp.terasoluna.fw.batch.openapi.ReturnCode;
import jp.terasoluna.fw.file.dao.FileLineException;
import jp.terasoluna.fw.file.dao.FileLineIterator;
import jp.terasoluna.fw.file.dao.FileQueryDAO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StandardFileCollector
extends AbstractCollector {
    private FileQueryDAO fileQueryDao = null;
    private Object resultClass = null;
    private String inputFileName = null;
    private boolean readNextLine = false;
    private static Log log = LogFactory.getLog(StandardFileCollector.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected CollectorResult doCollect(JobContext jobContext, CollectedDataHandler collectedDataHandler, JobStatus jobStatus) {
        int collected = 0;
        FileLineIterator<?> fileLineIterator = this.fileQueryDao.execute(this.inputFileName, this.resultClass.getClass());
        if (fileLineIterator == null) {
            return new CollectorResult(ReturnCode.NORMAL_END, collected);
        }
        try {
            while (fileLineIterator.hasNext()) {
                try {
                    Object fileLineObject = fileLineIterator.next();
                    collectedDataHandler.handle(fileLineObject, collected++);
                    jobStatus.incrementCollected();
                }
                catch (FileLineException ex) {
                    if (!this.readNextLine) throw ex;
                    this.writeWarnLog(ex);
                    continue;
                    return new CollectorResult(ReturnCode.NORMAL_END, collected);
                }
            }
        }
        finally {
            fileLineIterator.closeFile();
        }
    }

    public void setFileQueryDao(FileQueryDAO fileQueryDao) {
        this.fileQueryDao = fileQueryDao;
    }

    public void setInputFileName(String inputFileName) {
        this.inputFileName = inputFileName;
    }

    public void setResultClass(Object resultClass) {
        this.resultClass = resultClass;
    }

    public void setReadNextLine(boolean readNextLine) {
        this.readNextLine = readNextLine;
    }

    protected void writeWarnLog(FileLineException fileLineException) {
        StringBuilder builder = new StringBuilder();
        builder.append(fileLineException.toString());
        builder.append(" [FileName]:");
        builder.append(fileLineException.getFileName());
        builder.append(" [LineNo]:");
        builder.append(fileLineException.getLineNo());
        builder.append(" [ColumnName]:");
        builder.append(fileLineException.getColumnName());
        log.warn((Object)builder.toString());
    }
}

