﻿//-----------------------------------------------------------------------------
//  TenjiTexter
//  Copyright(c)2009 Masataka Shinke
//  <http://www.shinke.net/>  
//-----------------------------------------------------------------------------

///////////////////////////////////////////////////////////////////////////////
// インクルード宣言
#include <iostream>				// 入出力ストリーム
#include <fstream>				// ファイルストリーム	
#include <string>					// 文字列
#include <locale>					// ロケール
#include <vector>					// 動的配列
#include <functional>			// 
#include <algorithm>				//
#include <sstream>				// 文字列ストリーム

using namespace std;

#include "English_Table.h"		// 英文変換テーブル
#include "Info_Table.h"			// 情報変換テーブル
#include "Japanese_Table.h"		// 日本語変換テーブル

///////////////////////////////////////////////////////////////////////////////
// 点字変換クラスライブラリ
class CBraille 
{
public:
	
	// コンストラクタ
	CBraille(wstring m_FileName);

	// デストラクタ
	virtual ~CBraille(void);
	
	// メンバー関数
	wstring braille_code(void);						//
	wstring braille_code_r(void);					//
	
	wstring winbes_code(void);						//
	wstring winbes_code_r(void);					//
	
	wstring katakana_code(void);					//
	wstring katakana_to_hiragana(wstring katakana);
	wstring hiragana_to_katakana(wstring hiragana);
	wstring a_to_A(wstring al);
	wstring A_to_a(wstring Al);

	string		narrow(const wstring &src);			//
	wstring	widen(const string &src);			//


	wstring	ReadFile(wstring p_LoadFileName);	//
	void 		SaveFile(wstring p_SaveFileName);	//

	wstring 	katakana_conv(void);						//
	wstring 	numeric_conv(unsigned &pos);			//
	wstring 	numeric2_conv(unsigned &pos);			//
	wstring 	roma_conv(unsigned &pos);				//
	wstring	info_conv(unsigned &pos);				//
	wstring	eng_conv(unsigned &pos,wstring s_c);	//
	wstring	eng_conv2(unsigned &pos,wstring  s_c);	//
	
	wstring Cxx(wstring cbuff);																		//
	wstring Cxx2(wstring cbuff);
	wstring Cxx3(wstring cbuff);


		
	static bool is_eqals(const wstring& left,const wstring& right);
	static bool is_sizes(const wstring& left,const wstring& right);

	// メンバー変数
	vector<wstring>	m_Buff;

	wstring			m_Data;	
	wstring			m_Separator;
	wstring		 m_Katakana;
	
	//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
	//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
	//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
	
	
	///////////////////////////////////////////////////////////////////////////
	// 配列サイズを取得する
	// 引き数：配列
	// 戻り値：配列要素数を戻す
	///////////////////////////////////////////////////////////////////////////
	template<size_t N>	unsigned  size( 
		const wstring 	(&m_a)[N]
	)
	{
		return (unsigned) N;
	};	
		
	///////////////////////////////////////////////////////////////////////////
	// 点字コードに一致するレコードを取り出す
	// 	引き数１：検索対象配列
	//	引き数２：点字コード
	//	引き数３：点字コードの検索桁
	//
	//	戻り値：抽出結果
	///////////////////////////////////////////////////////////////////////////
	template<size_t N>	wstring  fined( 
		const wstring 	(&m_a)[N],
		wchar_t			m_b,
		unsigned			pos
	)
	{
		wstring m_Ret =L"─";
		for(unsigned k=0;k<N;k+=2)
		{
			if(m_b==m_a[k+1].at(m_a[k+1].length()-1))
			{
				if(pos==m_a[k+1].length())
				{
					m_Ret=m_a[k];
					break;
				}
			}
		}
		return m_Ret;
	};
	
	///////////////////////////////////////////////////////////////////////////
	// 点字コードに一致するレコードを取り出す
	// 	引き数１：	検索対象配列
	//	引き数２：	点字文字列
	//	戻り値：	抽出結果
	///////////////////////////////////////////////////////////////////////////
	template<size_t N>	wstring  finedS( 
		const wstring 	(&m_a)[N],
		wstring			m_b
	)
	{
		wstring m_Ret =L"─";
		for(unsigned k=0;k<N;k+=2)
		{
			if(m_b.compare(m_a[k+1])==0)
			{
				if(m_b.length()==m_a[k+1].length())
				{
					m_Ret=m_a[k];
					break;
				}
			}
		}
		return m_Ret;
	};
	
	
	
	
	
	
	
};

