ActiveGroonga::Schema.define(:version => 20130203033331) do |schema|
  schema.instance_eval do
    create_table("arcs",
                 :type => :hash,
                 :key_type => "ShortText",
                 :force => true) do |table|
      table.time("created_at")
      table.short_text("extname")
      table.boolean("locked")
      table.short_text("origname")
      table.short_text("summary")
      table.time("updated_at")
    end

    create_table("pmds",
                 :force => true) do |table|
      table.time("created_at")
      table.short_text("path")
      table.time("updated_at")
    end

    create_table("schema_migrations",
                 :type => :hash,
                 :key_type => "UInt64",
                 :force => true) do |table|
      table.time("migrated_at")
    end

    create_table("seigas",
                 :type => :hash,
                 :key_type => "ShortText",
                 :force => true) do |table|
      table.time("created_at")
      table.short_text("description")
      table.short_text("title")
      table.time("updated_at")
    end

    create_table("sites",
                 :type => :hash,
                 :key_type => "ShortText",
                 :force => true) do |table|
      table.time("created_at")
      table.short_text("summary")
      table.time("updated_at")
      table.short_text("url")
    end

    create_table("terms",
                 :type => :patricia_trie,
                 :key_type => "ShortText",
                 :key_normalize => true,
                 :default_tokenizer => "TokenBigram",
                 :force => true) do |table|
    end

    create_table("thumbs",
                 :type => :hash,
                 :key_type => "ShortText",
                 :force => true) do |table|
      table.time("created_at")
      table.short_text("description")
      table.short_text("title")
      table.time("updated_at")
    end

    create_table("vmds",
                 :force => true) do |table|
      table.time("created_at")
      table.short_text("path")
      table.time("updated_at")
    end

    create_table("xes",
                 :force => true) do |table|
      table.time("created_at")
      table.short_text("path")
      table.time("updated_at")
    end

    change_table("arcs") do |table|
      table.reference("site", "sites")
      table.reference("thumbs", "thumbs", :type => :vector)
    end

    change_table("pmds") do |table|
      table.reference("arc", "arcs")
    end

    change_table("thumbs") do |table|
      table.reference("arcs", "arcs", :type => :vector)
    end

    change_table("vmds") do |table|
      table.reference("arc", "arcs")
    end

    change_table("xes") do |table|
      table.reference("arc", "arcs")
    end

    change_table("terms") do |table|
      table.index("arcs", "origname", :name => "arcs_origname")
      table.index("arcs", "summary", :name => "arcs_summary")
      table.index("pmds", "path", :name => "pmds_path")
      table.index("seigas", "description", :name => "seigas_description")
      table.index("seigas", "title", :name => "seigas_title")
      table.index("thumbs", "description", :name => "thumbs_description")
      table.index("thumbs", "title", :name => "thumbs_title")
      table.index("vmds", "path", :name => "vmds_path")
      table.index("xes", "path", :name => "xes_path")
    end
  end
end
