class VmdsController < ApplicationController
  layout 'arcs'
  before_filter :login_required, :only => [ :new, :edit, :create, :update, :destroy ]

  # GET /vmds
  # GET /vmds.xml
  def index
    @search = Vmd::Search.new(params[:search])
    @vmds = Vmd.search(@search).paginate([ '_id' ], :size => 30, :page => params[:page])

    respond_to do |format|
      format.html # index.html.erb
      format.xml  { render :xml => @vmds }
    end
  end
end
