class PmdsController < ApplicationController
  layout 'arcs'
  before_filter :login_required, :only => [ :new, :edit, :create, :update, :destroy ]

  # GET /pmds
  # GET /pmds.xml
  def index
    @search = Pmd::Search.new(params[:search])
    @pmds = Pmd.search(@search).paginate([ '_id' ], :size => 30, :page => params[:page])

    respond_to do |format|
      format.html # index.html.erb
      format.xml  { render :xml => @pmds }
    end
  end
end
