﻿////////////////////////////////////////////////////////////////
//               税金計算ソフト Source Cord                   //
//              Copyright (c) 2020 Akashigi                  //
//                                                            //
//  このソースコード、はMITライセンス上で公開されています。   //
////////////////////////////////////////////////////////////////
using System;
using System.Windows.Forms;

namespace 税金計算ソフト_Windows_
{
    public partial class MainForm : Form
    {

        public MainForm()
        {
            InitializeComponent();
        }

        // base_price_inputのキー入力制限
        private void base_price_input_KeyPress(object sender, KeyPressEventArgs e)
        {
            if ((e.KeyChar < '0' || e.KeyChar > '9') && e.KeyChar != '\b')
            {
                e.Handled = true;
            }
        }

        // 計算スタート
        private void calc_start_Click(object sender, EventArgs e)
        {
            int bp_int1 = tax_calc_verif(base_price_input.Text);    //値をチェックします。
            
            if (r_taxrate_check.Checked == true)                    //チェックボックスがONになっているか確かめます。
            {
                string rp = tax_calc(bp_int1, 1.08);
                result.Text = rp;
            }
            else
            {
                string rp = tax_calc(bp_int1, 1.1);
                result.Text = rp;
            }

            
        }

        // 値を確認
        private int tax_calc_verif(string base_price) 
        {
            if (base_price == "")       //値が無であるか確認します。
            {
                base_price = "0";       //値が無であれば、数値を代入します。
            }
            return int.Parse(base_price);
        }

        // 税込価格を計算
        private string tax_calc(int base_price2, double tax_rate)
        {
            double result_price = base_price2 * tax_rate;
            return result_price.ToString();
        }


        // 消費税のヘルプを表示
        private void mh_taxhelp_Click(object sender, EventArgs e)
        {
            tax_help th = new tax_help();
            th.Show();
        }

        // 軽減税率のヘルプを表示
        private void mh_mittaxhelp_Click(object sender, EventArgs e)
        {
            mitigation_help mhw = new mitigation_help();
            mhw.Show();
        }

        // バージョンを表示
        private void mh_version_Click(object sender, EventArgs e)
        {
            about ab = new about();
            ab.Show();
        }
    }
}
