/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Alert/AlertPreference.cs#2 $
 * $DateTime: 2008/01/08 19:01:29 $
 */
using System;
using System.Collections.Generic;
using System.Text;

using Bellagio.Environment;
using Bellagio.Forms;

using Poderosa.Plugins;
using Poderosa.Preferences;

namespace Bellagio.Alert {
    public class AlertPreference : PreferenceSupplierImpl, IPreferenceChangeListener {
        private IBoolPreferenceItem _enabled;

        public AlertPreference()
            : base("tactico.alert") {
        }
        public override void InitializePreference(IPreferenceBuilder builder, IPreferenceFolder folder) {
            folder.AddChangeListener(this);
            _enabled = builder.DefineBoolValue(folder, "enabled", true, null);
        }


        public void OnPreferenceImport(IPreferenceFolder oldvalues, IPreferenceFolder newvalues) {
        }

        public void OnPreferenceImportFinish() {
            ReloadPreference();
        }
        public void ReloadPreference() {
            AlertContent c = AlertPlugin.Instance.AlertContent;
            if(c!=null) c.ReloadPreference();
        }

        public bool Enabled {
            get {
                return _enabled.Value;
            }
            set {
                _enabled.Value = value;
            }
        }
        
    }
}
