/*******************************************************
 *
 * Author: Hirokazu Kato
 *
 *         kato@sys.im.hiroshima-cu.ac.jp
 *
 * Revision: 3.1
 * Date: 01/12/07
 *
*******************************************************/

#include <stdlib.h>
#include <math.h>
#include <AR/ar.h>
#include <AR/matrix.h>

#define P_MAX       500

static ARVAL  pos2d[P_MAX][2];
static ARVAL  pos3d[P_MAX][3];

static ARVAL arGetTransMatSub( ARVAL rot[3][3], ARVAL ppos2d[][2],
                                ARVAL pos3d[][3], int num,ARVAL conv[3][4],
                                ARVAL *dist_factor, ARVAL cpara[3][4] );

ARVAL arGetTransMat( ARMarkerInfo *marker_info,
                      ARVAL center[2], ARVAL width, ARVAL conv[3][4] )
{
    ARVAL  rot[3][3];
    ARVAL  ppos2d[4][2];
    ARVAL  ppos3d[4][2];
 		int     dir;
    ARVAL  err;
    int     i;
		ARVAL  w;

    if( arGetInitRot( marker_info, arParam.lmat, rot ) < 0 ) return -1;

    dir = marker_info->dir;
		
		w = width >> 1;
    ppos2d[0][0] = marker_info->vertex[(4-dir)&3][0];
    ppos2d[0][1] = marker_info->vertex[(4-dir)&3][1];
    ppos2d[1][0] = marker_info->vertex[(5-dir)&3][0];
    ppos2d[1][1] = marker_info->vertex[(5-dir)&3][1];
    ppos2d[2][0] = marker_info->vertex[(6-dir)&3][0];
    ppos2d[2][1] = marker_info->vertex[(6-dir)&3][1];
    ppos2d[3][0] = marker_info->vertex[(7-dir)&3][0];
    ppos2d[3][1] = marker_info->vertex[(7-dir)&3][1];
    ppos3d[0][0] = center[0] - w;
    ppos3d[0][1] = center[1] + w;
    ppos3d[1][0] = center[0] + w;
    ppos3d[1][1] = center[1] + w;
    ppos3d[2][0] = center[0] + w;
    ppos3d[2][1] = center[1] - w;
    ppos3d[3][0] = center[0] - w;
    ppos3d[3][1] = center[1] - w;

    for( i = 0; i < AR_GET_TRANS_MAT_MAX_LOOP_COUNT; i++ ) {
        err = arGetTransMat3( rot, ppos2d, ppos3d, 4, conv,
                                   arParam.ldist_factor, arParam.lmat );
        if ( err < DoubleToARVAL( AR_GET_TRANS_MAT_MAX_FIT_ERROR )  &&  conv[ 2 ][ 3 ] >= 0LL ) 
					break;
    }
    return err;
}

ARVAL arGetTransMat2( ARVAL rot[3][3], ARVAL ppos2d[][2],
                   ARVAL ppos3d[][2], int num, ARVAL conv[3][4] )
{
    return arGetTransMat3( rot, ppos2d, ppos3d, num, conv,
                           arParam.ldist_factor, arParam.lmat );
}

ARVAL arGetTransMat3( ARVAL rot[3][3], ARVAL ppos2d[][2],
                       ARVAL ppos3d[][2], int num, ARVAL conv[3][4],
                       ARVAL *dist_factor, ARVAL cpara[3][4] )
{
    ARVAL  off[3], pmax[3], pmin[3];
    ARVAL  ret;
    int     i;

    pmax[0]=pmax[1]=pmax[2] = -IntToARVAL( 100000000 );
    pmin[0]=pmin[1]=pmin[2] =  IntToARVAL( 100000000 );
    for( i = 0; i < num; i++ ) {
        if( ppos3d[i][0] > pmax[0] ) pmax[0] = ppos3d[i][0];
        if( ppos3d[i][0] < pmin[0] ) pmin[0] = ppos3d[i][0];
        if( ppos3d[i][1] > pmax[1] ) pmax[1] = ppos3d[i][1];
        if( ppos3d[i][1] < pmin[1] ) pmin[1] = ppos3d[i][1];
/*
        if( ppos3d[i][2] > pmax[2] ) pmax[2] = ppos3d[i][2];
        if( ppos3d[i][2] < pmin[2] ) pmin[2] = ppos3d[i][2];
*/
    }
    off[0] = -(pmax[0] + pmin[0]) >> 1;
    off[1] = -(pmax[1] + pmin[1]) >> 1;
    off[2] = -(pmax[2] + pmin[2]) >> 1;
    for( i = 0; i < num; i++ ) {
        pos3d[i][0] = ppos3d[i][0] + off[0];
        pos3d[i][1] = ppos3d[i][1] + off[1];
/*
        pos3d[i][2] = ppos3d[i][2] + off[2];
*/
        pos3d[i][2] = 0;
    }

    ret = arGetTransMatSub( rot, ppos2d, pos3d, num, conv,
                            dist_factor, cpara );

    conv[0][3] = MulARVAL( conv[0][0], off[0] ) + MulARVAL( conv[0][1], off[1] ) + MulARVAL( conv[0][2], off[2] ) + conv[0][3];
    conv[1][3] = MulARVAL( conv[1][0], off[0] ) + MulARVAL( conv[1][1], off[1] ) + MulARVAL( conv[1][2], off[2] ) + conv[1][3];
    conv[2][3] = MulARVAL( conv[2][0], off[0] ) + MulARVAL( conv[2][1], off[1] ) + MulARVAL( conv[2][2], off[2] ) + conv[2][3];

    return ret;
}

ARVAL arGetTransMat4( ARVAL rot[3][3], ARVAL ppos2d[][2],
                       ARVAL ppos3d[][3], int num, ARVAL conv[3][4] )
{
    return arGetTransMat5( rot, ppos2d, ppos3d, num, conv,
                           arParam.ldist_factor, arParam.lmat );
}

ARVAL arGetTransMat5( ARVAL rot[3][3], ARVAL ppos2d[][2],
                       ARVAL ppos3d[][3], int num, ARVAL conv[3][4],
                       ARVAL *dist_factor, ARVAL cpara[3][4] )
{
    ARVAL  off[3], pmax[3], pmin[3];
    ARVAL  ret;
    int     i;

    pmax[0]=pmax[1]=pmax[2] = -IntToARVAL( 100000 );
    pmin[0]=pmin[1]=pmin[2] =  IntToARVAL( 100000 );
    for( i = 0; i < num; i++ ) {
        if( ppos3d[i][0] > pmax[0] ) pmax[0] = ppos3d[i][0];
        if( ppos3d[i][0] < pmin[0] ) pmin[0] = ppos3d[i][0];
        if( ppos3d[i][1] > pmax[1] ) pmax[1] = ppos3d[i][1];
        if( ppos3d[i][1] < pmin[1] ) pmin[1] = ppos3d[i][1];
        if( ppos3d[i][2] > pmax[2] ) pmax[2] = ppos3d[i][2];
        if( ppos3d[i][2] < pmin[2] ) pmin[2] = ppos3d[i][2];
    }
    off[0] = -(pmax[0] + pmin[0]) >> 1;
    off[1] = -(pmax[1] + pmin[1]) >> 1;
    off[2] = -(pmax[2] + pmin[2]) >> 1;
    for( i = 0; i < num; i++ ) {
        pos3d[i][0] = ppos3d[i][0] + off[0];
        pos3d[i][1] = ppos3d[i][1] + off[1];
        pos3d[i][2] = ppos3d[i][2] + off[2];
    }

    ret = arGetTransMatSub( rot, ppos2d, pos3d, num, conv,
                            dist_factor, cpara );

    conv[0][3] = MulARVAL( conv[0][0], off[0] ) + MulARVAL( conv[0][1], off[1] ) + MulARVAL( conv[0][2], off[2] ) + conv[0][3];
    conv[1][3] = MulARVAL( conv[1][0], off[0] ) + MulARVAL( conv[1][1], off[1] ) + MulARVAL( conv[1][2], off[2] ) + conv[1][3];
    conv[2][3] = MulARVAL( conv[2][0], off[0] ) + MulARVAL( conv[2][1], off[1] ) + MulARVAL( conv[2][2], off[2] ) + conv[2][3];

    return ret;
}

static ARVAL arGetTransMatSub( ARVAL rot[3][3], ARVAL ppos2d[][2],
                                ARVAL pos3d[][3], int num, ARVAL conv[3][4],
                                ARVAL *dist_factor, ARVAL cpara[3][4] )
{
    ARMat  *mat_a, *mat_b, *mat_c, *mat_d, *mat_e, *mat_f;
    ARVAL  trans[3];
    ARVAL  wx, wy, wz;
    ARVAL  ret;
    int    i, j;
		int    sftf, sfte;

    mat_a = arMatrixAlloc( num*2, 3 );
    mat_b = arMatrixAlloc( 3, num*2 );
    mat_c = arMatrixAlloc( num*2, 1 );
    mat_d = arMatrixAlloc( 3, 3 );
    mat_e = arMatrixAlloc( 3, 1 );
    mat_f = arMatrixAlloc( 3, 1 );

    if( arFittingMode == AR_FITTING_TO_INPUT ) {
        for( i = 0; i < num; i++ ) {
            arParamIdeal2Observ(dist_factor, ppos2d[i][0], ppos2d[i][1],
                                             &pos2d[i][0], &pos2d[i][1]);
        }
    }
    else {
        for( i = 0; i < num; i++ ) {
            pos2d[i][0] = ppos2d[i][0];
            pos2d[i][1] = ppos2d[i][1];
        }
    }

    for( j = 0; j < num; j++ ) {
        wx = MulARVAL( rot[0][0], pos3d[j][0] )
           + MulARVAL( rot[0][1], pos3d[j][1] )
           + MulARVAL( rot[0][2], pos3d[j][2] );
        wy = MulARVAL( rot[1][0], pos3d[j][0] )
           + MulARVAL( rot[1][1], pos3d[j][1] )
           + MulARVAL( rot[1][2], pos3d[j][2] );
        wz = MulARVAL( rot[2][0], pos3d[j][0] )
           + MulARVAL( rot[2][1], pos3d[j][1] )
           + MulARVAL( rot[2][2], pos3d[j][2] );
        mat_a->ml[j*6+0] = mat_b->ml[num*0+j*2] = cpara[0][0];
        mat_a->ml[j*6+1] = mat_b->ml[num*2+j*2] = cpara[0][1];
        mat_a->ml[j*6+2] = mat_b->ml[num*4+j*2] = cpara[0][2] - pos2d[j][0];
        mat_c->ml[j*2+0] = MulARVAL( wz, pos2d[j][0] ) - MulARVAL( cpara[0][0], wx ) - MulARVAL( cpara[0][1], wy ) - MulARVAL( cpara[0][2], wz );
        mat_a->ml[j*6+3] = mat_b->ml[num*0+j*2+1] = 0;
        mat_a->ml[j*6+4] = mat_b->ml[num*2+j*2+1] = cpara[1][1];
        mat_a->ml[j*6+5] = mat_b->ml[num*4+j*2+1] = cpara[1][2] - pos2d[j][1];
        mat_c->ml[j*2+1] = MulARVAL( wz, pos2d[j][1] ) - MulARVAL( cpara[1][1], wy ) - MulARVAL( cpara[1][2], wz );
    }
    arMatrixMul( mat_d, mat_b, mat_a );
    arMatrixMulShift( mat_e, &sfte, mat_b, mat_c, 0 );
    arMatrixSelfInv( mat_d );
    arMatrixMulShift( mat_f, &sftf, mat_d, mat_e, sfte );
		if ( sftf > 0 )
		{
			trans[0] = mat_f->ml[0] << sftf;
			trans[1] = mat_f->ml[1] << sftf;
			trans[2] = mat_f->ml[2] << sftf;
		}
		else
		{
			trans[0] = mat_f->ml[0] >> -sftf;
			trans[1] = mat_f->ml[1] >> -sftf;
			trans[2] = mat_f->ml[2] >> -sftf;
		}

    ret = arModifyMatrix( rot, trans, cpara, pos3d, pos2d, num );

    for( j = 0; j < num; j++ ) {
        wx = MulARVAL( rot[0][0], pos3d[j][0] )
           + MulARVAL( rot[0][1], pos3d[j][1] )
           + MulARVAL( rot[0][2], pos3d[j][2] );
        wy = MulARVAL( rot[1][0], pos3d[j][0] )
           + MulARVAL( rot[1][1], pos3d[j][1] )
           + MulARVAL( rot[1][2], pos3d[j][2] );
        wz = MulARVAL( rot[2][0], pos3d[j][0] )
           + MulARVAL( rot[2][1], pos3d[j][1] )
           + MulARVAL( rot[2][2], pos3d[j][2] );
        mat_a->ml[j*6+0] = mat_b->ml[num*0+j*2] = cpara[0][0];
        mat_a->ml[j*6+1] = mat_b->ml[num*2+j*2] = cpara[0][1];
        mat_a->ml[j*6+2] = mat_b->ml[num*4+j*2] = cpara[0][2] - pos2d[j][0];
        mat_c->ml[j*2+0] = MulARVAL( wz, pos2d[j][0] ) - MulARVAL( cpara[0][0], wx ) - MulARVAL( cpara[0][1], wy ) - MulARVAL( cpara[0][2], wz );
        mat_a->ml[j*6+3] = mat_b->ml[num*0+j*2+1] = 0;
        mat_a->ml[j*6+4] = mat_b->ml[num*2+j*2+1] = cpara[1][1];
        mat_a->ml[j*6+5] = mat_b->ml[num*4+j*2+1] = cpara[1][2] - pos2d[j][1];
        mat_c->ml[j*2+1] = MulARVAL( wz, pos2d[j][1] ) - MulARVAL( cpara[1][1], wy ) - MulARVAL( cpara[1][2], wz );
    }
    arMatrixMul( mat_d, mat_b, mat_a );
    arMatrixMulShift( mat_e, &sfte, mat_b, mat_c, 0 );
    arMatrixSelfInv( mat_d );
    arMatrixMulShift( mat_f, &sftf, mat_d, mat_e, sfte );
		if ( sftf > 0 )
		{
			trans[0] = mat_f->ml[0] << sftf;
			trans[1] = mat_f->ml[1] << sftf;
			trans[2] = mat_f->ml[2] << sftf;
		}
		else
		{
			trans[0] = mat_f->ml[0] >> -sftf;
			trans[1] = mat_f->ml[1] >> -sftf;
			trans[2] = mat_f->ml[2] >> -sftf;
		}

    ret = arModifyMatrix( rot, trans, cpara, pos3d, pos2d, num );

    arMatrixFree( mat_a );
    arMatrixFree( mat_b );
    arMatrixFree( mat_c );
    arMatrixFree( mat_d );
    arMatrixFree( mat_e );
    arMatrixFree( mat_f );

    for( j = 0; j < 3; j++ ) {
        for( i = 0; i < 3; i++ ) conv[j][i] = rot[j][i];
        conv[j][3] = trans[j];
    }

    return ret;
}
