package com.shizentai.app.arcam;

/**
 * ネイティブライブラリのラッパークラス。
 * @author Shizentai Factory Co.
 *
 */
public class JNIutils
{
	static 
	{
		System.loadLibrary( "arcamLib" );
	}

	/**
	 * YUV_420SPをRGB_565に変換する。
	 * 
	 * @param rgb 変換結果を受け取る配列
	 * @param yuv420sp 変換元のビットマップが格納された配列
	 * @param width 変換元のビットマップ全体の横幅[pixel]
	 * @param height 変換元のビットマップ全体の縦幅[pixel]
	 * @param rectwidth 実際に変換する領域の横幅[pixel] width以下であること
	 * @param rectheight 実際に変換する領域の縦幅[pixel] height以下であること
	 */
	static native void decodeYUV420SP_RGB565( short[] rgb, byte[] yuv420sp, int width, int height, int rectwidth, int rectheight );

	/**
	 * YUV_420SPをARGB_8888に変換する。
	 * 
	 * @param rgb 変換結果を受け取る配列
	 * @param yuv420sp 変換元のビットマップが格納された配列
	 * @param width 変換元のビットマップ全体の横幅[pixel]
	 * @param height 変換元のビットマップ全体の縦幅[pixel]
	 * @param rectwidth 実際に変換する領域の横幅[pixel] width以下であること
	 * @param rectheight 実際に変換する領域の縦幅[pixel] height以下であること
	 */
	static native void decodeYUV420SP_ARGB8888( int[] rgb, byte[] yuv420sp, int width, int height, int rectwidth, int rectheight );
	
	/**
	 * メタセコイアのモデルファイル(*.mqo)をロードする
	 * 
	 * @param path モデルファイルのパス
	 * @return trueなら成功
	 */
	static native boolean loadModel( String[] path );
	
	/**
	 * モデルファイルをアンロードする
	 */
	static native void unloadModel();

	/**
	 * モデルを描画する
	 */
	static native void drawModel( int n );
}
 