/*******************************************************
 *
 * Author: Shinsaku Hiura, Hirokazu Kato
 *
 *         shinsaku@sys.es.osaka-u.ac.jp
 *         kato@sys.im.hiroshima-cu.ac.jp
 *
 * Revision: 2.1
 * Date: 99/07/16
 *
*******************************************************/

#include <stdio.h>
#include <math.h>
#include <AR/matrix.h>

int arVecTridiagonalize( ARMat *a, ARVec *d, ARVec *e )
{
    ARVec     wv1, wv2;
    ARVAL  *vl;
    ARVAL  s, t, p, q;
    int     dim;
    int     i, j, k;

    if( a->clm != a->row )   return(-1);
    if( a->clm != d->clm )   return(-1);
    if( a->clm != e->clm+1 ) return(-1);
    dim = a->clm;

    for( k = 0; k < dim-2; k++ ) {
        vl = &(a->ml[k*dim]);
        d->vl[k] = vl[k];

        wv1.clm = dim-k-1;
        wv1.vl = &(vl[k+1]);
        e->vl[k] = arVecHousehold(&wv1);
        if( e->vl[k] == 0 ) continue;

        for( i = k+1; i < dim; i++ ) {
            s = 0;
            for( j = k+1; j < i; j++ ) {
                s += MulARVAL( a->ml[j*dim+i], vl[j] );
            }
            for( j = i; j < dim; j++ ) {
                s += MulARVAL( a->ml[i*dim+j], vl[j] );
            }
            d->vl[i] = s;
        }

        wv1.clm = wv2.clm = dim-k-1;
        wv1.vl = &(vl[k+1]);
        wv2.vl = &(d->vl[k+1]);
        t = arVecInnerproduct( &wv1, &wv2 ) >> 1;
        for( i = dim-1; i > k; i-- ) {
            p = vl[i];
            q = d->vl[i] -= MulARVAL( t, p );
            for( j = i; j < dim; j++ ) {
                a->ml[i*dim+j] -= MulARVAL( p, d->vl[j] ) + MulARVAL( q, vl[j] );
            }
        }
    }

    if( dim >= 2) {
        d->vl[dim-2] = a->ml[(dim-2)*dim+(dim-2)];
        e->vl[dim-2] = a->ml[(dim-2)*dim+(dim-1)];
    }

    if( dim >= 1 ) d->vl[dim-1] = a->ml[(dim-1)*dim+(dim-1)];

    for( k = dim-1; k >= 0; k-- ) {
        vl = &(a->ml[k*dim]);
        if( k < dim-2 ) {
            for( i = k+1; i < dim; i++ ) {
                wv1.clm = wv2.clm = dim-k-1;
                wv1.vl = &(vl[k+1]);
                wv2.vl = &(a->ml[i*dim+k+1]);
                t = arVecInnerproduct( &wv1, &wv2 );
                for( j = k+1; j < dim; j++ ) a->ml[i*dim+j] -= MulARVAL( t, vl[j] );
            }
        }
        for( i = 0; i < dim; i++ ) vl[i] = 0;
        vl[k] = IntToARVAL( 1 );
    }

    return(0);
}
