package com.shizentai.app.arcam;

import java.io.IOException;
import java.io.InputStream;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.HashMap;

import android.content.Context;
import android.graphics.*;
import android.hardware.Camera;
import android.util.Log;
import android.view.*;
import android.widget.Toast;
import android.hardware.Camera.Size;

/**
 * 
 * @author Shizentai Factory Co.
 *
 */
public class arcamView extends SurfaceView implements SurfaceHolder.Callback, Camera.PreviewCallback, Runnable
{
	public static final int STATE_STOPPED=0;
	public static final int STATE_STARTED=1;
	static final int[] pattern_res = { R.raw.patt00, R.raw.patt07 };
	static public final int max_patterns = pattern_res.length;
		
	SurfaceHolder holder;
	Camera cam;
	int curState;
	int imgw, imgh;
	int srcw, srch;		// [imgw, imgh]から実際に表示する領域
	int surfaceWidth, surfaceHeight;
	
	double[] matProj;
	final int[] idPattern = new int [ max_patterns ];
	final HashMap<Integer, Integer> mapPattern = new HashMap<Integer, Integer>();
	
	// 要同期
	Thread thread;
	boolean isThreadEnd;
	boolean isInThreadProc;
	byte[] yuvData;
	final Object sync = new Object(); // 同期アンカー
	
	public arcamView(Context context)
	{
		super( context );
		holder = getHolder();
		holder.addCallback( this );
		//holder.setType( SurfaceHolder.SURFACE_TYPE_PUSH_BUFFERS );
		//holder.setType( SurfaceHolder.SURFACE_TYPE_HARDWARE );
		holder.setType( SurfaceHolder.SURFACE_TYPE_GPU );
		//holder.setType( SurfaceHolder.SURFACE_TYPE_NORMAL );
		//holder.setFormat( PixelFormat.RGB_565 );
		curState = STATE_STOPPED;
		imgw = 0;
		imgh = 0;
		thread = null;
	}

	@Override
	protected void finalize() throws Throwable
	{
		try
		{
			super.finalize();
		}
		finally
		{
			endThread();
		}
	}

	void beginThread()
	{
		if ( thread == null )
		{
			isThreadEnd = false;
			isInThreadProc = false;
			thread = new Thread( this );
			thread.start();
		}
	}
	void endThread()
	{
		if ( thread != null )
		{
			isThreadEnd = true;
			synchronized ( sync )
			{
				sync.notify();
			}
			try
			{
				thread.join();
			}
			catch ( Exception e )
			{
			}
			thread = null;
		}
	}
	
	public int getPattern( int id )
	{
		return mapPattern.containsKey( id )? mapPattern.get( id ) : -1;
	}
	
	public void setCamera( Camera camera )
	{
		if ( camera != null )
		{
			cam = camera;
		}
		else
		{
			if ( cam != null )
			{
				if ( curState == STATE_STARTED )
				{
					cam.stopPreview();
					curState = STATE_STOPPED;
				}
				cam = null;
			}
		}
	}
	
	public void startAutoFocus()
	{
		if ( cam != null )
		{
			if ( curState == STATE_STARTED )
				cam.autoFocus( null );
		}
	}
	public void cancelAutoFocus()
	{
	}

	@Override
	public void surfaceChanged( SurfaceHolder holder, int format, int width, int height )
	{
		if ( cam != null )
		{
			surfaceDestroyed( null );
			
			// 表示領域
			surfaceWidth = width;
			surfaceHeight = height;
			
			// カメラ撮影領域(解像度)と実際に取り扱う領域
			imgw = 320;	imgh = 240;
			if ( (surfaceWidth<<16)/surfaceHeight > (imgw<<16)/imgh )
			{ 
				srcw = imgw; 
				srch = imgw*surfaceHeight/surfaceWidth;
			}
			else
			{
				srcw = surfaceWidth*imgh/surfaceHeight;
				srch = imgh;
			}

			//
			// AR初期化
			//
			
			// カメラパラメータ読み込み 
	    InputStream is = getContext().getResources().openRawResource( R.raw.camera_para );
	    try
			{
		    byte[] cpar = new byte [ 256 ];
				is.read( cpar );
				matProj = ARtk.arInit( cpar, srcw, srch );
				if ( matProj == null )
					throw new IOException();
			}
			catch ( IOException e1 )
			{
				e1.printStackTrace();
				((arcam)getContext()).terminateDialog( R.string.msg_fail_view );
				return;
			}
			// マーカー検出モード設定
			ARtk.arSetPattMode( 0 );	// 画像検出モード
			// パターンファイル読み込み
			mapPattern.clear();
			for ( int i=0; i<max_patterns; i++ )
			{
		    is = getContext().getResources().openRawResource( pattern_res[ i ] );
		    try
				{
					byte[] patt = new byte [ 12680 ];
					is.read( patt );
					if ( (idPattern[ i ] = ARtk.arLoadPatt( patt )) < 0 )
						throw new IOException();
					mapPattern.put( i, idPattern[ i ] );
				}
				catch ( IOException e1 )
				{
					e1.printStackTrace();
					((arcam)getContext()).terminateDialog( R.string.msg_fail_view );
					return;
				}
			}			
			
			// カメラ初期化
			Camera.Parameters param = cam.getParameters();
			param.setPreviewSize( imgw, imgh );
			param.setPreviewFormat( PixelFormat.YCbCr_420_SP );	// 少なくともandroid1.6では、RGB_565でのpreviewは実装されていない 
			param.setPreviewFrameRate( 4 );
			//param.setPictureFormat( PixelFormat.YCbCr_420_SP );
			cam.setParameters( param );
			
			param = cam.getParameters();
			Size sz = param.getPreviewSize();
			Log.d( arcam.dbgtag, "preview size: "+sz.width+"x"+sz.height );
			Log.d( arcam.dbgtag, "preview format: "+param.getPreviewFormat() );

			beginThread();
			
			try
			{
				//cam.setPreviewDisplay( holder );
			}
			catch ( Exception e )
			{
				return;
			}
			
			cam.setPreviewCallback( this );
			cam.startPreview();
			curState = STATE_STARTED;
		}
	}	

	@Override
	public void surfaceCreated( SurfaceHolder holder )
	{
	}

	@Override
	public void surfaceDestroyed( SurfaceHolder holder )
	{
		endThread();
		if ( cam != null )
		{
			if ( curState == STATE_STARTED )
			{
				cam.stopPreview();
				curState = STATE_STOPPED;
			}
		}
		
		if ( matProj != null )
		{
			ARtk.arExit();
			matProj = null;
		}
		
	}

	@Override
	public void onPreviewFrame( byte[] data, Camera camera )
	{
		/*
		final short[] p = imgbuf.array();
		decodeYUV420SP_RGB565( p, data, imgw, imgh, 100, 100 );
		
		imgbmp.copyPixelsFromBuffer( imgbuf );
		Canvas c = holder.lockCanvas();
		c.drawBitmap( imgbmp, 0, 0, null );
		holder.unlockCanvasAndPost( c );	// フリップ
		*/
		if ( data == null )
		{
			System.gc();
			return;
		}
		synchronized ( sync )
		{
			if ( isInThreadProc )
				return;
			yuvData = data;
			sync.notify();
		}
		
		data = null;
	}
  
	@Override
	public void run()
	{
		Render render = new Render( this, holder, surfaceWidth, surfaceHeight, imgw, imgh );
		//Render render = null;
		//Bitmap.Config fmt = Bitmap.Config.RGB_565;
		Bitmap.Config fmt = Bitmap.Config.ARGB_8888;
	
		IntBuffer imgbufi = (fmt == Bitmap.Config.ARGB_8888)? IntBuffer.allocate( imgw*imgh ) : null;
		ShortBuffer imgbufs = (fmt == Bitmap.Config.RGB_565)? ShortBuffer.allocate( imgw*imgh ) : null;
		Bitmap imgbmp = (render != null)? null : Bitmap.createBitmap( imgw, imgh, fmt );

		if ( render != null )
			render.setProjectionMatrix( matProj );
		
		// モデルデータ読み込み
		if ( !JNIutils.loadModel( ((arcam)getContext()).modelpath ) )
			Toast.makeText( getContext(), R.string.msg_fail_modeldata_load, Toast.LENGTH_SHORT ).show();
		
		while ( !isThreadEnd )
		{
			byte[] yuv;
			synchronized ( sync )
			{
				isInThreadProc = true;
				yuv = yuvData;
				yuvData = null;
			}
			
			if ( yuv != null )
			{
				if ( fmt == Bitmap.Config.RGB_565 )  
					JNIutils.decodeYUV420SP_RGB565( imgbufs.array(), yuv, imgw, imgh, srcw, srch );
				else
					JNIutils.decodeYUV420SP_ARGB8888( imgbufi.array(), yuv, imgw, imgh, srcw, srch );
				yuv = null;
				
				ARtk.MarkerInfo[] marker = ARtk.arDetectMarker( imgbufi.array(), 100 );
				//if ( marker.length > 0 )
				//	Log.d( arcam.dbgtag, "found " );
				
				if ( render != null )
				{
					render.setTextureImage( render.texCamimg, imgbufi, srcw, srch );
					render.draw( marker );
					render.flip();
				}
				else
				{
					imgbmp.copyPixelsFromBuffer( (fmt == Bitmap.Config.RGB_565)? imgbufs : imgbufi );
					Canvas c = holder.lockCanvas();
					c.drawBitmap( imgbmp, new Rect(0,0,srcw,srch), new Rect(0,0,surfaceWidth,surfaceHeight), null );
					holder.unlockCanvasAndPost( c );	// フリップ
				}
			}
			
			synchronized ( sync )
			{
				isInThreadProc = false;
				try
				{
					sync.wait();
				}
				catch ( Exception e )
				{
				}
			}
		}

		JNIutils.unloadModel();
		
		if ( render != null )
			render.destroy();
	}	
}
