package com.shizentai.app.arcam;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

import javax.microedition.khronos.opengles.GL11;

/**
 * 
 * @author Shizentai Factory Co.
 *
 */
public class Models
{
	final int es1 = 1<<16; 
	final float lw = 0.03f;
	
	// 平板の頂点
	final int[] panel_vertices =
	{
		0,	0, //左上
		0, -es1, //左下
		es1,	0, //右上
		1, -es1, //右下
	};
	// 平板のテクスチャUV
	final int[] panel_UVs =
	{
		0, 0, //左上
		0, es1, //左下
		es1, 0, //右上
		es1, es1, //右下
	};
	

	// 立方体の頂点、色、描画リスト
	final int[] cube_vertices = 
	{
		 -es1, -es1, -es1,
			es1, -es1, -es1,
			es1,	es1, -es1,
		 -es1,	es1, -es1,
		 -es1, -es1,	es1,
			es1, -es1,	es1,
			es1,	es1,	es1,
		 -es1,	es1,	es1,
	};
	final int[] cube_colors = 
	{
			0,		0,		0,	es1,
		es1,		0,		0,	es1,
		es1,	es1,		0,	es1,
			0,	es1,		0,	es1,
			0,		0,	es1,	es1,
		es1,		0,	es1,	es1,
		es1,	es1,	es1,	es1,
			0,	es1,	es1,	es1,
	};
	final byte[] cube_indexs = 
	{
		0, 4, 5,		0, 5, 1,
		1, 5, 6,		1, 6, 2,
		2, 6, 7,		2, 7, 3,
		3, 7, 4,		3, 4, 0,
		4, 7, 6,		4, 6, 5,
		3, 0, 1,		3, 1, 2
	};

	//
	// 近距離照準
	//
	// 部品A
	final float[] reticulum_near_A = 
	{
		-1.0f,    0.54f,   0f,
		-1.0f+lw, 0.54f,   0f,
		-1.0f,    0.9f,    0f,
		-1.0f+lw, 0.9f,    0f,
		-0.9f,    1.0f,    0f,
		-0.9f,    1.0f-lw, 0f,
		-0.54f,   1.0f,    0,
		-0.54f,   1.0f-lw, 0
	};
	// 部品B
	final float[] reticulum_near_B1 = 
	{
		-1.0f, 0.66f, 0f,
		-1.0f, 0.54f, 0f,
		-0.90f, 0.66f, 0f,
		-0.90f, 0.54f, 0f
	};
	final float[] reticulum_near_B2 = 
	{
		-0.66f, 1.0f, 0f,
		-0.66f, 0.90f, 0f,
		-0.54f, 1.0f, 0f,
		-0.54f, 0.90f, 0
	};

	//
	// 遠距離照準
	//
	// 部品A 
	final float[] reticulum_far_A1 = 
	{
		0f, 0.74f, 0f,
		0f, 0.58f, 0f,
		lw, 0.74f, 0f,
		lw, 0.58f, 0f
	};
	final float[] reticulum_far_A2 = 
	{
		0f, -0.58f, 0f,
		0f, -0.74f, 0f,
		lw, -0.58f, 0f,
		lw, -0.74f, 0f
	};
	// 部品B 
	final float[] reticulum_far_B = 
	{
		-0.76f, 0.26f,    0f,
		-0.76f, 0.26f-lw, 0f,
		-0.52f, 0.26f,    0f,
		-0.52f, 0.26f-lw, 0f,
		-0.3f,  0.6f,     0f,
		-0.3f,  0.6f-lw,  0f,
		-0.1f,  0.6f,     0f,
		-0.1f,  0.6f-lw,  0
	};

	//
	// ロックオンマーカー 内側六角形 シングル/ダブル共用
	//
	// GL_LINE_LOOP
	final float[] lockonmarker_inner = 
	{
		-0.3f, 0.5f, 0f,
		-0.3f, 0.5f-lw, 0f,
		0.3f, 0.5f, 0f,
		0.3f, 0.5f-lw, 0f,
		0.6f, 0f, 0f,
		0.6f-lw, 0f, 0f,
		0.3f, -0.5f, 0f,
		0.3f, -0.5f+lw, 0f,
		-0.3f, -0.5f, 0f,
		-0.3f, -0.5f+lw, 0f,
		-0.6f, 0f, 0,
		-0.6f+lw, 0f, 0,
		-0.3f, 0.5f, 0f,
		-0.3f, 0.5f-lw, 0f
	};
	
	//
	// ロックオンマーカー シングル 外側 
	//
	// 部品A
	final float[] lockonmarker_outer_A = 
	{
		-0.65f, -0.08f, 0f,
		-0.65f-lw, -0.08f, 0f,
		-0.74f, 0.04f, 0f,
		-0.74f-lw, 0.04f, 0f,
		-0.7f, 0.4f, 0f,
		-0.7f-lw, 0.4f, 0f,
		-0.34f, 0.66f, 0f,
		-0.34f, 0.66f+lw, 0f,
		-0.24f, 0.6f, 0,
		-0.24f, 0.6f+lw, 0
	};
	// 部品B GL_LINE_STRIP
	final float[] lockonmarker_outer_B = 
	{
		-0.4f, -0.5f, 0f,
		-0.4f+lw, -0.5f, 0f,
		-0.4f, -0.6f, 0f,
		-0.4f+lw, -0.6f, 0f,
		0f, -0.8f, 0f,
		0f, -0.8f+lw, 0f,
		0.4f, -0.6f, 0f,
		0.4f-lw, -0.6f, 0f,
		0.4f, -0.5f, 0,
		0.4f-lw, -0.5f, 0
	};
	
	//
	// ロックオンマーカー ダブル 外側
	//
	// 部品A
	final float[] lockonmarker_dbl_outer_A = 
	{
		-0.5f, 0.85f, 0f,
		-0.5f, 0.85f+lw, 0f,
		0.5f, 0.85f, 0f,
		0.5f, 0.85f+lw, 0f,
		1.0f, 0f, 0f,
		1.0f+lw, 0f, 0f,
		0.5f, -0.85f, 0f,
		0.5f, -0.85f-lw, 0f,
		-0.5f, -0.85f, 0f,
		-0.5f, -0.85f-lw, 0f,
		-1.0f, 0f, 0,
		-1.0f-lw, 0f, 0,
		-0.5f, 0.85f, 0f,
		-0.5f, 0.85f+lw, 0f,
	};
	// 部品B
	final float[] lockonmarker_dbl_outer_B = 
	{
		-0.64f, 0.38f, 0f,
		-0.74f, 0.44f, 0f,
		-0.42f, 0.74f, 0f,
		-0.5f, 0.85f, 0f,
		0f, 0.74f, 0f,
		0f, 0.85f, 0f
	};
	// 部品C
	final float[] lockonmarker_dbl_outer_C = 
	{
		0.64f, 0.38f, 0f,
		0.74f, 0.44f, 0f,
		0.85f, 0f, 0f,
		1.0f, 0f, 0f,
		0.64f, -0.38f, 0f,
		0.74f, -0.44f, 0f
	};
	// 部品D
	final float[] lockonmarker_dbl_outer_D = 
	{
		-0.64f, -0.38f, 0f,
		-0.74f, -0.44f, 0f,
		-0.42f, -0.74f, 0f,
		-0.5f, -0.85f, 0f,
		0f, -0.74f, 0f,
		0f, -0.85f, 0
	};

	
	public IntBuffer	 panelVertexBuf;
	public IntBuffer	 panelUVBuf;
	
	public ByteBuffer  cubeIndexBuf;
	public IntBuffer	 cubeVertexBuf;
	public IntBuffer	 cubeColorBuf;
	
	public FloatBuffer reticulumFarA1Buf;
	public FloatBuffer reticulumFarA2Buf;
	public FloatBuffer reticulumFarBBuf;
	public FloatBuffer reticulumNearABuf;
	public FloatBuffer reticulumNearB1Buf;
	public FloatBuffer reticulumNearB2Buf;
	public FloatBuffer lockonInnerBuf;
	public FloatBuffer lockonOuterABuf;
	public FloatBuffer lockonOuterBBuf;
	public FloatBuffer dblLockonOuterABuf;
	public FloatBuffer dblLockonOuterBBuf;
	public FloatBuffer dblLockonOuterCBuf;
	public FloatBuffer dblLockonOuterDBuf;
	
	
	public Models()
	{
		// 平板の頂点バッファ、UVバッファを生成
		panelVertexBuf = makeIntBuffer( panel_vertices );
		panelUVBuf = makeIntBuffer( panel_UVs );
	
		// 立方体の頂点バッファ、色バッファ、描画リストバッファを生成
		cubeVertexBuf = makeIntBuffer( cube_vertices );
		cubeColorBuf = makeIntBuffer( cube_colors );
		cubeIndexBuf = makeByteBuffer( cube_indexs );
		
		// 遠距離照準
		reticulumFarA1Buf = makeFloatBuffer( reticulum_far_A1 );  
		reticulumFarA2Buf = makeFloatBuffer( reticulum_far_A2 );  
		reticulumFarBBuf = makeFloatBuffer( reticulum_far_B );  
		
		// 近距離照準
		reticulumNearABuf = makeFloatBuffer( reticulum_near_A );  
		reticulumNearB1Buf = makeFloatBuffer( reticulum_near_B1 );  
		reticulumNearB2Buf = makeFloatBuffer( reticulum_near_B2 );  

		// ロックオンマーカー 内側六角形 シングル/ダブル共用
		lockonInnerBuf = makeFloatBuffer( lockonmarker_inner );  
		
		// ロックオンマーカー シングル 外側 
		lockonOuterABuf = makeFloatBuffer( lockonmarker_outer_A );  
		lockonOuterBBuf = makeFloatBuffer( lockonmarker_outer_B );  
	
		// ロックオンマーカー ダブル 外側
		dblLockonOuterABuf = makeFloatBuffer( lockonmarker_dbl_outer_A );  
		dblLockonOuterBBuf = makeFloatBuffer( lockonmarker_dbl_outer_B );  
		dblLockonOuterCBuf = makeFloatBuffer( lockonmarker_dbl_outer_C );  
		dblLockonOuterDBuf = makeFloatBuffer( lockonmarker_dbl_outer_D );  
		
	}
	
	static public FloatBuffer makeFloatBuffer( float[] arr )
	{
		ByteBuffer bb = ByteBuffer.allocateDirect( arr.length * 4 );
		bb.order( ByteOrder.nativeOrder() );
		FloatBuffer b = bb.asFloatBuffer();
		b.put( arr );
		b.position( 0 );
		return b;
	}
	static public IntBuffer makeIntBuffer( int[] arr )
	{
		ByteBuffer bb = ByteBuffer.allocateDirect( arr.length * 4 );
		bb.order( ByteOrder.nativeOrder() );
		IntBuffer b = bb.asIntBuffer();
		b.put( arr );
		b.position( 0 );
		return b;
	}
	static public ByteBuffer makeByteBuffer( byte[] arr )
	{
		ByteBuffer bb = ByteBuffer.allocateDirect( arr.length * 4 );
		bb.put( arr );
		bb.position( 0 );
		return bb;
	}
	
	void setPanelBuffers( GL11 gl )
	{
		gl.glEnableClientState( GL11.GL_VERTEX_ARRAY );
		gl.glEnableClientState( GL11.GL_TEXTURE_COORD_ARRAY );
		gl.glDisableClientState( GL11.GL_COLOR_ARRAY );
		
		panelVertexBuf.position( 0 );
		panelUVBuf.position( 0 );
		gl.glVertexPointer( 2, GL11.GL_FIXED, 0, panelVertexBuf );
		gl.glTexCoordPointer( 2, GL11.GL_FIXED, 0, panelUVBuf );
	}

	void setCubeBuffers( GL11 gl )
	{
		gl.glEnableClientState( GL11.GL_VERTEX_ARRAY );
    gl.glDisableClientState( GL11.GL_TEXTURE_COORD_ARRAY );
		gl.glEnableClientState( GL11.GL_COLOR_ARRAY );
		
		cubeVertexBuf.position( 0 );
		cubeColorBuf.position( 0 );
		gl.glVertexPointer( 3, GL11.GL_FIXED, 0, cubeVertexBuf );
		gl.glColorPointer( 4, GL11.GL_FIXED, 0, cubeColorBuf );
	}
	
	public void drawPanel( GL11 gl, int textureid, int x, int y, int w, int h )
	{
    gl.glEnableClientState( GL11.GL_VERTEX_ARRAY );
    gl.glEnableClientState( GL11.GL_TEXTURE_COORD_ARRAY );
    gl.glDisableClientState( GL11.GL_COLOR_ARRAY );
    
    setPanelBuffers( gl );
    gl.glBindTexture( GL11.GL_TEXTURE_2D, textureid );
    gl.glPushMatrix();
	  gl.glTranslatex( x, -y, 0 );
	  gl.glScalef( w, h, 1 );
	  gl.glDrawArrays( GL11.GL_TRIANGLE_STRIP, 0, 4 );
    gl.glPopMatrix();
    gl.glBindTexture( GL11.GL_TEXTURE_2D, 0 );
	}
	
	void drawLine( GL11 gl, int x0, int y0, int x1, int y1, int[] color )
	{
		final int[] vertexs = { x0<<16, -y0<<16, 0, x1<<16, -y1<<16, 0 };
		final int[] colors = { color[ 0 ]<<16, color[ 1 ]<<16, color[ 2 ]<<16, color[ 3 ]<<16, color[ 0 ]<<16, color[ 1 ]<<16, color[ 2 ]<<16, color[ 3 ]<<16 }; 
		
    gl.glEnableClientState( GL11.GL_VERTEX_ARRAY );
    gl.glDisableClientState( GL11.GL_TEXTURE_COORD_ARRAY );
		gl.glEnableClientState( GL11.GL_COLOR_ARRAY );
		
		gl.glVertexPointer( 3, GL11.GL_FIXED, 0, makeIntBuffer( vertexs ) );
		gl.glColorPointer( 4, GL11.GL_FIXED, 0, makeIntBuffer( colors ) );
		gl.glPushMatrix();
		gl.glDrawArrays( GL11.GL_LINE_STRIP, 0, 2 );
		gl.glPopMatrix();
	}
	
	void drawReticulumFar( GL11 gl, int x, int y, int scale )
	{
    gl.glEnableClientState( GL11.GL_VERTEX_ARRAY );
    gl.glDisableClientState( GL11.GL_TEXTURE_COORD_ARRAY );
		gl.glDisableClientState( GL11.GL_COLOR_ARRAY );
		
		gl.glColor4x( 1<<16, (1<<16)/2, (1<<16)/10, 1<<16 );
		
		gl.glPushMatrix();
	  gl.glTranslatex( x<<16, -y<<16, 0 );
	  gl.glScalex( scale<<16, scale<<16, scale<<16 );
		
		// 内側
		gl.glVertexPointer( 3, GL11.GL_FLOAT, 0, reticulumFarA1Buf );
		gl.glDrawArrays( GL11.GL_TRIANGLE_STRIP, 0, 4 );
		gl.glVertexPointer( 3, GL11.GL_FLOAT, 0, reticulumFarA2Buf );
		gl.glDrawArrays( GL11.GL_TRIANGLE_STRIP, 0, 4 );
	
		// 外側
    boolean c = gl.glIsEnabled( GL11.GL_CULL_FACE );
    gl.glDisable( GL11.GL_CULL_FACE );	// 裏面も描画
		gl.glVertexPointer( 3, GL11.GL_FLOAT, 0, reticulumFarBBuf );
		for ( int i=0; i<2; i++ )
		{
			for ( int k=0; k<2; k++ )
			{
				gl.glDrawArrays( GL11.GL_TRIANGLE_STRIP, 0, 8 );
				gl.glRotatex( 180<<16, 1<<16, 0, 0 );
			}
			gl.glRotatex( 180<<16, 0, 1<<16, 0 );
		}
		if ( c )
			gl.glEnable( GL11.GL_CULL_FACE );
		
		gl.glPopMatrix();
		gl.glColor4x( 1<<16, 1<<16, 1<<16, 1<<16 );
	}

	void drawReticulumNear( GL11 gl, int x, int y, int scale )
	{
    gl.glEnableClientState( GL11.GL_VERTEX_ARRAY );
    gl.glDisableClientState( GL11.GL_TEXTURE_COORD_ARRAY );
		gl.glDisableClientState( GL11.GL_COLOR_ARRAY );
		
		gl.glColor4x( 1<<16, (1<<16)/2, (1<<16)/10, 1<<16 );
		
		gl.glPushMatrix();
	  gl.glTranslatex( x<<16, -y<<16, 0 );
	  gl.glScalex( scale<<16, scale<<16, scale<<16 );
		
	
    boolean c = gl.glIsEnabled( GL11.GL_CULL_FACE );
    gl.glDisable( GL11.GL_CULL_FACE );	// 裏面も描画
		for ( int i=0; i<2; i++ )
		{
			for ( int k=0; k<2; k++ )
			{
				gl.glVertexPointer( 3, GL11.GL_FLOAT, 0, reticulumNearABuf );
				gl.glDrawArrays( GL11.GL_TRIANGLE_STRIP, 0, 8 );
				gl.glVertexPointer( 3, GL11.GL_FLOAT, 0, reticulumNearB1Buf );
				gl.glDrawArrays( GL11.GL_TRIANGLE_STRIP, 0, 4 );
				gl.glVertexPointer( 3, GL11.GL_FLOAT, 0, reticulumNearB2Buf );
				gl.glDrawArrays( GL11.GL_TRIANGLE_STRIP, 0, 4 );
				gl.glRotatex( 180<<16, 1<<16, 0, 0 );
			}
			gl.glRotatex( 180<<16, 0, 1<<16, 0 );
		}
		if ( c )
			gl.glEnable( GL11.GL_CULL_FACE );
		
		gl.glPopMatrix();
		gl.glColor4x( 1<<16, 1<<16, 1<<16, 1<<16 );
	}
	
	void drawLockonCursor( GL11 gl, int x, int y, int scale, boolean isDrawOuter )
	{
    gl.glEnableClientState( GL11.GL_VERTEX_ARRAY );
    gl.glDisableClientState( GL11.GL_TEXTURE_COORD_ARRAY );
		gl.glDisableClientState( GL11.GL_COLOR_ARRAY );
		
		gl.glColor4x( 1<<16, (1<<16)/2, (1<<16)/5, 1<<16 );
		
		gl.glPushMatrix();
	  gl.glTranslatex( x<<16, -y<<16, 0 );
	  gl.glScalex( scale<<16, scale<<16, scale<<16 );
		
	
    boolean c = gl.glIsEnabled( GL11.GL_CULL_FACE );
    gl.glDisable( GL11.GL_CULL_FACE );	// 裏面も描画

		gl.glVertexPointer( 3, GL11.GL_FLOAT, 0, lockonInnerBuf );
		gl.glDrawArrays( GL11.GL_TRIANGLE_STRIP, 0, 14 );
		if ( isDrawOuter )
		{
			gl.glPushMatrix();
			gl.glVertexPointer( 3, GL11.GL_FLOAT, 0, lockonOuterABuf );
			gl.glDrawArrays( GL11.GL_TRIANGLE_STRIP, 0, 10 );
			gl.glRotatex( 180<<16, 0, 1<<16, 0 );
			gl.glDrawArrays( GL11.GL_TRIANGLE_STRIP, 0, 10 );
			gl.glPopMatrix();
			gl.glVertexPointer( 3, GL11.GL_FLOAT, 0, lockonOuterBBuf );
			gl.glDrawArrays( GL11.GL_TRIANGLE_STRIP, 0, 10 );
		}
    
    if ( c )
			gl.glEnable( GL11.GL_CULL_FACE );
		
		gl.glPopMatrix();
		gl.glColor4x( 1<<16, 1<<16, 1<<16, 1<<16 );
	}
	

	void drawDoubleLockonCursor( GL11 gl, int x, int y, int scale, int angle )
	{
    gl.glEnableClientState( GL11.GL_VERTEX_ARRAY );
    gl.glDisableClientState( GL11.GL_TEXTURE_COORD_ARRAY );
		gl.glDisableClientState( GL11.GL_COLOR_ARRAY );
		
		gl.glColor4x( 1<<16, (1<<16)/2, (1<<16)/5, 1<<16 );
		
		gl.glPushMatrix();
	  gl.glTranslatex( x<<16, -y<<16, 0 );
	  gl.glScalex( scale<<16, scale<<16, scale<<16 );
	
    boolean c = gl.glIsEnabled( GL11.GL_CULL_FACE );
    gl.glDisable( GL11.GL_CULL_FACE );	// 裏面も描画

		gl.glVertexPointer( 3, GL11.GL_FLOAT, 0, lockonInnerBuf );
		gl.glDrawArrays( GL11.GL_TRIANGLE_STRIP, 0, 14 );

		gl.glRotatex( angle, 0, 0, 1<<16 );
		gl.glVertexPointer( 3, GL11.GL_FLOAT, 0, dblLockonOuterABuf );
		gl.glDrawArrays( GL11.GL_TRIANGLE_STRIP, 0, 14 );
		gl.glVertexPointer( 3, GL11.GL_FLOAT, 0, dblLockonOuterBBuf );
		gl.glDrawArrays( GL11.GL_TRIANGLE_STRIP, 0, 6 );
		gl.glVertexPointer( 3, GL11.GL_FLOAT, 0, dblLockonOuterCBuf );
		gl.glDrawArrays( GL11.GL_TRIANGLE_STRIP, 0, 6 );
		gl.glVertexPointer( 3, GL11.GL_FLOAT, 0, dblLockonOuterDBuf );
		gl.glDrawArrays( GL11.GL_TRIANGLE_STRIP, 0, 6 );
    
    if ( c )
			gl.glEnable( GL11.GL_CULL_FACE );
		
		gl.glPopMatrix();
		gl.glColor4x( 1<<16, 1<<16, 1<<16, 1<<16 );
	}
}
