/*******************************************************
 *
 * Author: Hirokazu Kato
 *
 *         kato@sys.im.hiroshima-cu.ac.jp
 *
 * Revision: 2.1
 * Date: 99/07/16
 *
*******************************************************/

#include <stdio.h>
#include <math.h>
#include <AR/param.h>

#define  PD_LOOP   3

int arParamObserv2Ideal( const ARVAL dist_factor[4], const ARVAL ox, const ARVAL oy,
                         ARVAL *ix, ARVAL *iy )
{
    ARDBL  z02, z0, p, q, z, px, py;
    int     i;

    px = ARVALtoARDBL( ox - dist_factor[0] );
    py = ARVALtoARDBL( oy - dist_factor[1] );
    p = DivARDBL( ARVALtoARDBL( dist_factor[2] ), IntToARDBL( 100000000 ) );
    z02 = MulARDBL(px, px) + MulARDBL(py, py);
    q = z0 = SqrtARDBL( z02 );

    for( i = 1; ; i++ ) {
        if( z0 != 0 ) {
            z = z0 - DivARDBL( (MulARDBL( (IntToARDBL( 1 ) - MulARDBL( p, z02 )), z0 ) - q), (IntToARDBL( 1 ) - 3*MulARDBL( p, z02 )) );
            px = DivARDBL( MulARDBL( px, z ), z0 );
            py = DivARDBL( MulARDBL( py, z ), z0 );
        }
        else {
            px = 0;
            py = 0;
            break;
        }
        if( i == PD_LOOP ) break;

        z02 = MulARDBL( px, px ) + MulARDBL( py, py );
        z0 = SqrtARDBL( z02 );
    }

    *ix = ARDBLtoARVAL( DivARDBL( px, dist_factor[3] ) ) + dist_factor[0];
    *iy = ARDBLtoARVAL( DivARDBL( py, dist_factor[3] ) ) + dist_factor[1];

    return(0);
}

int arParamIdeal2Observ( const ARVAL dist_factor[4], const ARVAL ix, const ARVAL iy,
                         ARVAL *ox, ARVAL *oy )
{
    ARVAL    x, y, d;

    x = MulARVAL( (ix - dist_factor[0]), dist_factor[3] );
    y = MulARVAL( (iy - dist_factor[1]), dist_factor[3] );
    if( x == 0 && y == 0 ) {
        *ox = dist_factor[0];
        *oy = dist_factor[1];
    }
    else {
        d = IntToARVAL( 1 ) - MulARVAL( (MulARVAL(x,x) + MulARVAL(y,y))/IntToARVAL( 10000 ), dist_factor[2]/IntToARVAL( 10000 ) );
        *ox = MulARVAL( x, d ) + dist_factor[0];
        *oy = MulARVAL( y, d ) + dist_factor[1];
    }

    return(0);
}
