package noguchi.Shadowinkun;

import android.app.ListActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.Toast;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.ArrayAdapter;

import java.io.File;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class FileSelectorActivity extends ListActivity {
	final public static String INTENT_EXTENSION = "ext";
	final public static String INTENT_FILENAME = "filename";
	final public static String INTENT_FILEPATH = "filepath";

	private String m_strDirPath;
	private String[] extension = null;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.fileselector);

		// LZ̖߂l̎w
		setResult(RESULT_CANCELED);

		Bundle extras = getIntent().getExtras();
		// gq̎擾
		if (extras != null) {
			extension = (String[]) extras.get(INTENT_EXTENSION);
		}

		// sdcardJgɂăXg\z
		// This should be imporved!!
		m_strDirPath = "/sdcard/external_sd/Music";
		fillList();

	}

	@Override
	protected void onListItemClick(ListView l, View v, int position, long id) {
		super.onListItemClick(l, v, position, id);
		// XgA_v^猻ݑI𒆂̃t@C^fBNg擾
		String strItem = (String) getListAdapter().getItem(position);

		if (strItem.equals("..")) {
			// fBNg1Kwオꍇ
			if (m_strDirPath.lastIndexOf("/") <= 0) {
				// [g1Kwڂ̏ꍇ
				m_strDirPath = m_strDirPath.substring(0, m_strDirPath
						.lastIndexOf("/") + 1);
			} else {
				// [g2Kwڈȏ̏ꍇ
				m_strDirPath = m_strDirPath.substring(0, m_strDirPath
						.lastIndexOf("/"));
			}
			fillList();
		} else if (strItem.substring(strItem.length() - 1).equals("/")) {
			// fBNgɓꍇ
			if (m_strDirPath.equals("/")) {
				// [g̏ꍇ
				m_strDirPath += strItem;
			} else {
				// [g1Kwڈȏ̏ꍇ
				m_strDirPath = m_strDirPath + "/" + strItem;
			}
			m_strDirPath = m_strDirPath.substring(0, m_strDirPath.length() - 1);
			fillList();
		} else {
			// t@C̏ꍇ͉ɐݒ
			setResult(RESULT_OK, getIntent().putExtra(INTENT_FILENAME, strItem)
					.putExtra(INTENT_FILEPATH, m_strDirPath + "/" + strItem));
			// ANeBreB̏I
			finish();
		}
	}

	// t@CXg\z
	private void fillList() {
		File[] files = new File(m_strDirPath).listFiles();
		if (files == null) {
			Toast.makeText(FileSelectorActivity.this, "Unable Access...",
					Toast.LENGTH_SHORT).show();
			return;
		}

		// fBNg啶ŖOɂȂ悤Ƀ\[g
		Arrays.sort(files, new Comparator<File>() {
			@Override
			public int compare(File object1, File object2) {
				final boolean isdir1 = object1.isDirectory();
				final boolean isdir2 = object2.isDirectory();

				if (isdir1 ^ isdir2) {
					if (isdir1) {
						return -1;
					} else {
						return 1;
					}
				}
				return object1.getName().compareToIgnoreCase(object2.getName());
			}
		});

		// JgfBNgTextViewɐݒ
		TextView txtDirName = (TextView) findViewById(R.id.txtDirName);
		txtDirName.setText(m_strDirPath);

		ArrayList<String> items = new ArrayList<String>();

		// [gȂꍇ́AKwオ悤".."ArrayList̐擪ɐݒ
		if (!m_strDirPath.equals("/")) {
			items.add("..");
		}

		// t@C͊gqɈv́AfBNg͑SAArrayListɒǉ
		for (File file : files) {
			if (file.isDirectory()) {
				items.add(file.getName() + "/");
			} else {
				if (extension != null) {
					String name = file.getName();
					String smallname = name.toLowerCase();
					for (String ext : extension) {
						if (smallname.endsWith(ext)) {
							items.add(name);
							break;
						}
					}
				} else {
					items.add(file.getName());
				}
			}
		}

		// ArrayListListActivityɐݒ肷
		ArrayAdapter<String> fileList = new ArrayAdapter<String>(this,
				R.layout.file_row, items);
		setListAdapter(fileList);
	}

}
