#pragma once

#include <Poco/StreamCopier.h>
#include <d3d9.h>
#include <d3dx9.h>
#define DIRECTINPUT_VERSION 0x0800
#include <dinput.h>
#include <Poco/ActiveMethod.h>
#include <Poco/ActiveResult.h>
#include <Poco/FileStream.h>
#include <Poco/Logger.h>
#include <Poco/Mutex.h>
#include <Poco/Thread.h>
#include <Poco/Runnable.h>
#include <map>
#include <string>
#include <vector>
#include <queue>

#include "Common.h"

#include "Container.h"
#include "Renderer.h"
#include "Scene.h"
#include "Transition.h"
#include "Workspace.h"

using std::string;
using std::vector;
using std::queue;
using std::map;

using Poco::ActiveMethod;
using Poco::ActiveResult;


/**
 * Đp[^.
 */
struct PlayParameters
{
	string playlistID;
	int i;
	string action;
	string transition;
};

/**
 * [oufBA֘A.
 */
struct RemovableMediaArgs {
	const string& driveLetter;
};


/**
 * xĴ߂̃Reiz_.
 */
class DelayedRelease {
private:
	Poco::Timestamp t;
	ContainerPtr c;

	DelayedRelease& copy(const DelayedRelease& dr) {
		t = dr.t;
		c = dr.c;
		return *this;
	}

public:
	DelayedRelease(ContainerPtr _c) {
		Poco::DateTime now;
		t = now.timestamp();
		c = _c;
	}

	virtual ~DelayedRelease() {
	}

	DelayedRelease& operator=(const DelayedRelease& dr) {
		return copy(dr);
    }

	const Poco::Timestamp& timestamp() {
		return t;
	}

	const ContainerPtr& container() {
		return c;
	}
};


/**
 * CV[NX.
 * fW^TCl[WvC̊{Iȋ@\񋟂܂
 */
class MainScene: public Scene
{
private:
	Poco::FastMutex _lock;
	Poco::FastMutex _workspaceLock;
	Poco::FastMutex _delayedUpdateLock;

	WorkspacePtr _workspace;
	WorkspacePtr _updatedWorkspace;

	DWORD _frame;
	bool _startup;
	bool _autoStart;
	int _brightness;

	vector<ContainerPtr> _contents;
	int _currentContent;
	bool _preparing;

	/** ĐRec */
	PlayParameters _playCurrent;

	/**  */
	LPDIRECT3DTEXTURE9 _description;
	/** vCXg */
	LPDIRECT3DTEXTURE9 _playlistName;
	/** Đ̃Rec */
	LPDIRECT3DTEXTURE9 _currentName;

	vector<PlayParameters> _nextStack;
	int _nextStackTime;

	/** ĐRec */
	PlayParameters _playNext;

	/** ̃vCXg */
	LPDIRECT3DTEXTURE9 _nextPlaylistName;
	/** ̃Rec */
	LPDIRECT3DTEXTURE9 _nextName;

	vector<PlayParameters> _prepareStack;
	int _prepareStackTime;

	/** ؑ֏Rec */
	PlayParameters _playPrepared;

	/** ؑ֏Rec */
	ContainerPtr _prepared;

	/** ؑ֏̃vCXg */
	LPDIRECT3DTEXTURE9 _preparedPlaylistName;
	/** ؑ֏̃Rec */
	LPDIRECT3DTEXTURE9 _preparedName;

	/** Đ */
	int _playCount;
	bool _doPrepareNext;
	bool _preparingNext;
	/** ؑփtO */
	bool _doSwitchNext;
	/** ؑ֏Rec̐ؑփtO */
	bool _doSwitchPrepared;
	/** gWV */
	TransitionPtr _transition;

	/** ݎ */
	string _nowTime;
	/** ݎ̕b */
	int _timeSecond;

	bool _initializing;
	bool _running;

	string _castLogDate;
	Poco::FileOutputStream* _castLog;

	/** XVXgbNt@C */
	map<string, File> _stock;

	/** USBACR */
	LPDIRECT3DTEXTURE9 _removableIcon;
	float _removableIconAlpha;
	string _addRemovable;
	float _removableAlpha;
	float _removableCover;
	unsigned long _copySize;
	unsigned long _currentCopySize;
	int _copyProgress;
	int _currentCopyProgress;
	int _copyRemoteFiles;
	string _copyingRemote;
	bool _delayedCopy;
	vector<File> _delayUpdateFiles;

	vector<DelayedRelease> _delayReleases;
	queue<string> _deletes;

	/** X^oCfBA */
	map<string, ContainerPtr> _stanbyMedias;
	string _interruptted;
	ContainerPtr _interrupttedContent;

	/** bZ[W */
	DWORD _messageFrame;
	queue<string> _messages;


	/** Rec̒xs܂ */
	void execDelayedRelease();

	/** Rec̒xs܂ */
	void pushDelayedRelease(ContainerPtr c);

	/** X^oCfBȀ */
	void preparedStanbyMedia();

	/** tHg̏ */
	void preparedFont(WorkspacePtr workspace);

	void run();

	/** ؑ֗pRec̏ */
	bool prepareContent(const PlayParameters& args);

	/** ĐRec܂ */
	bool prepareNextContent(const PlayParameters& args);

	/** ContainerɎw肳ꂽvCXg̃Rec܂ */
	bool preparePlaylist(ContainerPtr container, const string& playlistID, const int i, const bool round = false);

	bool prepareMedia(ContainerPtr container, MediaItemPtr media, const string& templatedText);

	void addRemovableMedia(const string& driveLetter);

	int copyFiles(const string& src, const string& dst);

	/** [gRs[ */
	void copyRemote(const string& remote);

	bool copyRemoteFile(const string& remote, const string& path, Path& out, bool equalityCheck = false);

	void setRemoteStatus(const string& remote, const string& name, const string& value);

	/** [gfBNg̃Rs[ */
/*	bool copyRemoteDir(const string& remote, const string& root);
*/
	/** ĐRec(ANeBu) */
	ActiveMethod<bool, PlayParameters, MainScene> activePrepareNextContent;


public:
	MainScene(Renderer& renderer);

	virtual ~MainScene();

	/**  */
	bool initialize();

	/** ݒ肳ĂWorkspace擾܂ */
	Workspace& getWorkspace();

	void notifyKey(const int keycode, const bool shift, const bool ctrl);

	/** ؑ֗pRecX^bN܂ */
	bool stackPrepareContent(string& playlistID, int i = 0);

	/** ݒ */
	const void setDescription(const string& description);

	/** vCXgeLXg擾 */
	const string getPlaylistText(const string& playlistID);

	/** vCXgeLXgݒ */
	bool setPlaylistText(const string& playlistID, const string& text);

	/** Pxݒ */
	void setBrightness(int i);

	/** JڃANVݒ */
	void setAction(string& action);

	/** gWVݒ */
	void setTransition(string& transition);

	/** ؑ֗pRec̏(ANeBu) */
	ActiveMethod<bool, PlayParameters, MainScene> activePrepareContent;

	/**
	 * 蓮Őؑւs܂
	 * ̃\bh̓CXbhubN̂ŃCXbhactiveSwitchContent()Ōďo
	 */
	bool switchContent();

	/** ؑ֗pRecɐؑ(ANeBu) */
	ActiveMethod<bool, void, MainScene> activeSwitchContent;

	bool addStock(const string& path, File file, bool copy = false);

	void clearStock();

	bool flushStock();

	/** xXVt@Cǉ܂ */
	void addDelayedUpdateFile(File& file);

	/** xXVt@Cǉ܂ */
	void removeDelayedUpdateFile(File& file);

	/** xXVt@CXV܂ */
	void updateDelayedFiles();

	/** workspaceXV */
	bool updateWorkspace();

	/** [gRs[ (ANeBu) */
	ActiveMethod<void, string, MainScene> activeCopyRemote;

	/** [oufBA̒ǉ(ANeBu) */
	ActiveMethod<void, string, MainScene> activeAddRemovableMedia;

	/** t[ōs */
	virtual void process();

	/**
	 * t[`
	 * RecȂǂ̃C`n
	 */
	virtual void draw1();

	/**
	 * t[`
	 * ɃXe[^Xn
	 */
	virtual void draw2();

	/** R\[\ */
	void drawConsole(string text);
};

typedef MainScene* MainScenePtr;
