#ifdef USE_FLASH

//#define _ATL_APARTMENT_THREADED
//#define _ATL_FREE_THREADED
//#define _ATL_NO_AUTOMATIC_NAMESPACE
//#define _ATL_CSTRING_EXPLICIT_CONSTRUCTORS

//#include <windows.h>
#include <atlbase.h>
//#include <atlbase.h>
//#include <atlwin.h>
#include "FlashContent.h"
#include <Poco/UnicodeConverter.h>
//#include <Poco/DateTime.h>
//#include <Poco/Timezone.h>
#include "Utils.h"


FlashContent::FlashContent(Renderer& renderer, float x, float y, float w, float h): Content(renderer, x, y, w, h),
	_module(NULL), _controlSite(NULL), _ole(NULL), _flash(NULL), _windowless(NULL), _view(NULL),
	_buf(NULL)
{
	initialize();
}

FlashContent::~FlashContent() {
	close();
	SAFE_RELEASE(_view);
	SAFE_RELEASE(_windowless);
	SAFE_RELEASE(_flash);
	SAFE_RELEASE(_ole);
	SAFE_RELEASE(_controlSite);
	if (_module) FreeLibrary(_module);	
}

void FlashContent::initialize() {
	_controlSite = new ControlSite();
	//_controlSite->Init(this);

	HRESULT hr;
	_module = LoadLibraryA("C:\\WINDOWS\\system32\\macromed\\Flash\\flash10e.ocx");
	if (_module == NULL) {
		_module = LoadLibraryA("flash.ocx");
	}
	if (_module != NULL) {
		IClassFactory* classFactory = NULL;
		DllGetClassObjectFunc aDllGetClassObjectFunc = (DllGetClassObjectFunc)GetProcAddress(_module, "DllGetClassObject");
		hr = aDllGetClassObjectFunc(CLSID_ShockwaveFlash, IID_IClassFactory, (void**)&classFactory);
		classFactory->CreateInstance(NULL, IID_IOleObject, (void**)&_ole);
		classFactory->Release();	
	} else {
		// XCLSCTX_ALL CLSCTX_INPROC_SERVER CLSID_ShockwaveFlash
		hr = CoCreateInstance(CLSID_ShockwaveFlash, NULL, CLSCTX_INPROC_SERVER, IID_IOleObject, (void**)&_ole);
		if FAILED(hr) {
			_log.warning("failed not created 'ShockwaveFlash' class");
			return;
		}
	}

	IOleClientSite* clientSite = NULL;
	hr = _controlSite->QueryInterface(__uuidof(IOleClientSite), (void**)&clientSite);
	if FAILED(hr) {
		_log.warning("failed not query 'IOleClientSite'");
		return;
	}
	hr = _ole->SetClientSite(clientSite);
	if FAILED(hr) {
		_log.warning("failed SetClientSite");
		return;
	}

	hr = _ole->QueryInterface(__uuidof(IShockwaveFlash), (LPVOID*)&_flash);
	if FAILED(hr) {
		_log.warning("failed not query 'IShockwaveFlash'");
		return;
	}
	long ver = _flash->FlashVersion();
	_log.information(Poco::format("flash version: %f", (ver / 65536.0)));
	hr = _flash->put_WMode(L"Transparent");

	hr = _ole->DoVerb(OLEIVERB_INPLACEACTIVATE, NULL, clientSite, 0, NULL, NULL);
	if FAILED(hr) {
		_log.warning("failed DoVerb");
		//return;
	}
	clientSite->Release();

	hr = _ole->QueryInterface(__uuidof(IOleInPlaceObjectWindowless), (LPVOID*)&_windowless);
	if FAILED(hr) {
		_log.warning("failed not query 'IOleInPlaceObjectWindowless'");
		//return;
	}
	hr = _flash->QueryInterface(IID_IViewObject, (LPVOID*)&_view);
	if FAILED(hr) {
		_log.warning("failed not query 'IViewObject'");
		return;
	}
	_log.information("flash initialized");
}

/** t@CI[v܂ */
bool FlashContent::open(const MediaItemPtr media, const int offset) {
	//Poco::ScopedLock<Poco::FastMutex> lock(_lock);
	if (!_flash) return false;

	//load the movie
	//_log.information(Poco::format("ready state before: %ld", _flash->ReadyState));
	MediaItemFile mif = media->files()[0];
	string file;
	if (mif.file().find("http://") != string::npos) {
		file = mif.file();
	} else {
		//file = "file://" + Path(mif.file()).absolute(config().dataRoot).toString(Poco::Path::PATH_UNIX);
		file = Path(mif.file()).absolute(config().dataRoot).toString();
	}
	//string sjis;
	//svvitch::utf8_sjis(file, sjis);
	wstring wfile;
	Poco::UnicodeConverter::toUTF16(file, wfile);
	HRESULT hr = _flash->put_Movie(_bstr_t(wfile.c_str()));   
	if (FAILED(hr)) {
		_log.warning(Poco::format("failed movie: %s", file));
		return false;
	}
	_buf = _renderer.createTexture(L(_w), L(_h), D3DFMT_X8R8G8B8);
	IOleInPlaceObject* inPlaceObject = NULL;     
	hr = _ole->QueryInterface(__uuidof(IOleInPlaceObject), (LPVOID*) &inPlaceObject);
	if SUCCEEDED(hr) {
		RECT rect;
		::SetRect(&rect, _x, _y, _w, _h);
		inPlaceObject->SetObjectRects(&rect, &rect);   
		inPlaceObject->Release();   
	} else {
		_log.warning("failed query 'IOleInPlaceObject'");
		return false;
	}

	set("alpha", 1.0f);
	_duration = media->duration() * 60 / 1000;
	_current = 0;
	_mediaID = media->id();
	return true;
}


/**
 * Đ
 */
void FlashContent::play() {
	_playing = true;
	if (_flash) _flash->Play();
}

/**
 * ~
 */
void FlashContent::stop() {
	_playing = false;
	if (_flash) _flash->Stop();
}

bool FlashContent::useFastStop() {
	return true;
}

/**
 * Đǂ
 */
const bool FlashContent::playing() const {
	if (_flash && _playing) {
		return _flash->IsPlaying() == VARIANT_TRUE;
	}
	return _playing;
}

const bool FlashContent::finished() {
	if (_flash && _playing) {
		return _flash->IsPlaying() == VARIANT_FALSE;
	}
	return true;
	//return _current >= _duration;
}

/** t@CN[Y܂ */
void FlashContent::close() {
	stop();
	_mediaID.clear();
	SAFE_RELEASE(_buf);
}

void FlashContent::process(const DWORD& frame) {
	if (_flash && _playing && _buf) {
		LPDIRECT3DSURFACE9 surface = NULL;
		_buf->GetSurfaceLevel(0, &surface);
		if (surface) {
			HDC hdc = NULL;
			HRESULT hr = surface->GetDC(&hdc);
			if SUCCEEDED(hr) {
				if (_view != NULL) {
					// RECT is relative to the windowless container rect
					RECTL rectl = {0, 0, L(_w), L(_h)};
					//HBRUSH brush = CreateSolidBrush(RGB(255, 255, 255));
					//FillRect(hdc, (RECT*)&rectl, brush);
					hr = _view->Draw(DVASPECT_CONTENT, 1, NULL, NULL, NULL, hdc, &rectl, NULL, NULL, 0);
					if FAILED(hr) _log.warning("failed draw");
					//DeleteObject(brush);
				}
				surface->ReleaseDC(hdc);
			} else {
				_log.warning("failed getDC");
			}
			surface->Release();
		} else {
			_log.warning("failed get surface");
		}
	}
}

void FlashContent::draw(const DWORD& frame) {
	if (_flash && _playing && _buf) {
		DWORD col = 0xffffffff;
		_renderer.drawTexture(_x, _y, _buf, 0, col, col, col, col);
	}
}

#endif
