#pragma once

#include <map>
#include <string>
#include <vector>
#include <Poco/Path.h>

using std::map;
using std::string;
using std::wstring;
using std::vector;
using Poco::Path;


namespace svvitch {
	/** SJIS>UTF-8ɕϊ */
	void sjis_utf8(const string& in, string& out);

	/** SJIS>UTF-16ɕϊ */
	void sjis_utf16(const string& in, wstring& out);

	/** UTF16->SJISɕϊ */
	void utf16_sjis(const wstring& wstr, string& out);

	/** UTF-8->SJISɕϊ */
	void utf8_sjis(const string& str, string& out);

	/** TutH_܂ރt@CԂ܂ */
	int fileCount(const Path& path);

	/** t@CMD5VOlC`擾 */
	string md5(const Path& path);

	/** 񌋍 */
	string join(const vector<string>& v, const string& c);

	/** 񕪊 */
	void split(const string& s, char c, vector<string>& v, int splits = 0);

	/** JSON񐶐 */
	string formatJSON(const map<string, string>& json);

	/** JSONz񕶎񐶐 */
	string formatJSONArray(const vector<string>& list);

	string trimQuotationMark(const string& s);

	void parseJSON(const string& json, map<string, string>& map);

	void parseJSONArray(const string& json, vector<string>& v);

	/** src̒̍Ōfindȍ~̕擾܂ */
	string findLastOfText(const string& src, const string& find);
}
