/*
 * Created on 2004/12/04
 */
package jp.co.isic.HoroScope;

import java.awt.*;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import javax.imageio.ImageIO;

/**
 * ۥײ饹 jp.co.isic.HoroScope.ImageReader
 * @author Atsuji Okuyama
 */
public class ImageReader implements ImageObserver {

	/**
	 * ١ <code>base</code>
	 */
	private BufferedImage[]		base;
	/**
	 *  <code>StarObj</code>
	 */
	private BufferedImage[]		StarObj;
	/**
	 * ² <code>ZodiacObj</code>
	 */
	private BufferedImage[]		ZodiacObj;
	/**
	 *  Graphics <code>horoscope</code>
	 */
	private Graphics			horoscope;

	/**
	 * ɽ
	 * <code>zXpos</code>
	 */
	private static final int	zXpos[]	=
										{7, 26, 80, 148, 216, 270, 290, 270,
			216, 148, 80, 26			};
	/**
	 * ɽ
	 * <code>zYpos</code>
	 */
	private static final int	zYpos[]	=
										{148, 220, 272, 286, 272, 220, 148, 76,
			24, 12, 24, 76				};
	/**
	 * ɽ
	 * <code>sXpos</code>
	 */
	private static final int	sXpos[]	=
										{42, 45, 49, 54, 61, 70, 81, 92, 105,
			119, 133, 147, 162, 176, 190, 203, 216, 228, 238, 247, 255, 260,
			263, 266, 266, 263, 259, 254, 247, 238, 227, 216, 203, 189, 175,
			161, 146, 132, 118, 105, 92, 80, 70, 61, 53, 48, 45, 42, 63, 57,
			67, 66, 79, 80, 93, 99, 116, 122, 136, 146, 162, 173, 184, 196,
			206, 219, 224, 235, 237, 248, 244, 252, 245, 251, 241, 242, 229,
			228, 215, 209, 192, 186, 172, 162, 146, 135, 124, 112, 102, 89, 84,
			73, 71, 60, 64, 56, 82, 72, 86, 79, 95, 92, 107, 107, 125, 128,
			140, 147, 162, 170, 177, 189, 197, 210, 208, 222, 221, 233, 225,
			237, 226, 236, 222, 229, 213, 216, 201, 201, 183, 180, 168, 161,
			146, 138, 131, 119, 111, 98, 100, 86, 87, 75, 83, 71};
	/**
	 * ɽ
	 * <code>sYpos</code>
	 */
	private static final int	sYpos[]	=
										{162, 176, 190, 203, 216, 228, 238,
			247, 255, 260, 263, 266, 266, 263, 259, 254, 247, 238, 227, 216,
			203, 189, 175, 161, 146, 132, 118, 105, 92, 80, 70, 61, 53, 48, 45,
			42, 42, 45, 49, 54, 61, 70, 81, 92, 105, 119, 133, 147, 162, 173,
			184, 196, 206, 219, 224, 235, 237, 248, 244, 252, 245, 251, 241,
			242, 229, 228, 215, 209, 192, 186, 172, 162, 146, 135, 124, 112,
			102, 89, 84, 73, 71, 60, 64, 56, 63, 57, 67, 66, 79, 80, 93, 99,
			116, 122, 136, 146, 162, 170, 177, 189, 197, 210, 208, 222, 221,
			233, 225, 237, 226, 236, 222, 229, 213, 216, 201, 201, 183, 180,
			168, 161, 146, 138, 131, 119, 111, 98, 100, 86, 87, 75, 83, 71, 82,
			72, 86, 79, 95, 92, 107, 107, 125, 128, 140, 147};

	/**
	 * 󥹥ȥ饯
	 */
	public ImageReader() throws IOException {
		base = new BufferedImage[3];
		StarObj = new BufferedImage[10];
		ZodiacObj = new BufferedImage[12];
		try {
			base[0] = ImageIO.read(getUrl("img/base.png"));
			base[1] = ImageIO.read(getUrl("img/do.png"));
			base[2] = ImageIO.read(getUrl("img/moon16.png"));

			StarObj[0] = ImageIO.read(getUrl("img/taiyou12.png"));
			StarObj[1] = ImageIO.read(getUrl("img/tuki12.png"));
			StarObj[2] = ImageIO.read(getUrl("img/suisei12.png"));
			StarObj[3] = ImageIO.read(getUrl("img/kinsei12.png"));
			StarObj[4] = ImageIO.read(getUrl("img/kasei12.png"));
			StarObj[5] = ImageIO.read(getUrl("img/mokusei12.png"));
			StarObj[6] = ImageIO.read(getUrl("img/dosei12.png"));
			StarObj[7] = ImageIO.read(getUrl("img/tennou12.png"));
			StarObj[8] = ImageIO.read(getUrl("img/kaiou12.png"));
			StarObj[9] = ImageIO.read(getUrl("img/meiou12.png"));

			ZodiacObj[0] = ImageIO.read(getUrl("img/ohitsuji.png"));
			ZodiacObj[1] = ImageIO.read(getUrl("img/ousi.png"));
			ZodiacObj[2] = ImageIO.read(getUrl("img/futago.png"));
			ZodiacObj[3] = ImageIO.read(getUrl("img/kani.png"));
			ZodiacObj[4] = ImageIO.read(getUrl("img/shishi.png"));
			ZodiacObj[5] = ImageIO.read(getUrl("img/otome.png"));
			ZodiacObj[6] = ImageIO.read(getUrl("img/tenbin.png"));
			ZodiacObj[7] = ImageIO.read(getUrl("img/sasori.png"));
			ZodiacObj[8] = ImageIO.read(getUrl("img/ite.png"));
			ZodiacObj[9] = ImageIO.read(getUrl("img/yagi.png"));
			ZodiacObj[10] = ImageIO.read(getUrl("img/mizugame.png"));
			ZodiacObj[11] = ImageIO.read(getUrl("img/uo.png"));

			horoscope = base[0].getGraphics();
			horoscope.setFont(new Font("SansSerif", Font.PLAIN, 10));
			horoscope.setColor(new Color(0, 0, 0));

		} catch (IOException ex) {
			ex.printStackTrace();
			throw ex;
		}
	}
	/**
	 * @param filename ե̾
	 * @return InputStream
	 * @throws IOException
	 */
	private static InputStream getUrl(String filename) throws IOException {
		InputStream res;
		URL url = ImageReader.class.getResource(filename);
		res = url.openStream();
		return res;
	}

	/**
	 * ᡼
	 * @param location 
	 * @param star ֹ
	 */
	public void putStar(int location, int star) {
		horoscope.drawImage((Image) StarObj[star], sXpos[location],
				sYpos[location], this);
	}

	/**
	 * ¥᡼
	 * @param location 
	 * @param zodiac ֹ
	 */
	public void putZodiac(int location, int zodiac) {
		horoscope.drawImage((Image) ZodiacObj[zodiac], zXpos[location],
				zYpos[location], this);
	}
	/**
	 * פγ٤
	 * @param location 
	 * @param str 
	 */
	public void putCusp(int location, String str) {
		if (location < 7) {

			horoscope.drawImage((Image) base[1], zXpos[location] + 8,
					zYpos[location] + 23, this);
			horoscope.drawString(str + "'", zXpos[location] - 2,
					zYpos[location] + 23 + 10);
		} else {

			horoscope.drawImage((Image) base[1], zXpos[location] + 8,
					zYpos[location] - 12, this);
			horoscope.drawString(str + "'", zXpos[location] - 2,
					zYpos[location] - 12 + 10);
		}
	}

	/**
	 * ۥץ᡼
	 * @return BufferedImage ۥץ᡼
	 */
	public BufferedImage getBase() {
		return base[0];
	}

	/**
	 * (non-Javadoc)
	 * 
	 * @see java.awt.image.ImageObserver#imageUpdate(java.awt.Image, int, int,
	 *      int, int, int)
	 */
	public boolean imageUpdate(Image theimg, int infoflags, int x, int y,
			int w, int h) {
		if ((infoflags & ALLBITS) != 0)
			return false;
		else
			return true;
	}
	

	/**
	 * ƥ main
	 * @param args
	 * @throws Exception
	 */
	public static void main(String[] args) throws Exception {
		ImageReader horo = new ImageReader();
		horo.putStar(0, 0);
		horo.putStar(1, 1);
		horo.putStar(2, 2);
		horo.putStar(3, 3);
		horo.putStar(4, 4);
		horo.putStar(5, 5);
		horo.putStar(6, 6);
		horo.putStar(7, 7);
		horo.putStar(8, 8);
		horo.putStar(9, 9);

		horo.putZodiac(0, 0);
		horo.putZodiac(1, 1);
		horo.putZodiac(2, 2);
		horo.putZodiac(3, 3);
		horo.putZodiac(4, 4);
		horo.putZodiac(5, 5);
		horo.putZodiac(6, 6);
		horo.putZodiac(7, 7);
		horo.putZodiac(8, 8);
		horo.putZodiac(9, 9);
		horo.putZodiac(10, 10);
		horo.putZodiac(11, 11);

		horo.putCusp(0, "88 88");
		horo.putCusp(1, "88 88");
		horo.putCusp(2, "88 88");
		horo.putCusp(3, "88 88");
		horo.putCusp(4, "88 88");
		horo.putCusp(5, "88 88");
		horo.putCusp(6, "88 88");
		horo.putCusp(7, "88 88");
		horo.putCusp(8, "88 88");
		horo.putCusp(9, "88 88");
		horo.putCusp(10, "88 88");
		horo.putCusp(11, "88 88");

		BufferedImage objBi = horo.getBase();
		File dest = new File("image.png");
		try {
			ImageIO.write(objBi, "PNG", dest);
		} catch (IOException ex) {
			ex.printStackTrace();
		}
	}
}