﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using System.IO;

namespace StrokeStyleT
{
	class Options :IDisposable
	{
		public float fスクロールスピード = 2.0f;
		public bool bチャイナが左にある
		{
			get;
			set;
		}
		public bool bチャイナが右にある
		{
			get { return !this.bチャイナが左にある; }
			set { this.bチャイナが左にある = !value; }
		}
		public bool bライドが左にある
		{
			get;
			set;
		}
		public bool bライドが右にある
		{
			get { return !this.bライドが左にある; }
			set { this.bライドが左にある = !value; }
		}
		public bool bスプラッシュが左にある
		{
			get;
			set;
		}
		public bool bスプラッシュが右にある
		{
			get { return !this.bスプラッシュが左にある; }
			set { this.bスプラッシュが左にある = !value; }
		}
		public bool b自動演奏 = false;
		public Dictionary<Eヒット判定, int> dicヒット判定toRange = null;

		public Options()
		{
			// 極めて個人的に決定された初期値。

			this.bチャイナが左にある = false;
			this.bライドが左にある = false;
			this.bスプラッシュが左にある = true;
			this.b自動演奏 = false;
			this.dicヒット判定toRange = new Dictionary<Eヒット判定, int>( 6 ) {
				{ Eヒット判定.PERFECT, 34 },
				{ Eヒット判定.GREAT, 67 },
				{ Eヒット判定.GOOD, 84 },
				{ Eヒット判定.POOR, 117 },
				{ Eヒット判定.MISS, 0 },	// 使わない
				{ Eヒット判定.AUTO, 0 },	// 使わない
			};
		}

		#region [ XML ]
		//-----------------
		public void Load( XmlTextReader reader )
		{
			if( reader.NodeType != XmlNodeType.Element || !reader.Name.Equals( "Option" ) || reader.IsEmptyElement )
				return;

			while( reader.Read() )
			{
				bool bValue;
				float fValue;
				int nValue;

				if( reader.NodeType == XmlNodeType.EndElement && reader.Name.Equals( "Option" ) )
					break;	// </Option>

				if( reader.NodeType == XmlNodeType.Element && !reader.IsEmptyElement )
				{
					switch( reader.Name )
					{
						case "ScrollSpeed":
							Global.tXMLのテキスト要素を読み込む( reader, ( value ) => {
								if( float.TryParse( value, out fValue ) )
									this.fスクロールスピード = fValue;
							} );
							continue;

						case "ChinaPosition":
							Global.tXMLのテキスト要素を読み込む( reader, ( value ) => {
								this.bチャイナが右にある = ( value.Equals( "Right" ) );
							} );
							continue;

						case "RidePosition":
							Global.tXMLのテキスト要素を読み込む( reader, ( value ) => {
								this.bライドが右にある = ( value.Equals( "Right" ) );
							} );
							continue;

						case "SplashPosition":
							Global.tXMLのテキスト要素を読み込む( reader, ( value ) => {
								this.bスプラッシュが右にある = ( value.Equals( "Right" ) );
							} );
							continue;

						case "AutoPlay":
							Global.tXMLのテキスト要素を読み込む( reader, ( value ) => {
								if( bool.TryParse( value, out bValue ) )
									this.b自動演奏 = bValue;
							} );
							continue;

						case "HitRange":
							while( reader.Read() )
							{
								if( reader.NodeType == XmlNodeType.EndElement && reader.Name.Equals( "HitRange" ) )
									break;	// </HitRange>

								switch( reader.Name )
								{
									case "Perfect":
										Global.tXMLのテキスト要素を読み込む( reader, ( value ) => {
											if( int.TryParse( value, out nValue ) )
												this.dicヒット判定toRange[ Eヒット判定.PERFECT ] = nValue;
										} );
										continue;

									case "Great":
										Global.tXMLのテキスト要素を読み込む( reader, ( value ) => {
											if( int.TryParse( value, out nValue ) )
												this.dicヒット判定toRange[ Eヒット判定.GREAT ] = nValue;
										} );
										continue;

									case "Good":
										Global.tXMLのテキスト要素を読み込む( reader, ( value ) => {
											if( int.TryParse( value, out nValue ) )
												this.dicヒット判定toRange[ Eヒット判定.GOOD ] = nValue;
										} );
										continue;

									case "Poor":
										Global.tXMLのテキスト要素を読み込む( reader, ( value ) => {
											if( int.TryParse( value, out nValue ) )
												this.dicヒット判定toRange[ Eヒット判定.POOR ] = nValue;
										} );
										continue;

									default:
										continue;	// その他はデフォルトの初期値のまま
								}
							}
							continue;
					}
				}
			}
		}
		public void Save( XmlTextWriter writer )
		{
			writer.WriteStartElement( null, "Option", null );		// <Option>

			// <ScrollSpeed>

			writer.WriteElementString( "ScrollSpeed", this.fスクロールスピード.ToString() );

			// <～Position>

			writer.WriteElementString( "ChinaPosition", ( this.bチャイナが右にある ) ? "Right" : "Left" );
			writer.WriteElementString( "RidePosition", ( this.bライドが右にある ) ? "Right" : "Left" );
			writer.WriteElementString( "SplashPosition", ( this.bスプラッシュが右にある ) ? "Right" : "Left" );

			// <AutoPlay>

			writer.WriteElementString( "AutoPlay", this.b自動演奏.ToString() );

			// <HitRange>

			writer.WriteStartElement( "HitRange" );
			writer.WriteElementString( "Perfect", this.dicヒット判定toRange[ Eヒット判定.PERFECT ].ToString() );
			writer.WriteElementString( "Great", this.dicヒット判定toRange[ Eヒット判定.GREAT ].ToString() );
			writer.WriteElementString( "Good", this.dicヒット判定toRange[ Eヒット判定.GOOD ].ToString() );
			writer.WriteElementString( "Poor", this.dicヒット判定toRange[ Eヒット判定.POOR ].ToString() );
			writer.WriteEndElement();

			writer.WriteEndElement();								// </Option>
		}
		//-----------------
		#endregion

		#region [ IDisposable 実装 ]
		//-----------------
		public void Dispose()
		{
		}
		//-----------------
		#endregion
	}
}
