﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using System.Windows.Forms;

namespace StrokeStyleT
{
	class Folders : IDisposable
	{
		public string stgシステムフォルダパス { get; private set; }
		public string stgユーザ共通フォルダパス { get; private set; }
		public string stgユーザ個別フォルダパス { get; private set; }

		public Folders()
		{
			// システムフォルダパスの設定
#if DEBUG
			// Debug 時 ……… システムフォルダはカレントフォルダ（Libフォルダ；VSで設定する）の親フォルダにする。
			this.stgシステムフォルダパス = Path.Combine( Environment.CurrentDirectory, @".." );
#else
			// Release 時 …… システムフォルダは exe の存在するフォルダ（Libフォルダ；必ずしもカレントフォルダとは一致しない）の親フォルダにする。
			this.stgシステムフォルダパス = Path.Combine( Path.GetDirectoryName( Application.ExecutablePath ), @".." );
#endif

			// ユーザ共通フォルダパスの設定

			this.stgユーザ共通フォルダパス = Path.Combine( Environment.GetFolderPath( Environment.SpecialFolder.MyDocuments ), @"StrokeStyleT" );
			
			if( !Directory.Exists( this.stgユーザ共通フォルダパス ) )
				Directory.CreateDirectory( this.stgユーザ共通フォルダパス );		// 存在しなければ作成する。


			// ユーザ個別フォルダパスの設定

			this.stgユーザ個別フォルダパス = null;	// ログインするまで不明。
		}

		#region [ IDisposable 実装 ]
		//-----------------
		public void Dispose()
		{
		}
		//-----------------
		#endregion

		public void tフォルダがなければ作成する( string path )
		{
			if( !Directory.Exists( path ) )
				Directory.CreateDirectory( path );
		}
		public string tパスの正当性を確認のうえ絶対パスに変換して返す( string path, string str相対パス時のルート = null )
		{
			// path が 空文字列 or null の場合は空文字列を返す。

			if( string.IsNullOrEmpty( path ) )
				return "";


			// path が相対パス指定であれば、引数 str相対パス時のルートからの相対パスと見なす。

			try
			{
				if( !Path.IsPathRooted( path ) )
				{
					if( string.IsNullOrEmpty( str相対パス時のルート ) )
						throw new NullReferenceException( string.Format( "相対パスですがルートパスが指定されていません。[{0}]", this.tファイルパスをマクロ付きパスに変換する( path ) ) );

					path = Path.Combine( str相対パス時のルート, path );
				}
			}
			catch( ArgumentException e )
			{
				throw new ArgumentException( string.Format( "パス文字列に無効な文字が含まれています。[{0}]", this.tファイルパスをマクロ付きパスに変換する( path ) ), e );
			}


			// path 文字列がパスとして正しいかを個別確認する。

			try
			{
				path = Path.GetFullPath( path );	// path は既に絶対パスになっているが、Path.GetFullPath() を利用して、パス文字列の正当性確認を行う。
			}
			catch( ArgumentException e )
			{
				throw new ArgumentException( string.Format( "パス文字列に無効な文字が含まれています。[{0}]", path ), e );
			}
			catch( System.Security.SecurityException e )
			{
				throw new System.Security.SecurityException( string.Format( "パスにはアクセス権限がありません。[{0}]", path ), e );
			}
			catch( NotSupportedException e )
			{
				throw new NotSupportedException( string.Format( "パス文字列にサポートされていない文字が含まれています。[{0}]", path ), e );
			}
			catch( PathTooLongException e )
			{
				throw new PathTooLongException( string.Format( "パス文字列が長すぎます。[{0}]", path ), e );
			}

			return path;
		}
	
		// パスを表示・出力する場合は、マクロ付きパスに変換してユーザ名などを隠蔽すること。

		public string tファイルパスをマクロ付きパスに変換する( string path )
		{
			this.tファイルパスをマクロ付きパスに変換する( ref path );
			return path;
		}
		public void tファイルパスをマクロ付きパスに変換する( ref string path )
		{
			// システムフォルダ

			path = path.Replace( this.stgシステムフォルダパス, @"$(SystemFolder)" );


			// ユーザ共通フォルダ

			path = path.Replace( this.stgユーザ共通フォルダパス, @"$(CommonUserFolder)" );


			// ユーザ個別フォルダ

			if( !string.IsNullOrEmpty( this.stgユーザ個別フォルダパス ) )
				path = path.Replace( this.stgユーザ個別フォルダパス, @"$(UserFolder)" );
		}

		public string tファイルパス内のマクロを展開する( string path )
		{
			this.tファイルパス内のマクロを展開する( ref path );
			return path;
		}
		public void tファイルパス内のマクロを展開する( ref string path )
		{
			// システムフォルダ

			path = path.Replace( @"$(SystemFolder)", this.stgシステムフォルダパス );

			
			// ユーザ共通フォルダ

			path = path.Replace( @"$(CommonUserFolder)", this.stgユーザ共通フォルダパス );

			
			// ユーザ個別フォルダ

			if( !string.IsNullOrEmpty( this.stgユーザ個別フォルダパス ) )
				path = path.Replace( @"$(UserFolder)", this.stgユーザ個別フォルダパス );
		}
	}
}
