#pragma once

namespace FDK
{
	/// RXgN^Ŏw肳ꂽXg[ɑ΂ Trace Oo͂郊Xi[B
	/// Trace::Listeners  Add() ΁AftHg̏o̓EBhEɉāAAdd Xi[ɂbZ[Wo͂悤ɂȂB
	public ref class CTraceLogListener : TraceListener
	{
	public:
		CTraceLogListener( StreamWriter^ stream )
		{
			this->streamWriter = stream;
		}
		~CTraceLogListener()
		{
			if( this->streamWriter != nullptr )
			{
				this->streamWriter->Close();
				SAFE_REF_DELETE( this->streamWriter );	// StreamWriter ꏏɉB
			}
		}

		virtual void Flush() override
		{
			if( this->streamWriter != nullptr )
			{
				try
				{
					this->streamWriter->Flush();
				}
				catch( ObjectDisposedException^ )
				{
				}
			}
		}
		virtual void TraceEvent( TraceEventCache^ eventCache, String^ source, TraceEventType eventType, int id, String^ message ) override
		{
			if( this->streamWriter != nullptr )
			{
				try
				{
					this->tCxgʂo͂( eventType );
					this->tCfgo͂();
					this->streamWriter->WriteLine( message );
				}
				catch( ObjectDisposedException^ )
				{
				}
			}
		}
		virtual void TraceEvent( TraceEventCache^ eventCache, String^ source, TraceEventType eventType, int id, String^ format, ... array<Object^>^ args ) override
		{
			if( this->streamWriter != nullptr )
			{
				try
				{
					this->tCxgʂo͂( eventType );
					this->tCfgo͂();
					this->streamWriter->WriteLine( String::Format( format, args ) );
				}
				catch( ObjectDisposedException^ )
				{
				}
			}
		}
		virtual void Write( String^ message ) override
		{
			if( this->streamWriter != nullptr )
			{
				try
				{
					this->streamWriter->Write( message );
				}
				catch( ObjectDisposedException^ )
				{
				}
			}
		}
		virtual void WriteLine( String^ message ) override
		{
			if( this->streamWriter != nullptr )
			{
				try
				{
					this->streamWriter->WriteLine( message );
				}
				catch( ObjectDisposedException^ )
				{
				}
			}
		}

	protected:
		StreamWriter^ streamWriter;

		void tCxgʂo͂( TraceEventType eventType )
		{
			if( this->streamWriter != nullptr )
			{
				try
				{
					DateTime now = DateTime::Now;
					this->streamWriter->Write( String::Format( "{0:D4}/{1:D2}/{2:D2} {3:D2}:{4:D2}:{5:D2}.{6:D3} ", gcnew array<Object^> { now.Year, now.Month, now.Day, now.Hour, now.Minute, now.Second, now.Millisecond } ) );
					switch( eventType )
					{
					case TraceEventType::Error:
						this->streamWriter->Write( "*[ERR ] " );
						return;

					case ( TraceEventType::Error | TraceEventType::Critical ):
						return;

					case TraceEventType::Warning:
						this->streamWriter->Write( "+[WARN] " );
						return;

					case TraceEventType::Information:
						break;

					default:
						return;
					}
					this->streamWriter->Write( " [INFO] " );
				}
				catch( ObjectDisposedException^ )
				{
				}
			}
		}
		void tCfgo͂()
		{
			if( ( this->streamWriter != nullptr ) && ( this->IndentLevel > 0 ) )
			{
				try
				{
					for( int i = 0; i < this->IndentLevel; i++ )
						this->streamWriter->Write( "    " );
				}
				catch( ObjectDisposedException^ )
				{
				}
			}
		}
	};
}
