#pragma once

#include "refCTimerBase.h"

namespace FDK
{
	public ref class CTimer : CTimerBase
	{
	public:
		enum class E
		{
			Unknown = -1,
			PerformanceCounter = 0,
			MultiMedia = 1,
			GetTickCount = 2,
		};
		
		property E e^C}
		{
			E get() { return this->_e^C}; }
		protected:
			void set( E value ) { this->_e^C} = value; }
		};
		virtual property Int64 nVXems
		{
			Int64 get() override
			{
				switch( this->e^C} )
				{
				case E::PerformanceCounter:
					{
						Double num = 0.0;
						if( this->n݂̎g != 0L )
						{
							LARGE_INTEGER x;
							::QueryPerformanceCounter( &x );
							num = ( (Double) x.QuadPart ) / ( ( (Double) this->n݂̎g ) / 1000.0 );
						}
						return (Int64) num;
					}
				case E::MultiMedia:
					return (Int64) ::timeGetTime();

				case E::GetTickCount:
					return (Int64) Environment::TickCount;
				}
				return 0;
			}
		}

		CTimer( E e^C} )
			: CTimerBase()
		{
			this->e^C} = e^C};

			if( this->nQƃJEg[ (int) this->e^C} ] == 0 )
			{
				switch( this->e^C} )
				{
				case E::PerformanceCounter:
					if( !this->bmFƐݒ_PerformanceCounter() && !this->bmFƐݒ_MultiMedia() )
						this->bmFƐݒ_GetTickCount();
					break;

				case E::MultiMedia:
					if( !this->bmFƐݒ_MultiMedia() && !this->bmFƐݒ_PerformanceCounter() )
						this->bmFƐݒ_GetTickCount();
					break;

				case E::GetTickCount:
					this->bmFƐݒ_GetTickCount();
					break;

					default:
						throw gcnew ArgumentException( String::Format( "m̃^C}ʂłB[{0}]", this->e^C} ) );
				}
			}
	
			this->tZbg();

			this->nQƃJEg[ (int) this->e^C} ]++;
		}
		~CTimer()
		{
			if( this->e^C} == E::Unknown )
				return;

			int type = (int) this->e^C};

			this->nQƃJEg[ type ] = Math::Max( this->nQƃJEg[ type ] - 1, 0 );

			if( this->nQƃJEg[ type ] == 0 )
			{
				if( this->e^C} == E::MultiMedia )
					::timeEndPeriod( (UINT) this->timeCaps.wPeriodMin );
			}

			this->e^C} = E::Unknown;
		}

	protected:
		Int64 n݂̎g;
		static array<int>^ nQƃJEg = gcnew array<int>(3);

		value class TimeCaps
		{
		public:
			WORD wPeriodMin;
			WORD wPeriodMax;
		};
		
		TimeCaps timeCaps;

		bool bmFƐݒ_GetTickCount()
		{
			this->e^C} = E::GetTickCount;
			return true;
		}
		bool bmFƐݒ_MultiMedia()
		{
			TIMECAPS tc;

			if( ( ::timeGetDevCaps( &tc, (UINT) Marshal::SizeOf( TimeCaps::typeid ) ) == 0 ) && ( tc.wPeriodMin < 10 ) )
			{
				this->timeCaps = TimeCaps();
				this->timeCaps.wPeriodMax = tc.wPeriodMax;
				this->timeCaps.wPeriodMin = tc.wPeriodMin;

				this->e^C} = E::MultiMedia;
				::timeBeginPeriod( tc.wPeriodMin );
				return true;
			}
			return false;
		}
		bool bmFƐݒ_PerformanceCounter()
		{
			LARGE_INTEGER li;
			if( ::QueryPerformanceFrequency( &li ) != 0 )
			{
				this->n݂̎g = (Int64) li.QuadPart;
				this->e^C} = E::PerformanceCounter;
				return true;
			}
			return false;
		}

	private:
		E _e^C};
	};
}
