#pragma once

#include "CritSec.h"
#include "AutoLock.h"

namespace FDK
{
	generic< class T >
	public ref class CAtom
	{
	private:
		T _value;
		CritSec *pcsValue;

	public:
		CAtom( T l )
		{
			this->_value = l;
			this->pcsValue = new CritSec();
		}
		~CAtom()
		{
			this->!CAtom();
		}
		!CAtom()
		{
			SAFE_REF_DELETE( this->pcsValue );
		}
		T Get()
		{
			AutoLock lock( *this->pcsValue );
			return this->_value;
		}
		void Set( T value )
		{
			AutoLock lock( *this->pcsValue );
			this->_value = value;
		}
	};
}
