#pragma once

// F
// 
// List ev[gNX́AȒPȑoXgB
//
// Q̃o[W Clear() \bhB
// EClear(void) ́AIuWFNgɃXgNAB
// EClear(FN fn) ́AIuWFNg邽߂̋@\IuWFNggB
//
// XgNX́A񋓂T|[gBȉɗB
//
// List<T>::POSIITON pos = list.GetFrontPosition();		// 擪ʒu̎擾
// while (pos != list.GetEndPosition())					// 񋓂I܂Łcc
// {
//     T item;
//     hr = list.GetItemPos(&item);						// ݈ʒũACe擾iϐ pos ͕svj
//     pos = list.Next(pos);							// ̈ʒu擾
// }

namespace FDK
{
	template <class T>
	class LinkList
	{

	protected:

		#pragma region [ Xgm[h\ Node ̒` ]
		//-----------------
		struct Node
		{
			Node *prev;
			Node *next;
			T    item;

			Node() : prev(NULL), next(NULL)
			{
			}
			Node( T item ) : prev(NULL), next(NULL)
			{
				this->item = item;
			}

			T Item() const
			{
				return item;
			}
		};
		//-----------------
		#pragma endregion

		#pragma region [ T^I Clear \bhpNX̒`iNoOp, ComAutoRelease, MemDeletejB]
		//-----------------
		class MemDelete
		{
		public: 
			void operator()( void *p )
			{
				if( p )
					delete p;
			}
		};
		template <class T> struct NoOp
		{
			void operator()(T& t)
			{
			}
		};
		class ComAutoRelease
		{
		public: 
			void operator()( IUnknown *p )
			{
				if( p )
					p->Release();
			}
		};
		//-----------------
		#pragma endregion

	public:

		#pragma region [ Xg̗񋓗pNX POSITION ̒` ]
		//-----------------
		class POSITION
		{
			friend class LinkList<T>;

		public:
			POSITION() : pNode(NULL)
			{
			}

			bool operator==(const POSITION &p) const
			{
				return pNode == p.pNode;
			}
			bool operator!=(const POSITION &p) const
			{
				return pNode != p.pNode;
			}

		private:
			const Node *pNode;
			POSITION(Node *p) : pNode(p) 
			{
			}
		};
		//-----------------
		#pragma endregion

	protected:

		Node    m_anchor;  // Xg̃AJ[m[hB
		DWORD   m_count;   // Xg̃ACeim[hjB

		Node* Front() const
		{
			return m_anchor.next;
		}
		Node* Back() const
		{
			return m_anchor.prev;
		}

		virtual HRESULT InsertAfter( T item, Node *pBefore )
		{
			if( pBefore == NULL )
				return E_POINTER;

			Node *pNode = new Node( item );
            
			if( pNode == NULL )
				return E_OUTOFMEMORY;

			Node *pAfter = pBefore->next;
            
			pBefore->next = pNode;
			pAfter->prev = pNode;
			pNode->prev = pBefore;
			pNode->next = pAfter;

			m_count++;

			return S_OK;
		}
		virtual HRESULT GetItem( const Node *pNode, T *ppItem )
		{
			if( pNode == NULL || ppItem == NULL )
				return E_POINTER;

			*ppItem = pNode->item;
			return S_OK;
		}
		
		// ppItem  NULL ȂA폜ACe֊i[ĕԂB
		virtual HRESULT RemoveItem( Node *pNode, T *ppItem )
		{
			if( pNode == NULL )
				return E_POINTER;
			
			if( pNode == &m_anchor )	// AJ[m[h͍폜łȂB
				return E_INVALIDARG;
			
			T item;
			
			pNode->next->prev = pNode->prev;
			pNode->prev->next = pNode->next;
			
			item = pNode->item;
			delete pNode;
			
			m_count--;
			
			if( ppItem )
				*ppItem = item;
			
			return S_OK;
		}
	
	public:
		
		LinkList()
		{
			m_anchor.next = &m_anchor;
			m_anchor.prev = &m_anchor;
			m_count = 0;
		}
		virtual ~LinkList()
		{
			this->Clear();
		}
		HRESULT InsertBack( T item )
		{
			return this->InsertAfter( item, m_anchor.prev );
		}
		HRESULT InsertFront( T item )
		{
			return this->InsertAfter( item, &m_anchor );
		}
		HRESULT RemoveBack( T *ppItem )
		{
			if( this->IsEmpty() )
			{
				return E_FAIL;
			}
			else
			{
				// ppItem  NULL ȂA폜ACe֊i[ĕԂB
				return this->RemoveItem( this->Back(), ppItem );
			}
		}
		HRESULT RemoveFront( T *ppItem )
		{
			if( this->IsEmpty() )
			{
				return E_FAIL;
			}
			else
			{
				// ppItem  NULL ȂA폜ACe֊i[ĕԂB
				return this->RemoveItem( this->Front(), ppItem );
			}
		}
		HRESULT GetBack( T *ppItem )
		{
			if( this->IsEmpty() )
			{
				return E_FAIL;
			}
			else
			{
				return this->GetItem( this->Back(), ppItem );
			}
		}
		HRESULT GetFront( T *ppItem )
		{
			if( this->IsEmpty() )
			{
				return E_FAIL;
			}
			else
			{
				return this->GetItem( this->Front(), ppItem );
			}
		}
		DWORD GetCount() const
		{
			return m_count;
		}
		bool IsEmpty() const
		{
			return ( GetCount() == 0 );
		}

		template <class FN>
		void Clear( FN& clear_fn )
		{
			// XgŃIuWFNg operator() IuWFNgɎB

			Node *n = m_anchor.next;
			
			// m[h폜B
			while( n != &m_anchor )
			{
				clear_fn( n->item );
				
				Node *tmp = n->next;
				delete n;
				n = tmp;
			}
			
			// AJ[gɐݒ肷B
			m_anchor.next = &m_anchor;
			m_anchor.prev = &m_anchor;
			m_count = 0;
		}
		
		// XgACe delete  release ͍sȂB
		virtual void Clear()
		{
			this->Clear<NoOp<T>>(NoOp<T>());
		}
		
		// 񋓊֐
		
		POSITION FrontPosition()
		{
			if( this->IsEmpty() )
			{
				return POSITION( NULL );
			}
			else
			{
				return POSITION( this->Front() );
			}
		}
		POSITION EndPosition() const
		{
			return POSITION();
		}
		HRESULT GetItemPos( POSITION pos, T *ppItem )
		{   
			if( pos.pNode )
			{
				return this->GetItem( pos.pNode, ppItem );
			}
			else 
			{
				return E_FAIL;
			}
		}
		POSITION Next( const POSITION pos )
		{
			if( pos.pNode && ( pos.pNode->next != &m_anchor ) )
			{
				return POSITION( pos.pNode->next );
			}
			else
			{
				return POSITION( NULL );
			}
		}
		// ppItem  NULL ȂA폜ACe֊i[ĕԂB
		HRESULT Remove( POSITION& pos, T *ppItem )
		{
			if( pos.pNode )
			{
				Node *pNode = const_cast<Node*>( pos.pNode );

				pos = POSITION();
				return this->RemoveItem( pNode, ppItem );
			}
			else
			{
				return E_INVALIDARG;
			}
		}
	};
}
