#include "stdafx.h"
#include "refCSound.h"

namespace FDK
{
	int CSound::n::get()
	{
		float f = 0.0f;
		if( ::BASS_Mixer_ChannelGetEnvelopePos( this->hBassStream,BASS_MIXER_ENV_VOL, &f ) == -1 )
			return 100;
		return (int) ( f * 100 );
	}
	void CSound::n::set( int value )
	{
		float f = Math::Min( Math::Max( value, 0 ), 100 ) / 100.0f;	// 0`100  0.0`1.0
		BASS_MIXER_NODE nodes[ 1 ];
		nodes[ 0 ].pos = 0;
		nodes[ 0 ].value = f;
		::BASS_Mixer_ChannelSetEnvelope( this->hBassStream, BASS_MIXER_ENV_VOL, nodes, 1 );
	}

	int CSound::nʒu::get()
	{
		float fʒu = 0.0f;
		if( ::BASS_Mixer_ChannelGetEnvelopePos( this->hBassStream, BASS_MIXER_ENV_PAN, &fʒu ) == -1 )
			return 0;
		return (int) ( fʒu * 100 );
	}
	void CSound::nʒu::set( int value )
	{
		float fʒu = min( max( value, -100 ), 100 ) / 100.0f;	// -100`100  -1.0`1.0
		BASS_MIXER_NODE nodes[ 1 ];
		nodes[ 0 ].pos = 0;
		nodes[ 0 ].value = fʒu;
		::BASS_Mixer_ChannelSetEnvelope( this->hBassStream, BASS_MIXER_ENV_PAN, nodes, 1 );
	}

	bool CSound::bĐ::get()
	{
		DWORD dwState = ::BASS_ChannelIsActive( this->hBassStream );
		// fR[h`l̏ꍇ̖߂lF
		//   BASS_ACTIVE_PLAYING ... fR[hׂf[^cĂ
		//   BASS_ACTIVE_STOPPED ... fR[hׂf[^ȂȂ
		//   BASS_ACTIVE_PAUSED .... fR[hꎞ~
		//   BASS_ACTIVE_STALLED ... ꂪԂ邱Ƃ͂Ȃ

		return ( dwState == BASS_ACTIVE_PLAYING ) ? true : false;
	}

	CSound::CSound()
	{
		this->n = 100;
		this->nʒu = 0;
		this->hBassStream = 0xFFFFFFFF;
		this->e쐬@ = E쐬@::m̍쐬@;
		this->efoCX = ESoundDeviceType::Unknown;
		this->strt@C = nullptr;
		this->byArrWAVt@CC[W = nullptr;
		this->b~LT[~ = true;
		this->bDisposeς = false;
	}
	CSound::~CSound()
	{
		// this SCX^XXg폜

		if( CSound::listCX^X != nullptr && CSound::listCX^X->Contains( this ) )	 // č\zꍇAł listCX^Xɂ͓o^ĂȂideletejB
			CSound::listCX^X->Remove( this );


		// }l[Wh̉B

		if( this->hGC.IsAllocated )
			this->hGC.Free();

		SAFE_REF_DELETE( this->strt@C );
		SAFE_REF_DELETE( this->byArrWAVt@CC[W );

		// lCeBủB

		this->!CSound();
	}
	CSound::!CSound()
	{
		// BASS ̉

		if( this->hBassStream != 0xFFFFFFFF )
		{
			::BASS_Mixer_ChannelRemove( this->hBassStream );
			::BASS_StreamFree( this->hBassStream );
		}
	}

	void CSound::tCX^X폜()
	{
		CSound::listCX^X->Remove( this );
	}

	void CSound::tWASAPITEh쐬( String^ strt@C, int hMixer, ESoundDeviceType efoCX )
	{
		this->tBASSTEh쐬( strt@C, hMixer, BASS_STREAM_DECODE | BASS_SAMPLE_FLOAT | BASS_UNICODE );
		this->efoCX = efoCX;		// 쐬ɐݒ肷Bi쐬ɎsĂƗOoĂ͎sȂj
	}
	void CSound::tWASAPITEh쐬( array<byte>^ byArrWAVt@CC[W, int hMixer, ESoundDeviceType efoCX )
	{
		this->tBASSTEh쐬( byArrWAVt@CC[W, hMixer, BASS_STREAM_DECODE | BASS_SAMPLE_FLOAT | BASS_UNICODE );
		this->efoCX = efoCX;		// 쐬ɐݒ肷Bi쐬ɎsĂƗOoĂ͎sȂj
	}

	void CSound::tCX^Xc܂܉()
	{
		delete this;
	}

	void CSound::t擪Đ()
	{
		// ~LT[֏o͊JnB

		if( this->b~LT[~ )
		{
			::BASS_Mixer_ChannelFlags( this->hBassStream, 0, BASS_MIXER_PAUSE );	// BASS_MIXER_PAUSE tÔݏBiɍĐn܂̂ŒӁj
			this->b~LT[~ = false;
		}

		// BASS ŃfR[hJnB

		this->tĐʒu擪ɖ߂();
		::BASS_ChannelPlay( this->hBassStream, TRUE/*擪*/ );
	}
	void CSound::t~()
	{
		// ~LTւ̏o͂~B

		::BASS_Mixer_ChannelFlags( this->hBassStream, BASS_MIXER_PAUSE, BASS_MIXER_PAUSE );	// BASS_MIXER_PAUSE tOZbgB
		this->b~LT[~ = true;

		// BASS ŃfR[h~B
		
		::BASS_ChannelStop( this->hBassStream );
	}
	void CSound::tꎞ~()
	{
		// ~LTւ̏o͂ꎞ~B

		::BASS_Mixer_ChannelFlags( this->hBassStream, BASS_MIXER_PAUSE, BASS_MIXER_PAUSE );	// BASS_MIXER_PAUSE tOZbgB
		this->b~LT[~ = true;

		// BASS ŃfR|hꎞ~B

		::BASS_ChannelPause( this->hBassStream );
	}
	void CSound::tĊJ()
	{
		// ~LTւ̏o͂ĊJB

		if( this->b~LT[~ )
		{
			::BASS_Mixer_ChannelFlags( this->hBassStream, 0, BASS_MIXER_PAUSE );	// BASS_MIXER_PAUSE tÔݏBiɍĐn܂̂ŒӁj
			this->b~LT[~ = false;
		}

		// BASS ŃfR[hĊJB

		::BASS_ChannelPlay( this->hBassStream, FALSE );		// ~ʒuĐĊJ
	}

	void CSound::tĐʒu擪ɖ߂()
	{
		::BASS_Mixer_ChannelSetPosition( this->hBassStream, 0, BASS_POS_BYTE );
	}
	void CSound::tĐʒuύX( Int64 nʒums )
	{
		::BASS_Mixer_ChannelSetPosition( this->hBassStream, ::BASS_ChannelSeconds2Bytes( this->hBassStream, nʒums / 1000.0 ), BASS_POS_BYTE );
	}

	ESoundDeviceType CSound::tTEhfoCXʂ()
	{
		BASS_WASAPI_DEVICEINFO info;
		if( BASS_WASAPI_GetDeviceInfo( 0, &info ) )
		{
			return ESoundDeviceType::ExclusiveWASAPI;
		}

		return ESoundDeviceType::Unknown;
	}
	void CSound::tׂẴTEhԂɖ߂()
	{
		for each( CSound^ sound in CSound::listCX^X )
			sound->tCX^Xc܂܉();
	}
	void CSound::tׂẴTEhč\z( ISoundDevice^ device )
	{
		if( CSound::listCX^X->Count == 0 )
			return;


		// TEhč\zۂɃCX^XXgɂǉ̂ŁAzɃRs[ĂAXg̓NAB

		array<CSound^>^ sounds = CSound::listCX^X->ToArray();
		CSound::listCX^X->Clear();
			

		// zɊÂČX̃TEhč쐬B

		CSound^ newSound = nullptr;
		for( int i = 0; i < sounds->Length; i++ )
		{
			switch( sounds[ i ]->e쐬@ )
			{
			case E쐬@::t@C:
				{
					String^ strt@C = sounds[ i ]->strt@C;
					delete sounds[ i ];		// DisposeAłCSoundւ̎QƂ̂ĂBCSound̃t@CiCYsƂACSound͂łlistCX^Xɂ͊܂܂ĂȂ̂ŒӁB
					device->tTEh쐬( strt@C, newSound );		// newSound  listCX^X Ɋ܂܂̂ŁAł͂ȏ newSound ͐G炸B
				}
				break;

			case E쐬@::WAVt@CC[W:
				{
					array<byte>^ byArrWavet@CC[W = sounds[ i ]->byArrWAVt@CC[W;
					delete sounds[ i ];															// B
					device->tTEh쐬( byArrWavet@CC[W, newSound );			// B
				}
				break;
			}
		}
	}

	void CSound::tBASSTEh쐬( String^ strt@C, int hMixer, DWORD flags )
	{
		this->e쐬@ = E쐬@::t@C;
		this->strt@C = strt@C;

		// BASSt@CXg[쐬B

		pin_ptr<const void> pFileName = PtrToStringChars( strt@C );
		this->hBassStream = ::BASS_StreamCreateFile( FALSE, pFileName, 0, 0, flags );
		if( this->hBassStream == 0 )
			throw gcnew Exception( String::Format( "TEhXg[̐Ɏs܂B[BASS Error = {0}]", BASS_ErrorGetCode() ) );


		// ~LT[BASSt@CXg[ǉB

		::BASS_Mixer_StreamAddChannel( hMixer, this->hBassStream, BASS_SPEAKER_FRONT | BASS_MIXER_PAUSE );
		this->b~LT[~ = true;


		// CX^XXgɓo^B

		CSound::listCX^X->Add( this );
	}
	void CSound::tBASSTEh쐬( array<byte>^ byArrWAVt@CC[W, int hMixer, DWORD flags )
	{
		this->e쐬@ = E쐬@::WAVt@CC[W;
		this->byArrWAVt@CC[W = byArrWAVt@CC[W;
		this->hGC = GCHandle::Alloc( byArrWAVt@CC[W, System::Runtime::InteropServices::GCHandleType::Pinned );		// bytezs


		// BASSt@CXg[쐬B

		this->hBassStream = ::BASS_StreamCreateFile( TRUE, hGC.AddrOfPinnedObject().ToPointer(),  0,  byArrWAVt@CC[W->Length, flags );
		if( this->hBassStream == 0 )
			throw gcnew Exception( "TEhXg[̐Ɏs܂B" );


		// ~LT[BASSt@CXg[ǉB

		::BASS_Mixer_StreamAddChannel( hMixer, this->hBassStream, BASS_SPEAKER_FRONT | BASS_MIXER_PAUSE );
		this->b~LT[~ = true;


		// CX^XXgɓo^B

		CSound::listCX^X->Add( this );
	}
}