#include "stdafx.h"
#include "refCXg[o.h"

namespace FDK
{
// public:

	/// <summary>
	/// t@C fileName ŏ̃I[fBIXg[fR[h MemoryStream Ɋi[ĕԂB
	/// </summary>
	void CXg[o::tWAVC[Wo( String^ fileName, [ Out ] MemoryStream^% msWaveImage )
	{
		HRESULT hr = S_OK;
		IMFSourceReader *pReader = NULL;
		IMFMediaType *pAudioType = NULL;    // PCM I[fBItH[}bg\B
		BinaryWriter^ bwWaveFile = nullptr;

		try
		{
			// ̓t@Cw肵 SourceReader 쐬B
			{
				pin_ptr<const wchar_t> fname = ::PtrToStringChars( fileName );
				tFAILEDȂO( L"̓t@C SourceReader ̍쐬", 
					hr = ::MFCreateSourceReaderFromURL( fname, NULL, &pReader ) );
			}


			// oWAVEt@CC[WC^[쐬B

			bwWaveFile = gcnew BinaryWriter( msWaveImage );


			// \[Xt@C񈳏k PCM I[fBI擾悤ASourceReader ݒ肷BPCMI[fBI^Cv pAudioType Ɏ󂯎B
				
			pAudioType = NULL;
			CXg[o::ConfigureAudioStream( pReader, &pAudioType );


			// WAVEt@Cwb_oB
				
			DWORD cbHeader = 0;		// oꂽ WAVE t@Cwb_̃TCY󂯎BoCgPʁB
			CXg[o::WriteWaveHeader( bwWaveFile, pAudioType, &cbHeader );
				

			// I[fBIf[^t@CɃfR[hB
				
			DWORD cbAudioData = 0;	// t@Cɏo͂ꂽ PCM I[fBIf[^TCY󂯎BoCgPʁB
			CXg[o::WriteWaveData( bwWaveFile, pReader, &cbAudioData );
				
				
			// TCY RIFF wb_tB
				
			CXg[o::FixUpChunkSizes( bwWaveFile, cbHeader, cbAudioData );

			#if _DEBUG
			// t@CɏóifobOpj
			//msWaveImage->WriteTo( gcnew FileStream( gcnew String( L"C:\\ProgramData\\StrokeStyleT\\test.wav" ), FileMode::Create ) );
			#endif
		}
		catch( Exception^ e )
		{
			throw gcnew Exception( L"WAVC[W̒oɎs܂B", e );
		}
		finally
		{
			if( bwWaveFile != nullptr )
			{
				bwWaveFile->Close();
				delete bwWaveFile;
			}
			SAFE_COM_RELEASE( pAudioType );
			SAFE_COM_RELEASE( pReader );
		}
	}

// private;

	void CXg[o::ConfigureAudioStream( IMFSourceReader *pReader, [Out] IMFMediaType** ppAudioType )
	{
		HRESULT hr = S_OK;
        IMFMediaType *pUncompressedAudioType = NULL;
        IMFMediaType *pPartialType = NULL;

		try
		{
			// ŏ̃I[fBIXg[IȂׂ̂ẴXg[IɂB

			tFAILEDȂO( L"ׂẴI[fBIXg[̑I̔ے",
				hr = pReader->SetStreamSelection( MF_SOURCE_READER_ALL_STREAMS, FALSE ) );

			tFAILEDȂO( L"ŏ̃I[fBIXg[̑I",
				hr = pReader->SetStreamSelection( MF_SOURCE_READER_FIRST_AUDIO_STREAM, TRUE ) );


	        // 񈳏k PCM I[fB\sSfBA^Cv쐬B
				
			tFAILEDȂO( L"sSfBA^Cv̍쐬",
				hr = ::MFCreateMediaType( &pPartialType ) );

			tFAILEDȂO( L"W[^Cv(Audio)̐ݒ",
				hr = pPartialType->SetGUID( MF_MT_MAJOR_TYPE, MFMediaType_Audio ) );

			tFAILEDȂO( L"Tu^Cv(PCM)̐ݒ",
				hr = pPartialType->SetGUID( MF_MT_SUBTYPE, MFAudioFormat_PCM ) );


			// ̃fBA^Cv SourceReader ɃZbgBSourceReader ͕KvȃfR[_IɃ[hB

			tFAILEDȂO( L"ŏ̃Xg[ւ̃fBA^Cv̐ݒ",
				hr = pReader->SetCurrentMediaType( (DWORD) MF_SOURCE_READER_FIRST_AUDIO_STREAM, NULL, pPartialType ) );
				
				
			// SȔ񈳏ktH[}bg擾B
				
			tFAILEDȂO( L"SȔ񈳏ktH[}bg̎擾",
				hr = pReader->GetCurrentMediaType( (DWORD) MF_SOURCE_READER_FIRST_AUDIO_STREAM, &pUncompressedAudioType ) );
				
				
			// Xg[IĂ邱Ƃۏ؂B
				
			tFAILEDȂO( L"ŏ̃Xg[̑IiQځj",
				hr = pReader->SetStreamSelection( (DWORD) MF_SOURCE_READER_FIRST_AUDIO_STREAM, TRUE ) );
				
				
			// PCM tH[}bgĂяoɕԂB

			*ppAudioType = pUncompressedAudioType;
			(*ppAudioType)->AddRef();
		}
		catch( Exception^ e )
		{
			throw gcnew Exception( L"I[fBIXg[̑IPCMtH[}bg̎擾Ɏs܂B", e );
		}
		finally
		{
			SAFE_COM_RELEASE( pUncompressedAudioType );
			SAFE_COM_RELEASE( pPartialType );
		}
	}
	void CXg[o::WriteWaveHeader( BinaryWriter^ bwFile, IMFMediaType *pAudioType, [Out] DWORD *pcbWritten )
	{
		HRESULT hr = S_OK;
		UINT32 cbFormat = 0;
		WAVEFORMATEX *pWav = NULL;
		*pcbWritten = 0;

		try
		{
			// PCM I[fBItH[}bg WAVEFORMATEX \̂ɕϊB
			
			tFAILEDȂO( L"PCM I[fBItH[}bg WAVEFORMATEX \̂ւ̕ϊ",
				hr = ::MFCreateWaveFormatExFromMFMediaType( pAudioType, &pWav, &cbFormat ) );
				
				
			// 'RIFF' wb_ƍŏ 'fmt ' `NoB
				
			bwFile->Write( (UInt32) 0x46464952 );    // 'RIFF'
			bwFile->Write( (UInt32) 0 );             // t@CTCY - 8ij
			bwFile->Write( (UInt32) 0x45564157 );    // 'WAVE'
			bwFile->Write( (UInt32) 0x20746d66 );    // 'fmt '
			bwFile->Write( (UInt32) cbFormat );      // fmt`NTCY
				
				
			// WAVEFORMATEX \̂oB

			for( UINT32 i = 0; i < cbFormat; i++ )
				bwFile->Write( (UCHAR) ((UCHAR*)pWav)[i] );

				
			// 'data' `N̊JnoB
				
			bwFile->Write( (UInt32) 0x61746164 );    // 'data'
			bwFile->Write( (UInt32) 0 );             // data `NTCYij
				
				
			// ŏIIȏݗʂvZB

			*pcbWritten = sizeof(UInt32) * 5 + cbFormat + sizeof(UInt32) * 2;
		}
		catch( Exception^ e )
		{
			throw gcnew Exception( L"WAVEwb_̏oɎs܂B", e );
		}
		finally
		{
			if( pWav )
				::CoTaskMemFree( pWav );
		}
	}
	void CXg[o::WriteWaveData( BinaryWriter^ bwFile, IMFSourceReader *pReader, [Out] DWORD *pcbDataWritten )
	{
		HRESULT hr = S_OK;
		DWORD cbAudioData = 0;
		DWORD cbBuffer = 0;
		BYTE *pAudioData = NULL;
        IMFSample *pSample = NULL;
        IMFMediaBuffer *pBuffer = NULL;

		*pcbDataWritten = 0;

		try
		{
			// SourceReader I[fBITv擾B

			while( true )
			{
				DWORD dwFlags = 0;
					

				// ̃TvǂݍށB
					
				tFAILEDȂO( L"Tv̓ǂݍ",
					hr = pReader->ReadSample( (DWORD) MF_SOURCE_READER_FIRST_AUDIO_STREAM, 0, NULL, &dwFlags, NULL, &pSample ) );

				if( dwFlags & MF_SOURCE_READERF_CURRENTMEDIATYPECHANGED )		// fBA^Cvς炱ŔB
					break;

				if( dwFlags & MF_SOURCE_READERF_ENDOFSTREAM )					// Ō܂œǂݍ񂾂甲B
					break;
					
				if( pSample == NULL )											// TvȂxB
					continue;

					
				// TvI[fBIf[^bNẴ|C^擾B
					
				tFAILEDȂO( L"TṽI[fBIf[^|C^̎擾",
					hr = pSample->ConvertToContiguousBuffer( &pBuffer ) );

				tFAILEDȂO( L"I[fBIf[^̃bN",
					hr = pBuffer->Lock( &pAudioData, NULL, &cbBuffer ) );


				// ̃f[^o̓t@CɏށB

				for( DWORD i = 0; i < cbBuffer; i++ )
					bwFile->Write( (UCHAR) pAudioData[i] );


				// obt@̃bNB

				tFAILEDȂO( L"I[fBIf[^̃bN",
					hr = pBuffer->Unlock() );

				pAudioData = NULL;
					
					
				// I[fBIf[^̏ݑʂZB

				cbAudioData += cbBuffer;


				// Tvƃobt@ÃTvցB

				SAFE_COM_RELEASE( pSample );
				SAFE_COM_RELEASE( pBuffer );
			}


			// 񂾑f[^ʂԂB

			*pcbDataWritten = cbAudioData;
		}
		catch( Exception^ e )
		{
			throw gcnew Exception( L"WAVEf[^̏oɎs܂B", e );
		}
		finally
		{
			if( pAudioData )
				pBuffer->Unlock();	// Lock() ɓ pAudioData B

			SAFE_COM_RELEASE( pSample );
			SAFE_COM_RELEASE( pBuffer );
		}
	}
	void CXg[o::FixUpChunkSizes( BinaryWriter^ bwFile, UInt32 cbHeader, DWORD cbAudioData )
	{
		// f[^TCYށB

		bwFile->Seek( cbHeader - sizeof(UInt32), System::IO::SeekOrigin::Begin );
		bwFile->Write( (UInt32) cbAudioData );


		// t@CTCYށB

		bwFile->Seek( sizeof(UInt32), System::IO::SeekOrigin::Begin );
		bwFile->Write( (UInt32)( cbHeader + cbAudioData - 8 ) );
	}
}