#include "Stdafx.h"
#include "CustomEVRPresenter.h"
#include "\AutoLock.h"
#include "MediaTypeBuilders.h"
#include "CustomGUID.h"
#include "Direct3D9\CDirect3DNative.h"


//=========================================================
// !! Win32 ƘAĝŁAO𔭐Ă͂ȂȂB!!
//=========================================================

namespace FDK
{
// public:

	HRESULT CustomEVRPresenter::CreateInstance( IUnknown *pUnkOuter, REFIID iid, void **ppv )
	{
		// p[^`FbNB

		if( pUnkOuter != NULL )
			return CLASS_E_NOAGGREGATION;

		if( ppv == NULL )
			return E_POINTER;


		HRESULT hr = S_OK;
		CustomEVRPresenter *pObject = NULL;
			
		try
		{
			// JX^v[^̃CX^X쐬B

			if( (pObject = new CustomEVRPresenter( hr )) == NULL )
				return E_OUTOFMEMORY;

			tFAILEDȂA( hr );


			// w肳ꂽC^[tF[XNGĕԂB

			tFAILEDȂA( hr = pObject->QueryInterface( iid, ppv ) );
		}
		finally
		{
			SAFE_COM_RELEASE( pObject );
		}

		return hr;
	}


	// IUnknown 

	STDMETHODIMP CustomEVRPresenter::QueryInterface( REFIID riid, void **ppv )
	{
		if( ppv == NULL )
			return E_POINTER;

		if( riid == __uuidof(IUnknown) )
			*ppv = static_cast<IUnknown*>( static_cast<IMFVideoPresenter*>(this) );

		else if( riid == __uuidof(IMFVideoDeviceID) )
			*ppv = static_cast<IMFVideoDeviceID*>(this);

		else if( riid == __uuidof(IMFVideoPresenter) )
			*ppv = static_cast<IMFVideoPresenter*>(this);

		else if( riid == __uuidof(IMFClockStateSink) )
			*ppv = static_cast<IMFClockStateSink*>(this);

		else if( riid == __uuidof(IMFRateSupport) )
			*ppv = static_cast<IMFRateSupport*>(this);

		else if( riid == __uuidof(IMFGetService) )
			*ppv = static_cast<IMFGetService*>(this);

		else if( riid == __uuidof(IMFTopologyServiceLookupClient) )
			*ppv = static_cast<IMFTopologyServiceLookupClient*>(this);

		else if( riid == __uuidof(IMFVideoDisplayControl) )
			*ppv = static_cast<IMFVideoDisplayControl*>(this);

		else if( riid == __uuidof(IMFActivate) )
			*ppv = static_cast<IMFActivate*>(this);

		else if( riid == __uuidof(IMFAttributes) )
			*ppv = static_cast<IMFAttributes*>(this);

		else
		{
			*ppv = NULL;
			return E_NOINTERFACE;
		}

		this->AddRef();

		return S_OK;
	}
	STDMETHODIMP_( ULONG ) CustomEVRPresenter::AddRef()
	{
		return ::InterlockedIncrement( &this->nQƃJE^ );
	}
	STDMETHODIMP_( ULONG ) CustomEVRPresenter::Release()
	{
		ULONG uCount = ::InterlockedDecrement( &this->nQƃJE^ );

		if( uCount == 0 )
			delete this;
        
		return uCount;
	}


	// IMFGetService 
	
	STDMETHODIMP CustomEVRPresenter::GetService( REFGUID guidService, REFIID riid, LPVOID *ppvObject )
	{
		if( guidService != MR_VIDEO_RENDER_SERVICE )	// MR_VIDEO_RENDER_SERVICE ȊÕT[rXID̓T|[gȂB
			return MF_E_UNSUPPORTED_SERVICE;

		if( ppvObject == NULL )
			return E_POINTER;


		HRESULT hr = S_OK;

		
		// ŏɁAv[^GW GetService() B

		Debug::Assert( this->m_pPresenterEngine != NULL );
		hr = m_pPresenterEngine->GetService( guidService, riid, ppvObject );

		
		// s QueryInterface() ֊ۓB

		if( FAILED( hr ) )
			hr = this->QueryInterface( riid, ppvObject );	// G[`FbNȂ

		return hr;
	}
	

	// IMFTopologyServiceLookupClient 
	
	STDMETHODIMP CustomEVRPresenter::InitServicePointers( IMFTopologyServiceLookup *pLookup )
	{
		// from MSDN:
		//
		// EVR v[^ƂAv[^ IMFTopologyServiceLookupClient::InitServicePointers ĂяoB
		// ɂ́AEVR  IMFTopologyServiceLookup ւ̃|C^i[ĂB
		//
		// v[^́AIMFTopologyServiceLookup::LookupService ĂяoāAEVR ~LT[C^[tF[X|C^擾B
		//
		// ET[rX GUID  MR_VIDEO_RENDER_SERVICE ȂAEVR ֖₢킹B
		// ET[rX GUID  MR_VIDEO_MIXER_SERVICE ȂA~LT[֖₢킹B
		// 
		// v[^́AInitServicePointers ̎̒ŁAEVR ȉ̃C^[tF[X擾邱ƁB
		//
		//	IMediaEventSink			v[^ EVR ɃbZ[W𑗂@񋟂B̃C^[tF[X DirectShow SDK 
		//							`Ă邽߁AbZ[W Media Foundation Cxgł͂Ȃ DirectShow Cxgp^[ɏ]B
		//
		//	IMFClock				EVR ̃NbN\Bv[^͂̃C^[tFXgāAv[e[ṼTvXPW[B
		//							EVR ̓NbNłs邱Ƃł邽߁ÃC^[tF[X͗p\ł͂ȂȂB
		//							ȂALookupService ̃G[R[h𖳎邱ƁB
		//							܂ANbN IMFTimer BMedia Foundation pCvCł́ANbN IMFPresentationClock B
		//
		// ~LT[͈ȉ̃C^[tF[X擾邱ƁB
		//
		//	IMFTransform			v[^~LT[ƂƂł悤ɂB
		//
		//	IMFVideoDeviceID		v[^[~LT[̃foCX GUID ؂邱ƂłB

		if( pLookup == NULL )
			return E_POINTER;

		HRESULT hr = S_OK;
		DWORD dwObjectCount = 0;

		AutoLock lock( m_ObjectLock );


		// Đ܂͒~ɏ邱Ƃ͋ȂB

		if( this->bĐ܂͈ꎞ~ł() )
			return MF_E_INVALIDREQUEST;


		// COM ̉

		SAFE_COM_RELEASE( m_pClock );
		SAFE_COM_RELEASE( m_pMixer );
		SAFE_COM_RELEASE( m_pMediaEventSink );

		#pragma region [ EVR  IMFClock 擾(m_pClock)B]
		//-----------------
		dwObjectCount = 1;

		hr = pLookup->LookupService(      
			MF_SERVICE_LOOKUP_GLOBAL,   // gpB
			0,                          // \B
			MR_VIDEO_RENDER_SERVICE,    // Ώۂ̃T[rXB
			__uuidof(IMFClock),         // Ώۂ̃C^[tF[XB
			(void**)&m_pClock,			// C^[tF[X̊i[ꏊizjB
			&dwObjectCount              // i[ꏊ̔z̗vfB
			);

		// EVR̓NbNĂȂmȂ̂ŁAhr ̐Es͖ȂB
			
		//-----------------
		#pragma endregion

		#pragma region [ Mixer(IMFTransform)擾(m_pMixer)B]
		//-----------------
		dwObjectCount = 1; 

		hr = pLookup->LookupService(
				MF_SERVICE_LOOKUP_GLOBAL,
				0,
				MR_VIDEO_MIXER_SERVICE,
				__uuidof( IMFTransform ),
				(void**) &m_pMixer,
				&dwObjectCount );

		if( FAILED( hr ) )
			goto failed;

		//-----------------
		#pragma endregion

		#pragma region [ Mixer  IMFVideoDeviceID 擾A`FbNB]
		//-----------------
		if( FAILED( hr = this->t~LTDeviceIDmF]`ݒ肷( m_pMixer ) ) )	// mF邾ŕێ͂ȂB
			goto failed;
		//-----------------
		#pragma endregion

		#pragma region [ EVR  IMediaEventSink 擾(m_pMediaEventSink)B]
		//-----------------
		dwObjectCount = 1;

		hr = pLookup->LookupService(
				MF_SERVICE_LOOKUP_GLOBAL,
				0,
				MR_VIDEO_RENDER_SERVICE,
				__uuidof( IMediaEventSink ),
				(void**) &m_pMediaEventSink,
				&dwObjectCount );

		if( FAILED( hr ) )
			goto failed;
		//-----------------
		#pragma endregion

		// ɐ̂ŃXe[^X stopped ɂB
		this->m_RenderState = RENDER_STATE_~;
		return S_OK;

	failed:
		SAFE_COM_RELEASE( m_pClock );
		SAFE_COM_RELEASE( m_pMixer );
		SAFE_COM_RELEASE( m_pMediaEventSink );
		return hr;
	}
	STDMETHODIMP CustomEVRPresenter::ReleaseServicePointers()
	{
		// from MSDN:
		//
		// LoopupService œꂽC^[tF[X|C^ɂȂ鎞AEVR  IMFTopologyServiceLookupClient::ReleaseServicePointers ĂяoB
		// ̃\bh̓ł́AׂẴ|C^Av[^̏Ԃ shutdown ɃZbgB

		HRESULT hr = S_OK;


		// Xe[^XuVbg_Eς݁vɕςB

		m_ObjectLock.Lock();
		this->m_RenderState = RENDER_STATE_Vbg_Eς;
		m_ObjectLock.Unlock();


		// XPW[Ă邷ׂẴTv̉B
		
		hr = this->Flush();		// s͖B

		
		// fBA^CvNAȂтɊ֘A郊\[XiT[tFCXȂǁj̉B

		hr = this->SetMediaType( NULL );	// s͖B


		// InitServicePointers() Ŏ擾eC^[tF[XB

		SAFE_COM_RELEASE( this->m_pClock );
		SAFE_COM_RELEASE( this->m_pMixer );
		SAFE_COM_RELEASE( this->m_pMediaEventSink );

		return S_OK;
	}

	
	// IMFVideoPresenter 

	STDMETHODIMP CustomEVRPresenter::ProcessMessage( MFVP_MESSAGE_TYPE eMessage, ULONG_PTR ulParam )
	{
		// from MSDN:
		//
		// ProcessMessage \bh́AEVR ɂƂăv[^ƒʐMDIJjYłB
		// ȉ̃bZ[W`ĂBebZ[W̎̏ڍׂɂĂ͌qB


		HRESULT hr = S_OK;
		AutoLock lock( m_ObjectLock );
	
		tFAILEDȂA( hr = this->tVbg_EԂȂG[Ԃ() );


		// bZ[Wɂ菈B

		switch( eMessage )
		{

		// EVR _OpCvCɂf[^tbVB
		// v[^̓XPW[OĂ邷ׂẴrfIt[jׂłB
		case MFVP_MESSAGE_FLUSH:

			return this->Flush();
				

		case MFVP_MESSAGE_INVALIDATEMEDIATYPE:
			// ~LT[̏o̓fBA^CvłB
			// v[^̓~LT[ƐVfBA^CvlSVG[VׂłB
			// v[^́AK؂ȃ^Cv܂ł́A MFVP_MESSAGE_INVALIDATEMEDIATYPE bZ[W󂯎ꍇB

			return this->RenegotiateMediaType();


		case MFVP_MESSAGE_PROCESSINPUTNOTIFY:
			// ~LT[V̓Tv󂯎邽тɁAEVR  MFVP_MESSAGE_PROCESSINPUTNOTIFY bZ[Wv[^ɑMB   
			// ̃bZ[ẂA~LT[񋟉\ȃrfIt[Ă邾낤ƂĂB
			// ƂāAv[^̓~LT[ IMFTransform::ProcessOutput ĂяoB
			// \bhꍇ́Av[^̓Tvv[e[VpɃXPW[B

			return this->ProcessInputNotify( );


		case MFVP_MESSAGE_BEGINSTREAMING:
			// Xg[~OJnꂽB
			// ̃bZ[Wɑ΂ēʂȃANVNKv͂ȂA\[X蓖ĂꍇɎgp邱ƂłB

			return this->BeginStreaming();


		case MFVP_MESSAGE_ENDSTREAMING:
			// Xg[~OIB
			// MFVP_MESSAGE_BEGINSTREAMING bZ[W󂯎Ɋ蓖ĂׂẴ\[X邱ƁB

			return this->EndStreaming( );


		case MFVP_MESSAGE_ENDOFSTREAM:
			// v[e[VIB

			this->m_bEndStreaming = TRUE; 
        	return this->CheckEndOfStream();	// IĂ EC_COMPLETE Cxg EVR ɑB


		case MFVP_MESSAGE_STEP:
			// v[^ɁAN t[OփXebv邱ƂvĂB
			// v[^͎ N-1 ̃t[jAN Ԗڂ̃t[\ׂłB

			return this->PrepareFrameStep( ((DWORD)(ulParam)) );


		case MFVP_MESSAGE_CANCELSTEP:
			// t[̃XebsOLZꂽB

			return this->CancelFrameStep();
		}

		return E_INVALIDARG;
	}
	STDMETHODIMP CustomEVRPresenter::GetCurrentMediaType( IMFVideoMediaType **ppMediaType )
	{
		// from MSDN:
		//
		// GetCurrentMediaType \bh́Av[^̃fBA^CvԂB
		// fBA^Cv IMFVideoMediaType |C^ƂĕԂB
		// IMFMediaType  IMFVideoMediaType 擾ɂ́AQueryInterface gB

		HRESULT hr = S_OK;
		AutoLock lock( m_ObjectLock );

		if( ppMediaType == NULL )
			return E_POINTER;

		if( this->m_pMediaType == NULL )
			return MF_E_NOT_INITIALIZED;

		tFAILEDȂA( hr = this->tVbg_EԂȂG[Ԃ() );

		
		// IMFMediaType  IMFVideoMediaType oĕԂB
		hr = this->m_pMediaType->QueryInterface( __uuidof(IMFVideoMediaType), (void**)&ppMediaType );	// G[`FbNȂ
		return hr;
	}


	// IMFClockStateSink 

	STDMETHODIMP CustomEVRPresenter::OnClockStart( MFTIME hnsSystemTime, LONGLONG llClockStartOffset )
	{
		// from MSDN:
		//
		// 1. v[^̃Xe[^X started ɃZbgB
		//
		// 2. llClockStartOffset  PRESENTATION_CURRENT_POSITION ł͂ȂȂAv[^̃TvL[tbVB
		//    i MFVP_MESSAGE_FLUSH bZ[W̎MƓBj
		//
		// 3. Õt[Xebv̗v܂ۗłꍇ́AvBȊȌꍇ́A~LT[̏o݂͂̏B
		//
		// v[^Vbg_EĂꍇA\bh͎sB
		//

		HRESULT hr = S_OK;
		AutoLock lock( m_ObjectLock );

		tFAILEDȂA( hr = this->tVbg_EԂȂG[Ԃ() );


		// (A) ~܂ĂȂԂJnꂽ

		if( this->bĐ܂͈ꎞ~ł() )
		{
			this->m_RenderState = RENDER_STATE_Đ;
			
			if( llClockStartOffset != PRESENTATION_CURRENT_POSITION )
			{
				// NbNANeBûƂɃNbNʒuύXꂽꍇA seek vłB
				// ̂Ƃɂ́AׂĂ̗܂ĂTvjKvB

				tFAILEDȂA( hr = this->Flush() );
			}
		}

		// (B) ~ԂJnꂽ
		else
		{
			this->m_RenderState = RENDER_STATE_Đ;

			// ݁At[XebsO̓rɂ邩A܂́At[XebvL[ɂ̑ҋ@Tv\B
			// ܂͂̃P[XB

			tFAILEDȂA( hr = this->StartFrameStep() );
		}

		
		// ~LT[Vo̓Tv̎擾݂B

		this->ProcessOutputLoop();

		return S_OK;
	}
	STDMETHODIMP CustomEVRPresenter::OnClockStop( MFTIME hnsSystemTime )
	{
		// from MSDN:
		//
		// 1. v[^̃Xe[^X stopped ɃZbgB
		// 2. v[^[̃TvL[tbVB
		// 3. ۗĂ邷ׂẴt[XebvLZB
		//
		// v[^Vbg_EĂꍇA\bh͎sB
		//

		HRESULT hr = S_OK;
		AutoLock lock( m_ObjectLock );

		tFAILEDȂA( hr = this->tVbg_EԂȂG[Ԃ() );

		// Xe[^Xu~vɂB

		if( this->m_RenderState == RENDER_STATE_~ )
			return S_OK;	// łɒ~ԂȂX[B

		this->m_RenderState = RENDER_STATE_~;
		

		// TvL[tbVB

		tFAILEDȂA( hr = this->Flush() );


		// t[XebvȂA𒼂ɃLZB

		if( this->m_FrameStep.state != FRAMESTEP_ĂȂ )
			tFAILEDȂA( hr = this->CancelFrameStep() );

		return S_OK;
	}
	STDMETHODIMP CustomEVRPresenter::OnClockPause( MFTIME hnsSystemTime )
	{
		// from MSDN:
		//
		// v[^̃Xe[^X paused ɃZbgB
		//
		// v[^Vbg_EĂꍇA\bh͎sB
		//

		HRESULT hr = S_OK;
		AutoLock lock( m_ObjectLock );

		tFAILEDȂA( hr = this->tVbg_EԂȂG[Ԃ() );

		this->m_RenderState = RENDER_STATE_ꎞ~;
		
		return S_OK;
	}
	STDMETHODIMP CustomEVRPresenter::OnClockRestart( MFTIME hnsSystemTime )
	{
		// from MSDN:
		//
		// ̃\bh́Apaused Ԃ̂ƂɂĂ΂Ă͂ȂB
		// OnClockStart() ƓɈATvL[̃tbV͂ȂB
		//
		// v[^Vbg_EĂꍇA\bh͎sB
		//

		AutoLock lock( m_ObjectLock );
		HRESULT hr = S_OK;

		tFAILEDȂA( hr = this->tVbg_EԂȂG[Ԃ() );

		if( this->m_RenderState != RENDER_STATE_ꎞ~ )
			return E_FAIL;	// ꎞ~ȂĂł̓_B
		
		
		// Xe[^XuĐvɂB
		
		this->m_RenderState = RENDER_STATE_Đ;


		// ݁At[XebsO̓rɂ邩A܂́At[XebvL[ɂ̑ҋ@Tv\B
		// ܂͂̃P[XB

		tFAILEDȂA( hr = this->StartFrameStep() );


		// ~LT[Vo̓Tv̎擾݂B

		this->ProcessOutputLoop();

		return S_OK;
	}
	STDMETHODIMP CustomEVRPresenter::OnClockSetRate( MFTIME hnsSystemTime, float fRate )
	{
		// from MSDN:
		//
		// 1. [[ɕύXꂽꍇ́At[XebsOLZB
		// 2. VNbN[gi[BNbN[ǵATv\^C~Oɉe^B
		//
		// v[^Vbg_EĂꍇA\bh͎sB
		//
		// lF
		// ł́AEVR ͍ő僌[gۏ؂̂Ɖ肷B
		// {́Av[^ IMFRateSupport C^[tF[Xő僌[gmFB

		AutoLock lock( m_ObjectLock );
		HRESULT hr = S_OK;

		tFAILEDȂA( hr = this->tVbg_EԂȂG[Ԃ() );

		if( ( this->m_fRate == 0.0f ) && ( fRate != 0.0f ) )
		{
			tFAILEDȂA( hr = this->CancelFrameStep() );
			this->m_FrameStep.samples.Clear();
		}

		this->m_fRate = fRate;
		this->m_scheduler.tNbN[gݒ肷( fRate );

		return S_OK;
	}


	// IMFRateSupport 

	STDMETHODIMP CustomEVRPresenter::GetSlowestRate( MFRATE_DIRECTION eDirection, BOOL bThin, float *pfRate )
	{
		// from MSDN:
		//
		// ŒᑬxȂꍇ 0 ԂB
		// v[^Vbg_EĂꍇA\bh͎sB
		//

		if( pfRate == NULL )
			return E_POINTER;

		AutoLock lock( m_ObjectLock );
		HRESULT hr = S_OK;

		tFAILEDȂA( hr = this->tVbg_EԂȂG[Ԃ() );

		// ŏ[g݂͑Ȃ̂ŁA0 ԂB
		*pfRate = 0; 

		return S_OK;
	}
	STDMETHODIMP CustomEVRPresenter::GetFastestRate( MFRATE_DIRECTION eDirection, BOOL bThin, float *pfRate )
	{
		// from MSDN:
		//
		// Đx́Aj^̃tbV[g𒴂Ă͂ȂȂB
		// Ȃ킿Aő呬xtbV[g[Hz]rfĨt[[g[fps] łB
		// rfĨt[[ǵAv[^̃fBA^CvɎw肳ĂB
		//
		// ԔĐȂAĐx͖łB̏ꍇ FLT_MAX lԂB
		// ۂɂ́A\[XƃfR[_͊ԔĐԂ̗vf̐󂯂邾낤B
		//
		// tĐꍇ́Aő呬x̕ԂB
		//
		// v[^Vbg_EĂꍇA\bh͎sB
		//

		if( pfRate == NULL )
			return E_POINTER;

		AutoLock lock( m_ObjectLock );
		HRESULT hr = S_OK;

		tFAILEDȂA( hr = this->tVbg_EԂȂG[Ԃ() );

		
		// ő̑O[g擾B
		
		float fMaxRate = this->GetMaxRate( bThin );


		// tĐȂ烌[g𔽓]B
		
		if( eDirection == MFRATE_REVERSE )
			fMaxRate = -fMaxRate;


		// [gԂB

		*pfRate = fMaxRate;

		return S_OK;
	}
	STDMETHODIMP CustomEVRPresenter::IsRateSupported( BOOL bThin, float fRate, float *pfNearestSupportedRate )
	{
		// from MSDN:
		//
		// fRate ̐Βlv[^̍őĐx𒴂ꍇAMF_E_UNSUPPORTED_RATE ԂB
		// ő呬xɂẮAGetFastestRate ŏqׂ@ŌvZB
		//
		// v[^Vbg_EĂꍇA\bh͎sB
		//

		HRESULT hr = S_OK;

		AutoLock lock( m_ObjectLock );

		tFAILEDȂA( hr = this->tVbg_EԂȂG[Ԃ( ) );

		float fMaxRate = 0.0f;
		float fNearestRate = fRate;   // fRate T|[gꍇ́A͋ߎlłB


		// őO[gmFB
		// lFŏ[g݂͑Ȃi擾0ԂjB

		fMaxRate = this->GetMaxRate( bThin );


		// w肳ꂽ[gAőO[g傫ꍇcc

		if( fabsf( fRate ) > fMaxRate )
		{
			// ߎlƂāAw肳ꂽl̐Βlő僌[gɎ߂B

			fNearestRate = fMaxRate;	
			if( fRate < 0 )
				fNearestRate = -fNearestRate;		// ̃[gw肳ꂽꍇ͔]B

			hr = MF_E_UNSUPPORTED_RATE;		// ̃G[ԂB
		}


		// T|[glƂāAߎlԂB

		if( pfNearestSupportedRate != NULL )	// NULL Ȃ疳B
			*pfNearestSupportedRate = fNearestRate;

		return hr;
	}


	// IMFVideoDeviceID 

	STDMETHODIMP CustomEVRPresenter::GetDeviceID( IID* pDeviceID )
	{
		// from MSDN:
		//
		// WIȃ~LT[v[^́Aǂ Direct3D9 gp邽߁AfoCXGUID IID_IDirect3DDevice9 łB
		// WIȃ~LT[ƃJX^v[^Agꍇ́Av[^̃foCX GUID  IID_IDirect3DDevice9 łȂ΂ȂȂB
		// ̃R|[lguȂAVfoCXGUID`łB
		// ̃\bh́Av[^Vbg_EĂ鎞łKvB

		if( pDeviceID == NULL )
			return E_POINTER;

		*pDeviceID = __uuidof(IDirect3DDevice9);

		return S_OK;
	}


	// IMFVideoDisplayControl 

	STDMETHODIMP CustomEVRPresenter::SetVideoPosition( const MFVideoNormalizedRect *pnrcSource, const LPRECT prcDest )
	{
		HRESULT hr = S_OK;

//		AutoLock lock( m_ObjectLock );		fbhbN̊댯

		#pragma region [ `FbN ]
		//-----------------
		if( pnrcSource == NULL && prcDest == NULL )
			return E_POINTER;

		if( pnrcSource )
		{
			if( ( pnrcSource->left > pnrcSource->right ) || ( pnrcSource->top > pnrcSource->bottom ) )
				return E_INVALIDARG;

			if( ( pnrcSource->left < 0 ) || ( pnrcSource->right > 1 ) || ( pnrcSource->top < 0 ) || ( pnrcSource->bottom > 1 ) )
				return E_INVALIDARG;
		}

		if( prcDest )
		{
			if( ( prcDest->left > prcDest->right ) || ( prcDest->top > prcDest->bottom ) )
				return E_INVALIDARG;
		}
		//-----------------
		#pragma endregion

		#pragma region [ ]`̎w肪ꍇ́A~LT[ɓo^B]
		//-----------------
		if( pnrcSource )
		{
			this->m_nrcSource = *pnrcSource;

			if( this->m_pMixer )
			{
				tFAILEDȂA( hr = this->SetMixerSourceRect( this->m_pMixer, this->m_nrcSource ) );
			}
		}
		//-----------------
		#pragma endregion

		#pragma region [ ]`̎w肪ꍇ́AXVB]
		//-----------------
		if( prcDest )
		{
			RECT rcOldDest = this->m_rcDest;

			if( !::EqualRect( &rcOldDest, prcDest ) )		// `ύXꂽꍇB
			{
				this->m_rcDest = *prcDest;

				//// VfBA^Cv~LT[ƃlSVG[VB

				//if( this->m_pMixer )
				//{
				//	hr = this->RenegotiateMediaType();
				//	
				//	if( hr == MF_E_TRANSFORM_TYPE_NOT_SET )
				//	{
				//		// This error means that the mixer is not ready for the media type.
				//		// Not a failure case -- the EVR will notify us when we need to set
				//		// the type on the mixer.
				//		hr = S_OK;
				//	}
				//	else
				//	{
				//		if( FAILED( hr ) )
				//			return hr;

				//		// The media type changed. Request a repaint of the current frame.
				//		this->m_bRepaint = TRUE;
				//		this->ProcessOutput(); // Ignore errors, the mixer might not have a video frame.
				//	}
				//}
			}
		}
		//-----------------
		#pragma endregion

		return hr;
	}
	STDMETHODIMP CustomEVRPresenter::GetVideoPosition( MFVideoNormalizedRect* pnrcSource, LPRECT prcDest )
	{
		AutoLock lock( m_ObjectLock );

		if( pnrcSource == NULL || prcDest == NULL )
			return E_POINTER;

		*pnrcSource = this->m_nrcSource;
		*prcDest = this->m_rcDest;

		return S_OK;
	}
	STDMETHODIMP CustomEVRPresenter::SetVideoWindow( HWND hwndVideo )
	{
		AutoLock lock( m_ObjectLock );

		if( !::IsWindow( hwndVideo ) )
			return E_INVALIDARG;

		if( this->m_pPresenterEngine == NULL )
			return MF_E_NOT_INITIALIZED;

		return this->m_pPresenterEngine->SetVideoWindow( hwndVideo );
	}
	STDMETHODIMP CustomEVRPresenter::GetVideoWindow( HWND* phwndVideo )
	{
		AutoLock lock( m_ObjectLock );

		if( phwndVideo == NULL )
			return E_POINTER;

		if( this->m_pPresenterEngine == NULL )
		{
			*phwndVideo = NULL;
			return MF_E_NOT_INITIALIZED;
		}

		*phwndVideo = this->m_pPresenterEngine->GetVideoWindow();

		return S_OK;
	}
	STDMETHODIMP CustomEVRPresenter::RepaintVideo()
	{
		AutoLock lock( m_ObjectLock );

		HRESULT hr = S_OK;

		tFAILEDȂA( hr = this->tVbg_EԂȂG[Ԃ() );


		// ܂TvȂȂ疳B

		if( this->m_bPrerolled )
		{
			this->m_bRepaint = TRUE;
			return this->ProcessOutput();
		}

		return hr;
	}
	STDMETHODIMP CustomEVRPresenter::SetRenderingPrefs( DWORD dwRenderFlags )
	{
		switch( dwRenderFlags )
		{

		case MFVideoRenderPrefs_DisplayChange:
			
			if( this->m_pMediaEventSink )		// EVR ɑ΂āAD3DfoCXύXꂽƂ EC_DISPLAY_CHANGED ʒmB
				return this->m_pMediaEventSink->Notify( EC_DISPLAY_CHANGED, 0, 0 );

		case MFVideoRenderPrefs_DisplaySample:
			
			if( this->m_pPresenterEngine )		// ŐṼTv`悷B
				this->m_pPresenterEngine->tTv`悷( NULL, &this->m_rcDest, this->ueNX`̓x, this->ueNX`̉Z );
			
			return S_OK;

		case MFVideoRenderPrefs_RequestNextSample:

			if( this->m_pPresenterEngine )		// ̃TvvB
				this->m_pPresenterEngine->t̃Tvv();

			return S_OK;
		}

		return E_INVALIDARG;
	}
	STDMETHODIMP CustomEVRPresenter::GetNativeVideoSize( SIZE* pszVideo, SIZE* pszARVideo )
	{
		if( pszVideo )
			*pszVideo = this->m_pPresenterEngine->GetVideoSize();

		return S_OK;
	}


	// IMFActivate 

	STDMETHODIMP CustomEVRPresenter::ActivateObject( REFIID riid, void **ppv )
	{
		return CustomEVRPresenter::CreateInstance( NULL, riid, ppv );
	}
	STDMETHODIMP CustomEVRPresenter::ShutdownObject()
	{
		return S_OK;
	}


	// IMFAttributes 

	STDMETHODIMP CustomEVRPresenter::GetUINT32( REFGUID guidKey, UINT32 *punValue )
	{
		if( punValue == NULL )
			return E_POINTER;

		if( IsEqualGUID( guidKey, GUIDofeNX`̓x ) )
		{
			*punValue = this->ueNX`̓x;
		}
		else if( IsEqualGUID( guidKey, GUIDofeNX`̉Z ) )
		{
			*punValue = this->ueNX`̉Z;
		}
		else
		{
			return MF_E_INVALID_KEY;
		}

		return S_OK;
	}
	STDMETHODIMP CustomEVRPresenter::SetUINT32( REFGUID guidKey, UINT32 unValue )
	{
		if( IsEqualGUID( guidKey, GUIDofeNX`̓x ) )
		{
			this->ueNX`̓x = unValue;

			if( this->ueNX`̓x > 255 )
				this->ueNX`̓x = 255;
		}
		else if( IsEqualGUID( guidKey, GUIDofeNX`̉Z ) )
		{
			this->ueNX`̉Z = unValue;
		}
		else
		{
			return MF_E_INVALID_KEY;
		}

		return S_OK;
	}


// protected:

	CustomEVRPresenter::CustomEVRPresenter( HRESULT &hr ) :
		m_SampleFreeCB( this, &CustomEVRPresenter::OnSampleFree )
	{
		this->m_RenderState = RENDER_STATE_Vbg_Eς;
		this->m_pPresenterEngine = NULL;
		this->m_pClock = NULL;
		this->m_pMixer = NULL;
		this->m_pMediaEventSink = NULL;
		this->m_pMediaType = NULL;
		this->m_bSampleNotify = FALSE;
		this->m_bRepaint = FALSE;
		this->m_bEndStreaming = FALSE;
		this->m_bPrerolled = FALSE;
		this->m_fRate = 1.0f;
		this->m_TokenCounter = 0;

		hr = S_OK;

		this->nQƃJE^ = 1;
		this->g_DefaultFrameRate.Numerator  = 30;
		this->g_DefaultFrameRate.Denominator = 1;
		this->ueNX`̓x = 255;
		this->ueNX`̉Z = 0;
		::SetRectEmpty( &this->m_rcDest );

		// ]` = (0,0,1,1)

		m_nrcSource.top = 0;
		m_nrcSource.left = 0;
		m_nrcSource.bottom = 1;
		m_nrcSource.right = 1;


		// v[^GW𐶐B

		this->m_pPresenterEngine = new PresenterEngine( hr );

		if( this->m_pPresenterEngine == NULL)
			hr = E_OUTOFMEMORY;

		
		// s炱ŏIB

		if( FAILED( hr ) )
		{
			SAFE_DELETE( this->m_pPresenterEngine );
			return;
		}


		// XPW[ɁAv[^GWւ̃R[obNݒB

		this->m_scheduler.tR[obNݒ肷( this->m_pPresenterEngine );
	}
	CustomEVRPresenter::~CustomEVRPresenter()
	{
		SAFE_COM_RELEASE( this->m_pClock );
		SAFE_COM_RELEASE( this->m_pMixer );
		SAFE_COM_RELEASE( this->m_pMediaEventSink );
		SAFE_COM_RELEASE( this->m_pMediaType );
		SAFE_DELETE( this->m_pPresenterEngine );
	}

	HRESULT CustomEVRPresenter::tVbg_EԂȂG[Ԃ() const
	{
		return ( this->m_RenderState == RENDER_STATE_Vbg_Eς ) ? MF_E_SHUTDOWN : S_OK;
	}
	BOOL	CustomEVRPresenter::bĐ܂͈ꎞ~ł() const
	{
		return ( ( this->m_RenderState == RENDER_STATE_Đ ) || ( this->m_RenderState == RENDER_STATE_ꎞ~ ) );
	}
	BOOL	CustomEVRPresenter::IsScrubbing() const
	{
		return ( m_fRate == 0.0f );
	}
	HRESULT	CustomEVRPresenter::tEVRɃCxgʒm( long EventCode, LONG_PTR Param1, LONG_PTR Param2 )
	{
		// from MSDN:
		//
		// v[^́AEVR ɗlXȃCxgʒmȂ΂ȂȂB
		// sɂ́AEVR  IMediaEventSink gpB
		// ̃C^[tF[X EVR v[^ IMFTopologyServiceLookupClient::InitServicePointers() ĂяoɎ擾łB
		// iIMediaEventSink C^[tF[X͂Ƃ DirectShow ̃C^[tF[Xł邪AMedia Foundation łgpĂBj
		//

		HRESULT hr = S_OK;

		if( this->m_pMediaEventSink == NULL )
			return MF_E_NOT_INITIALIZED;

		return this->m_pMediaEventSink->Notify( EventCode, Param1, Param2 );
	}
	float	CustomEVRPresenter::GetMaxRate( BOOL bThin )
	{
		// (A) Thinning = TRUE ̏ꍇF
		// @ő僌[gƂ FLT_MAX ԂB
		//
		// (B) Thinning = FALSE ̏ꍇF
		// @t[[gƃj^̃tbV[g擾łꍇ́Ã[gő僌[gƂĕԂB
		// @ȊȌꍇ FLT_MAX ԂB

		float   fMaxRate = FLT_MAX;
		MFRatio fps = { 0, 0 };
		UINT    utbV[gHz = 0; 

		if( !bThin && ( this->m_pMediaType != NULL ) )
		{
			if( FAILED( FDK::tfBA^Cv̑t[[gԂ( this->m_pMediaType, &fps ) ) )
			{
				fps.Numerator = 0;		// 擾s
				fps.Denominator = 0;
			}

			utbV[gHz = this->m_pPresenterEngine->RefreshRate();

			if( fps.Denominator && fps.Numerator && utbV[gHz )
			{
				// ő僌[g = tbV[gt[[g
				fMaxRate = (float) ::MulDiv( utbV[gHz, fps.Denominator, fps.Numerator );
			}
		}

		return fMaxRate;
	}
	float	CustomEVRPresenter::MFOffsetToFloat( const MFOffset& offset )
	{
		return (float)offset.value + (float)offset.value / 65536.0f;
	}

	// ~LT[

	HRESULT	CustomEVRPresenter::t~LTDeviceIDmF]`ݒ肷( IMFTransform *pMixer )
	{
		HRESULT hr = S_OK;
		IID deviceID = GUID_NULL;
		IMFVideoDeviceID *pDeviceID = NULL;

		try
		{
			// ~LT[foCXIDĂ邱ƂmFB
				
			tFAILEDȂA( hr = pMixer->QueryInterface( __uuidof( IMFVideoDeviceID ), (void**) &pDeviceID ) );	// ~LT[ IMFVideoDeviceID 擾B
			tFAILEDȂA( hr = pDeviceID->GetDeviceID( &deviceID ) );											// ~LT[foCXID擾B

			if( !::IsEqualGUID( deviceID, __uuidof( IDirect3DDevice9 ) ) )
				return MF_E_INVALIDREQUEST;		// ~LT[ DeviceID  IDirect3DDevice9 ł͂ȂB

			// ~LT̓]`ݒ肷B

			tFAILEDȂA( hr = this->SetMixerSourceRect( pMixer, this->m_nrcSource ) );
		}
		finally
		{
			SAFE_COM_RELEASE( pDeviceID );
		}

		return S_OK;
	}

	// tH[}bg

	HRESULT	CustomEVRPresenter::CreateOptimalVideoType( IMFMediaType *pProposedType, IMFMediaType **ppOptimalType )
	{
		HRESULT hr = S_OK;
	
		RECT rcOutput;
		::ZeroMemory( &rcOutput, sizeof(rcOutput) );
		
		MFVideoArea displayArea;
		::ZeroMemory( &displayArea, sizeof(displayArea) );
		
		VideoTypeBuilder *pmtOptimal = NULL;

		try
		{
			// fBA^Cvp VideoTypeBuilder 쐬B
			tFAILEDȂA( hr = VideoTypeBuilder::Create( &pmtOptimal ) );

			// w肳ꂽfBA^Cv畡ʁB
			tFAILEDȂA( hr = pmtOptimal->CopyFrom( pProposedType ) );

			// MF_MT_PIXEL_ASPECT_RATIO ւ̃fBXvCPAR (1:1) ɐݒB
			tFAILEDȂA( hr = pmtOptimal->SetPixelAspectRatio( 1, 1 ) );

			// gF̐ݒBł BT.709 gpB
			tFAILEDȂA( hr = pmtOptimal->SetYUVMatrix( MFVideoTransferMatrix_BT709 ) );
			tFAILEDȂA( hr = pmtOptimal->SetTransferFunction( MFVideoTransFunc_709 ) );
			tFAILEDȂA( hr = pmtOptimal->SetVideoPrimaries( MFVideoPrimaries_BT709 ) );
			tFAILEDȂA( hr = pmtOptimal->SetVideoNominalRange( MFNominalRange_16_235 ) );
			tFAILEDȂA( hr = pmtOptimal->SetVideoLighting( MFVideoLighting_dim ) );
				
			// \[X̃IWiTCYGWɓo^B
			UINT32 w, h;
			tFAILEDȂA( hr = pmtOptimal->GetFrameDimensions( &w, &h ) );	// \[X̃IWiTCY̎擾
			this->m_pPresenterEngine->SetVideoSize( w, h );						// o^

			// o͋` rcOutput \[X̃IWiTCYɐݒB
			rcOutput.right = w;
			rcOutput.bottom = h;

			// MF_MT_FRAME_SIZE  Direct3D T[tFCXɊ]镝ƍݒB
			tFAILEDȂA( hr = pmtOptimal->SetFrameDimensions( rcOutput.right, rcOutput.bottom ) );

			// MF_MT_PAN_SCAN_ENABLED  FALSE lݒB
			tFAILEDȂA( hr = pmtOptimal->SetPanScanEnabled( FALSE ) );

			// MF_MT_GEOMETRIC_APERTURE ɂ́ADirect3D T[tFCX̋`ZbgB
			// ~LT[o̓t[𐶐ƁA\[X摜̋`ɕ`悳B
			// ̋`́AT[tFCX傫AT[tFCX̃Tu`ɂ邱ƂłB

			displayArea = MakeArea( 0, 0, rcOutput.right, rcOutput.bottom );
			tFAILEDȂA( hr = pmtOptimal->SetGeometricAperture( displayArea ) );
			tFAILEDȂA( hr = pmtOptimal->SetPanScanAperture( displayArea ) );
			tFAILEDȂA( hr = pmtOptimal->SetMinDisplayAperture( displayArea ) );

			// fBA^Cv ppOptimalType ֏óB
			tFAILEDȂA( hr = pmtOptimal->GetMediaType( ppOptimalType ) );
		}
		finally
		{
			SAFE_COM_RELEASE( pmtOptimal );
		}

		return S_OK;
	}
	HRESULT	CustomEVRPresenter::SetMediaType( IMFMediaType *pMediaType )
	{
		//Debug::Assert( pMediaType != NULL );		fBA^CvNAɂ NULL w肷dlB

		#pragma region [ fBA^CvNAꍇB]
		//-----------------
		if( pMediaType == NULL )
		{
			// fBA^CṽNÁAǂȏԂłĂ\iVbg_EԊ܂ށjB
			SAFE_COM_RELEASE( m_pMediaType );
			this->ReleaseResources();
			return S_OK;	// NAB
		}
		//-----------------
		#pragma endregion

		HRESULT hr = S_OK;
		MFRatio fps = { 0, 0 };
		CVideoSampleList sampleQueue;
	
		try
		{
			tFAILEDȂA( hr = tVbg_EԂȂG[Ԃ() );

			// fBA^CvɕύXȂȂ牽IB
			if( this->AreMediaTypesEqual( m_pMediaType, pMediaType ) )	// ̊֐̈ɂ NULL w\B
				return S_OK;

			// ̃fBA^CvB
			SAFE_COM_RELEASE( m_pMediaType );
			this->ReleaseResources();
			
			// VfBA^Cvgăv[^GWB̓Iɂ͐VTvmۂB
			tFAILEDȂA( hr = m_pPresenterEngine->CreateVideoSamples( pMediaType, sampleQueue ) );

			// TvL[̃TvׂĂɂāAMFSamplePresenter_SampleCounter Ƀg[NJE^ݒ肷B
			// ̐ĺATvɂȂꍇɑATvɂȂƂƂɎgB

			IMFSample *pSample = NULL;
			for( CVideoSampleList::POSITION pos = sampleQueue.FrontPosition( ); pos != sampleQueue.EndPosition( ); pos = sampleQueue.Next( pos ) )
			{
				tFAILEDȂA( hr = sampleQueue.GetItemPos( pos, &pSample ) );
				tFAILEDȂA( hr = pSample->SetUINT32( MFSamplePresenter_SampleCounter, m_TokenCounter ) );
				SAFE_COM_RELEASE( pSample );
			}

			// Tvv[ɃTvL[̃TvǉB
			tFAILEDȂA( hr = m_SamplePool.t( sampleQueue ) );

			// XPW[Ƀt[[gݒ肷B
			if( SUCCEEDED( FDK::tfBA^Cv̑t[[gԂ( pMediaType, &fps ) ) && ( fps.Numerator != 0 ) && ( fps.Denominator != 0 ) )
				this->m_scheduler.tt[[gݒ肷( fps );
			else
				this->m_scheduler.tt[[gݒ肷( g_DefaultFrameRate );

			// fBA^CvۑB
			m_pMediaType = pMediaType;
			m_pMediaType->AddRef();
			
			hr = S_OK;
		}
		finally
		{
			if( FAILED( hr ) )
				this->ReleaseResources();
		}
		return hr;
	}
	HRESULT	CustomEVRPresenter::IsMediaTypeSupported( IMFMediaType *pMediaType )
	{
		HRESULT                 hr = S_OK;
		VideoTypeBuilder		*pmtProposed = NULL;

		try
		{
			// fBA^Cṽbp[IuWFNg쐬B
			tFAILEDȂA( hr = VideoTypeBuilder::Create( pMediaType, &pmtProposed ) );

			// ktH[}bg͋ۂB
			BOOL bk = FALSE;
			tFAILEDȂA( hr = pmtProposed->IsCompressedFormat( &bk ) );
			if( bk )
				return MF_E_INVALIDMEDIATYPE;

			// tH[}bg`FbNB
			D3DFORMAT d3dFormat = D3DFMT_UNKNOWN;
			tFAILEDȂA( hr = pmtProposed->GetFourCC( (DWORD*) &d3dFormat ) );
			tFAILEDȂA( hr = m_pPresenterEngine->tw肳ꂽtH[}bgp\ׂ( d3dFormat ) );

			// C^[X[h̓vObVû݋BC^[X͕sB
			MFVideoInterlaceMode InterlaceMode = MFVideoInterlace_Unknown;
			tFAILEDȂA( hr = pmtProposed->GetInterlaceMode( &InterlaceMode ) );
			if( InterlaceMode != MFVideoInterlace_Progressive )
				return MF_E_INVALIDMEDIATYPE;

			// t[TCYɑ΂eAp`ݒ肷B
			// fBA^CvKvƂAp`ł邩ǂɂĂ͒PɖB
			
			UINT32 width = 0, height = 0;
			MFVideoArea VideoCropArea;

			tFAILEDȂA( hr = pmtProposed->GetFrameDimensions( &width, &height ) );

			if( SUCCEEDED( pmtProposed->GetPanScanAperture( &VideoCropArea ) ) )
				this->ValidateVideoArea( VideoCropArea, width, height );	// G[`FbNȂ

			if( SUCCEEDED( pmtProposed->GetGeometricAperture( &VideoCropArea ) ) )
				this->ValidateVideoArea( VideoCropArea, width, height );	// 

			if( SUCCEEDED( pmtProposed->GetMinDisplayAperture( &VideoCropArea ) ) )
				this->ValidateVideoArea( VideoCropArea, width, height );	// 
		}
		finally
		{
			SAFE_COM_RELEASE( pmtProposed );
		}
		return S_OK;
	}

	// bZ[WnhO

	HRESULT	CustomEVRPresenter::Flush()
	{
		HRESULT hr = S_OK;

		this->m_bPrerolled = FALSE;

		// XPW[ɃtbVwB
		// XPW[͕\҂ĂTvĂ邩mȂB
		// ̌ĂяóAXPW[XbhׂẴTvj܂ŃubNB
		tFAILEDȂA( hr = m_scheduler.tTvL[tbV() );

		// t[XebvL[tbVB
		m_FrameStep.samples.Clear();

		// ~Ȃ獕ōĕ`悷B
		if( m_RenderState == RENDER_STATE_~ )
			tFAILEDȂA( hr = m_pPresenterEngine->tTv󂯎( NULL, 0 ) );

		return S_OK; 
	}
	HRESULT	CustomEVRPresenter::RenegotiateMediaType()
	{
		// v[^́AEVR  MFVP_MESSAGE_INVALIDATEMEDIATYPE bZ[W󂯎͂łA
		// ~LT[̏o̓tH[}bgȉ̂悤ɐݒ肵Ȃ΂ȂȂB

		HRESULT hr = S_OK;
		IMFMediaType *pMixerType = NULL;
		IMFMediaType *pOptimalType = NULL;
		IMFVideoMediaType *pVideoType = NULL;

		// ~LT[ȂȂAҁB
		if( !m_pMixer )
			return MF_E_INVALIDREQUEST;

		try
		{
			// ~LT[Ή\ȂׂĂ̏o̓^Cvɂācc

			DWORD iTypeIndex = 0;

			while( hr != MF_E_NO_MORE_TYPES )
			{
				SAFE_COM_RELEASE( pMixerType );
				SAFE_COM_RELEASE( pOptimalType );


				//-----------------
				// (1)~LT[ IMFTransform::GetOutputAvailableType() ĂяoA\ȏo̓^Cv擾B
				//    ̃^Cv́A~LT[̓Xg[琶邱ƂłtH[}bgƁAOtBbNfoCX̃rfIvZbVO\͂LqB

				hr = m_pMixer->GetOutputAvailableType( 0, iTypeIndex++, &pMixerType );
				if( FAILED( hr ) )	// w肵CfbNX̃^CvȂA~LT[ MF_E_NO_MORE_TYPES ԂB
					break;			// Ń[vIB


				//-----------------
				// (2)v[^̃fBA^Cv_OtH[}bgƂĎgpł邩ۂmFB
				//    ^CvełȂꍇ́AXebv(1) ɖ߂A~LT[̎̐^Cv擾B

				if( FAILED( hr = this->IsMediaTypeSupported( pMixerType ) ) )
					continue;


				//-----------------
				// (3)IWi^CṽN[ƂĐVfBA^Cv쐬B

				if( FAILED( hr = this->CreateOptimalVideoType( pMixerType, &pOptimalType ) ) )
					continue;


				//-----------------
				// (4)~LT[Cꂽo̓^Cv󂯓邩ǂeXg邽߂ɁAMFT_SET_TYPE_TEST_ONLY tOw肵
				//    IMFTransform::SetOutputType() ĂяoB
				//    ~LT[^Cv₵AXebv(1)ɖ߂Ď̃^Cv擾B

				if( FAILED( hr = m_pMixer->SetOutputType( 0, pOptimalType, MFT_SET_TYPE_TEST_ONLY ) ) )
					continue;


				//-----------------
				// (5)Direct3D T[tFCX̃v[蓖ĂB
				//    ~LT[͂̃T[tFCXgčς݃rfIt[`悷B

				if( FAILED( hr = this->SetMediaType( pOptimalType ) ) )
					continue;


				//-----------------
				// (6)tOȂ SetOutputType ĂяoA~LT[ɏo̓^CvZbgB
				//    Xebv(4)ł SetOutputType() ĂꍇǍĂяo邾낤B

				if( FAILED( hr = m_pMixer->SetOutputType( 0, pOptimalType, 0 ) ) )
				{
					this->SetMediaType( NULL );	// ܂ŗăAEgAfBA^CvNAB
					continue;
				}

				break;	// 
			}
		}
		finally
		{
			SAFE_COM_RELEASE( pMixerType );
			SAFE_COM_RELEASE( pOptimalType );
			SAFE_COM_RELEASE( pVideoType );
		}
		return S_OK;
	}
	HRESULT	CustomEVRPresenter::ProcessInputNotify()
	{
		HRESULT hr = S_OK;

		// ~LT[VTvƂʒmtO𗧂ĂB
		this->m_bSampleNotify = TRUE;

		// fBA^CvݒȂG[B
		if( this->m_pMediaType == NULL )
			return MF_E_TRANSFORM_TYPE_NOT_SET;

		this->ProcessOutputLoop();
		return S_OK;
	}
	HRESULT	CustomEVRPresenter::BeginStreaming()
	{
		return this->m_scheduler.tXPW[[JXbhŊJn( this->m_pClock );
	}
	HRESULT	CustomEVRPresenter::EndStreaming()
	{
		return this->m_scheduler.tXPW[~[JXbhI();
	}
	HRESULT	CustomEVRPresenter::CheckEndOfStream()
	{
		if( !m_bEndStreaming )
			return S_OK;	// EVR  MFVP_MESSAGE_ENDOFSTREAM 𑗐MȂ̂ŒӁB

		if( m_bSampleNotify )
			return S_OK;	// ~LT[܂TvĂB

		if( m_SamplePool.bTv݂Ă() )
			return S_OK;	// `pɃXPW[ĂTvB

		// ׂĊĂ̂ŁAEVR ɏIB

		tEVRɃCxgʒm( EC_COMPLETE, (LONG_PTR) S_OK, 0 );
		m_bEndStreaming = FALSE;

		return S_OK;
	}

	// TvǗ

	void	CustomEVRPresenter::ProcessOutputLoop()
	{
		HRESULT hr = S_OK;

		// \Ȍ葽̃TvB

		while( hr == S_OK )
		{
			// ~LT[̓TvĂȂȂ烋[v𔲂B
			if( !m_bSampleNotify )
			{
				hr = MF_E_TRANSFORM_NEED_MORE_INPUT;
				break;
			}

			// TvBTvȂꍇ S_FALSE Ԃ̂ŁA[v𔲂B
			hr = this->ProcessOutput();
		}

		// ~LT[̓f[^̏łꍇAXg[IĂȂmFB
		if( hr == MF_E_TRANSFORM_NEED_MORE_INPUT )
			hr = this->CheckEndOfStream();
	}
	HRESULT	CustomEVRPresenter::ProcessOutput()
	{
		HRESULT     hr = S_OK;
		DWORD       dwStatus = 0;
		LONGLONG    mixerStartTime = 0, mixerEndTime = 0;
		MFTIME      systemTime = 0;
		BOOL        bRepaint = m_bRepaint;
		IMFSample	*pSample = NULL;

		MFT_OUTPUT_DATA_BUFFER dataBuffer;
		::ZeroMemory( &dataBuffer, sizeof( dataBuffer ) );

		try
		{
			//-----------------
			// 	1. NbNXe[^XmFB
			//     NbN paused ̏ꍇAMFVP_MESSAGE_PROCESSINPUTNOTIFY bZ[ẂAꂪŏ̃rfIt[łȂ薳邱ƁB
			//     NbN running łA܂͂ꂪŏ̃rfIt[łꍇ́AB

			if( ( m_RenderState != RENDER_STATE_Đ ) &&	// ĐJnĂȂAA
				!m_bRepaint &&								// ĕ`vȂAA
				m_bPrerolled )								// ߂Ă̕`悶ȂȂAAB
			{
				return S_FALSE;
			}

			if( m_pMixer == NULL )
				return MF_E_INVALIDREQUEST;		// `𖞂Ă̂Ƀ~LT[Ȃ̂͂B


			//-----------------
			// 2. p\ȃTṽL[Tv𓾂B
			//    L[̏ꍇAׂ͂Ă̊蓖čς݃Tv\XPW[Ă邱ƂӖB
			//    ̏ꍇAMFVP_MESSAGE_PROCESSINPUTNOTIFY bZ[W͂̎_ŖB
			//    ̃Tvp\ɂȂƂAɋLڂĂ菇JԂB

			if( ( hr = m_SamplePool.tv[Tvo( &pSample ) ) == MF_E_SAMPLEALLOCATOR_EMPTY )
				return S_FALSE;		// n

			tFAILEDȂA( hr );	// n


			//-----------------
			// 	3. ĕ`vꍇ́ATvɍŌ̃Tvݒ肷B
			//     ĕ`vȂꍇ́ATv̕`]NAB

			// (a) ĕ`v̏ꍇ
			if( m_bRepaint )
			{
				tFAILEDȂA( hr = this->SetDesiredSampleTime( pSample, m_scheduler.llŌ̃Tv(), m_scheduler.llt[Ԋu() ) );
				m_bRepaint = FALSE;		// Bĕ`vNAB
			}

			// (b) ĕ`vł͂Ȃꍇ
			else
			{
				// Tv̕`]NAB~LT[͎̃t[łB
				tFAILEDȂA( hr = this->ClearDesiredSampleTime( pSample ) );

				// iIvVjNbNp\łꍇÃ݂NbN^C擾B
				if( m_pClock )
				{
					// CeVpɁAProcessOutput() JnꂽLĂB
					(void) m_pClock->GetCorrelatedTime( 0, &mixerStartTime, &systemTime );
				}
			}


			//-----------------
			// 4. ~LT[ IMFTransform::ProcessOutput ĂяoB
			//    ꍇATv̓rfIt[܂łB
			//    sꍇAԂꂽR[h`FbN邱ƁB

			dataBuffer.dwStreamID = 0;
			dataBuffer.pSample = pSample;
			dataBuffer.dwStatus = 0;

			hr = m_pMixer->ProcessOutput( 0, 1, &dataBuffer, &dwStatus );

			if( FAILED( hr ) )
			{
				#pragma region [ (a) s ]
				//-----------------

				HRESULT hr2 = m_SamplePool.tTvv[ɖ߂( pSample );

				if( FAILED( hr2 ) )
					tFAILEDȂA( hr = hr2 );

				// ProcessOutput 瓾ȉ̃G[R[h͒vIȎsł͂ȂB

				if( hr == MF_E_TRANSFORM_TYPE_NOT_SET )
				{
					// ~LT[͐VfBA^CvvĂB
					// ̃G[R[h擾ꍇA~LT[̏o̓^CvlSVG[V邱ƁB

					hr = this->RenegotiateMediaType();
				}
				else if( hr == MF_E_TRANSFORM_STREAM_CHANGE )
				{
					// ~LT[̏o̓^CvłB炭㗬̃tH[}bgύXłB
					// ̃G[R[h擾ꍇAv[^̃fBA^Cv NULL ɐݒ肷邱ƁB
					// EVR ͐VtH[}bgv邾낤B

					this->SetMediaType( NULL );
				}
				else if( hr == MF_E_TRANSFORM_NEED_MORE_INPUT )
				{
					// ~LT[́AVt[𐶐邽߂ɂȂ͂KvƂĂB
					// ̃G[R[h擾ꍇAEVR Xg[̏I[ɓBǂmFAB
					// ȊȌꍇ́ÃbZ[W𖳎邱ƁB

					// ~LT[ ProcessOutput() \bh MF_E_TRANSFORM_NEED_MORE_INPUT ԂꍇA
					// ́A~LT[o͂𐶐łȂƂӖ邽߁Av[^ m_fSampleNotify tONAB
					m_bSampleNotify = FALSE;
				}
				//-----------------
				#pragma endregion
			}
			else
			{
				#pragma region [ (b) s ]
				//-----------------

				// 5.iIvVjNbNp\ȏꍇ́Ã݂NbN^C擾iT2jB
				//   ~LT[ɂēxʂ (T2 - T1) łB
				//   ̒lāAEVR  EC_PROCESSING_LATENCY Cxg𑗂邱ƁBEVR ͂̒liɗpB
				//   NbN͎gȂꍇ́AEC_PROCESSING_LATENCY 𑗐M闝R͂ȂB

				if( m_pClock && !bRepaint )
				{
					(void) m_pClock->GetCorrelatedTime( 0, &mixerEndTime, &systemTime );

					LONGLONG latencyTime = mixerEndTime - mixerStartTime;
					tFAILEDȂA( hr = this->tEVRɃCxgʒm( EC_PROCESSING_LATENCY, (LONG_PTR) &latencyTime, 0 ) );
				}

				
				// 6.iIvVjTv IMFTrackedSample ₢킹AIMFTrackedSample::SetAllocator ĂяoB

				tFAILEDȂA( hr = this->TrackSample( pSample ) );

				
				// 7. Tvv[e[VpɃXPW[OB

				if( ( m_FrameStep.state == FRAMESTEP_ĂȂ ) || bRepaint )
				{
					tFAILEDȂA( hr = DeliverSample( pSample, bRepaint ) );
				}
				else
				{
					tFAILEDȂA( hr = DeliverFrameStepSample( pSample ) );
				}

				// ȂƂP̃Tv`łB
				m_bPrerolled = TRUE;

				//-----------------
				#pragma endregion
			}
		}
		finally
		{
			SAFE_COM_RELEASE( dataBuffer.pEvents );
			SAFE_COM_RELEASE( pSample );
		}

		return hr;
	}
	HRESULT	CustomEVRPresenter::DeliverSample( IMFSample *pSample, BOOL bRepaint )
	{
		HRESULT hr = S_OK;
		PresenterEngine::D3DDEVICE_STATE state = PresenterEngine::D3DDEVICE_STATE_OK;

		// Đł͂Ȃ or R}蒆ł͂Ȃ or ĕ`vł͂Ȃ@@Tv𑦎`悷邩XPW[ɓ
		BOOL bPresentNow = ( ( this->m_RenderState != RENDER_STATE_Đ ) || this->IsScrubbing() || bRepaint );

		hr = CDirect3DNative::tfoCX̏Ԃ擾();
		if( SUCCEEDED( hr ) )
			hr = this->m_scheduler.tVTv\邩XPW[L[ɓ( pSample, bPresentNow );

		// s瑦fB
		if( hr == D3DERR_DEVICEREMOVED || hr == D3DERR_OUTOFVIDEOMEMORY )
			this->tEVRɃCxgʒm(EC_ERRORABORT, hr, 0);

		return hr;
	}
	HRESULT	CustomEVRPresenter::TrackSample( IMFSample *pSample )
	{
		HRESULT hr = S_OK;
		IMFTrackedSample *pTracked = NULL;

		try
		{
			tFAILEDȂA( hr = pSample->QueryInterface( __uuidof( IMFTrackedSample ), (void**) &pTracked ) );
			tFAILEDȂA( hr = pTracked->SetAllocator( &m_SampleFreeCB, NULL ) );
		}
		finally
		{
			SAFE_COM_RELEASE( pTracked );
		}

		return hr;
	}
	void	CustomEVRPresenter::ReleaseResources()
	{
		HRESULT hr = S_OK;

		// g[NJE^[𑝂₷ƂŁAׂẴrfITvꂽƂSXbhɒʒmB
		//  OnSampleFree() R[obNŃv[^ĖꂽTvgĂ܂ƂB

		this->m_TokenCounter++;


		// ׂẴTvAjB

		this->Flush();
		this->m_SamplePool.Clear();
		this->m_pPresenterEngine->ReleaseResources();
	}

	// t[XebsOiR}j

	HRESULT	CustomEVRPresenter::PrepareFrameStep( DWORD cSteps )
	{
		HRESULT hr = S_OK;

		// XebvJEgɉZB
		m_FrameStep.steps += cSteps;

		// t[Xebv̏ԂݒB
		m_FrameStep.state = FRAMESTEP_Ă邯ǃNbN͎n܂ĂȂ;

		// NbNɎn܂ĂȂAt[XebsOɊJnłB
		if( m_RenderState == RENDER_STATE_Đ )
			tFAILEDȂA( hr = this->StartFrameStep() );

		return S_OK;
	}
	HRESULT	CustomEVRPresenter::StartFrameStep()
	{
		HRESULT hr = S_OK;
		IMFSample *pSample = NULL;

		try
		{
			if( this->m_FrameStep.state == FRAMESTEP_Ă邯ǃNbN͎n܂ĂȂ )
			{
				// ܃Tv҂̏ԁB
				this->m_FrameStep.state = FRAMESTEP_NbN͎n܂ĂăTv҂Ă;

				// L[ɂ邷ׂẴTvɂācc
				while( !this->m_FrameStep.samples.IsEmpty() &&													// t[XebvL[ɂȂ邩
					 ( this->m_FrameStep.state == FRAMESTEP_NbN͎n܂ĂăTv҂Ă ) )		// t[Xebv삪΃[v𔲂B
				{
					tFAILEDȂA( hr = this->m_FrameStep.samples.RemoveFront( &pSample ) );
					tFAILEDȂA( hr = this->DeliverFrameStepSample( pSample ) );
				}
			}
			else if( m_FrameStep.state == FRAMESTEP_ĂȂ )
			{
				// t[XebvȂ̂ɃTvꍇ͂𕁒ʂɏB
				while( !m_FrameStep.samples.IsEmpty() )
				{
					tFAILEDȂA( hr = m_FrameStep.samples.RemoveFront( &pSample ) );
					tFAILEDȂA( hr = DeliverSample( pSample, FALSE ) );
				}
			}
		}
		finally
		{
			SAFE_COM_RELEASE( pSample );
		}

		return S_OK;
	}
	HRESULT	CustomEVRPresenter::DeliverFrameStepSample( IMFSample *pSample )
	{
		HRESULT hr = S_OK;
		IUnknown *pUnk = NULL;

		#pragma region [ ̃TvgȂȂ疳ďIB]
		//-----------------
		if( this->IsScrubbing() &&									// t[XebsOŁA
			this->m_pClock &&										// NbN݂A
			this->IsSampleTimePassed( this->m_pClock, pSample ) )	// Tv̕`掞߂ĂȂA
		{
			return S_OK;											// ̃Tv͖B
		}
		//-----------------
		#pragma endregion

		#pragma region [ ɕ`ς݂ȂÃTv\邽߂ɁA܂t[XebvL[ɖ߂ďIB]
		//-----------------
		if( this->m_FrameStep.state == FRAMESTEP_STATE::FRAMESTEP_`悷Tv̂ꂽ ||
			this->m_FrameStep.state == FRAMESTEP_STATE::FRAMESTEP_Tv̕`͊ )
		{
			return this->m_FrameStep.samples.InsertBack( pSample );
		}
		//-----------------
		#pragma endregion

		#pragma region [ ܂TvXṼ^C~OȂȂ牽IB]
		//-----------------
		// Xebv炷B
		if( this->m_FrameStep.steps > 0 )
			this->m_FrameStep.steps--;

		// ܂Ō̃Xebvł͂ȂȂAȂB
		if( this->m_FrameStep.steps > 0 )
			return S_OK;
		//-----------------
		#pragma endregion

		#pragma region [ NbNJnĂȂȂÃTvt[XebvL[ɖ߂āAIB]
		//-----------------
		if( this->m_FrameStep.state == FRAMESTEP_STATE::FRAMESTEP_Ă邯ǃNbN͎n܂ĂȂ )
			return this->m_FrameStep.samples.InsertBack( pSample );
		//-----------------
		#pragma endregion

		try
		{
			// NbNJnĂ̂ŁÃTvzMB
			tFAILEDȂA( hr = this->DeliverSample( pSample, FALSE ) );

			// ŃTvʂ邽߂ɁAIUnknown 擾ĂB
			//  COMł́ÃIuWFNgɑ΂ IUnknown ₢킹Ɠ̃|C^ԂB
			tFAILEDȂA( hr = pSample->QueryInterface( __uuidof( IUnknown ), (void**) &pUnk ) );
			this->m_FrameStep.pSampleNoRef = (DWORD_PTR) pUnk;		// QƂł͂ȂʎqƂĎgȂ̂ŁAAddRef() ͂ȂB

			// ̊BԂXVB
			this->m_FrameStep.state = FRAMESTEP_`悷Tv̂ꂽ;
		}
		finally
		{
			SAFE_COM_RELEASE( pUnk );
		}

		return S_OK;
	}
	HRESULT	CustomEVRPresenter::CompleteFrameStep( IMFSample *pSample )
	{
		HRESULT hr = S_OK;
		MFTIME hnsSampleTime = 0;
		MFTIME hnsSystemTime = 0;

		// ԂuvɍXVA`Tv̎ʎq(IUnknown|C^)NAB
		m_FrameStep.state = FRAMESTEP_Tv̕`͊;
		m_FrameStep.pSampleNoRef = NULL;

		// EVR ɁAt[XebsOƂʒmB
		tFAILEDȂA( hr = tEVRɃCxgʒm( EC_STEP_COMPLETE, FALSE, 0 ) );	// FALSE = iLZĂȂjӖ

		// ~ȂAEVR ɒ~CxgʒmB
		if( this->IsScrubbing() )
		{
			// Tv̕`掞擾B
			hr = pSample->GetSampleTime( &hnsSampleTime );
			
			// 擾ɎsÃ݂v[e[VgB
			if( FAILED( hr ) )
			{
				if( m_pClock )
					(void) m_pClock->GetCorrelatedTime( 0, &hnsSampleTime, &hnsSystemTime );		// G[`FbNȂ
			}

			// EVR ֎CxgʒmB
			tFAILEDȂA( this->tEVRɃCxgʒm( EC_SCRUB_TIME, LODWORD( hnsSampleTime ), HIDWORD( hnsSampleTime ) ) );
		}

		return S_OK;
	}
	HRESULT	CustomEVRPresenter::CancelFrameStep()
	{
		HRESULT hr = S_OK;
		FRAMESTEP_STATE oldState = this->m_FrameStep.state;

		// ōĊJ邩mȂ̂ŁALZ̒iKł͂܂t[XebvL[̓NAȂƁB

		this->m_FrameStep.state = FRAMESTEP_ĂȂ;
		this->m_FrameStep.steps = 0;
		this->m_FrameStep.pSampleNoRef = NULL;

		if( oldState == FRAMESTEP_STATE::FRAMESTEP_Ă邯ǃNbN͎n܂ĂȂ ||
			oldState == FRAMESTEP_STATE::FRAMESTEP_NbN͎n܂ĂăTv҂Ă ||
			oldState == FRAMESTEP_STATE::FRAMESTEP_`悷Tv̂ꂽ )
		{
			// EVRցAt[XebsO̍ŒɃLZꂽƂʒmB
			tFAILEDȂA( hr = tEVRɃCxgʒm( EC_STEP_COMPLETE, TRUE, 0 ) );	// TRUE = LZꂽił͂ȂjӖ
		}

		return S_OK;
	}

	// R[obN

	HRESULT	CustomEVRPresenter::OnSampleFree( IMFAsyncResult *pResult )
	{
		HRESULT hr = S_OK;
		IUnknown *pObject = NULL;
		IMFSample *pSample = NULL;
		IUnknown *pUnk = NULL;

		try
		{
			// 񓯊ʃIuWFNg pResult Tv擾B

			tFAILEDȂA( hr = pResult->GetObject( &pObject ) );											// IUnknown 擾
			tFAILEDȂA( hr = pObject->QueryInterface( __uuidof( IMFSample ), (void**) &pSample ) );	// IMFSample ֕ϊ


			// Tvt[XebsOpɎ̂ĂȂAt[XebvB
			
			if( this->m_FrameStep.state == FRAMESTEP_STATE::FRAMESTEP_`悷Tv̂ꂽ )
			{
				// Tv̎ʎq(IUnknown|C^)擾
				tFAILEDȂA( hr = pSample->QueryInterface( __uuidof( IMFSample ), (void**) &pUnk ) );	// pObject ͎gȂ̂ŒӁI

				// Deliver ς݂̃TvƓ̎ʎqȂAEVR փt[XebvʒmB
				if( this->m_FrameStep.pSampleNoRef == (DWORD_PTR) pUnk )
					tFAILEDȂA( hr = this->CompleteFrameStep( pSample ) );
			}


			// Tv܂łȂig[NJE^ςĂȂjȂATvv[ɖ߂ĕ`悷B

			AutoLock lock( this->m_ObjectLock );

			if( ::MFGetAttributeUINT32( pSample, MFSamplePresenter_SampleCounter, (UINT32) -1 ) == m_TokenCounter )
			{
				tFAILEDȂA( hr = m_SamplePool.tTvv[ɖ߂( pSample ) );
				(void) ProcessOutputLoop();		// G[`FbNȂ
			}
		}
		finally
		{
			if( FAILED( hr ) )
				(void) this->tEVRɃCxgʒm( EC_ERRORABORT, hr, 0 );		// G[`FbNȂ

			SAFE_COM_RELEASE( pObject );
			SAFE_COM_RELEASE( pSample );
			SAFE_COM_RELEASE( pUnk );
		}

		return S_OK;
	}


// private:

	RECT	CustomEVRPresenter::CorrectAspectRatio( const RECT& src, const MFRatio& srcPAR, const MFRatio& destPAR )
	{
		// `̏l͓]`ł邪A (0,0) ̃ItZbgłƂ݂ȂB
		RECT rc = { 0, 0, src.right - src.left, src.bottom - src.top };

		// ]Ɠ] PAR ȂA邱Ƃ͂ȂB
		// قȂȂAȉ̎菇ŉ摜TCY𒲐B
		//   1. ] PAR  1:1 ɕό`B
		//   2. 1:1 ] PAR ɕό`B
		
		if( ( srcPAR.Numerator != destPAR.Numerator ) || ( srcPAR.Denominator != destPAR.Denominator ) )	// قȂĂ
		{
			//------------------
			// 1. ] PAR  1:1 ɕϊB
			
			if( srcPAR.Numerator > srcPAR.Denominator )
			{
				// ] PAR ͉łB
				rc.right = ::MulDiv( rc.right, srcPAR.Numerator, srcPAR.Denominator );
			}
			else if( srcPAR.Numerator < srcPAR.Denominator )
			{
				// ] PAR ͏cłB
				rc.bottom = ::MulDiv( rc.bottom, srcPAR.Denominator, srcPAR.Numerator );
			}
			else
			{
				// ] PAR ͊ 1:1 łB
			}

			//------------------
			// 2. 1:1 ] PAR ɕϊB

			if( destPAR.Numerator > destPAR.Denominator )
			{
				// ] PAR ͉łB
				rc.bottom = MulDiv( rc.bottom, destPAR.Numerator, destPAR.Denominator );
			}
			else if( destPAR.Numerator < destPAR.Denominator )
			{
				// ] PAR ͏cłB
				rc.right = MulDiv( rc.right, destPAR.Denominator, destPAR.Numerator );
			}
			else
			{
				// ] PAR  1:1 łB
			}
		}

		return rc;
	}
	BOOL	CustomEVRPresenter::AreMediaTypesEqual( IMFMediaType *pType1, IMFMediaType *pType2 )
	{
		// ǂ NULL Ȃ瓙ƌȂB
		if( ( pType1 == NULL ) && ( pType2 == NULL ) )
			return TRUE;

		// ꂩ NULL ȂقȂƌȂB
		if( ( pType1 == NULL ) || ( pType2 == NULL ) )
			return FALSE;

		// ҂rB
		DWORD dwFlags = 0;
		HRESULT hr = pType1->IsEqual( pType2, &dwFlags );
		return ( hr == S_OK );
	}
	HRESULT	CustomEVRPresenter::ValidateVideoArea( const MFVideoArea& area, UINT32 width, UINT32 height )
	{
		float fOffsetX = this->MFOffsetToFloat( area.OffsetX );
		float fOffsetY = this->MFOffsetToFloat( area.OffsetY );

		if( ( (LONG) fOffsetX + area.Area.cx > (LONG) width ) ||
			( (LONG) fOffsetY + area.Area.cy > (LONG) height ) )
		{
			return MF_E_INVALIDMEDIATYPE;
		}
		else
		{
			return S_OK;
		}
	}
	HRESULT	CustomEVRPresenter::SetDesiredSampleTime( IMFSample *pSample, const LONGLONG& hnsSampleTime, const LONGLONG& hnsDuration )
	{
		if( pSample == NULL )
			return E_POINTER;

		HRESULT hr = S_OK;
		IMFDesiredSample *pDesired = NULL;

		try
		{
			tFAILEDȂA( hr = pSample->QueryInterface( __uuidof( IMFDesiredSample ), (void**) &pDesired ) );
			pDesired->SetDesiredSampleTimeAndDuration( hnsSampleTime, hnsDuration );
		}
		finally
		{
			SAFE_COM_RELEASE( pDesired );
		}

		return S_OK;
	}
	HRESULT	CustomEVRPresenter::ClearDesiredSampleTime( IMFSample *pSample )
	{
		if( pSample == NULL )
			return E_POINTER;

		HRESULT hr = S_OK;
		IMFDesiredSample *pDesired = NULL;
		IUnknown *pUnkTexture = NULL;
    
		try
		{
			// ۑB
			UINT32 counter = ::MFGetAttributeUINT32( pSample, MFSamplePresenter_SampleCounter, (UINT32) -1 );	// Tṽg[NJE^[l擾B
			(void) pSample->GetUnknown( MFSamplePresenter_Texture, IID_IUnknown, (void**) &pUnkTexture );		// TṽeNX`擾B̑ȂmȂ̂ŁAG[`FbN͌ŁB

			// IMFSample  IMFDesireSample 擾ANAB
			tFAILEDȂA( hr = pSample->QueryInterface( __uuidof( IMFDesiredSample ), (void**) &pDesired ) );
			pDesired->Clear();	// ̃\bh́ATvׂ̂Ă̑폜Ă܂B

			// ߂đo^B
			tFAILEDȂA( hr = pSample->SetUINT32( MFSamplePresenter_SampleCounter, counter ) );				// Ƃăg[NJE^[lo^B
			if( pUnkTexture )
				tFAILEDȂA( hr = pSample->SetUnknown( MFSamplePresenter_Texture, pUnkTexture ) );			// ƂăeNX`iȂjo^B
		}
		finally
		{
			SAFE_COM_RELEASE( pUnkTexture );
			SAFE_COM_RELEASE( pDesired );
		}

		return S_OK;
	}
	BOOL	CustomEVRPresenter::IsSampleTimePassed( IMFClock *pClock, IMFSample *pSample )
	{
		if( pSample == NULL || pClock == NULL )
			return E_POINTER;

		HRESULT hr = S_OK;
		MFTIME hnsTimeNow = 0;
		MFTIME hnsSystemTime = 0;
		MFTIME hnsSampleStart = 0;
		MFTIME hnsSampleDuration = 0;

		// Tv^CX^vԂĂƂ͌ȂƁA܂ANbNԂƂ͌ȂƂɒӂB

		if( FAILED( hr = pClock->GetCorrelatedTime( 0, &hnsTimeNow, &hnsSystemTime ) ) )
			return FALSE;

		if( FAILED( hr = pSample->GetSampleTime( &hnsSampleStart ) ) )
			return FALSE;

		if( FAILED( hr = pSample->GetSampleDuration( &hnsSampleDuration ) ) )
			return FALSE;

		if( hnsSampleStart + hnsSampleDuration < hnsTimeNow )
			return TRUE;

		return FALSE;
	}
	HRESULT	CustomEVRPresenter::SetMixerSourceRect( IMFTransform *pMixer, const MFVideoNormalizedRect& nrcSource )
	{
		if( pMixer == NULL )
			return E_POINTER;

		HRESULT hr = S_OK;
		IMFAttributes *pAttributes = NULL;

		try
		{
			tFAILEDȂA( hr = pMixer->GetAttributes( &pAttributes ) );
			tFAILEDȂA( hr = pAttributes->SetBlob( VIDEO_ZOOM_RECT, (const UINT8*) &nrcSource, sizeof( nrcSource ) ) );
		}
		finally
		{
			SAFE_COM_RELEASE( pAttributes );
		}

		return S_OK;
	}
}

