#include "stdafx.h"
#include "DrawTexture.h"
#include "valMatrix.h"

namespace FDK
{
// public:

	void DrawTexture::t3D`( IDirect3DDevice9Ex *pDevice, IDirect3DTexture9* pTexture, int nx0to255, bool bZ, D3DMATRIX* pMatrix, LPRECT prc摜̕`̈ )
	{
		Debug::Assert( pDevice != NULL );
		Debug::Assert( pTexture != NULL );

		HRESULT hr = S_OK;
		D3DSURFACE_DESC desc;

		
		// k{sɔfB

		Matrix mat = Matrix::Multiply(
						Matrix::FromD3DXMATRIX( *pMatrix ),
						Matrix::Scaling( DrawTexture::fk{, DrawTexture::fk{, DrawTexture::fk{ ) );
		
		D3DMATRIX matrix = Matrix::ToD3DXMATRIX( mat );

		try
		{
			tFAILEDȂO( L"T[tFCXx 0  Description ̎擾",
				hr = pTexture->GetLevelDesc( 0, &desc ) );

			float x = ( (float) ( prc摜̕`̈->right - prc摜̕`̈->left ) ) / 2.0f;
			float y = ( (float) ( prc摜̕`̈->bottom - prc摜̕`̈->top ) ) / 2.0f;
			float z = 0.0f;
			float fUl = ( (float) prc摜̕`̈->left ) / ( (float) desc.Width );
			float fEUl = ( (float) prc摜̕`̈->right ) / ( (float) desc.Width );
			float fVl = ( (float) prc摜̕`̈->top ) / ( (float) desc.Height );
			float fVl = ( (float) prc摜̕`̈->bottom ) / ( (float) desc.Height );
			DWORD color = ( (DWORD) ( nx0to255 ) << 24 ) | 0x00FFFFFF;

			pPositionColoredVertexies[ 0 ].u = fUl;
			pPositionColoredVertexies[ 0 ].v = fVl;
			pPositionColoredVertexies[ 0 ].x = -x;
			pPositionColoredVertexies[ 0 ].y = y;
			pPositionColoredVertexies[ 0 ].z = z;
			pPositionColoredVertexies[ 0 ].color = color;

			pPositionColoredVertexies[ 1 ].u = fEUl;
			pPositionColoredVertexies[ 1 ].v = fVl;
			pPositionColoredVertexies[ 1 ].x = x;
			pPositionColoredVertexies[ 1 ].y = y;
			pPositionColoredVertexies[ 1 ].z = z;
			pPositionColoredVertexies[ 1 ].color = color;

			pPositionColoredVertexies[ 2 ].u = fUl;
			pPositionColoredVertexies[ 2 ].v = fVl;
			pPositionColoredVertexies[ 2 ].x = -x;
			pPositionColoredVertexies[ 2 ].y = -y;
			pPositionColoredVertexies[ 2 ].z = z;
			pPositionColoredVertexies[ 2 ].color = color;

			pPositionColoredVertexies[ 3 ].u = fEUl;
			pPositionColoredVertexies[ 3 ].v = fVl;
			pPositionColoredVertexies[ 3 ].x = x;
			pPositionColoredVertexies[ 3 ].y = -y;
			pPositionColoredVertexies[ 3 ].z = z;
			pPositionColoredVertexies[ 3 ].color = color;

			DrawTexture::t_OXe[g̐ݒ( pDevice, bZ );
			
			tFAILEDȂO( L"[hs̐ݒ",
				hr = pDevice->SetTransform( D3DTS_WORLD, &matrix ) );
			
			tFAILEDȂO( L"`eNX`̐ݒ",
				hr = pDevice->SetTexture( 0, pTexture ) );

			tFAILEDȂO( L"`̐ݒ(FVF)",
				hr = pDevice->SetFVF( D3DFVF_XYZ | D3DFVF_DIFFUSE | D3DFVF_TEX1 ) );

			tFAILEDȂO( L"v~eBu̕`",
				hr = pDevice->DrawPrimitiveUP( D3DPT_TRIANGLESTRIP, 2, pPositionColoredVertexies, sizeof( STPositionColoredVertexies ) ) );
		}
		catch( Exception^ e )
		{
			#pragma region [ s ]
			//-----------------
			throw gcnew Exception( L"eNX`3D`Ɏs܂B", e );
			//-----------------
			#pragma endregion
		}
	}
	void DrawTexture::t3D`( IDirect3DDevice9Ex *pDevice, IDirect3DTexture9* pTexture, int nx0to255, bool bZ, D3DMATRIX* pMatrix )
	{
		Debug::Assert( pTexture != NULL );

		HRESULT hr = S_OK;
		D3DSURFACE_DESC desc;
		RECT rcS摜;

		try
		{
			tFAILEDȂO( L"T[tFCXx 0  Description ̎擾",
				hr = pTexture->GetLevelDesc( 0, &desc ) );

			rcS摜.left = 0;
			rcS摜.top = 0;
			rcS摜.right = desc.Width;
			rcS摜.bottom = desc.Height;
		}
		catch( Exception^ e )
		{
			#pragma region [ s ]
			//-----------------
			throw gcnew Exception( L"eNX`3D`Ɏs܂B", e );
			//-----------------
			#pragma endregion
		}

		DrawTexture::t3D`( pDevice, pTexture, nx0to255, bZ, pMatrix, &rcS摜 );
	}

	void DrawTexture::t2D`( IDirect3DDevice9Ex *pDevice, IDirect3DTexture9* pTexture, int nx0to255, bool bZ, float fgk{X, float fgk{Y, int x, int y, float depth, LPRECT prc摜̕`̈ )
	{
		Debug::Assert( pDevice != NULL );
		Debug::Assert( pTexture != NULL );

		HRESULT hr = S_OK;
		D3DSURFACE_DESC desc;

		try
		{
			tFAILEDȂO( L"T[tFCXx 0  Description ̎擾",
				hr = pTexture->GetLevelDesc( 0, &desc ) );

			float fx = ( x*DrawTexture::fk{ ) - 0.5f;	// -0.5 ͍WƃsNŽ덷z邽߂̍W␳lB(MSDNQ)
			float fy = ( y*DrawTexture::fk{ ) - 0.5f;	//
			float w = ( prc摜̕`̈->right - prc摜̕`̈->left ) * fgk{X * DrawTexture::fk{;
			float h = ( prc摜̕`̈->bottom - prc摜̕`̈->top ) * fgk{Y * DrawTexture::fk{;
			float fUl = ( (float) prc摜̕`̈->left ) / ( (float) desc.Width );
			float fEUl = ( (float) prc摜̕`̈->right ) / ( (float) desc.Width );
			float fVl = ( (float) prc摜̕`̈->top ) / ( (float) desc.Height );
			float fVl = ( (float) prc摜̕`̈->bottom ) / ( (float) desc.Height );
			D3DCOLOR color = ( (D3DCOLOR) ( nx0to255 ) << 24 ) | 0x00FFFFFF;
			
			pTransformedColoredTexturedVertexies[ 0 ].u = fUl;
			pTransformedColoredTexturedVertexies[ 0 ].v = fVl;
			pTransformedColoredTexturedVertexies[ 0 ].x = fx;
			pTransformedColoredTexturedVertexies[ 0 ].y = fy;
			pTransformedColoredTexturedVertexies[ 0 ].z = depth;
			pTransformedColoredTexturedVertexies[ 0 ].w = 1.0f;
			pTransformedColoredTexturedVertexies[ 0 ].color = color;

			pTransformedColoredTexturedVertexies[ 1 ].u = fEUl;
			pTransformedColoredTexturedVertexies[ 1 ].v = fVl;
			pTransformedColoredTexturedVertexies[ 1 ].x = fx + w;
			pTransformedColoredTexturedVertexies[ 1 ].y = fy;
			pTransformedColoredTexturedVertexies[ 1 ].z = depth;
			pTransformedColoredTexturedVertexies[ 1 ].w = 1.0f;
			pTransformedColoredTexturedVertexies[ 1 ].color = color;

			pTransformedColoredTexturedVertexies[ 2 ].u = fUl;
			pTransformedColoredTexturedVertexies[ 2 ].v = fVl;
			pTransformedColoredTexturedVertexies[ 2 ].x = fx;
			pTransformedColoredTexturedVertexies[ 2 ].y = fy + h;
			pTransformedColoredTexturedVertexies[ 2 ].z = depth;
			pTransformedColoredTexturedVertexies[ 2 ].w = 1.0f;
			pTransformedColoredTexturedVertexies[ 2 ].color = color;

			pTransformedColoredTexturedVertexies[ 3 ].u = fEUl;
			pTransformedColoredTexturedVertexies[ 3 ].v = fVl;
			pTransformedColoredTexturedVertexies[ 3 ].x = fx + w;
			pTransformedColoredTexturedVertexies[ 3 ].y = fy + h;
			pTransformedColoredTexturedVertexies[ 3 ].z = depth;
			pTransformedColoredTexturedVertexies[ 3 ].w = 1.0f;
			pTransformedColoredTexturedVertexies[ 3 ].color = color;

			DrawTexture::t_OXe[g̐ݒ( pDevice, bZ );

			tFAILEDȂO( L"`eNX`̐ݒ",
				hr = pDevice->SetTexture( 0, pTexture ) );

			tFAILEDȂO( L"`̐ݒ(FVF)",
				hr = pDevice->SetFVF( D3DFVF_XYZRHW | D3DFVF_DIFFUSE | D3DFVF_TEX1 ) );

			tFAILEDȂO( L"v~eBu̕`",
				hr = pDevice->DrawPrimitiveUP( D3DPT_TRIANGLESTRIP, 2, pTransformedColoredTexturedVertexies, sizeof( STTransformedColoredTextureVertexies ) ) );
		}
		catch( Exception^ e )
		{
			#pragma region [ s ]
			//-----------------
			throw gcnew Exception( L"eNX`2D`Ɏs܂B", e );
			//-----------------
			#pragma endregion
		}
	}
	void DrawTexture::t2D`( IDirect3DDevice9Ex *pDevice, IDirect3DTexture9* pTexture, int nx0to255, bool bZ, float fgk{X, float fgk{Y, int x, int y, LPRECT prc摜̕`̈ )
	{
		DrawTexture::t2D`( pDevice, pTexture, nx0to255, bZ, fgk{X, fgk{Y, x, y, 1.0f, prc摜̕`̈ );
	}
	void DrawTexture::t2D`( IDirect3DDevice9Ex *pDevice, IDirect3DTexture9* pTexture, int nx0to255, bool bZ, float fgk{X, float fgk{Y, int x, int y )
	{
		Debug::Assert( pDevice != NULL );
		Debug::Assert( pTexture != NULL );

		HRESULT hr = S_OK;
		D3DSURFACE_DESC desc;
		RECT rc摜̕`̈;

		try
		{
			tFAILEDȂO( L"T[tFCXx 0  Description ̎擾",
				hr = pTexture->GetLevelDesc( 0, &desc ) );

			rc摜̕`̈.left = 0;
			rc摜̕`̈.top = 0;
			rc摜̕`̈.right = desc.Width;
			rc摜̕`̈.bottom = desc.Height;
		}
		catch( Exception^ e )
		{
			#pragma region [ s ]
			//-----------------
			throw gcnew Exception( L"eNX`2D`Ɏs܂B", e );
			//-----------------
			#pragma endregion
		}

		DrawTexture::t2D`( pDevice, pTexture, nx0to255, bZ, fgk{X, fgk{Y, x, y, &rc摜̕`̈ );
	}
	void DrawTexture::t2D`( IDirect3DDevice9Ex *pDevice, IDirect3DTexture9* pTexture, int nx0to255, bool bZ, float fgk{X, float fgk{Y, Point pt, float depth, LPRECT prc摜̕`̈ )
	{
		DrawTexture::t2D`( pDevice, pTexture, nx0to255, bZ, fgk{X, fgk{Y, pt.X, pt.Y, depth, prc摜̕`̈ );
	}
	void DrawTexture::t2D`( IDirect3DDevice9Ex *pDevice, IDirect3DTexture9* pTexture, int nx0to255, bool bZ, float fgk{X, float fgk{Y, Point pt, LPRECT prc摜̕`̈ )
	{
		DrawTexture::t2D`( pDevice, pTexture, nx0to255, bZ, fgk{X, fgk{Y, pt.X, pt.Y, 1.0f, prc摜̕`̈ );
	}
	void DrawTexture::t2D`( IDirect3DDevice9Ex *pDevice, IDirect3DTexture9* pTexture, int nx0to255, bool bZ, float fgk{X, float fgk{Y, Point pt )
	{
		Debug::Assert( pDevice != NULL );
		Debug::Assert( pTexture != NULL );

		HRESULT hr = S_OK;
		D3DSURFACE_DESC desc;
		RECT rc摜̕`̈;

		try
		{
			tFAILEDȂO( L"T[tFCXx 0  Description ̎擾",
				hr = pTexture->GetLevelDesc( 0, &desc ) );

			rc摜̕`̈.left = 0;
			rc摜̕`̈.top = 0;
			rc摜̕`̈.right = desc.Width;
			rc摜̕`̈.left = 0;
		}
		catch( Exception^ e )
		{
			#pragma region [ s ]
			//-----------------
			throw gcnew Exception( L"eNX`2D`Ɏs܂B", e );
			//-----------------
			#pragma endregion
		}

		DrawTexture::t2D`( pDevice, pTexture, nx0to255, bZ, fgk{X, fgk{Y, pt.X, pt.Y, 1.0f, &rc摜̕`̈ );
	}

// protected:

	STPositionColoredVertexies DrawTexture::pPositionColoredVertexies[ 4 ];
	STTransformedColoredTextureVertexies DrawTexture::pTransformedColoredTexturedVertexies[ 4 ];
	float DrawTexture::fk{ = 1.0f;

	void DrawTexture::t_OXe[g̐ݒ( IDirect3DDevice9Ex *pDevice, bool bZ )
	{
		Debug::Assert( pDevice != NULL );

		HRESULT hr = S_OK;

		try
		{
			if( bZ )
			{
				tFAILEDȂO( L"D3DRS_ALPHABLENDENABLE ̐ݒ",
					hr = pDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE ) );

				tFAILEDȂO( L"D3DRS_SRCBLEND ̐ݒ",
					hr = pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA ) );

				tFAILEDȂO( L"D3DRS_DESTBLEND ̐ݒ",
					hr = pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE ) );
			}
			else
			{
				tFAILEDȂO( L"D3DRS_ALPHABLENDENABLE ̐ݒ",
					hr = pDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE ) );

				tFAILEDȂO( L"D3DRS_SRCBLEND ̐ݒ",
					hr = pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA ) );

				tFAILEDȂO( L"D3DRS_DESTBLEND ̐ݒ",
					hr = pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA ) );
			}
		}
		catch( Exception^ e )
		{
			#pragma region [ s ]
			//-----------------
			throw gcnew Exception( L"_OXe[g̐ݒɎs܂B", e );
			//-----------------
			#pragma endregion
		}
	}
}
