﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using FDK;

namespace StrokeStyleT
{
	class CActドラムキット : CActivity
	{
		protected override void Onデバイスリソースの作成()
		{
			lock( this )
			{
				Global.tデバイスをロックして処理を行う( ( hDevice ) => {

					this.txバス = new CTexture( hDevice, Path.Combine( Global.Folders.stgシステムフォルダパス, @"Images\DrumKit Bass.png" ) );
					this.txロータム = new CTexture( hDevice, Path.Combine( Global.Folders.stgシステムフォルダパス, @"Images\DrumKit LowTom.png" ) );
					this.txハイタム = new CTexture( hDevice, Path.Combine( Global.Folders.stgシステムフォルダパス, @"Images\DrumKit HighTom.png" ) );
					this.txフロアタム = new CTexture( hDevice, Path.Combine( Global.Folders.stgシステムフォルダパス, @"Images\DrumKit FloorTom.png" ) );
					this.txスネア = new CTexture( hDevice, Path.Combine( Global.Folders.stgシステムフォルダパス, @"Images\DrumKit Snare.png" ) );
					this.txハイハット下 = new CTexture( hDevice, Path.Combine( Global.Folders.stgシステムフォルダパス, @"Images\DrumKit HiHat Bottom.png" ) );
					this.txハイハット上 = new CTexture( hDevice, Path.Combine( Global.Folders.stgシステムフォルダパス, @"Images\DrumKit HiHat Top.png" ) );
					this.tx右シンバルスタンド = new CTexture( hDevice, Path.Combine( Global.Folders.stgシステムフォルダパス, @"Images\DrumKit RCymbal Stand.png" ) );
					this.tx右シンバル = new CTexture( hDevice, Path.Combine( Global.Folders.stgシステムフォルダパス, @"Images\DrumKit RCymbal.png" ) );
					this.tx右シンバルトップ = new CTexture( hDevice, Path.Combine( Global.Folders.stgシステムフォルダパス, @"Images\DrumKit RCymbal Top.png" ) );
					this.tx左シンバルスタンド = new CTexture( hDevice, Path.Combine( Global.Folders.stgシステムフォルダパス, @"Images\DrumKit LCymbal Stand.png" ) );
					this.tx左シンバル = new CTexture( hDevice, Path.Combine( Global.Folders.stgシステムフォルダパス, @"Images\DrumKit LCymbal.png" ) );
					this.tx左シンバルトップ = new CTexture( hDevice, Path.Combine( Global.Folders.stgシステムフォルダパス, @"Images\DrumKit LCymbal Top.png" ) );

				} );
			}
		}
		protected override void Onデバイスリソースの解放()
		{
			lock( this )
			{
				if( null != this.txバス )
				{
					this.txバス.Dispose();
					this.txバス = null;
				}
				if( null != this.txロータム )
				{
					this.txロータム.Dispose();
					this.txロータム = null;
				}
				if( null != this.txハイタム )
				{
					this.txハイタム.Dispose();
					this.txハイタム = null;
				}
				if( null != this.txフロアタム )
				{
					this.txフロアタム.Dispose();
					this.txフロアタム = null;
				}
				if( null != this.txスネア )
				{
					this.txスネア.Dispose();
					this.txスネア = null;
				}
				if( null != this.txハイハット下 )
				{
					this.txハイハット下.Dispose();
					this.txハイハット下 = null;
				}
				if( null != this.txハイハット上 )
				{
					this.txハイハット上.Dispose();
					this.txハイハット上 = null;
				}
				if( null != this.tx右シンバルスタンド )
				{
					this.tx右シンバルスタンド.Dispose();
					this.tx右シンバルスタンド = null;
				}
				if( null != this.tx右シンバル )
				{
					this.tx右シンバル.Dispose();
					this.tx右シンバル = null;
				}
				if( null != this.tx右シンバルトップ )
				{
					this.tx右シンバルトップ.Dispose();
					this.tx右シンバルトップ = null;
				}
				if( null != this.tx左シンバルスタンド )
				{
					this.tx左シンバルスタンド.Dispose();
					this.tx左シンバルスタンド = null;
				}
				if( null != this.tx左シンバル )
				{
					this.tx左シンバル.Dispose();
					this.tx左シンバル = null;
				}
				if( null != this.tx左シンバルトップ )
				{
					this.tx左シンバルトップ.Dispose();
					this.tx左シンバルトップ = null;
				}

				base.Onデバイスリソースの解放();
			}
		}
		protected override void On描画( IntPtr hDevice )
		{
			lock( this )
			{
				if( null != this.txバス )
					this.txバス.t2D描画( hDevice, 881, 891 );

				if( null != this.txロータム )
					this.txロータム.t2D描画( hDevice, 999, 901 );

				if( null != this.txハイタム )
					this.txハイタム.t2D描画( hDevice, 850, 901 );

				if( null != this.txフロアタム )
					this.txフロアタム.t2D描画( hDevice, 1050, 981 );

				if( null != this.txスネア )
					this.txスネア.t2D描画( hDevice, 741, 988 );

				if( null != this.txハイハット下 )
					this.txハイハット下.t2D描画( hDevice, 657, 935 );

				if( null != this.txハイハット上 )
					this.txハイハット上.t2D描画( hDevice, 657, 935 );

				if( null != this.tx右シンバルスタンド )
					this.tx右シンバルスタンド.t2D描画( hDevice, 1229, 920 );

				if( null != this.tx右シンバル )
				{
					this.mat右シンバル = Matrix.Identity;
					this.mat右シンバル *= Matrix.Translation( 1257f - Theme.sz描画サイズ原寸px.Width / 2f, -( 923f - Theme.sz描画サイズ原寸px.Height / 2f ), 0f );
					this.tx右シンバル.t3D描画( hDevice, this.mat右シンバル );
				}

				if( null != this.tx右シンバルトップ )
					this.tx右シンバルトップ.t2D描画( hDevice, 1229, 880 );

				if( null != this.tx左シンバルスタンド )
					this.tx左シンバルスタンド.t2D描画( hDevice, 472, 916 );

				if( null != this.tx左シンバル )
				{
					this.mat左シンバル = Matrix.Identity;
					this.mat左シンバル *= Matrix.Translation( 649f - Theme.sz描画サイズ原寸px.Width / 2f, -( 918f - Theme.sz描画サイズ原寸px.Height / 2f ), 0f );
					this.tx左シンバル.t3D描画( hDevice, this.mat左シンバル );
				}

				if( null != this.tx左シンバルトップ )
					this.tx左シンバルトップ.t2D描画( hDevice, 633, 891 );
			}
		}

		private CTexture txバス = null;
		private CTexture txロータム = null;
		private CTexture txハイタム = null;
		private CTexture txフロアタム = null;
		private CTexture txスネア = null;
		private CTexture txハイハット下 = null;
		private CTexture txハイハット上 = null;
		private CTexture tx右シンバルスタンド = null;
		private CTexture tx右シンバル = null;
		private CTexture tx右シンバルトップ = null;
		private CTexture tx左シンバルスタンド = null;
		private CTexture tx左シンバル = null;
		private CTexture tx左シンバルトップ = null;

		private Matrix mat右シンバル;	// 右シンバルは t3D描画() で描画する。
		private Matrix mat左シンバル;	// 左シンバルも t3D描画() で描画する。
	}
}
