﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using FDK;

namespace StrokeStyleT
{
	class CActステージキット : CActivity
	{
		public int n透明度
		{
			get
			{
				lock( this )
				{
					return this._n透明度0to255;
				}
			}
			set
			{
				lock( this )
				{
					this._n透明度0to255 = Math.Min( Math.Max( value, 0 ), 255 );
				}
			}
		}

		protected override void Onデバイスリソースの作成()
		{
			lock( this )
			{
				// ステージキット画像テクスチャの作成。

				Global.tデバイスをロックして処理を行う( ( hDevice ) => {

					this.txステージキット画像 = new CTexture( hDevice, Path.Combine( Global.Folders.stgシステムフォルダパス, @"Images\Stage.png" ) );
					this.txステージキット画像.n透明度 = this._n透明度0to255;

				} );
			}
		}
		protected override void Onデバイスリソースの解放()
		{
			lock( this )
			{
				if( null != this.txステージキット画像 )
				{
					this.txステージキット画像.Dispose();
					this.txステージキット画像 = null;
				}

				base.Onデバイスリソースの解放();
			}
		}
		protected override void On描画( IntPtr hDevice )
		{
			lock( this )
			{
				if( null != this.txステージキット画像 )
				{
					this.txステージキット画像.n透明度 = this._n透明度0to255;
					this.txステージキット画像.t2D描画( hDevice, 0, 0 );
				}
			}
		}

		private CTexture txステージキット画像 = null;
		private int _n透明度0to255 = 255;
	}
}
